/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import visad.VisADException;
import visad.bio.MeasureDataFile;
import visad.bio.VisBio;

public class StateManager {
    private VisBio bio;
    private File state;
    private File lines;
    private File oldLines;
    private Thread saveThread;
    private boolean stateDirty = false;
    private boolean measureDirty = false;
    private boolean restoring = false;

    public StateManager(VisBio biovis) {
        this(biovis, "biovisad.tmp", "lines.tmp", "linesold.tmp");
    }

    public StateManager(VisBio biovis, String state, String lines, String oldLines) {
        this.bio = biovis;
        this.state = new File(state);
        this.lines = new File(lines);
        this.oldLines = new File(oldLines);
    }

    public void restoreState() {
        this.restoring = true;
        try {
            BufferedReader fin = new BufferedReader(new FileReader(this.state));
            this.bio.restoreState(fin);
            fin.close();
            if (this.lines.exists()) {
                new MeasureDataFile(this.bio, this.lines).read();
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        this.restoring = false;
    }

    public void undo() {
        this.restoring = true;
        try {
            if (this.oldLines.exists()) {
                new MeasureDataFile(this.bio, this.oldLines).read();
                File temp = this.oldLines;
                this.oldLines = this.lines;
                this.lines = temp;
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        this.restoring = false;
    }

    public void saveState(boolean doState) {
        if (this.restoring) {
            return;
        }
        this.stateDirty = this.stateDirty || doState;
        boolean bl = this.measureDirty = this.measureDirty || !doState;
        if (this.saveThread == null || !this.saveThread.isAlive()) {
            this.saveThread = new Thread(new Runnable(){

                public void run() {
                    while (StateManager.this.stateDirty || StateManager.this.measureDirty) {
                        try {
                            if (StateManager.this.stateDirty) {
                                StateManager.this.stateDirty = false;
                                PrintWriter fout = new PrintWriter(new FileWriter(StateManager.this.state));
                                StateManager.this.bio.saveState(fout);
                                fout.close();
                            }
                            if (!StateManager.this.measureDirty) continue;
                            StateManager.this.measureDirty = false;
                            if (StateManager.this.oldLines.exists()) {
                                StateManager.this.oldLines.delete();
                            }
                            if (StateManager.this.lines.exists()) {
                                StateManager.this.lines.renameTo(StateManager.this.oldLines);
                            }
                            new MeasureDataFile(StateManager.this.bio, StateManager.this.lines).write();
                        }
                        catch (IOException exc) {
                            exc.printStackTrace();
                        }
                        catch (VisADException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
            });
            this.saveThread.start();
        }
    }

    public void checkState() {
        if (!this.state.exists() && !this.lines.exists()) {
            return;
        }
        int ans = JOptionPane.showConfirmDialog(this.bio, "It appears that VisBio crashed last time. Attempt to restore the previous state?", "VisBio", 0, 3);
        if (ans != 0) {
            return;
        }
        this.restoreState();
    }

    public void destroy() {
        if (this.state.exists()) {
            this.state.delete();
        }
        if (this.lines.exists()) {
            this.lines.delete();
        }
        if (this.oldLines.exists()) {
            this.oldLines.delete();
        }
    }
}

