/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import visad.AnimationControl;
import visad.BaseColorControl;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRenderer;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ValueControl;
import visad.VisADException;
import visad.bio.AlignmentPlane;
import visad.bio.ArbitrarySlice;
import visad.bio.BioUtil;
import visad.bio.MeasureList;
import visad.bio.PlaneListener;
import visad.bio.ProgressDialog;
import visad.bio.VisBio;
import visad.util.ColorMapWidget;
import visad.util.DualRes;
import visad.util.LabeledColorWidget;

public class SliceManager
implements ControlListener,
DisplayListener,
PlaneListener {
    static final RealType Z_TYPE = RealType.getRealType("bio_line_z");
    static final RealType TIME_TYPE = RealType.getRealType("bio_time");
    static final RealType SLICE_TYPE = RealType.getRealType("bio_slice");
    static final RealType RED_TYPE = RealType.getRealType("bio_red");
    static final RealType GREEN_TYPE = RealType.getRealType("bio_green");
    static final RealType BLUE_TYPE = RealType.getRealType("bio_blue");
    RealTupleType domain2;
    RealTupleType domain3;
    RealTupleType colorRange;
    RealType[] dtypes;
    RealType[] rtypes;
    ScalarMap x_map2;
    ScalarMap y_map2;
    float min_x;
    float max_x;
    float min_y;
    float max_y;
    float min_z;
    float max_z;
    int res_x;
    int res_y;
    private int sliceRes_x;
    private int sliceRes_y;
    private int volumeRes;
    AnimationControl anim_control2;
    AnimationControl anim_control3;
    AnimationControl anim_control_prev;
    AnimationControl anim_control_next;
    ValueControl value_control2;
    ArbitrarySlice arb;
    AlignmentPlane align;
    private boolean planeSelect;
    private boolean continuous;
    private boolean planeChanged;
    private boolean alignStacks;
    private boolean volume;
    private FieldImpl field;
    private FieldImpl lowresField;
    private FlatField sliceField;
    private FlatField volumeField;
    private ScalarMap[] rmaps2;
    private ScalarMap[] rmaps3;
    private ScalarMap[][] rmapsP;
    private LabeledColorWidget[] widgets;
    private DataReferenceImpl ref2;
    private DataReferenceImpl ref3;
    private DataReferenceImpl ref_prev;
    private DataReferenceImpl ref_next;
    private DataReferenceImpl lowresRef2;
    private DataReferenceImpl lowresRef3;
    private DataReferenceImpl planeRef;
    private DataRenderer renderer2;
    private DataRenderer renderer3;
    private DataRenderer planeRenderer2;
    private DataRenderer lowresRenderer2;
    private DataRenderer lowresRenderer3;
    private int[] thumbSize;
    private boolean lowres;
    private boolean doThumbs;
    private boolean hasThumbs;
    private boolean autoSwitch;
    private VisBio bio;
    private File[] files;
    private boolean filesAsSlices;
    private int timesteps;
    private int slices;
    private int index;
    private int slice;
    private int mode_index;
    private int mode_slice;

    public SliceManager(VisBio biovis) throws VisADException, RemoteException {
        this.bio = biovis;
        this.lowres = false;
        this.doThumbs = true;
        this.autoSwitch = true;
        this.planeSelect = false;
        this.continuous = false;
        this.planeChanged = false;
        this.alignStacks = false;
        this.colorRange = new RealTupleType(new RealType[]{RED_TYPE, GREEN_TYPE, BLUE_TYPE});
        this.ref2 = new DataReferenceImpl("bio_ref2");
        this.ref3 = new DataReferenceImpl("bio_ref3");
        this.lowresRef2 = new DataReferenceImpl("bio_lowresRef2");
        this.lowresRef3 = new DataReferenceImpl("bio_lowresRef3");
        this.ref_prev = new DataReferenceImpl("bio_ref_prev");
        this.ref_next = new DataReferenceImpl("bio_ref_next");
        this.planeRef = new DataReferenceImpl("bio_planeRef");
    }

    public int getIndex() {
        return this.index;
    }

    public int getSlice() {
        return this.slice;
    }

    public int getNumberOfIndices() {
        return this.timesteps;
    }

    public int getNumberOfSlices() {
        return this.slices;
    }

    public boolean hasThumbnails() {
        return this.hasThumbs;
    }

    public void setMode(boolean lowres) {
        this.setMode(lowres, true);
    }

    public void setIndex(int index) {
        if (this.index == index || this.bio.horiz.isBusy() && !this.lowres && !this.autoSwitch) {
            return;
        }
        boolean doRefresh = true;
        if (this.autoSwitch && !this.lowres) {
            this.setMode(true, false);
            doRefresh = false;
        }
        this.index = index;
        if (this.autoSwitch && this.lowres && index == this.mode_index) {
            this.setMode(false, false);
            doRefresh = false;
        }
        if (doRefresh) {
            this.refresh(false, true);
        } else {
            if (this.volume) {
                this.doVolumeMode();
            }
            this.updateList();
            this.updateAnimationControls();
        }
        this.align.setIndex(index);
    }

    public void setSlice(int slice) {
        if (this.slice == slice) {
            return;
        }
        this.slice = slice;
        this.refresh(true, false);
    }

    public void setAutoSwitch(boolean value) {
        this.autoSwitch = value;
    }

    public void setThumbnails(boolean thumbnails, int xres, int yres) {
        this.doThumbs = thumbnails;
        this.thumbSize = new int[]{xres, yres};
    }

    public void setPlaneSelect(boolean value) {
        if (this.bio.display3 == null) {
            return;
        }
        this.planeSelect = value;
        this.arb.toggle(value);
        this.planeRenderer2.toggle(value);
        this.renderer2.toggle(!value && !this.lowres);
        if (this.hasThumbs) {
            this.lowresRenderer2.toggle(!value && this.lowres);
        }
        if (value && this.planeRef.getData() == null) {
            this.updateSlice();
        }
    }

    public void setPlaneContinuous(boolean value) {
        this.continuous = value;
    }

    public void setAlignStacks(boolean value) {
        if (this.bio.display3 == null) {
            return;
        }
        this.alignStacks = value;
        this.align.toggle(value);
    }

    public void setVolumeRender(boolean volume) {
        if (this.bio.display3 == null) {
            return;
        }
        if (this.volume == volume) {
            return;
        }
        this.volume = volume;
        try {
            if (volume) {
                this.updateVolumeField();
            } else if (this.lowres) {
                this.lowresRef3.setData(this.lowresField);
            } else {
                this.ref3.setData(this.field);
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        this.bio.toolColor.doAlpha(!volume);
        this.syncColors();
    }

    public void setVolumeResolution(int res) {
        if (this.volumeRes == res) {
            return;
        }
        this.volumeRes = res;
        if (this.volume) {
            this.updateVolumeField();
        }
    }

    public void setSeries(File[] files) {
        this.setSeries(files, false);
    }

    public void setSeries(File[] files, boolean filesAsSlices) {
        this.files = files;
        this.filesAsSlices = filesAsSlices;
        if (filesAsSlices) {
            this.doThumbs = false;
        }
        this.index = 0;
        boolean success = false;
        try {
            this.setFile(true);
            success = true;
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {
            // empty catch block
        }
        if (success) {
            this.bio.horiz.updateSlider(this.timesteps);
            this.bio.vert.updateSlider(this.slices);
            this.bio.state.saveState(true);
        }
    }

    public File[] getSeries() {
        return this.files;
    }

    public boolean getFilesAsSlices() {
        return this.filesAsSlices;
    }

    public FieldImpl getField() {
        return this.field;
    }

    public boolean getPlaneSelect() {
        return this.planeSelect;
    }

    public void controlChanged(ControlEvent e) {
        Control c = e.getControl();
        if (c == this.anim_control2 || c == this.value_control2) {
            int slice;
            int index;
            if (this.anim_control2 != null && this.index != (index = this.anim_control2.getCurrent())) {
                this.bio.horiz.setValue(index + 1);
            }
            if (this.slice != (slice = (int)this.value_control2.getValue())) {
                this.bio.vert.setValue(slice + 1);
            }
        } else {
            this.syncColors();
        }
    }

    public void displayChanged(DisplayEvent e) {
        if (e.getId() != 10) {
            return;
        }
        this.bio.state.saveState(this.planeSelect && this.planeChanged);
        if (this.planeSelect && this.planeChanged && !this.continuous) {
            this.updateSlice();
        }
        this.planeChanged = false;
    }

    public void planeChanged() {
        this.planeChanged = true;
        if (this.continuous) {
            this.updateSlice();
        }
    }

    void purgeData(boolean refs) throws VisADException, RemoteException {
        if (refs) {
            FunctionType ftype = (FunctionType)this.field.getType();
            this.field = new FieldImpl(ftype, this.field.getDomainSet());
            this.ref2.setData(this.field);
            this.ref3.setData(this.field);
        } else {
            this.field = null;
        }
        System.gc();
    }

    void setFile(boolean initialize) throws VisADException, RemoteException {
        this.bio.setWaitCursor(true);
        try {
            if (initialize) {
                this.init(this.files, 0);
            } else if (!this.filesAsSlices) {
                this.purgeData(true);
                this.field = BioUtil.loadData(this.files[this.index], true);
                this.volumeField = null;
                this.sliceField = null;
                if (this.field != null) {
                    this.ref2.setData(this.field);
                    this.ref3.setData(this.field);
                } else {
                    this.bio.setWaitCursor(false);
                    JOptionPane.showMessageDialog(this.bio, this.files[this.index].getName() + " does not contain an image stack", "Cannot load file", 0);
                    Object var3_2 = null;
                    this.bio.setWaitCursor(false);
                    return;
                }
            }
            Object var3_3 = null;
            this.bio.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.bio.setWaitCursor(false);
            throw throwable;
        }
    }

    void syncColors() {
        int cm;
        int colorMode = this.bio.display2.getGraphicsModeControl().getColorMode();
        int n = cm = this.bio.composite ? 0 : 1;
        if (colorMode != cm) {
            try {
                this.bio.display2.getGraphicsModeControl().setColorMode(cm);
                if (this.bio.display3 != null) {
                    this.bio.display3.getGraphicsModeControl().setColorMode(cm);
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.widgets.length) {
            float[][] table = this.widgets[i].getTable();
            try {
                BaseColorControl cc2 = (BaseColorControl)this.rmaps2[i].getControl();
                float[][] t2 = BioUtil.adjustColorTable(table, null, false);
                if (!BioUtil.tablesEqual(t2, cc2.getTable())) {
                    cc2.setTable(t2);
                }
                if (this.bio.display3 != null) {
                    BaseColorControl cc3 = (BaseColorControl)this.rmaps3[i].getControl();
                    float[][] t3 = cc3.getTable();
                    if (!BioUtil.tablesEqual(t3 = BioUtil.adjustColorTable(table, t3[3], true), cc3.getTable())) {
                        cc3.setTable(t3);
                    }
                }
                if (this.hasThumbs && this.bio.previous != null && this.bio.next != null) {
                    if (t2 == null) {
                        t2 = BioUtil.adjustColorTable(table, null, false);
                    }
                    int j = 0;
                    while (j < this.rmapsP.length) {
                        BaseColorControl ccP = (BaseColorControl)this.rmapsP[j][i].getControl();
                        if (!BioUtil.tablesEqual(t2, ccP.getTable())) {
                            ccP.setTable(t2);
                        }
                        ++j;
                    }
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
            ++i;
        }
    }

    void startAnimation() {
        if (!this.lowres) {
            this.lowres = true;
            this.bio.toolView.setMode(true);
            this.setMode(true);
        }
    }

    void setSliceRange(int x, int y) {
        if (this.sliceRes_x == x && this.sliceRes_y == y) {
            return;
        }
        this.sliceRes_x = x;
        this.sliceRes_y = y;
        this.bio.state.saveState(true);
        if (this.planeSelect) {
            this.updateSlice();
        } else {
            this.sliceField = null;
        }
    }

    LabeledColorWidget[] getColorWidgets() {
        return this.widgets;
    }

    void saveState(PrintWriter fout) throws IOException, VisADException {
        fout.println(this.files.length);
        int i = 0;
        while (i < this.files.length) {
            fout.println(this.files[i].getPath());
            ++i;
        }
        fout.println(this.filesAsSlices);
        fout.println(this.hasThumbs);
        fout.println(this.thumbSize[0]);
        fout.println(this.thumbSize[1]);
        fout.println(this.sliceRes_x);
        fout.println(this.sliceRes_y);
        if (this.arb != null) {
            this.arb.saveState(fout);
        }
    }

    void restoreState(BufferedReader fin) throws IOException, VisADException {
        int len = Integer.parseInt(fin.readLine().trim());
        File[] files = new File[len];
        int i = 0;
        while (i < len) {
            files[i] = new File(fin.readLine().trim());
            ++i;
        }
        boolean fas = fin.readLine().trim().equals("true");
        boolean thumbs = fin.readLine().trim().equals("true");
        int thumbX = Integer.parseInt(fin.readLine().trim());
        int thumbY = Integer.parseInt(fin.readLine().trim());
        int sliceX = Integer.parseInt(fin.readLine().trim());
        int sliceY = Integer.parseInt(fin.readLine().trim());
        this.setThumbnails(thumbs, thumbX, thumbY);
        this.setSeries(files, fas);
        if (this.arb != null) {
            this.arb.restoreState(fin);
        }
    }

    private void init(File[] files, int index) throws VisADException {
        final File[] f = files;
        final int curfile = index;
        final ProgressDialog dialog = new ProgressDialog((Frame)this.bio, "Loading");
        Thread t = new Thread(new Runnable(){

            public void run() {
                ((SliceManager)SliceManager.this).bio.display2.disableAction();
                if (((SliceManager)SliceManager.this).bio.display3 != null) {
                    ((SliceManager)SliceManager.this).bio.display3.disableAction();
                }
                try {
                    RealType[] realTypeArray;
                    int i;
                    SliceManager.this.clearDisplays();
                    if (((SliceManager)SliceManager.this).bio.mm.lists != null) {
                        ((SliceManager)SliceManager.this).bio.mm.clear();
                    }
                    SliceManager.this.field = null;
                    SliceManager.this.sliceField = (SliceManager.this.volumeField = null);
                    FieldImpl[][] thumbs = null;
                    SliceManager.this.mode_index = (SliceManager.this.mode_slice = 0);
                    if (SliceManager.this.filesAsSlices) {
                        SliceManager.this.slices = f.length;
                        SliceManager.this.timesteps = 1;
                        i = 0;
                        while (i < SliceManager.this.slices) {
                            dialog.setText("Loading " + f[i].getName());
                            FieldImpl image = BioUtil.loadData(f[i], false);
                            if (image == null) {
                                return;
                            }
                            if (SliceManager.this.field == null) {
                                FunctionType stack_type = new FunctionType(SLICE_TYPE, image.getType());
                                SliceManager.this.field = new FieldImpl(stack_type, new Integer1DSet(SliceManager.this.slices));
                            }
                            SliceManager.this.field.setSample(i, (Data)image);
                            dialog.setPercent(100 * (i + 1) / SliceManager.this.slices);
                            ++i;
                        }
                        SliceManager.this.doThumbs = false;
                    } else if (SliceManager.this.doThumbs) {
                        SliceManager.this.timesteps = f.length;
                        i = 0;
                        while (i < SliceManager.this.timesteps) {
                            int ndx = i == SliceManager.this.timesteps - 1 ? curfile : (i >= curfile ? i + 1 : i);
                            SliceManager.this.purgeData(false);
                            dialog.setText("Loading " + f[ndx].getName());
                            SliceManager.this.field = BioUtil.loadData(f[ndx], true);
                            if (SliceManager.this.field == null) {
                                return;
                            }
                            if (thumbs == null) {
                                SliceManager.this.slices = SliceManager.this.field.getLength();
                                thumbs = new FieldImpl[SliceManager.this.timesteps][SliceManager.this.slices];
                            }
                            int j = 0;
                            while (j < SliceManager.this.slices) {
                                FieldImpl image = (FieldImpl)SliceManager.this.field.getSample(j);
                                thumbs[ndx][j] = DualRes.rescale(image, SliceManager.this.thumbSize);
                                dialog.setPercent(100 * (SliceManager.this.slices * i + j + 1) / (SliceManager.this.timesteps * SliceManager.this.slices));
                                ++j;
                            }
                            ++i;
                        }
                    } else {
                        SliceManager.this.timesteps = f.length;
                        dialog.setText("Loading " + f[curfile].getName());
                        SliceManager.this.field = BioUtil.loadData(f[curfile], true);
                        if (SliceManager.this.field == null) {
                            return;
                        }
                        SliceManager.this.slices = SliceManager.this.field.getLength();
                        dialog.setPercent(100);
                    }
                    if (SliceManager.this.field == null) {
                        return;
                    }
                    SliceManager.this.hasThumbs = SliceManager.this.doThumbs;
                    SliceManager.this.autoSwitch = SliceManager.this.hasThumbs;
                    dialog.setText("Analyzing data");
                    FunctionType time_function = (FunctionType)SliceManager.this.field.getType();
                    RealTupleType time_domain = time_function.getDomain();
                    MathType time_range = time_function.getRange();
                    if (time_domain.getDimension() > 1 || !(time_range instanceof FunctionType)) {
                        throw new VisADException("Field is not an image stack");
                    }
                    RealType slice_type = (RealType)time_domain.getComponent(0);
                    FunctionType image_function = (FunctionType)time_range;
                    SliceManager.this.domain2 = image_function.getDomain();
                    RealType[] image_dtypes = SliceManager.this.domain2.getRealComponents();
                    if (image_dtypes.length < 2) {
                        throw new VisADException("Data stack does not contain images");
                    }
                    SliceManager.this.dtypes = new RealType[]{image_dtypes[0], image_dtypes[1], slice_type};
                    SliceManager.this.domain3 = new RealTupleType(SliceManager.this.dtypes);
                    MathType range = image_function.getRange();
                    if (!(range instanceof RealTupleType) && !(range instanceof RealType)) {
                        throw new VisADException("Invalid field range");
                    }
                    if (range instanceof RealTupleType) {
                        realTypeArray = ((RealTupleType)range).getRealComponents();
                    } else {
                        RealType[] realTypeArray2 = new RealType[1];
                        realTypeArray = realTypeArray2;
                        realTypeArray2[0] = (RealType)range;
                    }
                    SliceManager.this.rtypes = realTypeArray;
                    SliceManager.this.lowresField = null;
                    if (SliceManager.this.doThumbs) {
                        FunctionType slice_function = new FunctionType(slice_type, image_function);
                        FunctionType lowres_function = new FunctionType(TIME_TYPE, slice_function);
                        SliceManager.this.lowresField = new FieldImpl(lowres_function, new Integer1DSet((MathType)TIME_TYPE, SliceManager.this.timesteps));
                        Integer1DSet lowres_set = new Integer1DSet((MathType)slice_type, SliceManager.this.slices);
                        int j = 0;
                        while (j < SliceManager.this.timesteps) {
                            FieldImpl step = new FieldImpl(slice_function, lowres_set);
                            step.setSamples(thumbs[j], false);
                            SliceManager.this.lowresField.setSample(j, (Data)step, false);
                            ++j;
                        }
                    }
                    dialog.setText("Configuring displays");
                    SliceManager.this.ref2.setData(SliceManager.this.field);
                    SliceManager.this.ref3.setData(SliceManager.this.field);
                    if (SliceManager.this.doThumbs) {
                        SliceManager.this.lowresRef2.setData(SliceManager.this.lowresField);
                        SliceManager.this.lowresRef3.setData(SliceManager.this.lowresField);
                        SliceManager.this.ref_prev.setData(SliceManager.this.lowresField);
                        SliceManager.this.ref_next.setData(SliceManager.this.lowresField);
                    }
                    SliceManager.this.configureDisplays();
                    ((SliceManager)SliceManager.this).bio.toolView.init();
                    ((SliceManager)SliceManager.this).bio.toolColor.init();
                    ((SliceManager)SliceManager.this).bio.toolAlign.init();
                    ((SliceManager)SliceManager.this).bio.toolMeasure.init();
                    ((SliceManager)SliceManager.this).bio.mm.initLists(SliceManager.this.timesteps);
                }
                catch (VisADException exc) {
                    dialog.setException(exc);
                }
                catch (RemoteException exc) {
                    dialog.setException(new VisADException("RemoteException: " + exc.getMessage()));
                }
                ((SliceManager)SliceManager.this).bio.display2.enableAction();
                if (((SliceManager)SliceManager.this).bio.display3 != null) {
                    ((SliceManager)SliceManager.this).bio.display3.enableAction();
                }
                ((SliceManager)SliceManager.this).bio.state.saveState(false);
                dialog.kill();
            }
        });
        t.start();
        dialog.show();
        try {
            dialog.checkException();
        }
        catch (VisADException exc) {
            JOptionPane.showMessageDialog(this.bio, "Cannot import data from " + files[index].getName() + "\n" + exc.getMessage(), "Cannot load file", 0);
            throw exc;
        }
    }

    private void clearDisplays() throws VisADException, RemoteException {
        this.bio.display2.removeAllReferences();
        this.bio.display2.clearMaps();
        if (this.bio.display3 != null) {
            this.bio.display3.removeAllReferences();
            this.bio.display3.clearMaps();
            this.bio.previous.removeAllReferences();
            this.bio.previous.clearMaps();
            this.bio.next.removeAllReferences();
            this.bio.next.clearMaps();
        }
        this.bio.toolColor.removeAllWidgets();
    }

    private void configureDisplays() throws VisADException, RemoteException {
        int i;
        this.x_map2 = new ScalarMap(this.dtypes[0], Display.XAxis);
        this.y_map2 = new ScalarMap(this.dtypes[1], Display.YAxis);
        ScalarMap slice_map2 = new ScalarMap(this.dtypes[2], Display.SelectValue);
        ScalarMap anim_map2 = null;
        ScalarMap r_map2 = new ScalarMap(RED_TYPE, Display.Red);
        ScalarMap g_map2 = new ScalarMap(GREEN_TYPE, Display.Green);
        ScalarMap b_map2 = new ScalarMap(BLUE_TYPE, Display.Blue);
        this.bio.display2.addMap(this.x_map2);
        this.bio.display2.addMap(this.y_map2);
        this.bio.display2.addMap(slice_map2);
        if (this.hasThumbs) {
            anim_map2 = new ScalarMap(TIME_TYPE, Display.Animation);
            this.bio.display2.addMap(anim_map2);
        }
        this.bio.display2.addMap(r_map2);
        this.bio.display2.addMap(g_map2);
        this.bio.display2.addMap(b_map2);
        this.rmaps2 = new ScalarMap[this.rtypes.length];
        int i2 = 0;
        while (i2 < this.rtypes.length) {
            this.rmaps2[i2] = new ScalarMap(this.rtypes[i2], Display.RGB);
            this.bio.display2.addMap(this.rmaps2[i2]);
            ++i2;
        }
        DisplayRenderer dr2 = this.bio.display2.getDisplayRenderer();
        boolean on = this.renderer2 == null ? true : this.renderer2.getEnabled();
        this.renderer2 = dr2.makeDefaultRenderer();
        this.renderer2.toggle(on);
        this.bio.display2.addReferences(this.renderer2, this.ref2);
        on = this.planeRenderer2 == null ? false : this.planeRenderer2.getEnabled();
        this.planeRenderer2 = dr2.makeDefaultRenderer();
        this.planeRenderer2.suppressExceptions(true);
        this.planeRenderer2.toggle(on);
        this.bio.display2.addReferences(this.planeRenderer2, this.planeRef);
        if (this.hasThumbs) {
            on = this.lowresRenderer2 == null ? false : this.lowresRenderer2.getEnabled();
            this.lowresRenderer2 = dr2.makeDefaultRenderer();
            this.lowresRenderer2.toggle(on);
            this.bio.display2.addReferences(this.lowresRenderer2, this.lowresRef2);
        }
        this.bio.mm.pool2.init();
        this.res_x = 0;
        this.res_y = 0;
        this.min_x = Float.MAX_VALUE;
        this.min_y = Float.MAX_VALUE;
        this.max_x = Float.MIN_VALUE;
        this.max_y = Float.MIN_VALUE;
        int i3 = 0;
        while (i3 < (this.filesAsSlices ? this.slices : 1)) {
            GriddedSet set = (GriddedSet)((FieldImpl)this.field.getSample(i3)).getDomainSet();
            float[] lo = set.getLow();
            float[] hi = set.getHi();
            int[] lengths = set.getLengths();
            if (this.res_x < lengths[0]) {
                this.res_x = lengths[0];
            }
            if (this.res_y < lengths[1]) {
                this.res_y = lengths[1];
            }
            if (this.min_x > lo[0]) {
                this.min_x = lo[0];
            }
            if (this.max_x < hi[0]) {
                this.max_x = hi[0];
            }
            if (this.min_y > lo[1]) {
                this.min_y = lo[1];
            }
            if (this.max_y < hi[1]) {
                this.max_y = hi[1];
            }
            ++i3;
        }
        if (this.min_x != this.min_x) {
            this.min_x = 0.0f;
        }
        if (this.max_x != this.max_x) {
            this.max_x = 0.0f;
        }
        this.x_map2.setRange(this.min_x, this.max_x);
        if (this.min_y != this.min_y) {
            this.min_y = 0.0f;
        }
        if (this.max_y != this.max_y) {
            this.max_y = 0.0f;
        }
        this.y_map2.setRange(this.min_y, this.max_y);
        this.min_z = 0.0f;
        this.max_z = this.slices - 1;
        slice_map2.setRange(this.min_z, this.max_z);
        r_map2.setRange(0.0, 255.0);
        g_map2.setRange(0.0, 255.0);
        b_map2.setRange(0.0, 255.0);
        ScalarMap x_map3 = null;
        ScalarMap y_map3 = null;
        ScalarMap z_map3a = null;
        ScalarMap z_map3b = null;
        ScalarMap anim_map3 = null;
        ScalarMap r_map3 = null;
        ScalarMap g_map3 = null;
        ScalarMap b_map3 = null;
        DisplayRenderer dr3 = null;
        this.widgets = new LabeledColorWidget[this.rtypes.length];
        if (this.bio.display3 == null) {
            i = 0;
            while (i < this.rtypes.length) {
                this.widgets[i] = new LabeledColorWidget(new ColorMapWidget(this.rmaps2[i], false));
                this.bio.toolColor.addWidget(this.rmaps2[i].getScalarName(), this.widgets[i]);
                this.rmaps2[i].getControl().addControlListener(this);
                ++i;
            }
        } else {
            x_map3 = new ScalarMap(this.dtypes[0], Display.XAxis);
            y_map3 = new ScalarMap(this.dtypes[1], Display.YAxis);
            z_map3a = new ScalarMap(this.dtypes[2], Display.ZAxis);
            z_map3b = new ScalarMap(Z_TYPE, Display.ZAxis);
            if (this.hasThumbs) {
                anim_map3 = new ScalarMap(TIME_TYPE, Display.Animation);
            }
            r_map3 = new ScalarMap(RED_TYPE, Display.Red);
            g_map3 = new ScalarMap(GREEN_TYPE, Display.Green);
            b_map3 = new ScalarMap(BLUE_TYPE, Display.Blue);
            this.bio.display3.addMap(x_map3);
            this.bio.display3.addMap(y_map3);
            this.bio.display3.addMap(z_map3a);
            this.bio.display3.addMap(z_map3b);
            if (this.hasThumbs) {
                this.bio.display3.addMap(anim_map3);
            }
            this.bio.display3.addMap(r_map3);
            this.bio.display3.addMap(g_map3);
            this.bio.display3.addMap(b_map3);
            this.rmaps3 = new ScalarMap[this.rtypes.length];
            i = 0;
            while (i < this.rtypes.length) {
                this.rmaps3[i] = new ScalarMap(this.rtypes[i], Display.RGBA);
                this.bio.display3.addMap(this.rmaps3[i]);
                this.widgets[i] = new LabeledColorWidget(new ColorMapWidget(this.rmaps3[i], false));
                this.bio.toolColor.addWidget(this.rmaps3[i].getScalarName(), this.widgets[i]);
                this.rmaps3[i].getControl().addControlListener(this);
                ++i;
            }
            dr3 = this.bio.display3.getDisplayRenderer();
            on = this.renderer3 == null ? true : this.renderer3.getEnabled();
            this.renderer3 = this.bio.display3.getDisplayRenderer().makeDefaultRenderer();
            this.renderer3.toggle(on);
            this.bio.display3.addReferences(this.renderer3, this.ref3);
            if (this.hasThumbs) {
                on = this.lowresRenderer3 == null ? false : this.lowresRenderer3.getEnabled();
                this.lowresRenderer3 = dr3.makeDefaultRenderer();
                this.lowresRenderer3.toggle(on);
                this.bio.display3.addReferences(this.lowresRenderer3, this.lowresRef3);
            }
            this.bio.mm.pool3.init();
            x_map3.setRange(this.min_x, this.max_x);
            y_map3.setRange(this.min_y, this.max_y);
            z_map3a.setRange(this.min_z, this.max_z);
            z_map3b.setRange(this.min_z, this.max_z);
            r_map3.setRange(0.0, 255.0);
            g_map3.setRange(0.0, 255.0);
            b_map3.setRange(0.0, 255.0);
        }
        ScalarMap anim_map_prev = null;
        ScalarMap anim_map_next = null;
        if (this.hasThumbs && this.bio.previous != null && this.bio.next != null) {
            this.rmapsP = new ScalarMap[2][];
            int j = 0;
            while (j < 2) {
                DataReferenceImpl ref;
                DisplayImpl display;
                ScalarMap x_mapP = new ScalarMap(this.dtypes[0], Display.XAxis);
                ScalarMap y_mapP = new ScalarMap(this.dtypes[1], Display.YAxis);
                ScalarMap z_mapPa = new ScalarMap(this.dtypes[2], Display.ZAxis);
                ScalarMap z_mapPb = new ScalarMap(Z_TYPE, Display.ZAxis);
                ScalarMap anim_mapP = new ScalarMap(TIME_TYPE, Display.Animation);
                ScalarMap r_mapP = new ScalarMap(RED_TYPE, Display.Red);
                ScalarMap g_mapP = new ScalarMap(GREEN_TYPE, Display.Green);
                ScalarMap b_mapP = new ScalarMap(BLUE_TYPE, Display.Blue);
                if (j == 0) {
                    display = this.bio.previous;
                    ref = this.ref_prev;
                    anim_map_prev = anim_mapP;
                } else {
                    display = this.bio.next;
                    ref = this.ref_next;
                    anim_map_next = anim_mapP;
                }
                display.addMap(x_mapP);
                display.addMap(y_mapP);
                display.addMap(z_mapPa);
                display.addMap(z_mapPb);
                display.addMap(anim_mapP);
                display.addMap(r_mapP);
                display.addMap(g_mapP);
                display.addMap(b_mapP);
                this.rmapsP[j] = new ScalarMap[this.rtypes.length];
                int i4 = 0;
                while (i4 < this.rtypes.length) {
                    this.rmapsP[j][i4] = new ScalarMap(this.rtypes[i4], Display.RGB);
                    display.addMap(this.rmapsP[j][i4]);
                    ++i4;
                }
                display.addReference(ref);
                x_mapP.setRange(this.min_x, this.max_x);
                y_mapP.setRange(this.min_y, this.max_y);
                z_mapPa.setRange(this.min_z, this.max_z);
                z_mapPb.setRange(this.min_z, this.max_z);
                r_mapP.setRange(0.0, 255.0);
                g_mapP.setRange(0.0, 255.0);
                b_mapP.setRange(0.0, 255.0);
                ++j;
            }
        }
        if (this.value_control2 != null) {
            this.value_control2.removeControlListener(this);
        }
        if (this.anim_control2 != null) {
            this.anim_control2.removeControlListener(this);
        }
        this.value_control2 = (ValueControl)((Object)slice_map2.getControl());
        if (this.hasThumbs) {
            this.anim_control2 = (AnimationControl)((Object)anim_map2.getControl());
            this.bio.toolView.setControl(this.anim_control2);
            this.anim_control2.addControlListener(this);
            if (this.bio.display3 != null) {
                this.anim_control3 = (AnimationControl)((Object)anim_map3.getControl());
                this.anim_control_prev = (AnimationControl)((Object)anim_map_prev.getControl());
                this.anim_control_next = (AnimationControl)((Object)anim_map_next.getControl());
            }
        }
        this.value_control2.addControlListener(this);
        if (this.bio.display3 != null) {
            if (this.arb == null) {
                this.arb = new ArbitrarySlice(this.bio.display3);
                this.arb.addListener(this);
            }
            this.arb.init(this.dtypes[0], this.dtypes[1], this.dtypes[2], Color.cyan, Color.white, this.min_x, this.min_y, this.min_z, this.max_x, this.max_y, this.max_z, this.min_x, this.max_y, this.max_z);
            if (this.align == null) {
                this.align = new AlignmentPlane(this.bio.display3);
            }
            this.align.init(this.dtypes[0], this.dtypes[1], this.dtypes[2], Color.red, Color.red, this.min_x, this.min_y, this.min_z, this.max_x, this.max_y, this.max_z, this.min_x, this.max_y, this.max_z);
        }
        this.bio.setAspect(this.res_x, this.res_y, Double.NaN);
        if (this.bio.display3 != null) {
            this.bio.display3.addDisplayListener(this);
        }
    }

    private void refresh(boolean new_slice, boolean new_index) {
        if (this.files == null) {
            return;
        }
        if (new_index) {
            this.sliceField = null;
            if (!this.lowres) {
                try {
                    this.setFile(false);
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
            }
            if (this.volume) {
                this.updateVolumeField();
            }
            this.updateList();
            this.updateAnimationControls();
        }
        if (new_slice) {
            this.bio.mm.pool2.setSlice(this.slice);
            try {
                this.value_control2.setValue(this.slice);
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
        if (this.planeSelect) {
            this.updateSlice();
        } else if (this.lowres) {
            if (this.hasThumbs) {
                this.lowresRenderer2.toggle(true);
            }
            this.renderer2.toggle(false);
        } else {
            this.renderer2.toggle(true);
            if (this.hasThumbs) {
                this.lowresRenderer2.toggle(false);
            }
        }
        if (this.bio.display3 != null) {
            if (this.lowres) {
                if (this.hasThumbs) {
                    this.lowresRenderer3.toggle(true);
                }
                this.renderer3.toggle(false);
            } else {
                this.renderer3.toggle(true);
                if (this.hasThumbs) {
                    this.lowresRenderer3.toggle(false);
                }
            }
        }
    }

    private void setMode(boolean lowres, boolean doVolume) {
        this.bio.toolView.setMode(lowres);
        if (this.lowres == lowres) {
            return;
        }
        this.lowres = lowres;
        this.sliceField = null;
        this.volumeField = null;
        this.refresh(this.mode_slice != this.slice, this.mode_index != this.index);
        this.mode_index = this.index;
        this.mode_slice = this.slice;
        if (doVolume && this.volume) {
            this.doVolumeMode();
        }
    }

    private void doVolumeMode() {
        this.updateVolumeField();
        try {
            if (this.lowres) {
                this.ref3.setData(this.field);
            } else {
                this.lowresRef3.setData(this.lowresField);
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    void updateAnimationControls() {
        try {
            if (this.anim_control2 != null) {
                this.anim_control2.setCurrent(this.index);
            }
            if (this.anim_control3 != null) {
                this.anim_control3.setCurrent(this.index);
            }
            if (this.anim_control_prev != null) {
                this.anim_control_prev.setCurrent(this.index - 1);
            }
            if (this.anim_control_next != null) {
                this.anim_control_next.setCurrent(this.index + 1);
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    private void updateSlice() {
        this.bio.setWaitCursor(true);
        try {
            if (this.sliceField == null) {
                this.updateSliceField();
            }
            this.planeRef.setData(this.arb.extractSlice(this.sliceField, this.sliceRes_x, this.sliceRes_y, this.res_x, this.res_y));
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        this.bio.setWaitCursor(false);
    }

    /*
     * Unable to fully structure code
     */
    private void updateSliceField() {
        block12: {
            try {
                f = this.lowres != false ? (FieldImpl)this.lowresField.getSample(this.index) : this.field;
                try {
                    this.sliceField = (FlatField)f.domainMultiply();
                    break block12;
                }
                catch (FieldException exc) {
                    set = (GriddedSet)f.getDomainSet();
                    len = set.getLengths()[0];
                    res_x = 0;
                    res_y = 0;
                    i = 0;
                    ** while (i < len)
                }
lbl-1000:
                // 1 sources

                {
                    flat = (FlatField)f.getSample(i);
                    flat_set = (GriddedSet)flat.getDomainSet();
                    l = flat_set.getLengths();
                    if (l[0] > res_x) {
                        res_x = l[0];
                    }
                    if (l[1] > res_y) {
                        res_y = l[1];
                    }
                    ++i;
                    continue;
                }
lbl22:
                // 1 sources

                nf = new FieldImpl((FunctionType)f.getType(), set);
                i = 0;
                while (i < len) {
                    flat = (FlatField)f.getSample(i);
                    flat_set = (GriddedSet)flat.getDomainSet();
                    l = flat_set.getLengths();
                    if (l[0] > res_x) {
                        res_x = l[0];
                    }
                    if (l[1] > res_y) {
                        res_y = l[1];
                    }
                    ++i;
                }
                i = 0;
                while (i < len) {
                    flat = (FlatField)f.getSample(i);
                    flat_set = (GriddedSet)flat.getDomainSet();
                    nf.setSample(i, (Data)flat.resample(new Integer2DSet(flat_set.getType(), res_x, res_y), 101, 202));
                    ++i;
                }
                this.sliceField = (FlatField)nf.domainMultiply();
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }

    private void updateVolumeField() {
        GriddedSet set;
        int[] len;
        this.bio.setWaitCursor(true);
        if (this.sliceField == null) {
            this.updateSliceField();
        }
        if ((len = (set = (GriddedSet)this.sliceField.getDomainSet()).getLengths())[0] == this.volumeRes && len[1] == this.volumeRes && len[2] == this.volumeRes) {
            this.volumeField = this.sliceField;
        } else {
            float[] lo = set.getLow();
            float[] hi = set.getHi();
            try {
                Linear3DSet nset = new Linear3DSet(set.getType(), lo[0], hi[0], this.volumeRes, lo[1], hi[1], this.volumeRes, lo[2], hi[2], this.volumeRes);
                this.volumeField = (FlatField)this.sliceField.resample(nset, 101, 202);
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
        if (this.volume) {
            try {
                if (this.lowres) {
                    this.lowresRef3.setData(this.volumeField);
                } else {
                    this.ref3.setData(this.volumeField);
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
        this.bio.setWaitCursor(false);
    }

    private void updateList() {
        MeasureList list = this.bio.mm.lists[this.index];
        this.bio.mm.pool2.set(list);
        if (this.bio.mm.pool3 != null) {
            this.bio.mm.pool3.set(list);
        }
    }
}

