/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visad.bio.ToolPanel;

public class SeriesChooser
extends JPanel {
    private static final String[] types = new String[]{"PIC", "TIFF", "MOV", "BMP"};
    JTextField prefix;
    JTextField start;
    JTextField end;
    JComboBox type;
    private JLabel treatLabel;
    JRadioButton treatTimestep;
    JRadioButton treatSlice;

    public SeriesChooser() {
        JLabel l1 = new JLabel("File prefix");
        JLabel l2 = new JLabel("Start");
        JLabel l3 = new JLabel("End");
        JLabel l4 = new JLabel("Extension");
        this.treatLabel = new JLabel("Treat each file as a:");
        l1.setForeground(Color.black);
        l2.setForeground(Color.black);
        l3.setForeground(Color.black);
        l4.setForeground(Color.black);
        this.treatLabel.setForeground(Color.black);
        this.prefix = new JTextField(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 150;
                return d;
            }
        };
        this.start = new JTextField();
        this.end = new JTextField();
        Vector<String> items = new Vector<String>(types.length);
        int i = 0;
        while (i < types.length) {
            items.add(types[i]);
            ++i;
        }
        this.type = new JComboBox(items){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 60;
                return d;
            }
        };
        this.type.setEditable(true);
        this.treatTimestep = new JRadioButton("timestep");
        this.treatSlice = new JRadioButton("slice");
        this.treatTimestep.setForeground(Color.black);
        this.treatSlice.setForeground(Color.black);
        this.treatTimestep.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.treatTimestep);
        group.add(this.treatSlice);
        this.setLayout(new BoxLayout(this, 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BoxLayout(topLeft, 1));
        topLeft.add(ToolPanel.pad(l1, false, true));
        topLeft.add(this.prefix);
        top.add(topLeft);
        JPanel topMid1 = new JPanel();
        topMid1.setLayout(new BoxLayout(topMid1, 1));
        topMid1.add(ToolPanel.pad(l2, false, true));
        topMid1.add(this.start);
        top.add(topMid1);
        JPanel topMid2 = new JPanel();
        topMid2.setLayout(new BoxLayout(topMid2, 1));
        topMid2.add(ToolPanel.pad(l3, false, true));
        topMid2.add(this.end);
        top.add(topMid2);
        JPanel topRight = new JPanel();
        topRight.setLayout(new BoxLayout(topRight, 1));
        topRight.add(ToolPanel.pad(l4, false, true));
        topRight.add(this.type);
        top.add(topRight);
        this.add(top);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(ToolPanel.pad(this.treatLabel, false, true));
        bottom.add(this.treatTimestep);
        bottom.add(this.treatSlice);
        this.add(bottom);
    }

    public File[] getSeries() {
        File[] series;
        boolean dot;
        String p = this.prefix.getText();
        String s = this.start.getText();
        String e = this.end.getText();
        String t = (String)this.type.getSelectedItem();
        int first = -1;
        int last = -1;
        try {
            first = Integer.parseInt(s);
            last = Integer.parseInt(e);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        boolean bl = dot = t != null && !t.equals("");
        if (dot) {
            t = "." + t;
        }
        if (first < 0 || last < 0) {
            series = new File[1];
            String name = p + (dot ? t : "");
            series[0] = new File(name);
        } else {
            int count = last - first + 1;
            series = new File[count];
            int c = first;
            int i = 0;
            while (i < count) {
                String name = p + c + (dot ? t : "");
                series[i] = new File(name);
                ++i;
                ++c;
            }
        }
        return series;
    }

    public String getPrefix() {
        return this.prefix.getText();
    }

    public boolean getFilesAsSlices() {
        return this.treatSlice.isSelected();
    }

    public void clearFields() {
        this.prefix.setText("");
        this.start.setText("");
        this.end.setText("");
        this.type.setSelectedItem(types[0]);
    }
}

