/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.rmi.RemoteException;
import visad.CellImpl;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.Real;
import visad.RealTuple;
import visad.VisADException;
import visad.bio.MeasurePoint;
import visad.bio.VisBio;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public class PoolPoint {
    private VisBio bio;
    DataReferenceImpl ref;
    private DisplayImpl display;
    private DataRenderer renderer;
    private int dim;
    MeasurePoint point;

    public PoolPoint(VisBio biovis, DisplayImpl display, String name, int dimension) {
        this.bio = biovis;
        this.display = display;
        try {
            this.ref = new DataReferenceImpl("bio_" + name);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        this.dim = dimension;
        final PoolPoint pt = this;
        CellImpl cell = new CellImpl(){

            public void doAction() {
                if (PoolPoint.this.point == null) {
                    return;
                }
                RealTuple tuple = (RealTuple)PoolPoint.this.ref.getData();
                if (tuple == null) {
                    return;
                }
                double[] v = tuple.getValues();
                if (PoolPoint.this.dim == 3) {
                    int numSlices = ((PoolPoint)PoolPoint.this).bio.sm.getNumberOfSlices();
                    int slice = (int)(v[2] + 0.5);
                    if (slice < 0) {
                        slice = 0;
                    } else if (slice >= numSlices) {
                        slice = numSlices - 1;
                    }
                    v[2] = slice;
                }
                PoolPoint.this.point.setCoordinates(pt, v[0], v[1], PoolPoint.this.dim == 3 ? v[2] : PoolPoint.this.point.z);
            }
        };
        try {
            cell.addReference(this.ref);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    public void init() throws VisADException, RemoteException {
        this.renderer = this.display instanceof DisplayImplJ3D ? new DirectManipulationRendererJ3D() : new DirectManipulationRendererJ2D();
        this.renderer.setPickCrawlToCursor(false);
        this.renderer.suppressExceptions(true);
        this.renderer.toggle(false);
        this.display.addReferences(this.renderer, this.ref);
    }

    public void toggle(boolean on) {
        this.renderer.toggle(on);
    }

    public void refresh() {
        if (this.point == null) {
            this.renderer.toggle(false);
            return;
        }
        this.renderer.toggle(true);
        try {
            double[] v;
            RealTuple tuple = (RealTuple)this.ref.getData();
            if (tuple != null && (v = tuple.getValues())[0] == this.point.x && v[1] == this.point.y && (this.dim == 2 || v[2] == this.point.z)) {
                return;
            }
            if (this.dim == 3) {
                this.ref.setData(new RealTuple(new Real[]{new Real(this.bio.sm.dtypes[0], this.point.x), new Real(this.bio.sm.dtypes[1], this.point.y), new Real(this.bio.sm.dtypes[2], this.point.z)}));
            } else {
                this.ref.setData(new RealTuple(new Real[]{new Real(this.bio.sm.dtypes[0], this.point.x), new Real(this.bio.sm.dtypes[1], this.point.y)}));
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }
}

