/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.bio.PlaneListener;
import visad.java3d.DirectManipulationRendererJ3D;

public class PlaneSelector {
    protected DisplayImpl display;
    protected DataReferenceImpl[] refs = new DataReferenceImpl[5];
    protected DataRenderer[] renderers = new DataRenderer[5];
    protected CellImpl cell;
    protected RealType xtype;
    protected RealType ytype;
    protected RealType ztype;
    protected double x1;
    protected double y1;
    protected double z1;
    protected double x2;
    protected double y2;
    protected double z2;
    protected double x3;
    protected double y3;
    protected double z3;
    protected boolean visible;
    protected Gridded3DSet lines;
    protected Gridded3DSet plane;
    protected Vector listeners = new Vector();

    public PlaneSelector(DisplayImpl display) {
        this.display = display;
        this.cell = new CellImpl(){

            public void doAction() {
                PlaneSelector.this.refresh();
            }
        };
        this.cell.disableAction();
        try {
            int i = 0;
            while (i < this.refs.length) {
                if (i > 1) {
                    this.refs[i] = new DataReferenceImpl("bio_plane" + i);
                    this.cell.addReference(this.refs[i]);
                } else {
                    this.refs[i] = new DataReferenceImpl(i == 0 ? "bio_edges" : "bio_plane");
                }
                ++i;
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        this.cell.enableAction();
    }

    public void toggle(boolean visible) {
        this.visible = visible;
        int i = 0;
        while (i < this.renderers.length) {
            this.renderers[i].toggle(visible);
            ++i;
        }
    }

    public void init(RealType xtype, RealType ytype, RealType ztype, Color lineColor, Color planeColor, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) throws VisADException, RemoteException {
        this.xtype = xtype;
        this.ytype = ytype;
        this.ztype = ztype;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.x3 = x3;
        this.y3 = y3;
        this.z3 = z3;
        this.visible = false;
        float line_r = (float)lineColor.getRed() / 255.0f;
        float line_g = (float)lineColor.getGreen() / 255.0f;
        float line_b = (float)lineColor.getBlue() / 255.0f;
        float plane_r = (float)planeColor.getRed() / 255.0f;
        float plane_g = (float)planeColor.getGreen() / 255.0f;
        float plane_b = (float)planeColor.getBlue() / 255.0f;
        DisplayRenderer displayRenderer = this.display.getDisplayRenderer();
        int i = 0;
        while (i < this.refs.length) {
            ConstantMap[] maps;
            if (i == 0) {
                this.renderers[i] = displayRenderer.makeDefaultRenderer();
                maps = new ConstantMap[]{new ConstantMap(line_r, Display.Red), new ConstantMap(line_g, Display.Green), new ConstantMap(line_b, Display.Blue), new ConstantMap(3.0, Display.LineWidth)};
            } else if (i == 1) {
                this.renderers[i] = displayRenderer.makeDefaultRenderer();
                maps = new ConstantMap[]{new ConstantMap(plane_r, Display.Red), new ConstantMap(plane_g, Display.Green), new ConstantMap(plane_b, Display.Blue), new ConstantMap(0.75, Display.Alpha)};
            } else {
                this.renderers[i] = new DirectManipulationRendererJ3D();
                this.renderers[i].setPickCrawlToCursor(false);
                maps = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(6.0, Display.PointSize)};
            }
            this.renderers[i].suppressExceptions(true);
            this.renderers[i].toggle(false);
            this.display.addReferences(this.renderers[i], this.refs[i], maps);
            ++i;
        }
    }

    public void addListener(PlaneListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PlaneListener l) {
        this.listeners.remove(l);
    }

    public boolean isVisible() {
        return this.visible;
    }

    void saveState(PrintWriter fout) throws IOException, VisADException {
        int i = 2;
        while (i < this.refs.length) {
            Real[] realArray;
            RealTuple tuple = (RealTuple)this.refs[i].getData();
            if (tuple == null) {
                Real[] realArray2 = new Real[3];
                realArray2[0] = null;
                realArray2[1] = null;
                realArray = realArray2;
                realArray2[2] = null;
            } else {
                realArray = tuple.getRealComponents();
            }
            Real[] r = realArray;
            int j = 0;
            while (j < 3) {
                double value = r[j] == null ? Double.NaN : r[j].getValue();
                fout.println(value);
                ++j;
            }
            ++i;
        }
    }

    void restoreState(BufferedReader fin) throws IOException, VisADException {
        int i = 0;
        while (i < this.refs.length - 2) {
            try {
                double x = Double.parseDouble(fin.readLine().trim());
                double y = Double.parseDouble(fin.readLine().trim());
                double z = Double.parseDouble(fin.readLine().trim());
                this.setData(i, x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    protected boolean refresh() {
        int len = this.refs.length - 2;
        RealTuple[] tuple = new RealTuple[len];
        int i = 0;
        while (i < len) {
            tuple[i] = (RealTuple)this.refs[i + 2].getData();
            if (tuple[i] == null) {
                double vy;
                double vx;
                if (this.xtype == null) {
                    return true;
                }
                double d = i == 0 ? this.x1 : (vx = i == 1 ? this.x2 : this.x3);
                double d2 = i == 0 ? this.y1 : (vy = i == 1 ? this.y2 : this.y3);
                double vz = i == 0 ? this.z1 : (i == 1 ? this.z2 : this.z3);
                this.setData(i, vx, vy, vz);
                return false;
            }
            ++i;
        }
        this.lines = null;
        this.plane = null;
        try {
            if (!this.computePlane(tuple)) {
                return false;
            }
            this.refs[0].setData(this.lines);
            this.refs[1].setData(this.plane);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        this.notifyListeners();
        return true;
    }

    protected boolean computePlane(RealTuple[] tuple) throws VisADException {
        int len = tuple.length;
        float[][] samples = new float[3][len + 1];
        int i = 0;
        while (i < len) {
            double[] values = tuple[i].getValues();
            int j = 0;
            while (j < 3) {
                samples[j][i] = (float)values[j];
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < 3) {
            samples[j][len] = samples[j][0];
            ++j;
        }
        RealTupleType type = (RealTupleType)tuple[0].getType();
        float[][] samps = new float[3][4];
        int i2 = 0;
        while (i2 < 3) {
            samps[i2][0] = samples[i2][0];
            samps[i2][1] = (samples[i2][0] + samples[i2][1]) / 2.0f;
            samps[i2][2] = samples[i2][2];
            samps[i2][3] = samples[i2][1];
            ++i2;
        }
        this.lines = new Gridded3DSet((MathType)type, samples, 4, null, null, null, false);
        this.plane = new Gridded3DSet((MathType)type, samps, 2, 2, null, null, null, false);
        return true;
    }

    protected void setData(int i, double x, double y, double z) {
        try {
            this.refs[i + 2].setData(new RealTuple(new Real[]{new Real(this.xtype, x), new Real(this.ytype, y), new Real(this.ztype, z)}));
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    protected void notifyListeners() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            PlaneListener l = (PlaneListener)this.listeners.elementAt(i);
            l.planeChanged();
            ++i;
        }
    }
}

