/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.CellImpl;
import visad.ConstantMap;
import visad.Control;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Scalar;
import visad.ScalarMap;
import visad.Set;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.bom.RubberBandLineRendererJ3D;
import visad.data.DefaultFamily;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.VisADSlider;

public class MultiLUT
implements ActionListener {
    private static final int NFILES = 17;
    private TextType text = null;
    private RealType element = null;
    private RealType line = null;
    private RealType value = null;
    private TupleType text_tuple = null;
    private float[][] data_values = null;
    private float[][] values = null;
    private float[][] wedge_samples = null;
    private FlatField data = null;
    private FieldImpl text_field = null;
    private FlatField wedge = null;
    private DataReferenceImpl[] value_refs = null;
    private DataReferenceImpl[] hue_refs = null;
    private int npixels = 0;
    private JLabel minmax = null;
    private DisplayImplJ3D display1 = null;
    ScalarMap vmap = null;
    ScalarMap hmap = null;
    ScalarMap huexmap = null;
    private DataReferenceImpl line_ref = null;

    public static void main(String[] args) throws IOException, VisADException, RemoteException {
        MultiLUT ml = new MultiLUT();
        ml.go(args);
    }

    public void go(String[] args) throws IOException, VisADException, RemoteException {
        String dir = "";
        String slash = System.getProperty("file.separator");
        if (args.length > 0 && !(dir = args[0]).endsWith(slash)) {
            dir = dir + slash;
        }
        RealTupleType domain = null;
        Unit unit = null;
        String name = null;
        Set set = null;
        RealType[] value_types = new RealType[17];
        this.values = new float[17][];
        DefaultFamily loader = new DefaultFamily("loader");
        int i = 0;
        while (i < 17) {
            Tuple tuple = (Tuple)loader.open(dir + "SPB" + (i + 1) + ".PIC");
            FieldImpl field = (FieldImpl)tuple.getComponent(0);
            FlatField ff = (FlatField)field.getSample(0);
            set = ff.getDomainSet();
            if (i == 0) {
                FunctionType func = (FunctionType)ff.getType();
                domain = func.getDomain();
                this.element = (RealType)domain.getComponent(0);
                this.line = (RealType)domain.getComponent(1);
                this.value = (RealType)func.getRange();
                unit = this.value.getDefaultUnit();
                name = this.value.getName();
            }
            value_types[i] = RealType.getRealType(name + (i + 1), unit);
            float[][] temps = ff.getFloats(false);
            this.values[i] = temps[0];
            ++i;
        }
        this.npixels = this.values[0].length;
        RealTupleType range = new RealTupleType(value_types);
        FunctionType big_func = new FunctionType(domain, range);
        final FlatField big_data = new FlatField(big_func, set);
        big_data.setSamples(this.values, false);
        RealType hue = RealType.getRealType("hue");
        RealType HUE = RealType.getRealType("HUE");
        RealTupleType new_range = new RealTupleType(this.value, hue);
        FunctionType new_func = new FunctionType(domain, new_range);
        this.data = new FlatField(new_func, set);
        this.data_values = new float[2][this.npixels];
        DataReferenceImpl ref1 = new DataReferenceImpl("ref1");
        ref1.setData(this.data);
        this.text = TextType.getTextType("text");
        RealType[] time = new RealType[]{RealType.Time};
        RealTupleType time_type = new RealTupleType(time);
        MathType[] mtypes = new MathType[]{this.element, this.line, this.text};
        this.text_tuple = new TupleType(mtypes);
        FunctionType text_function = new FunctionType(RealType.Time, this.text_tuple);
        Linear1DSet time_set = new Linear1DSet((MathType)time_type, 0.0, 1.0, 2);
        this.text_field = new FieldImpl(text_function, time_set);
        DataReferenceImpl text_ref = new DataReferenceImpl("text_ref");
        text_ref.setData(this.text_field);
        Linear2DSet wedge_set = new Linear2DSet((MathType)domain, 0.0, 767.0, 768, 550.0, 570.0, 21);
        this.wedge = new FlatField(new_func, wedge_set);
        this.wedge_samples = new float[2][16128];
        DataReferenceImpl wedge_ref = new DataReferenceImpl("wedge_ref");
        wedge_ref.setData(this.wedge);
        final DataReferenceImpl xref = new DataReferenceImpl("xref");
        this.display1 = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap xmap = new ScalarMap(this.element, Display.XAxis);
        this.display1.addMap(xmap);
        this.huexmap = new ScalarMap(HUE, Display.XAxis);
        this.display1.addMap(this.huexmap);
        ScalarMap ymap = new ScalarMap(this.line, Display.YAxis);
        this.display1.addMap(ymap);
        ymap.setRange(0.0, 511.0);
        this.vmap = new ScalarMap(this.value, Display.Value);
        this.display1.addMap(this.vmap);
        this.hmap = new ScalarMap(hue, Display.Hue);
        this.display1.addMap(this.hmap);
        ScalarMap textmap = new ScalarMap(this.text, Display.Text);
        this.display1.addMap(textmap);
        this.display1.addMap(new ConstantMap(1.0, Display.Saturation));
        Control ctrl = textmap.getControl();
        if (ctrl != null && ctrl instanceof TextControl) {
            TextControl text_control = (TextControl)ctrl;
            text_control.setSize(1.0);
            text_control.setJustification(TextControl.Justification.CENTER);
            text_control.setAutoSize(true);
        }
        this.display1.addReference(ref1);
        DefaultRendererJ3D renderer = new DefaultRendererJ3D();
        this.display1.addReferences((DataRenderer)renderer, xref);
        renderer.suppressExceptions(true);
        DefaultRendererJ3D text_renderer = new DefaultRendererJ3D();
        this.display1.addReferences((DataRenderer)text_renderer, text_ref);
        text_renderer.suppressExceptions(true);
        DefaultRendererJ3D wedge_renderer = new DefaultRendererJ3D();
        this.display1.addReferences((DataRenderer)wedge_renderer, wedge_ref);
        wedge_renderer.suppressExceptions(true);
        this.line_ref = new DataReferenceImpl("line");
        Gridded2DSet dummy_set = new Gridded2DSet((MathType)domain, null, 1);
        this.line_ref.setData(dummy_set);
        this.display1.addReferences((DataRenderer)new RubberBandLineRendererJ3D(this.element, this.line), this.line_ref);
        final RealType channel = RealType.getRealType("channel");
        final RealType point = RealType.getRealType("point");
        RealType intensity = RealType.getRealType("intensity");
        final FunctionType spectrum_type = new FunctionType(channel, intensity);
        final FunctionType spectra_type = new FunctionType(point, spectrum_type);
        final FunctionType line_type = new FunctionType(point, intensity);
        final FunctionType lines_type = new FunctionType(channel, line_type);
        final DataReferenceImpl ref2 = new DataReferenceImpl("ref2");
        DisplayImplJ3D display2 = new DisplayImplJ3D("display2");
        ScalarMap xmap2 = new ScalarMap(channel, Display.XAxis);
        display2.addMap(xmap2);
        ScalarMap ymap2 = new ScalarMap(intensity, Display.YAxis);
        display2.addMap(ymap2);
        ScalarMap zmap2 = new ScalarMap(point, Display.ZAxis);
        display2.addMap(zmap2);
        display2.getGraphicsModeControl().setScaleEnable(true);
        DefaultRendererJ3D renderer2 = new DefaultRendererJ3D();
        display2.addReferences((DataRenderer)renderer2, ref2);
        renderer2.suppressExceptions(true);
        final RealTupleType fdomain = domain;
        CellImpl cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Set cell_set = (Set)MultiLUT.this.line_ref.getData();
                if (cell_set == null) {
                    return;
                }
                float[][] samples = cell_set.getSamples();
                if (samples == null) {
                    return;
                }
                float x1 = samples[0][0];
                float x2 = samples[0][1];
                float y1 = samples[1][0];
                float y2 = samples[1][1];
                double dist = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
                int nsamp = (int)(dist + 1.0);
                if (nsamp < 2) {
                    nsamp = 2;
                }
                float[][] ss = new float[2][nsamp];
                int i = 0;
                while (i < nsamp) {
                    float a = (float)i / ((float)nsamp - 1.0f);
                    ss[0][i] = x1 + a * (x2 - x1);
                    ss[1][i] = y1 + a * (y2 - y1);
                    ++i;
                }
                Gridded2DSet line = new Gridded2DSet((MathType)fdomain, ss, nsamp);
                xref.setData(line);
                FlatField line_field = (FlatField)big_data.resample(line, 100, 202);
                float[][] line_samples = line_field.getFloats(false);
                Linear1DSet point_set = new Linear1DSet((MathType)point, 0.0, 1.0, nsamp);
                Integer1DSet channel_set = new Integer1DSet((MathType)channel, 17);
                FieldImpl spectra = new FieldImpl(spectra_type, point_set);
                int i2 = 0;
                while (i2 < nsamp) {
                    FlatField spectrum = new FlatField(spectrum_type, channel_set);
                    float[][] temp = new float[1][17];
                    int j = 0;
                    while (j < 17) {
                        temp[0][j] = line_samples[j][i2];
                        ++j;
                    }
                    spectrum.setSamples(temp, false);
                    spectra.setSample(i2, (Data)spectrum);
                    ++i2;
                }
                FieldImpl lines = new FieldImpl(lines_type, channel_set);
                int j = 0;
                while (j < 17) {
                    FlatField linex = new FlatField(line_type, point_set);
                    float[][] temp = new float[1][nsamp];
                    int i3 = 0;
                    while (i3 < nsamp) {
                        temp[0][i3] = line_samples[j][i3];
                        ++i3;
                    }
                    linex.setSamples(temp, false);
                    lines.setSample(j, (Data)linex);
                    ++j;
                }
                ref2.setData(new Tuple(new Data[]{spectra, lines}));
            }
        };
        cell.addReference(this.line_ref);
        VisADSlider[] value_sliders = new VisADSlider[17];
        VisADSlider[] hue_sliders = new VisADSlider[17];
        this.value_refs = new DataReferenceImpl[17];
        this.hue_refs = new DataReferenceImpl[17];
        JFrame frame = new JFrame("VisAD MultiLUT");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.setContentPane(panel);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.setAlignmentY(0.0f);
        left.setAlignmentX(0.0f);
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        center.setAlignmentY(0.0f);
        center.setAlignmentX(0.0f);
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        right.setAlignmentY(0.0f);
        right.setAlignmentX(0.0f);
        panel.add(left);
        panel.add(center);
        panel.add(right);
        Dimension d = new Dimension(300, 1000);
        left.setMaximumSize(d);
        center.setMaximumSize(d);
        int i2 = 0;
        while (i2 < 17) {
            this.value_refs[i2] = new DataReferenceImpl("value" + i2);
            this.value_refs[i2].setData(new Real(1.0));
            value_sliders[i2] = new VisADSlider("value" + i2, -100, 100, 100, 0.01, this.value_refs[i2], RealType.Generic);
            left.add(value_sliders[i2]);
            this.hue_refs[i2] = new DataReferenceImpl("hue" + i2);
            this.hue_refs[i2].setData(new Real(1.0));
            hue_sliders[i2] = new VisADSlider("hue" + i2, -100, 100, 100, 0.01, this.hue_refs[i2], RealType.Generic);
            center.add(hue_sliders[i2]);
            ++i2;
        }
        JButton value_clear = new JButton("Zero values");
        value_clear.addActionListener(this);
        value_clear.setActionCommand("value_clear");
        left.add(Box.createVerticalStrut(10));
        left.add(value_clear);
        JButton value_set = new JButton("One values");
        value_set.addActionListener(this);
        value_set.setActionCommand("value_set");
        left.add(value_set);
        JButton hue_clear = new JButton("Zero hues");
        hue_clear.addActionListener(this);
        hue_clear.setActionCommand("hue_clear");
        center.add(Box.createVerticalStrut(10));
        center.add(hue_clear);
        JButton hue_set = new JButton("One hues");
        hue_set.addActionListener(this);
        hue_set.setActionCommand("hue_set");
        center.add(hue_set);
        right.add(this.display1.getComponent());
        right.add(display2.getComponent());
        this.minmax = new JLabel(" ");
        left.add(Box.createVerticalStrut(30));
        left.add(this.minmax);
        JButton compute = new JButton("Compute");
        compute.addActionListener(this);
        compute.setActionCommand("compute");
        left.add(Box.createVerticalStrut(10));
        left.add(compute);
        int WIDTH = 1200;
        int HEIGHT = 1000;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        ((Component)frame).setSize(WIDTH, HEIGHT);
        ((Component)frame).setVisible(true);
        this.doit();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("compute")) {
            this.doit();
        } else if (cmd.equals("value_clear")) {
            try {
                int i = 0;
                while (i < 17) {
                    this.value_refs[i].setData(new Real(0.0));
                    ++i;
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        } else if (cmd.equals("value_set")) {
            try {
                int i = 0;
                while (i < 17) {
                    this.value_refs[i].setData(new Real(1.0));
                    ++i;
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        } else if (cmd.equals("hue_clear")) {
            try {
                int i = 0;
                while (i < 17) {
                    this.hue_refs[i].setData(new Real(0.0));
                    ++i;
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        } else if (cmd.equals("hue_set")) {
            try {
                int i = 0;
                while (i < 17) {
                    this.hue_refs[i].setData(new Real(1.0));
                    ++i;
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }

    public void doit() {
        try {
            float[] value_weights = new float[17];
            float[] hue_weights = new float[17];
            int i = 0;
            while (i < 17) {
                Real r = (Real)this.value_refs[i].getData();
                value_weights[i] = (float)r.getValue();
                r = (Real)this.hue_refs[i].getData();
                hue_weights[i] = (float)r.getValue();
                ++i;
            }
            float vmin = Float.MAX_VALUE;
            float vmax = Float.MIN_VALUE;
            float hmin = Float.MAX_VALUE;
            float hmax = Float.MIN_VALUE;
            int j = 0;
            while (j < this.npixels) {
                float v = 0.0f;
                float h = 0.0f;
                int i2 = 0;
                while (i2 < 17) {
                    v += value_weights[i2] * this.values[i2][j];
                    h += hue_weights[i2] * this.values[i2][j];
                    ++i2;
                }
                this.data_values[0][j] = v;
                this.data_values[1][j] = h;
                if (v < vmin) {
                    vmin = v;
                }
                if (v > vmax) {
                    vmax = v;
                }
                if (h < hmin) {
                    hmin = h;
                }
                if (h > hmax) {
                    hmax = h;
                }
                ++j;
            }
            int i3 = 0;
            while (i3 < 768) {
                float hue = hmin + (float)i3 / 767.0f * (hmax - hmin);
                int k = i3;
                while (k < 16128) {
                    this.wedge_samples[0][k] = vmax;
                    this.wedge_samples[1][k] = hue;
                    k += 768;
                }
                ++i3;
            }
            this.minmax.setText("vmin = " + vmin + "; vmax = " + vmax);
            double x1 = 0.0;
            double x2 = 767.0;
            double y = 525.0;
            this.text_field.setSample(0, (Data)new Tuple(this.text_tuple, new Scalar[]{new Real(this.element, x1), new Real(this.line, y), new Text(this.text, "" + hmin)}));
            this.text_field.setSample(1, (Data)new Tuple(this.text_tuple, new Scalar[]{new Real(this.element, x2), new Real(this.line, y), new Text(this.text, "" + hmax)}));
            this.display1.disableAction();
            this.vmap.setRange(vmin, vmax);
            this.hmap.setRange(hmin, hmax);
            this.huexmap.setRange(hmin, hmax);
            this.data.setSamples(this.data_values, false);
            this.wedge.setSamples(this.wedge_samples, false);
            this.display1.enableAction();
        }
        catch (VisADException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }
}

