/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visad.CellImpl;
import visad.VisADException;
import visad.bio.BioUtil;
import visad.bio.ColorRenderer;
import visad.bio.GroupDialog;
import visad.bio.MeasureGroup;
import visad.bio.MeasureLine;
import visad.bio.MeasureList;
import visad.bio.MeasurePoint;
import visad.bio.MeasureThing;
import visad.bio.PoolPoint;
import visad.bio.ToolPanel;
import visad.bio.VisBio;
import visad.browser.Convert;
import visad.browser.Divider;

public class MeasureToolPanel
extends ToolPanel {
    private static final Color[] COLORS = new Color[]{Color.white, Color.red, Color.orange, Color.green, Color.cyan, Color.blue, Color.magenta, Color.pink, Color.lightGray, Color.gray, Color.darkGray, Color.black};
    private static final String COORD_LABEL = " (0000.000, 0000.000)-(0000.000, 0000.000)";
    private static final String DIST_LABEL = "distance = 0000.000 pix";
    static int maxId = 0;
    private GroupDialog groupBox = new GroupDialog();
    private CellImpl cell;
    private boolean ignoreNextStandard = false;
    private boolean ignoreGroup = false;
    private boolean stdEnabled = true;
    private JLabel measureLabel = new JLabel("Measurements:");
    private JButton saveLines;
    private JButton restoreLines;
    private JButton addLine;
    private JButton addMarker;
    private JToggleButton merge;
    private JButton undo;
    private JButton clearAll;
    private JLabel measureCoord;
    private JLabel measureDist;
    private JCheckBox setStandard;
    private JButton removeSelected;
    private JLabel colorLabel;
    private JComboBox colorList;
    private JLabel groupLabel;
    private JComboBox groupList;
    private JButton newGroup;
    private JLabel descriptionLabel;
    private JTextArea descriptionBox;

    public MeasureToolPanel(VisBio biovis) {
        super(biovis);
        this.measureLabel.setForeground(Color.black);
        this.measureLabel.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.measureLabel));
        this.controls.add(Box.createVerticalStrut(5));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.saveLines = new JButton("Save");
        this.saveLines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasureToolPanel.this.bio.mm.saveMeasurements();
            }
        });
        this.saveLines.setEnabled(false);
        p.add(this.saveLines);
        p.add(Box.createHorizontalStrut(5));
        this.restoreLines = new JButton("Restore");
        this.restoreLines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasureToolPanel.this.bio.mm.restoreMeasurements();
            }
        });
        this.restoreLines.setEnabled(false);
        p.add(this.restoreLines);
        this.controls.add(ToolPanel.pad(p));
        this.controls.add(Box.createVerticalStrut(15));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.addLine = new JButton("New line");
        this.addLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasureToolPanel.this.bio.mm.getList().addLine();
                MeasureToolPanel.this.bio.state.saveState(false);
            }
        });
        this.addLine.setEnabled(false);
        p.add(this.addLine);
        p.add(Box.createHorizontalStrut(5));
        this.addMarker = new JButton("New marker");
        this.addMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasureToolPanel.this.bio.mm.getList().addMarker();
                MeasureToolPanel.this.bio.state.saveState(false);
            }
        });
        this.addMarker.setEnabled(false);
        p.add(this.addMarker);
        this.controls.add(ToolPanel.pad(p));
        this.controls.add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.merge = new JToggleButton("Merge");
        this.merge.setEnabled(false);
        p.add(this.merge);
        p.add(Box.createHorizontalStrut(5));
        this.undo = new JButton("Undo");
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasureToolPanel.this.bio.state.undo();
            }
        });
        this.undo.setEnabled(false);
        p.add(this.undo);
        p.add(Box.createHorizontalStrut(5));
        final MeasureToolPanel tool = this;
        this.clearAll = new JButton("Clear all");
        this.clearAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ans = JOptionPane.showConfirmDialog(tool, "Really clear all measurements?", "VisBio", 0, 3);
                if (ans != 0) {
                    return;
                }
                MeasureToolPanel.this.bio.mm.clear();
                MeasureToolPanel.this.bio.state.saveState(false);
            }
        });
        this.clearAll.setEnabled(false);
        p.add(this.clearAll);
        this.controls.add(ToolPanel.pad(p));
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        this.measureCoord = new JLabel(" "){

            public Dimension getPreferredSize() {
                FontMetrics fm = ((Component)this).getFontMetrics(this.getFont());
                int width = fm.stringWidth("     (0000.000, 0000.000)-(0000.000, 0000.000)");
                Dimension d = super.getPreferredSize();
                return new Dimension(width, d.height);
            }
        };
        this.controls.add(ToolPanel.pad(this.measureCoord));
        this.measureDist = new JLabel(" "){

            public Dimension getPreferredSize() {
                FontMetrics fm = ((Component)this).getFontMetrics(this.getFont());
                int width = fm.stringWidth("    distance = 0000.000 pix");
                Dimension d = super.getPreferredSize();
                return new Dimension(width, d.height);
            }
        };
        this.controls.add(ToolPanel.pad(this.measureDist));
        this.controls.add(Box.createVerticalStrut(10));
        this.cell = new CellImpl(){

            public void doAction() {
                MeasureToolPanel.this.updateMeasureInfo();
            }
        };
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.setStandard = new JCheckBox("Set standard");
        this.setStandard.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int ans;
                if (MeasureToolPanel.this.ignoreNextStandard) {
                    MeasureToolPanel.this.ignoreNextStandard = false;
                    return;
                }
                boolean std = MeasureToolPanel.this.setStandard.isSelected();
                if (!std && (ans = JOptionPane.showConfirmDialog(tool, "Are you sure?", "Unset standard", 0, 3)) != 0) {
                    MeasureToolPanel.this.ignoreNextStandard = true;
                    MeasureToolPanel.this.setStandard.setSelected(true);
                    return;
                }
                MeasureThing[] things = MeasureToolPanel.this.bio.mm.pool2.getSelection();
                int i = 0;
                while (i < things.length) {
                    MeasureToolPanel.this.doStandard(things[i], std);
                    ++i;
                }
                MeasureToolPanel.this.bio.mm.changed = true;
                MeasureToolPanel.this.bio.state.saveState(false);
            }
        });
        this.setStandard.setEnabled(false);
        p.add(this.setStandard);
        p.add(Box.createHorizontalStrut(5));
        this.removeSelected = new JButton("Remove");
        this.removeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasureToolPanel.this.bio.mm.getList().removeSelected();
                MeasureToolPanel.this.bio.state.saveState(false);
                MeasureToolPanel.this.updateSelection();
            }
        });
        this.removeSelected.setEnabled(false);
        p.add(this.removeSelected);
        this.controls.add(ToolPanel.pad(p));
        this.controls.add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.colorLabel = new JLabel("Color: ");
        this.colorLabel.setForeground(Color.black);
        this.colorLabel.setEnabled(false);
        p.add(this.colorLabel);
        this.colorList = new JComboBox<Color>(COLORS);
        this.colorList.setRenderer(new ColorRenderer());
        this.colorList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Color color = COLORS[MeasureToolPanel.this.colorList.getSelectedIndex()];
                MeasureThing[] things = MeasureToolPanel.this.bio.mm.pool2.getSelection();
                boolean changed = false;
                int i = 0;
                while (i < things.length) {
                    if (things[i].color != color) {
                        changed = true;
                        things[i].setColor(color);
                    }
                    ++i;
                }
                if (changed) {
                    MeasureToolPanel.this.bio.mm.changed = true;
                    MeasureToolPanel.this.bio.state.saveState(false);
                    MeasureToolPanel.this.bio.mm.pool2.refresh(true);
                    if (MeasureToolPanel.this.bio.mm.pool3 != null) {
                        MeasureToolPanel.this.bio.mm.pool3.refresh(true);
                    }
                }
            }
        });
        this.colorList.setEnabled(false);
        p.add(this.colorList);
        this.controls.add(p);
        this.controls.add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.groupLabel = new JLabel("Group: ");
        this.groupLabel.setForeground(Color.black);
        this.groupLabel.setEnabled(false);
        p.add(this.groupLabel);
        this.groupList = new JComboBox();
        this.groupList.addItem(VisBio.noneGroup);
        this.groupList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MeasureGroup group = (MeasureGroup)MeasureToolPanel.this.groupList.getSelectedItem();
                MeasureThing[] things = MeasureToolPanel.this.bio.mm.pool2.getSelection();
                boolean changed = false;
                int i = 0;
                while (i < things.length) {
                    if (things[i].group != group) {
                        changed = true;
                        things[i].group = group;
                    }
                    ++i;
                }
                if (group != null) {
                    MeasureToolPanel.this.descriptionBox.setText(group.getDescription());
                }
                if (changed) {
                    MeasureToolPanel.this.bio.mm.changed = true;
                    MeasureToolPanel.this.bio.state.saveState(false);
                }
            }
        });
        this.groupList.setEnabled(false);
        p.add(this.groupList);
        this.newGroup = new JButton("New");
        this.newGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int rval = MeasureToolPanel.this.groupBox.showDialog(MeasureToolPanel.this.bio);
                if (rval == 1) {
                    String name = MeasureToolPanel.this.groupBox.getGroupName();
                    MeasureGroup group = new MeasureGroup(MeasureToolPanel.this.bio, name);
                    MeasureToolPanel.this.groupList.addItem(group);
                    MeasureToolPanel.this.groupList.setSelectedItem(group);
                    MeasureToolPanel.this.bio.mm.changed = true;
                    MeasureToolPanel.this.bio.state.saveState(false);
                }
            }
        });
        this.newGroup.setEnabled(false);
        p.add(this.newGroup);
        this.controls.add(p);
        this.descriptionLabel = new JLabel("Group description:");
        this.descriptionLabel.setAlignmentX(2.0f);
        this.descriptionLabel.setForeground(Color.black);
        this.descriptionLabel.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.descriptionLabel));
        this.descriptionBox = new JTextArea();
        this.descriptionBox.setRows(4);
        this.descriptionBox.setLineWrap(true);
        this.descriptionBox.setWrapStyleWord(true);
        this.descriptionBox.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void update(DocumentEvent e) {
                MeasureGroup group = (MeasureGroup)MeasureToolPanel.this.groupList.getSelectedItem();
                group.setDescription(MeasureToolPanel.this.descriptionBox.getText());
                MeasureToolPanel.this.bio.state.saveState(false);
            }
        });
        this.descriptionBox.setEnabled(false);
        this.controls.add(new JScrollPane(this.descriptionBox));
    }

    public void init() {
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.measureLabel.setEnabled(true);
            this.restoreLines.setEnabled(true);
            this.updateFileButtons();
        } else {
            this.measureLabel.setEnabled(false);
            this.saveLines.setEnabled(false);
            this.restoreLines.setEnabled(false);
        }
        this.addLine.setEnabled(enabled);
        this.addMarker.setEnabled(enabled);
        this.merge.setEnabled(enabled);
        this.undo.setEnabled(enabled);
        this.clearAll.setEnabled(enabled);
    }

    public void setStandardEnabled(boolean enabled) {
        this.stdEnabled = enabled;
        this.setStandard.setEnabled(this.bio.mm.pool2.hasSelection() && enabled);
    }

    public void updateSelection() {
        boolean enabled = this.bio.mm.pool2.hasSelection();
        this.setStandard.setEnabled(enabled && this.stdEnabled);
        this.updateRemove();
        this.colorLabel.setEnabled(enabled);
        this.colorList.setEnabled(enabled);
        this.groupLabel.setEnabled(enabled);
        this.groupList.setEnabled(enabled);
        this.newGroup.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionBox.setEnabled(enabled);
        if (enabled) {
            boolean std = this.bio.mm.pool2.isSelectionStandard();
            if (this.setStandard.isSelected() != std) {
                this.ignoreNextStandard = true;
                this.setStandard.setSelected(std);
            }
            Color c = this.bio.mm.pool2.getSelectionColor();
            if (this.colorList.getSelectedItem() != c) {
                this.colorList.setSelectedItem(c);
            }
            MeasureGroup g = this.bio.mm.pool2.getSelectionGroup();
            if (this.groupList.getSelectedItem() != g) {
                this.groupList.setSelectedItem(g);
            }
        }
        CellImpl cellImpl = this.cell;
        synchronized (cellImpl) {
            try {
                boolean trigger;
                this.cell.disableAction();
                this.cell.removeAllReferences();
                boolean bl = trigger = !enabled;
                if (enabled) {
                    PoolPoint[] pts = this.bio.mm.pool2.getSelectionPts();
                    int i = 0;
                    while (i < pts.length) {
                        if (pts[i] != null) {
                            this.cell.addReference(pts[i].ref);
                        }
                        ++i;
                    }
                    if (pts.length == 0) {
                        trigger = true;
                    }
                }
                this.cell.enableAction();
                if (trigger) {
                    this.cell.doAction();
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }

    void updateInfo(boolean microns, double mx, double my, double sd) {
        this.groupList.removeAllItems();
        int i = 0;
        while (i < this.bio.mm.groups.size()) {
            this.groupList.addItem(this.bio.mm.groups.elementAt(i));
            ++i;
        }
        this.descriptionBox.setText("");
    }

    void setMerge(boolean merge) {
        if (merge != this.merge.isSelected()) {
            this.merge.setSelected(merge);
        }
    }

    boolean getMerge() {
        return this.merge.isSelected();
    }

    void updateFileButtons() {
        boolean b;
        boolean microns = this.bio.toolAlign.getUseMicrons();
        if (microns) {
            double mw = this.bio.toolAlign.getMicronWidth();
            double mh = this.bio.toolAlign.getMicronHeight();
            double sd = this.bio.toolAlign.getSliceDistance();
            b = mw == mw && mh == mh && sd == sd;
        } else {
            b = true;
        }
        this.bio.toolAlign.updateAspect(!microns);
        this.saveLines.setEnabled(b);
        this.updateMeasureInfo();
    }

    private void updateMeasureInfo() {
        String coord = "";
        String dist = "";
        if (this.bio.mm.pool2.hasSingleSelection()) {
            String vy;
            String vx;
            String unit;
            boolean microns;
            MeasureThing thing = this.bio.mm.pool2.getSelection()[0];
            boolean use = this.bio.toolAlign.getUseMicrons();
            double mw = this.bio.toolAlign.getMicronWidth();
            double mh = this.bio.toolAlign.getMicronHeight();
            double mx = mw / (double)this.bio.sm.res_x;
            double my = mw / (double)this.bio.sm.res_y;
            double sd = this.bio.toolAlign.getSliceDistance();
            boolean bl = microns = use && mx == mx && my == my && sd == sd;
            if (!microns) {
                sd = 1.0;
                my = 1.0;
                mx = 1.0;
            }
            String string = unit = microns ? "\u00b5" : "pix";
            if (thing instanceof MeasureLine) {
                MeasureLine line = (MeasureLine)thing;
                vx = Convert.shortString(mx * line.ep1.x);
                vy = Convert.shortString(my * line.ep1.y);
                String v2x = Convert.shortString(mx * line.ep2.x);
                String v2y = Convert.shortString(my * line.ep2.y);
                double[] p = new double[]{line.ep1.x, line.ep1.y, line.ep1.z};
                double[] q = new double[]{line.ep2.x, line.ep2.y, line.ep2.z};
                double[] m = new double[]{mx, my, sd};
                String d = Convert.shortString(BioUtil.getDistance(p, q, m));
                coord = "(" + vx + ", " + vy + ")-(" + v2x + ", " + v2y + ")";
                dist = "distance = " + d + " " + unit;
            } else if (thing instanceof MeasurePoint) {
                MeasurePoint point = (MeasurePoint)thing;
                vx = Convert.shortString(mx * point.x);
                vy = Convert.shortString(my * point.y);
                coord = "(" + vx + ", " + vy + ")";
            }
        }
        StringBuffer sb = new StringBuffer();
        int space = (COORD_LABEL.length() - coord.length()) / 2;
        int i = 0;
        while (i < space) {
            sb.append(" ");
            ++i;
        }
        String coordSpace = sb.toString();
        sb = new StringBuffer();
        space = (DIST_LABEL.length() - dist.length()) / 2;
        int i2 = 0;
        while (i2 < space) {
            sb.append(" ");
            ++i2;
        }
        String distSpace = sb.toString();
        this.measureCoord.setText(coordSpace + coord + coordSpace);
        this.measureDist.setText(distSpace + dist + distSpace);
    }

    private void updateRemove() {
        MeasureThing[] selThings = this.bio.mm.pool2.getSelection();
        boolean noStd = selThings.length > 0;
        int i = 0;
        while (i < selThings.length) {
            if (selThings[i].stdId >= 0) {
                noStd = false;
                break;
            }
            ++i;
        }
        this.removeSelected.setEnabled(noStd);
    }

    private void doStandard(MeasureThing thing, boolean std) {
        boolean isLine = thing instanceof MeasureLine;
        int index = this.bio.sm.getIndex();
        int slice = this.bio.sm.getSlice();
        if (std) {
            if (thing.stdId != -1) {
                return;
            }
            thing.setStdId(maxId++);
            int numSlices = this.bio.sm.getNumberOfSlices();
            int j = 0;
            while (j < this.bio.mm.lists.length) {
                MeasureList list = this.bio.mm.lists[j];
                boolean update = j == index;
                int i = 0;
                while (i < numSlices) {
                    if (j != index || i != slice) {
                        if (isLine) {
                            MeasureLine line = new MeasureLine((MeasureLine)thing, i);
                            list.addLine(line, update);
                        } else {
                            MeasurePoint point = new MeasurePoint((MeasurePoint)thing, i);
                            list.addMarker(point, update);
                        }
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            if (thing.stdId == -1) {
                return;
            }
            int stdId = thing.stdId;
            thing.setStdId(-1);
            int j = 0;
            while (j < this.bio.mm.lists.length) {
                MeasureList list = this.bio.mm.lists[j];
                boolean update = j == index;
                Vector lines = list.getLines();
                int k = 0;
                while (k < lines.size()) {
                    MeasureLine line = (MeasureLine)lines.elementAt(k);
                    if (line.stdId == stdId) {
                        list.removeLine(line, update);
                        continue;
                    }
                    ++k;
                }
                Vector points = list.getPoints();
                k = 0;
                while (k < points.size()) {
                    MeasurePoint point = (MeasurePoint)points.elementAt(k);
                    if (point.stdId == stdId) {
                        list.removeMarker(point, update);
                        continue;
                    }
                    ++k;
                }
                ++j;
            }
        }
        this.updateRemove();
    }
}

