/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JOptionPane;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;
import visad.bio.BioUtil;
import visad.bio.MeasureGroup;
import visad.bio.MeasureLine;
import visad.bio.MeasureList;
import visad.bio.MeasurePoint;
import visad.bio.MeasureThing;
import visad.bio.PoolPoint;
import visad.bio.SliceManager;
import visad.bio.VisBio;
import visad.bom.RubberBandBoxRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public class MeasurePool
implements DisplayListener {
    private static final int BUFFER_SIZE = 15;
    static final int MAX_POOLS = 2;
    private static int numPools = 0;
    private VisBio bio;
    private int pid;
    private DisplayImpl display;
    private int dim;
    private MeasureList list;
    private int slice;
    private boolean needMeasureSave;
    private Stack free;
    private Vector used;
    private CellImpl lineCell;
    private CellImpl boxCell;
    private Vector selLines;
    private Vector selPoints;
    private DataReferenceImpl solidLines;
    private DataRenderer lineRenderer;
    private DataReferenceImpl dashedLines;
    private DataRenderer dashedRenderer;
    private DataReferenceImpl coloredPoints;
    private DataRenderer pointRenderer;
    private DataReferenceImpl rubberBand;
    private DataRenderer boxRenderer;
    private int mx;
    private int my;
    private boolean m_shift;

    public MeasurePool(VisBio biovis, DisplayImpl display, int dimension) {
        this.bio = biovis;
        this.pid = numPools++;
        this.display = display;
        this.dim = dimension;
        this.free = new Stack();
        this.used = new Vector();
        try {
            this.solidLines = new DataReferenceImpl("bio_solid_lines");
            this.dashedLines = new DataReferenceImpl("bio_dashed_lines");
            this.coloredPoints = new DataReferenceImpl("bio_colored_points");
            this.rubberBand = new DataReferenceImpl("bio_rubber_band");
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        this.selLines = new Vector();
        this.selPoints = new Vector();
        this.lineCell = new CellImpl(){

            public void doAction() {
                if (MeasurePool.this.lineRenderer == null) {
                    return;
                }
                Vector<GriddedSet> solidStrips = new Vector<GriddedSet>();
                Vector<GriddedSet> dashedStrips = new Vector<GriddedSet>();
                Vector<MeasurePoint> pointStrips = new Vector<MeasurePoint>();
                Vector<Color> solidColors = new Vector<Color>();
                Vector<Color> dashedColors = new Vector<Color>();
                Vector<Color> pointColors = new Vector<Color>();
                boolean sel = MeasurePool.this.hasSelection();
                Vector lines = MeasurePool.this.list.getLines();
                int lsize = lines.size();
                int i = 0;
                while (i < lsize) {
                    block13: {
                        MeasureLine line;
                        block12: {
                            boolean t2;
                            line = (MeasureLine)lines.elementAt(i);
                            if (MeasurePool.this.dim != 2) break block12;
                            boolean b1 = line.ep1.z == (double)MeasurePool.this.slice;
                            boolean b2 = line.ep2.z == (double)MeasurePool.this.slice;
                            boolean t1 = b1 && (!sel || line.ep1.selected > 0);
                            boolean bl = t2 = b2 && (!sel || line.ep2.selected > 0);
                            if (line.ep1.pt[MeasurePool.this.pid] != null) {
                                line.ep1.pt[MeasurePool.this.pid].toggle(t1);
                            }
                            if (line.ep2.pt[MeasurePool.this.pid] != null) {
                                line.ep2.pt[MeasurePool.this.pid].toggle(t2);
                            }
                            if (!b1 && !b2) break block13;
                        }
                        GriddedSet set = MeasurePool.this.doSet(new MeasurePoint[]{line.ep1, line.ep2});
                        if (line.selected) {
                            dashedStrips.add(set);
                            dashedColors.add(line.color);
                            dashedColors.add(line.color);
                        } else {
                            solidStrips.add(set);
                            solidColors.add(line.color);
                            solidColors.add(line.color);
                        }
                        if (MeasurePool.this.dim == 2) {
                            MeasurePool.this.doXs(line, solidStrips, solidColors);
                        }
                    }
                    ++i;
                }
                Vector points = MeasurePool.this.list.getPoints();
                int psize = points.size();
                int i2 = 0;
                while (i2 < psize) {
                    MeasurePoint point = (MeasurePoint)points.elementAt(i2);
                    if (MeasurePool.this.dim != 2 || point.z == (double)MeasurePool.this.slice) {
                        pointStrips.add(point);
                        pointColors.add(point.selected > 0 ? Color.yellow : point.color);
                    }
                    ++i2;
                }
                MeasurePool.this.doLines(solidStrips, solidColors, MeasurePool.this.solidLines, MeasurePool.this.lineRenderer);
                MeasurePool.this.doLines(dashedStrips, dashedColors, MeasurePool.this.dashedLines, MeasurePool.this.dashedRenderer);
                MeasurePool.this.doPoints(pointStrips, pointColors, MeasurePool.this.coloredPoints, MeasurePool.this.pointRenderer);
                ((MeasurePool)MeasurePool.this).bio.mm.changed = true;
                MeasurePool.this.needMeasureSave = true;
            }
        };
        this.boxCell = new CellImpl(){

            public void doAction() {
                if (MeasurePool.this.boxRenderer == null) {
                    return;
                }
                GriddedSet set = (GriddedSet)MeasurePool.this.rubberBand.getData();
                float[][] samples = null;
                boolean stdPts = false;
                try {
                    samples = set.getSamples();
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                if (samples == null) {
                    return;
                }
                double x1 = samples[0][0];
                double y1 = samples[1][0];
                double x2 = samples[0][1];
                double y2 = samples[1][1];
                if (((MeasurePool)MeasurePool.this).bio.toolMeasure.getMerge()) {
                    int num_pts;
                    double sum_x = 0.0;
                    double sum_y = 0.0;
                    Vector<MeasurePoint> mpts = new Vector<MeasurePoint>();
                    Vector points = MeasurePool.this.list.getPoints();
                    int psize = points.size();
                    int i = 0;
                    while (i < psize) {
                        MeasurePoint point = (MeasurePoint)points.elementAt(i);
                        if (point.z == (double)MeasurePool.this.slice) {
                            if (point.stdId >= 0) {
                                stdPts = true;
                            } else if (BioUtil.contains(x1, y1, x2, y2, point.x, point.y)) {
                                sum_x += point.x;
                                sum_y += point.y;
                                mpts.add(point);
                            }
                        }
                        ++i;
                    }
                    if (stdPts) {
                        JOptionPane.showMessageDialog(MeasurePool.this.bio, "Some points within the merge box are standard and will not be merged.", "Warning", 2);
                    }
                    if ((num_pts = mpts.size()) == 0) {
                        ((MeasurePool)MeasurePool.this).bio.toolMeasure.setMerge(false);
                        return;
                    }
                    MeasurePoint first = (MeasurePoint)mpts.firstElement();
                    MeasurePoint merged = new MeasurePoint(sum_x / (double)num_pts, sum_y / (double)num_pts, first.z, first.color, first.group);
                    int i2 = 0;
                    while (i2 < num_pts) {
                        MeasurePoint point = (MeasurePoint)mpts.elementAt(i2);
                        if (point.lines.isEmpty()) {
                            MeasurePool.this.list.removeMarker(point, false);
                        } else {
                            int j = 0;
                            while (j < point.lines.size()) {
                                MeasureLine line = (MeasureLine)point.lines.elementAt(j);
                                if (line.ep1 == point || line.ep2 == point) {
                                    MeasurePool.this.list.removeLine(line, false);
                                    if (line.ep1 == point) {
                                        line.ep1 = merged;
                                    }
                                    if (line.ep2 == point) {
                                        line.ep2 = merged;
                                    }
                                    if (line.ep1 == line.ep2) continue;
                                    line.ep1.lines.add(line);
                                    line.ep2.lines.add(line);
                                    MeasurePool.this.list.addLine(line, false);
                                    continue;
                                }
                                ++j;
                            }
                        }
                        ++i2;
                    }
                    merged.refreshColor();
                    if (merged.lines.isEmpty()) {
                        MeasurePool.this.list.addMarker(merged, false);
                    }
                    MeasurePool.this.list.refreshPools(true);
                    ((MeasurePool)MeasurePool.this).bio.toolMeasure.setMerge(false);
                } else {
                    Vector lines = MeasurePool.this.list.getLines();
                    int lsize = lines.size();
                    int i = 0;
                    while (i < lsize) {
                        MeasureLine line = (MeasureLine)lines.elementAt(i);
                        if ((line.ep1.z == (double)MeasurePool.this.slice || line.ep2.z == (double)MeasurePool.this.slice) && BioUtil.intersects(x1, y1, x2, y2, line.ep1.x, line.ep1.y, line.ep2.x, line.ep2.y)) {
                            MeasurePool.this.select(line);
                        }
                        ++i;
                    }
                    Vector points = MeasurePool.this.list.getPoints();
                    int psize = points.size();
                    int i3 = 0;
                    while (i3 < psize) {
                        MeasurePoint point = (MeasurePoint)points.elementAt(i3);
                        if (point.lines.isEmpty() && point.z == (double)MeasurePool.this.slice && BioUtil.contains(x1, y1, x2, y2, point.x, point.y)) {
                            MeasurePool.this.select(point);
                        }
                        ++i3;
                    }
                    ((MeasurePool)MeasurePool.this).bio.toolMeasure.updateSelection();
                    MeasurePool.this.list.refreshPools(true);
                }
            }
        };
        try {
            this.boxCell.addReference(this.rubberBand);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        display.addDisplayListener(this);
        this.expand(15, false);
    }

    public void init() throws VisADException, RemoteException {
        this.lineRenderer = this.display.getDisplayRenderer().makeDefaultRenderer();
        this.lineRenderer.suppressExceptions(true);
        this.lineRenderer.toggle(false);
        this.display.addReferences(this.lineRenderer, this.solidLines);
        this.dashedRenderer = this.display.getDisplayRenderer().makeDefaultRenderer();
        this.dashedRenderer.suppressExceptions(true);
        this.dashedRenderer.toggle(false);
        this.display.addReferences(this.dashedRenderer, this.dashedLines, new ConstantMap[]{new ConstantMap(1.0, Display.LineStyle)});
        this.pointRenderer = this.display.getDisplayRenderer().makeDefaultRenderer();
        this.pointRenderer.suppressExceptions(true);
        this.pointRenderer.toggle(false);
        this.display.addReferences(this.pointRenderer, this.coloredPoints, new ConstantMap[]{new ConstantMap(5.0, Display.PointSize)});
        if (this.dim == 2 && this.display instanceof DisplayImplJ3D) {
            this.rubberBand.setData(new Gridded2DSet((MathType)this.bio.sm.domain2, null, 1));
            int m = 1;
            this.boxRenderer = new RubberBandBoxRendererJ3D(this.bio.sm.dtypes[0], this.bio.sm.dtypes[1], m, m);
            this.display.addReferences(this.boxRenderer, this.rubberBand);
        }
        int total = this.free.size();
        int i = 0;
        while (i < total) {
            ((PoolPoint)this.free.elementAt(i)).init();
            ++i;
        }
    }

    public PoolPoint lease(MeasurePoint point) {
        this.expand(1, true);
        PoolPoint pt = (PoolPoint)this.free.pop();
        pt.point = point;
        this.used.add(pt);
        point.pt[this.pid] = pt;
        pt.refresh();
        return pt;
    }

    public void release(MeasurePoint point) {
        this.purge(point.pt[this.pid]);
    }

    public void releaseAll() {
        while (!this.used.isEmpty()) {
            this.purge((PoolPoint)this.used.lastElement());
        }
    }

    public void set(MeasureList list) {
        if (this.list == list) {
            return;
        }
        if (this.list != null) {
            this.list.setCurrent(false);
        }
        this.list = list;
        list.setCurrent(true);
        this.deselectAll();
        this.releaseAll();
        this.refresh(true);
    }

    public void setSlice(int slice) {
        if (this.slice == slice) {
            return;
        }
        this.slice = slice;
        this.deselectAll();
        this.releaseAll();
        this.bio.toolMeasure.updateSelection();
        this.list.refreshPools(true);
    }

    public synchronized void refresh(boolean reconstruct) {
        if (this.list == null) {
            return;
        }
        Vector points = this.list.getPoints();
        int size = points.size();
        this.display.disableAction();
        int i = 0;
        while (i < size) {
            MeasurePoint point = (MeasurePoint)points.elementAt(i);
            if (point.pt[this.pid] == null) {
                point.pt[this.pid] = this.lease(point);
            }
            point.pt[this.pid].toggle(this.dim == 3 || point.z == (double)this.slice);
            ++i;
        }
        this.display.enableAction();
        if (reconstruct) {
            try {
                this.lineCell.doAction();
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }

    public int getSlice() {
        return this.slice;
    }

    public int getDimension() {
        return this.dim;
    }

    public boolean hasSelection() {
        return !this.selLines.isEmpty() || !this.selPoints.isEmpty();
    }

    public boolean hasSingleSelection() {
        return this.selLines.size() + this.selPoints.size() == 1;
    }

    public MeasureThing[] getSelection() {
        int lsize = this.selLines.size();
        int psize = this.selPoints.size();
        MeasureThing[] things = new MeasureThing[lsize + psize];
        int i = 0;
        while (i < lsize) {
            things[i] = (MeasureLine)this.selLines.elementAt(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < psize) {
            things[i2 + lsize] = (MeasurePoint)this.selPoints.elementAt(i2);
            ++i2;
        }
        return things;
    }

    public boolean isSelectionStandard() {
        int lsize = this.selLines.size();
        int psize = this.selPoints.size();
        if (lsize == 0 && psize == 0) {
            return false;
        }
        int i = 0;
        while (i < lsize) {
            MeasureLine line = (MeasureLine)this.selLines.elementAt(i);
            if (line.stdId == -1) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < psize) {
            MeasurePoint point = (MeasurePoint)this.selPoints.elementAt(i2);
            if (point.stdId == -1) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public Color getSelectionColor() {
        int lsize = this.selLines.size();
        int psize = this.selPoints.size();
        if (lsize == 0 && psize == 0) {
            return null;
        }
        return lsize > 0 ? ((MeasureLine)this.selLines.firstElement()).color : ((MeasurePoint)this.selPoints.firstElement()).color;
    }

    public MeasureGroup getSelectionGroup() {
        int lsize = this.selLines.size();
        int psize = this.selPoints.size();
        if (lsize == 0 && psize == 0) {
            return null;
        }
        return lsize > 0 ? ((MeasureLine)this.selLines.firstElement()).group : ((MeasurePoint)this.selPoints.firstElement()).group;
    }

    public void displayChanged(DisplayEvent e) {
        boolean ctrl;
        int id = e.getId();
        InputEvent event = e.getInputEvent();
        if (event == null || !(event instanceof MouseEvent)) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int mods = e.getModifiers();
        boolean left = (mods & 0x10) != 0;
        boolean right = (mods & 4) != 0;
        boolean shift = (mods & 1) != 0;
        boolean bl = ctrl = (mods & 2) != 0;
        if (ctrl) {
            return;
        }
        if (left && id == 1) {
            this.mx = x;
            this.my = y;
            this.m_shift = shift;
        } else if (left && id == 7) {
            if (x == this.mx && y == this.my) {
                MeasurePoint point;
                if (this.list == null || this.dim != 2) {
                    return;
                }
                Vector lines = this.list.getLines();
                Vector points = this.list.getPoints();
                double[] coords = BioUtil.pixelToDomain(this.display, x, y);
                double[] e1 = BioUtil.pixelToDomain(this.display, 0, 0);
                double[] e2 = BioUtil.pixelToDomain(this.display, 10, 0);
                double threshold = e2[0] - e1[0];
                int index = -1;
                double mindist = Double.POSITIVE_INFINITY;
                int lsize = lines.size();
                boolean isLine = true;
                int i = 0;
                while (i < lsize) {
                    MeasureLine line = (MeasureLine)lines.elementAt(i);
                    if (line.ep1.z == (double)this.slice || line.ep2.z == (double)this.slice) {
                        double[] a = new double[]{line.ep1.x, line.ep1.y};
                        double[] dArray = new double[]{line.ep2.x, line.ep2.y};
                        double[] b = dArray;
                        double dist = BioUtil.getDistance(a, b, coords, true);
                        if (dist < mindist) {
                            mindist = dist;
                            index = i;
                        }
                    }
                    ++i;
                }
                int psize = points.size();
                int i2 = 0;
                while (i2 < psize) {
                    double dy;
                    double dx;
                    double dist;
                    point = (MeasurePoint)points.elementAt(i2);
                    if (point.lines.isEmpty() && point.z == (double)this.slice && (dist = Math.sqrt((dx = point.x - coords[0]) * dx + (dy = point.y - coords[1]) * dy)) < mindist) {
                        mindist = dist;
                        index = i2;
                        isLine = false;
                    }
                    ++i2;
                }
                if (this.m_shift) {
                    if (mindist <= threshold && index >= 0) {
                        if (isLine) {
                            MeasureLine line = (MeasureLine)lines.elementAt(index);
                            if (this.selLines.contains(line)) {
                                this.deselect(line);
                            } else {
                                this.select(line);
                            }
                        } else {
                            point = (MeasurePoint)points.elementAt(index);
                            if (this.selPoints.contains(point)) {
                                this.deselect(point);
                            } else {
                                this.select(point);
                            }
                        }
                        this.bio.toolMeasure.updateSelection();
                        this.list.refreshPools(true);
                    }
                } else {
                    this.deselectAll();
                    if (mindist <= threshold && index >= 0) {
                        if (isLine) {
                            this.select((MeasureLine)lines.elementAt(index));
                        } else {
                            this.select((MeasurePoint)points.elementAt(index));
                        }
                    }
                    this.bio.toolMeasure.updateSelection();
                    this.list.refreshPools(true);
                }
            }
        } else if (right && id == 7 && this.needMeasureSave) {
            this.bio.state.saveState(false);
            this.needMeasureSave = false;
        }
    }

    PoolPoint[] getSelectionPts() {
        PoolPoint[] pts;
        int psize;
        int lsize = this.selLines.size();
        if (lsize + (psize = this.selPoints.size()) != 1) {
            pts = new PoolPoint[]{};
        } else if (lsize > 0) {
            pts = new PoolPoint[2];
            MeasureLine line = (MeasureLine)this.selLines.firstElement();
            pts[0] = line.ep1.pt[this.pid];
            pts[1] = line.ep2.pt[this.pid];
        } else {
            pts = new PoolPoint[1];
            MeasurePoint point = (MeasurePoint)this.selPoints.firstElement();
            pts[0] = point.pt[this.pid];
        }
        return pts;
    }

    void deselect(MeasureLine line) {
        if (!this.selLines.contains(line)) {
            return;
        }
        line.selected = false;
        --line.ep1.selected;
        --line.ep2.selected;
        this.selLines.remove(line);
        if (!this.hasSelection()) {
            this.list.setEndpointsEnabled(true);
        } else {
            if (line.ep1.selected == 0) {
                this.list.setEndpointEnabled(line.ep1, false);
            }
            if (line.ep2.selected == 0) {
                this.list.setEndpointEnabled(line.ep2, false);
            }
        }
    }

    void deselect(MeasurePoint point) {
        if (!this.selPoints.contains(point)) {
            return;
        }
        --point.selected;
        this.selPoints.remove(point);
        if (!this.hasSelection()) {
            this.list.setEndpointsEnabled(true);
        } else if (point.selected == 0) {
            this.list.setEndpointEnabled(point, false);
        }
    }

    private void expand(int size, boolean init) {
        int total = this.free.size();
        if (size <= total) {
            return;
        }
        int count = total + this.used.size();
        int n = size - total + 15;
        this.lineCell.disableAction();
        this.display.disableAction();
        int i = 0;
        while (i < n) {
            PoolPoint pt = new PoolPoint(this.bio, this.display, "p" + (count + i), this.dim);
            try {
                this.lineCell.addReference(pt.ref);
                if (init) {
                    pt.init();
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
            this.free.push(pt);
            ++i;
        }
        this.display.enableAction();
        this.lineCell.enableAction();
    }

    private void purge(PoolPoint pt) {
        if (!this.used.contains(pt)) {
            return;
        }
        pt.point.pt[this.pid] = null;
        pt.point = null;
        this.used.remove(pt);
        this.free.push(pt);
        pt.refresh();
    }

    private GriddedSet doSet(MeasurePoint[] points) {
        float[][] samples = new float[this.dim][points.length];
        GriddedSet set = null;
        try {
            if (this.dim == 2) {
                int i = 0;
                while (i < points.length) {
                    samples[0][i] = (float)points[i].x;
                    samples[1][i] = (float)points[i].y;
                    ++i;
                }
                set = new Gridded2DSet((MathType)this.bio.sm.domain2, samples, points.length, null, null, null, false);
            } else {
                int i = 0;
                while (i < points.length) {
                    samples[0][i] = (float)points[i].x;
                    samples[1][i] = (float)points[i].y;
                    samples[2][i] = (float)points[i].z;
                    ++i;
                }
                set = new Gridded3DSet((MathType)this.bio.sm.domain3, samples, points.length, null, null, null, false);
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        return set;
    }

    private void doXs(MeasureLine line, Vector strips, Vector colors) {
        double yRange;
        double xRange = Math.abs(this.bio.sm.max_x - this.bio.sm.min_x);
        double x_width = 0.05 * (xRange < (yRange = (double)Math.abs(this.bio.sm.max_y - this.bio.sm.min_y)) ? xRange : yRange);
        int j = 0;
        while (j < 2) {
            double z;
            double y;
            double x;
            if (j == 0) {
                x = line.ep1.x;
                y = line.ep1.y;
                z = line.ep1.z;
            } else {
                x = line.ep2.x;
                y = line.ep2.y;
                z = line.ep2.z;
            }
            if (z != (double)this.slice) {
                float[][] samples1 = new float[][]{{(float)(x - x_width), (float)(x + x_width)}, {(float)(y - x_width), (float)(y + x_width)}};
                float[][] samples2 = new float[][]{{(float)(x - x_width), (float)(x + x_width)}, {(float)(y + x_width), (float)(y - x_width)}};
                try {
                    strips.add(new Gridded2DSet((MathType)this.bio.sm.domain2, (float[][])samples1, 2, null, null, null, false));
                    strips.add(new Gridded2DSet((MathType)this.bio.sm.domain2, (float[][])samples2, 2, null, null, null, false));
                    int k = 0;
                    while (k < 4) {
                        colors.add(Color.white);
                        ++k;
                    }
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
            }
            ++j;
        }
    }

    private void doLines(Vector strips, Vector colors, DataReferenceImpl ref, DataRenderer renderer) {
        int size = strips.size();
        if (size == 0) {
            renderer.toggle(false);
            return;
        }
        Object[] sets = new GriddedSet[size];
        strips.copyInto(sets);
        try {
            RealTupleType domain = this.dim == 2 ? this.bio.sm.domain2 : this.bio.sm.domain3;
            UnionSet set = new UnionSet((MathType)domain, (SampledSet[])sets);
            FunctionType function = new FunctionType(domain, this.bio.sm.colorRange);
            FlatField field = new FlatField(function, set);
            int colorSize = colors.size();
            double[][] samples = new double[3][colorSize];
            int j = 0;
            while (j < colorSize) {
                Color color = (Color)colors.elementAt(j);
                samples[0][j] = color.getRed();
                samples[1][j] = color.getGreen();
                samples[2][j] = color.getBlue();
                ++j;
            }
            field.setSamples(samples, false);
            ref.setData(field);
            renderer.toggle(true);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    private void doPoints(Vector strips, Vector colors, DataReferenceImpl ref, DataRenderer renderer) {
        int size = strips.size();
        if (size == 0) {
            renderer.toggle(false);
            return;
        }
        try {
            RealType index = RealType.getRealType("point_index");
            RealType[] range_types = this.dim == 2 ? new RealType[]{this.bio.sm.dtypes[0], this.bio.sm.dtypes[1], SliceManager.RED_TYPE, SliceManager.GREEN_TYPE, SliceManager.BLUE_TYPE} : new RealType[]{this.bio.sm.dtypes[0], this.bio.sm.dtypes[1], this.bio.sm.dtypes[2], SliceManager.RED_TYPE, SliceManager.GREEN_TYPE, SliceManager.BLUE_TYPE};
            RealTupleType range = new RealTupleType(range_types);
            FunctionType function = new FunctionType(index, range);
            FlatField field = new FlatField(function, new Integer1DSet(size));
            double[][] samples = new double[this.dim + 3][size];
            if (this.dim == 2) {
                int j = 0;
                while (j < size) {
                    MeasurePoint point = (MeasurePoint)strips.elementAt(j);
                    Color color = (Color)colors.elementAt(j);
                    samples[0][j] = point.x;
                    samples[1][j] = point.y;
                    samples[2][j] = color.getRed();
                    samples[3][j] = color.getGreen();
                    samples[4][j] = color.getBlue();
                    ++j;
                }
            } else {
                int j = 0;
                while (j < size) {
                    MeasurePoint point = (MeasurePoint)strips.elementAt(j);
                    Color color = (Color)colors.elementAt(j);
                    samples[0][j] = point.x;
                    samples[1][j] = point.y;
                    samples[2][j] = point.z;
                    samples[3][j] = color.getRed();
                    samples[4][j] = color.getGreen();
                    samples[5][j] = color.getBlue();
                    ++j;
                }
            }
            field.setSamples(samples, false);
            ref.setData(field);
            renderer.toggle(true);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    private void select(MeasureLine line) {
        if (this.selLines.contains(line)) {
            return;
        }
        if (!this.hasSelection()) {
            this.list.setEndpointsEnabled(false);
        }
        line.selected = true;
        ++line.ep1.selected;
        ++line.ep2.selected;
        this.selLines.add(line);
        this.list.setEndpointEnabled(line.ep1, true);
        this.list.setEndpointEnabled(line.ep2, true);
    }

    private void select(MeasurePoint point) {
        if (this.selPoints.contains(point)) {
            return;
        }
        if (!this.hasSelection()) {
            this.list.setEndpointsEnabled(false);
        }
        ++point.selected;
        this.selPoints.add(point);
        this.list.setEndpointEnabled(point, true);
    }

    private void deselectAll() {
        int lsize = this.selLines.size();
        int i = 0;
        while (i < lsize) {
            MeasureLine line = (MeasureLine)this.selLines.elementAt(i);
            line.selected = false;
            --line.ep1.selected;
            --line.ep2.selected;
            ++i;
        }
        this.selLines.removeAllElements();
        int psize = this.selPoints.size();
        int i2 = 0;
        while (i2 < psize) {
            MeasurePoint point = (MeasurePoint)this.selPoints.elementAt(i2);
            --point.selected;
            ++i2;
        }
        this.selPoints.removeAllElements();
        this.list.setEndpointsEnabled(true);
    }
}

