/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.VisADException;
import visad.bio.BioUtil;
import visad.bio.MeasureLine;
import visad.bio.MeasurePoint;
import visad.bio.VisBio;

public class MeasureList {
    private VisBio bio;
    private Vector points;
    private Vector lines;
    private boolean isCurrent;

    public MeasureList(VisBio biovis) throws VisADException, RemoteException {
        this.bio = biovis;
        this.points = new Vector();
        this.lines = new Vector();
    }

    public void addLine() {
        double ry;
        Dimension size = this.bio.display2.getComponent().getSize();
        double[] e1 = BioUtil.pixelToDomain(this.bio.display2, 0, 0);
        double[] e2 = BioUtil.pixelToDomain(this.bio.display2, size.width, size.height);
        int slice = this.bio.sm.getSlice();
        double cx = (e1[0] + e2[0]) / 2.0;
        double cy = (e1[1] + e2[1]) / 2.0;
        double rx = Math.abs(e2[0] - cx);
        double r = 0.75 * (rx < (ry = Math.abs(e2[1] - cy)) ? rx : ry);
        double theta = Math.PI * 2 * Math.random();
        double inc = Math.PI;
        double t1 = theta;
        double x1 = r * Math.cos(t1) + cx;
        double y1 = r * Math.sin(t1) + cy;
        double t2 = theta + Math.PI;
        double x2 = r * Math.cos(t2) + cx;
        double y2 = r * Math.sin(t2) + cy;
        MeasurePoint ep1 = new MeasurePoint(x1, y1, slice);
        MeasurePoint ep2 = new MeasurePoint(x2, y2, slice);
        MeasureLine line = new MeasureLine(ep1, ep2, Color.white, VisBio.noneGroup, false);
        this.addLine(line, true);
    }

    public void addMarker() {
        Dimension size = this.bio.display2.getComponent().getSize();
        double[] e1 = BioUtil.pixelToDomain(this.bio.display2, 0, 0);
        double[] e2 = BioUtil.pixelToDomain(this.bio.display2, size.width, size.height);
        int slice = this.bio.sm.getSlice();
        double w = 0.75 * (e2[0] - e1[0]);
        double h = 0.75 * (e2[1] - e1[1]);
        double cx = (e1[0] + e2[0]) / 2.0;
        double cy = (e1[1] + e2[1]) / 2.0;
        double x = cx + w * (Math.random() - 0.5);
        double y = cy + h * (Math.random() - 0.5);
        MeasurePoint point = new MeasurePoint(x, y, slice, Color.white, VisBio.noneGroup);
        this.addMarker(point, true);
    }

    public void addLine(MeasureLine line, boolean updatePools) {
        this.points.add(line.ep1);
        this.points.add(line.ep2);
        this.lines.add(line);
        if (updatePools) {
            this.refreshPools(false);
        }
        boolean selection = this.bio.mm.pool2.hasSelection();
        this.setEndpointEnabled(line.ep1, !selection || line.ep1.selected > 0);
        this.setEndpointEnabled(line.ep2, !selection || line.ep2.selected > 0);
    }

    public void addMarker(MeasurePoint point, boolean updatePools) {
        this.points.add(point);
        if (updatePools) {
            this.refreshPools(false);
        }
        this.setEndpointEnabled(point, !this.bio.mm.pool2.hasSelection() || point.selected > 0);
    }

    public void removeLine(MeasureLine line, boolean updatePools) {
        if (!this.lines.contains(line)) {
            return;
        }
        this.remove(line);
        if (updatePools) {
            this.refreshPools(true);
        }
    }

    public void removeMarker(MeasurePoint point, boolean updatePools) {
        if (!this.points.contains(point)) {
            return;
        }
        this.remove(point);
        if (updatePools) {
            this.refreshPools(true);
        }
    }

    public void removeSelected() {
        this.remove(false);
    }

    public void removeAll() {
        this.remove(true);
    }

    public void setCurrent(boolean current) {
        this.isCurrent = current;
    }

    public Vector getPoints() {
        return this.points;
    }

    public Vector getLines() {
        return this.lines;
    }

    public boolean hasMeasurements() {
        return !this.points.isEmpty() || !this.lines.isEmpty();
    }

    void refreshPools(boolean reconstruct) {
        if (this.isCurrent) {
            this.bio.mm.pool2.refresh(reconstruct);
            if (this.bio.mm.pool3 != null) {
                this.bio.mm.pool3.refresh(reconstruct);
            }
        }
        this.bio.mm.changed = true;
    }

    void setEndpointsEnabled(boolean enabled) {
        int psize = this.points.size();
        int i = 0;
        while (i < psize) {
            MeasurePoint point = (MeasurePoint)this.points.elementAt(i);
            this.setEndpointEnabled(point, enabled);
            ++i;
        }
    }

    void setEndpointEnabled(MeasurePoint point, boolean enabled) {
        int i = 0;
        while (i < point.pt.length) {
            if (point.pt[i] != null) {
                point.pt[i].toggle(enabled);
            }
            ++i;
        }
    }

    private void remove(boolean all) {
        int i = 0;
        while (i < this.lines.size()) {
            MeasureLine line = (MeasureLine)this.lines.elementAt(i);
            if (all || line.selected) {
                this.remove(line);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.points.size()) {
            MeasurePoint point = (MeasurePoint)this.points.elementAt(i);
            if (all || point.selected > 0) {
                this.remove(point);
                continue;
            }
            ++i;
        }
        this.refreshPools(true);
    }

    private void remove(MeasureLine line) {
        line.ep1.lines.remove(line);
        line.ep2.lines.remove(line);
        if (line.ep1.lines.isEmpty()) {
            this.remove(line.ep1);
        }
        if (line.ep2.lines.isEmpty()) {
            this.remove(line.ep2);
        }
        this.bio.mm.pool2.deselect(line);
        if (this.bio.mm.pool3 != null) {
            this.bio.mm.pool3.deselect(line);
        }
        this.lines.remove(line);
    }

    private void remove(MeasurePoint point) {
        this.bio.mm.pool2.deselect(point);
        this.bio.mm.pool2.release(point);
        if (this.bio.mm.pool3 != null) {
            this.bio.mm.pool3.deselect(point);
            this.bio.mm.pool3.release(point);
        }
        this.points.remove(point);
    }
}

