/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import visad.bio.DoubleTextCheckBox;
import visad.bio.SeriesChooser;
import visad.bio.SeriesFileFilter;
import visad.util.Util;

public class ImportDialog
extends JPanel
implements ActionListener {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private SeriesChooser chooser = new SeriesChooser();
    private DoubleTextCheckBox thumbs = new DoubleTextCheckBox("Create low-resolution thumbnails", "by", "64", "64", true);
    private JButton ok;
    private JDialog dialog;
    private int rval;

    public ImportDialog() {
        this.thumbs.setMnemonic('t');
        this.ok = new JButton("Ok");
        this.ok.setMnemonic('o');
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        JButton select = new JButton("Choose file");
        select.setMnemonic('f');
        select.setActionCommand("select");
        select.addActionListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.chooser);
        this.add(this.thumbs);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(select);
        buttons.add(this.ok);
        buttons.add(cancel);
        this.add(buttons);
    }

    public int showDialog(Frame parent) {
        this.dialog = new JDialog(parent, "Open file series", true);
        this.dialog.getRootPane().setDefaultButton(this.ok);
        this.chooser.clearFields();
        this.dialog.setContentPane(this);
        this.dialog.pack();
        Util.centerWindow(this.dialog);
        ((Component)this.dialog).setVisible(true);
        return this.rval;
    }

    public File[] getSeries() {
        return this.chooser.getSeries();
    }

    public String getPrefix() {
        return this.chooser.getPrefix();
    }

    public boolean getFilesAsSlices() {
        return this.chooser.getFilesAsSlices();
    }

    public boolean getThumbs() {
        return this.thumbs.isSelected();
    }

    public int getThumbResX() {
        int size = -1;
        try {
            size = Integer.parseInt(this.thumbs.getFirstValue().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    public int getThumbResY() {
        int size = -1;
        try {
            size = Integer.parseInt(this.thumbs.getSecondValue().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("select")) {
            String ext;
            JFileChooser fileBox = new JFileChooser();
            SeriesFileFilter filter = new SeriesFileFilter();
            fileBox.setFileFilter(filter);
            int returnVal = fileBox.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            File file = fileBox.getSelectedFile();
            String name = file.getPath();
            int dot = name.lastIndexOf(".");
            if (dot >= 0) {
                ext = name.substring(dot + 1);
                name = name.substring(0, dot);
            } else {
                ext = "";
            }
            boolean series = false;
            int i = name.length();
            while (i > 0) {
                char last;
                if ((last = name.charAt(--i)) < '0' || last > '9') break;
                series = true;
            }
            String prefix = name.substring(0, i + 1);
            String first = "";
            String last = "";
            if (series) {
                String end = (ext.equals("") ? "" : ".") + ext;
                int num = -1;
                try {
                    num = Integer.parseInt(dot >= 0 ? name.substring(i + 1, dot) : name.substring(i + 1));
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                int min = num;
                int max = num;
                min = num;
                while (min > 0) {
                    if (!new File(prefix + (min - 1) + end).exists()) break;
                    --min;
                }
                first = "" + min;
                max = num;
                while (new File(prefix + (max + 1) + end).exists()) {
                    ++max;
                }
                last = "" + max;
            }
            this.chooser.prefix.setText(prefix);
            this.chooser.start.setText(first);
            this.chooser.end.setText(last);
            this.chooser.type.setSelectedItem(ext);
            if (this.chooser.type.getSelectedItem() == null) {
                this.chooser.type.addItem(ext);
            }
        } else if (command.equals("ok")) {
            this.rval = 1;
            ((Component)this.dialog).setVisible(false);
        } else if (command.equals("cancel")) {
            this.rval = 2;
            ((Component)this.dialog).setVisible(false);
        }
    }
}

