/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visad.FieldImpl;
import visad.FlatField;
import visad.GriddedSet;
import visad.Linear2DSet;
import visad.VisADException;
import visad.bio.BioUtil;
import visad.bio.DoubleTextCheckBox;
import visad.bio.ProgressDialog;
import visad.bio.SeriesChooser;
import visad.bio.ToolPanel;
import visad.bio.VisBio;
import visad.browser.Divider;
import visad.data.Form;
import visad.data.biorad.BioRadForm;
import visad.data.qt.QTForm;
import visad.data.tiff.TiffForm;
import visad.util.Util;

public class ExportDialog
extends JPanel
implements ActionListener,
DocumentListener {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private static final boolean CAN_DO_QT = Util.canDoQuickTime();
    private VisBio bio;
    private JDialog dialog;
    private int rval;
    private JCheckBox doColors;
    private JCheckBox doAlign;
    private JCheckBox timeOnly;
    private JCheckBox sliceOnly;
    private JRadioButton picFormat;
    private JRadioButton tiffFormat;
    private JRadioButton qtFormat;
    private SeriesChooser chooser;
    private DoubleTextCheckBox altRes;
    private DoubleTextCheckBox exportTimesteps;
    private DoubleTextCheckBox exportSlices;
    private JButton ok;

    public ExportDialog(VisBio biovis) {
        this.bio = biovis;
        this.chooser = new SeriesChooser();
        this.chooser.end.setEnabled(false);
        this.chooser.type.setEnabled(false);
        this.chooser.start.getDocument().addDocumentListener(this);
        this.chooser.start.addActionListener(this);
        this.chooser.treatTimestep.addActionListener(this);
        this.chooser.treatSlice.addActionListener(this);
        this.ok = new JButton("Ok");
        this.ok.setMnemonic('o');
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        this.doColors = new JCheckBox("Save color adjustments", true);
        this.doAlign = new JCheckBox("Save alignment", true);
        this.timeOnly = new JCheckBox("Save current timestep only");
        this.timeOnly.setActionCommand("timeOnly");
        this.timeOnly.addActionListener(this);
        this.sliceOnly = new JCheckBox("Save current slice only");
        this.sliceOnly.setActionCommand("sliceOnly");
        this.sliceOnly.addActionListener(this);
        JLabel outputLabel = new JLabel("Output format:");
        outputLabel.setForeground(Color.black);
        this.picFormat = new JRadioButton("Bio-Rad PIC", true);
        this.tiffFormat = new JRadioButton("Multi-page TIFF");
        this.qtFormat = new JRadioButton("QuickTime movie");
        this.qtFormat.setEnabled(CAN_DO_QT);
        ButtonGroup group = new ButtonGroup();
        group.add(this.picFormat);
        group.add(this.tiffFormat);
        group.add(this.qtFormat);
        this.picFormat.setActionCommand("picFormat");
        this.tiffFormat.setActionCommand("tiffFormat");
        this.qtFormat.setActionCommand("qtFormat");
        this.picFormat.addActionListener(this);
        this.tiffFormat.addActionListener(this);
        this.qtFormat.addActionListener(this);
        this.altRes = new DoubleTextCheckBox("Use alternate resolution", "by", "", "", false);
        this.exportTimesteps = new DoubleTextCheckBox("Only export timesteps", "through", "", "", false);
        this.exportTimesteps.setActionCommand("exportTimesteps");
        this.exportTimesteps.addActionListener(this);
        this.exportSlices = new DoubleTextCheckBox("Only export slices", "through", "", "", false);
        this.exportSlices.setActionCommand("exportSlices");
        this.exportSlices.addActionListener(this);
        this.setLayout(new BoxLayout(this, 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BoxLayout(topLeft, 1));
        topLeft.add(outputLabel);
        topLeft.add(this.picFormat);
        topLeft.add(this.tiffFormat);
        topLeft.add(this.qtFormat);
        top.add(topLeft);
        JPanel topRight = new JPanel();
        topRight.setLayout(new BoxLayout(topRight, 1));
        topRight.add(this.doColors);
        topRight.add(this.doAlign);
        topRight.add(this.timeOnly);
        topRight.add(this.sliceOnly);
        top.add(topRight);
        this.add(top);
        this.add(Box.createVerticalStrut(5));
        this.add(new Divider());
        this.add(Box.createVerticalStrut(5));
        JPanel mid = new JPanel();
        mid.setLayout(new BoxLayout(mid, 1));
        mid.add(this.altRes);
        mid.add(this.exportSlices);
        mid.add(this.exportTimesteps);
        this.add(mid);
        this.add(Box.createVerticalStrut(5));
        this.add(new Divider());
        this.add(Box.createVerticalStrut(5));
        this.add(this.chooser);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(this.ok);
        bottom.add(cancel);
        this.add(ToolPanel.pad(bottom));
    }

    public int showDialog() {
        this.dialog = new JDialog(this.bio, "Save file series", true);
        this.dialog.getRootPane().setDefaultButton(this.ok);
        this.chooser.clearFields();
        int ndx = this.picFormat.isSelected() ? 0 : (this.tiffFormat.isSelected() ? 1 : 2);
        this.chooser.type.setSelectedIndex(ndx);
        int maxSlice = this.bio.sm.getNumberOfSlices();
        int maxIndex = this.bio.sm.getNumberOfIndices();
        if (maxSlice > 1 || maxIndex > 1) {
            this.chooser.start.setText("1");
            this.chooser.end.setText("" + maxIndex);
        }
        this.dialog.setContentPane(this);
        this.dialog.pack();
        Util.centerWindow(this.dialog);
        ((Component)this.dialog).setVisible(true);
        return this.rval;
    }

    public void export() {
        Form form;
        int max;
        int min;
        int resY;
        int first = -1;
        int last = -1;
        try {
            first = Integer.parseInt(this.chooser.start.getText());
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        try {
            last = Integer.parseInt(this.chooser.end.getText());
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (first < 0 && last >= 0) {
            this.chooser.start.setText("1");
        }
        int min_slice = 1;
        int max_slice = this.bio.sm.getNumberOfSlices();
        int min_index = 1;
        int max_index = this.bio.sm.getNumberOfIndices();
        final int rx = this.bio.sm.res_x;
        final int ry = this.bio.sm.res_y;
        final boolean colors = this.doColors.isSelected();
        final boolean align = this.doAlign.isSelected();
        boolean singleTime = this.timeOnly.isSelected();
        boolean singleSlice = this.sliceOnly.isSelected();
        if (singleTime) {
            min_index = max_index = this.bio.sm.getIndex() + 1;
        }
        if (singleSlice) {
            min_slice = max_slice = this.bio.sm.getSlice() + 1;
        }
        final File[] series = this.chooser.getSeries();
        final boolean filesAsSlices = this.chooser.getFilesAsSlices();
        boolean doAltRes = this.altRes.isSelected();
        int altX = rx;
        int altY = ry;
        try {
            altX = Integer.parseInt(this.altRes.getFirstValue());
            altY = Integer.parseInt(this.altRes.getSecondValue());
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        final int resX = doAltRes ? altX : rx;
        int n = resY = doAltRes ? altY : ry;
        if (this.exportTimesteps.isSelected()) {
            try {
                min = Integer.parseInt(this.exportTimesteps.getFirstValue());
                max = Integer.parseInt(this.exportTimesteps.getSecondValue());
                min_index = min;
                max_index = max;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if (this.exportSlices.isSelected()) {
            try {
                min = Integer.parseInt(this.exportSlices.getFirstValue());
                max = Integer.parseInt(this.exportSlices.getSecondValue());
                min_slice = min;
                max_slice = max;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if (this.picFormat.isSelected()) {
            form = new BioRadForm();
        } else if (this.tiffFormat.isSelected()) {
            form = new TiffForm();
        } else if (this.qtFormat.isSelected()) {
            form = new QTForm();
        } else {
            JOptionPane.showMessageDialog(this.bio, "Invalid file format", "Export error", 0);
            return;
        }
        final int minSlice = min_slice - 1;
        int maxSlice = max_slice - 1;
        final int minIndex = min_index - 1;
        int maxIndex = max_index - 1;
        final int numSlices = maxSlice - minSlice + 1;
        final int numIndices = maxIndex - minIndex + 1;
        final boolean arbSlice = singleSlice && this.bio.sm.getPlaneSelect();
        String s = "Export " + (arbSlice ? "arbitrary slice" : "slice" + (numSlices == 1 ? " #" + min_slice : "s " + min_slice + " through " + max_slice)) + " at timestep" + (numIndices == 1 ? " #" + min_index : "s " + min_index + " through " + max_index) + " to file" + (series.length == 1 ? " " + series[0] : "s " + series[0] + " through " + series[series.length - 1]) + "?";
        int ans = JOptionPane.showConfirmDialog(this.bio, s, "VisBio", 0, 3);
        if (ans != 0) {
            return;
        }
        final ProgressDialog dialog = new ProgressDialog((Frame)this.bio, "Exporting");
        final Form saver = form;
        Thread t = new Thread(new Runnable(){

            public void run() {
                boolean needReload;
                File[] infiles = ((ExportDialog)ExportDialog.this).bio.sm.getSeries();
                boolean sliceSeries = ((ExportDialog)ExportDialog.this).bio.sm.getFilesAsSlices();
                boolean bl = needReload = !sliceSeries;
                if (needReload) {
                    try {
                        ((ExportDialog)ExportDialog.this).bio.sm.purgeData(true);
                    }
                    catch (VisADException exc) {
                        exc.printStackTrace();
                    }
                    catch (RemoteException exc) {
                        exc.printStackTrace();
                    }
                }
                int i = 0;
                while (i < series.length) {
                    dialog.setText("Exporting " + series[i].getName());
                    try {
                        FlatField[] images;
                        if (arbSlice) {
                            if (sliceSeries) {
                                images = new FlatField[]{(FlatField)((ExportDialog)ExportDialog.this).bio.sm.arb.extractSlice((FieldImpl)((ExportDialog)ExportDialog.this).bio.sm.getField().domainMultiply(), resX, resY, rx, ry)};
                            } else if (filesAsSlices) {
                                images = new FlatField[numIndices];
                                int j = 0;
                                while (j < numIndices) {
                                    File f = infiles[minIndex + j];
                                    FieldImpl timestep = BioUtil.loadData(f, true);
                                    images[j] = (FlatField)((ExportDialog)ExportDialog.this).bio.sm.arb.extractSlice((FieldImpl)timestep.domainMultiply(), resX, resY, rx, ry);
                                    float percent = (float)(j + 1) / (float)numIndices;
                                    dialog.setPercent((int)(100.0f * percent));
                                    ++j;
                                }
                            } else {
                                images = new FlatField[1];
                                File f = infiles[minIndex + i];
                                FieldImpl timestep = BioUtil.loadData(f, true);
                                images[0] = (FlatField)((ExportDialog)ExportDialog.this).bio.sm.arb.extractSlice((FieldImpl)timestep.domainMultiply(), resX, resY, rx, ry);
                            }
                        } else if (sliceSeries) {
                            FieldImpl field = ((ExportDialog)ExportDialog.this).bio.sm.getField();
                            if (filesAsSlices) {
                                images = new FlatField[]{(FlatField)field.getSample(minSlice + i)};
                            } else {
                                images = new FlatField[numSlices];
                                int j = 0;
                                while (j < numSlices) {
                                    images[j] = (FlatField)field.getSample(minSlice + j);
                                    float percent = (float)(numSlices * i + (j + 1)) / (float)(series.length * numSlices);
                                    dialog.setPercent((int)(100.0f * percent));
                                    ++j;
                                }
                            }
                        } else if (filesAsSlices) {
                            images = new FlatField[numIndices];
                            int j = 0;
                            while (j < numIndices) {
                                File f = infiles[minIndex + j];
                                FieldImpl timestep = BioUtil.loadData(f, true);
                                images[j] = (FlatField)timestep.getSample(minSlice + i);
                                float percent = (float)(numIndices * i + (j + 1)) / (float)(series.length * numIndices);
                                dialog.setPercent((int)(100.0f * percent));
                                ++j;
                            }
                        } else {
                            images = new FlatField[numSlices];
                            File f = infiles[minIndex + i];
                            FieldImpl timestep = BioUtil.loadData(f, true);
                            int j = 0;
                            while (j < numSlices) {
                                images[j] = (FlatField)timestep.getSample(minSlice + j);
                                float percent = (float)(numSlices * i + (j + 1)) / (float)(series.length * numSlices);
                                dialog.setPercent((int)(100.0f * percent));
                                ++j;
                            }
                        }
                        int j = 0;
                        while (j < images.length) {
                            GriddedSet set = (GriddedSet)images[j].getDomainSet();
                            int[] l = set.getLengths();
                            if (l[0] != resX || l[1] != resY) {
                                Linear2DSet nset = new Linear2DSet(set.getType(), 0.0, (double)(l[0] - 1), resX, 0.0, l[1] - 1, resY);
                                images[j] = (FlatField)images[j].resample(nset);
                            }
                            ++j;
                        }
                        FieldImpl data = BioUtil.makeStack(images);
                        if (colors) {
                            // empty if block
                        }
                        if (align) {
                            // empty if block
                        }
                        saver.save(series[i].getPath(), data, true);
                    }
                    catch (VisADException exc) {
                        dialog.setException(exc);
                    }
                    catch (Exception exc) {
                        dialog.setException(new VisADException(exc.getClass() + ": " + exc.getMessage()));
                    }
                    float percent = (float)(i + 1) / (float)series.length;
                    dialog.setPercent((int)(100.0f * percent));
                    ++i;
                }
                dialog.setText("Finishing");
                if (needReload) {
                    try {
                        ((ExportDialog)ExportDialog.this).bio.sm.setFile(false);
                    }
                    catch (VisADException exc) {
                        exc.printStackTrace();
                    }
                    catch (RemoteException exc) {
                        exc.printStackTrace();
                    }
                }
                dialog.kill();
            }
        });
        t.start();
        dialog.show();
        try {
            dialog.checkException();
        }
        catch (VisADException exc) {
            JOptionPane.showMessageDialog(this.bio, "Cannot export data\n" + exc.getMessage(), "Export error", 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ok")) {
            this.rval = 1;
            ((Component)this.dialog).setVisible(false);
        } else if (command.equals("cancel")) {
            this.rval = 2;
            ((Component)this.dialog).setVisible(false);
        } else if (command.equals("picFormat")) {
            this.chooser.type.setSelectedIndex(0);
        } else if (command.equals("tiffFormat")) {
            this.chooser.type.setSelectedIndex(1);
        } else if (command.equals("qtFormat")) {
            this.chooser.type.setSelectedIndex(2);
        } else {
            if (command.equals("sliceOnly")) {
                this.exportSlices.setEnabled(!this.sliceOnly.isSelected());
            } else if (command.equals("timeOnly")) {
                this.exportTimesteps.setEnabled(!this.timeOnly.isSelected());
            } else if (command.equals("exportSlices")) {
                this.sliceOnly.setEnabled(!this.exportSlices.isSelected());
            } else if (command.equals("exportTimesteps")) {
                this.timeOnly.setEnabled(!this.exportTimesteps.isSelected());
            }
            this.computeEnd();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.computeEnd();
    }

    public void insertUpdate(DocumentEvent e) {
        this.computeEnd();
    }

    public void removeUpdate(DocumentEvent e) {
        this.computeEnd();
    }

    private void computeEnd() {
        int max;
        int min;
        int startVal = 1;
        try {
            startVal = Integer.parseInt(this.chooser.start.getText());
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        int minSlice = 1;
        int maxSlice = this.bio.sm.getNumberOfSlices();
        int minIndex = 1;
        int maxIndex = this.bio.sm.getNumberOfIndices();
        if (this.timeOnly.isSelected()) {
            minIndex = maxIndex = this.bio.sm.getIndex() + 1;
        }
        if (this.sliceOnly.isSelected()) {
            minSlice = maxSlice = this.bio.sm.getSlice() + 1;
        }
        boolean filesAsSlices = this.chooser.getFilesAsSlices();
        if (this.exportTimesteps.isSelected()) {
            try {
                min = Integer.parseInt(this.exportTimesteps.getFirstValue());
                max = Integer.parseInt(this.exportTimesteps.getSecondValue());
                minIndex = min;
                maxIndex = max;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if (this.exportSlices.isSelected()) {
            try {
                min = Integer.parseInt(this.exportSlices.getFirstValue());
                max = Integer.parseInt(this.exportSlices.getSecondValue());
                minSlice = min;
                maxSlice = max;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if (filesAsSlices && minSlice == maxSlice || !filesAsSlices && minIndex == maxIndex) {
            this.chooser.end.setText("" + startVal);
        } else {
            int q = filesAsSlices ? maxSlice - minSlice : maxIndex - minIndex;
            this.chooser.end.setText("" + (startVal + q));
        }
    }
}

