/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visad.util.Util;

public class DoubleTextCheckBox
extends JPanel
implements DocumentListener,
ItemListener {
    private Vector listeners = new Vector();
    private String cmd = "";
    private JCheckBox box;
    private JLabel label;
    private JTextField field1;
    private JTextField field2;

    public DoubleTextCheckBox(String label1, String label2, String value1, String value2, boolean checked) {
        this.setLayout(new BoxLayout(this, 0));
        this.box = new JCheckBox(label1, checked);
        this.box.addItemListener(this);
        this.label = new JLabel(label2);
        this.label.setForeground(Color.black);
        this.field1 = new WideTextField(value1);
        this.field2 = new WideTextField(value2);
        this.field1.getDocument().addDocumentListener(this);
        this.field2.getDocument().addDocumentListener(this);
        Util.adjustTextField(this.field1);
        Util.adjustTextField(this.field2);
        this.updateGUI();
        this.add(this.box);
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.field1);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.label);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.field2);
    }

    public void updateGUI() {
        boolean enabled = this.box.isEnabled() && this.box.isSelected();
        this.label.setEnabled(enabled);
        this.field1.setEnabled(enabled);
        this.field2.setEnabled(enabled);
    }

    public boolean isSelected() {
        return this.box.isSelected();
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
        this.updateGUI();
    }

    public String getFirstValue() {
        return this.field1.getText();
    }

    public String getSecondValue() {
        return this.field2.getText();
    }

    public void setSelected(boolean selected) {
        this.box.setSelected(selected);
    }

    public void setValues(String text1, String text2) {
        this.field1.setText(text1);
        this.field2.setText(text2);
    }

    public void setMnemonic(char m) {
        this.box.setMnemonic(m);
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    public void setActionCommand(String cmd) {
        this.cmd = cmd;
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateGUI();
        this.notifyListeners();
    }

    public void changedUpdate(DocumentEvent e) {
        this.notifyListeners();
    }

    public void insertUpdate(DocumentEvent e) {
        this.notifyListeners();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notifyListeners();
    }

    private void notifyListeners() {
        ActionEvent e = new ActionEvent(this, 0, this.cmd);
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ActionListener l = (ActionListener)this.listeners.elementAt(i);
            l.actionPerformed(e);
            ++i;
        }
    }

    private class WideTextField
    extends JTextField {
        private static final int MIN_WIDTH = 30;

        public WideTextField(String value) {
            super(value);
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.width = 30;
            return d;
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getMinimumSize();
            if (d.width < 30) {
                d.width = 30;
            }
            return d;
        }
    }
}

