/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.RealType;
import visad.bio.BioColorWidget;
import visad.bio.ToolPanel;
import visad.bio.VisBio;
import visad.browser.Divider;
import visad.util.LabeledColorWidget;

public class ColorToolPanel
extends ToolPanel
implements ItemListener {
    private static final int MAX_POWER = 8;
    private JLabel brightnessLabel;
    private JSlider brightness;
    private JLabel brightnessValue;
    private JLabel contrastLabel;
    private JSlider contrast;
    private JLabel contrastValue;
    private JRadioButton rgb;
    private JRadioButton hsv;
    private BioColorWidget red;
    private BioColorWidget green;
    private BioColorWidget blue;
    private JCheckBox composite;
    private JLabel alphaLabel;
    private JSlider alpha;
    private JLabel alphaValue;
    private JComboBox selector;
    private int cc = 0;
    private boolean ignore = false;

    public ColorToolPanel(VisBio biovis) {
        super(biovis);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.brightnessLabel = new JLabel("Brightness: ");
        this.brightnessLabel.setForeground(Color.black);
        this.brightnessLabel.setAlignmentY(0.0f);
        p.add(this.brightnessLabel);
        this.brightness = new JSlider(0, 256, 128);
        this.brightness.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorToolPanel.this.doColorTable();
            }
        });
        this.brightness.setAlignmentY(0.0f);
        p.add(this.brightness);
        this.brightnessValue = new JLabel("128");
        Dimension labelSize = new JLabel(".256").getPreferredSize();
        this.brightnessValue.setPreferredSize(labelSize);
        this.brightnessValue.setAlignmentY(0.0f);
        p.add(this.brightnessValue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.contrastLabel = new JLabel("Contrast: ");
        this.contrastLabel.setForeground(Color.black);
        this.contrastLabel.setPreferredSize(this.brightnessLabel.getPreferredSize());
        this.contrastLabel.setAlignmentY(0.0f);
        p.add(this.contrastLabel);
        this.contrast = new JSlider(0, 256, 128);
        this.contrast.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorToolPanel.this.doColorTable();
            }
        });
        this.contrast.setAlignmentY(0.0f);
        this.contrast.setMajorTickSpacing(64);
        this.contrast.setMinorTickSpacing(16);
        this.contrast.setPaintTicks(true);
        p.add(this.contrast);
        this.contrastValue = new JLabel("128");
        this.contrastValue.setPreferredSize(labelSize);
        this.contrastValue.setAlignmentY(0.0f);
        p.add(this.contrastValue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        this.controls.add(Box.createVerticalStrut(5));
        ++this.cc;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel colorModel = new JLabel("Color model: ");
        colorModel.setForeground(Color.black);
        p.add(colorModel);
        ButtonGroup group = new ButtonGroup();
        this.rgb = new JRadioButton("RGB", true);
        this.rgb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorToolPanel.this.red.setModel(0);
                ColorToolPanel.this.green.setModel(0);
                ColorToolPanel.this.blue.setModel(0);
                ColorToolPanel.this.doColorTable();
            }
        });
        group.add(this.rgb);
        p.add(this.rgb);
        this.hsv = new JRadioButton("HSV");
        this.hsv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorToolPanel.this.red.setModel(1);
                ColorToolPanel.this.green.setModel(1);
                ColorToolPanel.this.blue.setModel(1);
                ColorToolPanel.this.doColorTable();
            }
        });
        group.add(this.hsv);
        p.add(this.hsv);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        this.controls.add(Box.createVerticalStrut(5));
        ++this.cc;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.red = new BioColorWidget(this.bio, 0);
        this.red.addItemListener(this);
        p.add(this.red);
        this.green = new BioColorWidget(this.bio, 1);
        this.green.addItemListener(this);
        p.add(this.green);
        this.blue = new BioColorWidget(this.bio, 2);
        this.blue.addItemListener(this);
        p.add(this.blue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        this.composite = new JCheckBox("Composite image coloring", false);
        this.composite.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = !ColorToolPanel.this.composite.isSelected();
                ColorToolPanel.this.red.setEnabled(b);
                ColorToolPanel.this.green.setEnabled(b);
                ColorToolPanel.this.blue.setEnabled(b);
                ColorToolPanel.this.doColorTable();
            }
        });
        this.controls.add(ToolPanel.pad(this.composite));
        ++this.cc;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.alphaLabel = new JLabel("Alpha: ");
        this.alphaLabel.setForeground(Color.black);
        this.alphaLabel.setAlignmentY(0.0f);
        this.alphaLabel.setPreferredSize(this.brightnessLabel.getPreferredSize());
        this.alphaLabel.setEnabled(false);
        p.add(this.alphaLabel);
        this.alpha = new JSlider(0, 256, 128);
        this.alpha.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorToolPanel.this.doAlpha(false);
            }
        });
        this.alpha.setAlignmentY(0.0f);
        this.alpha.setMajorTickSpacing(64);
        this.alpha.setMinorTickSpacing(16);
        this.alpha.setPaintTicks(true);
        this.alpha.setEnabled(false);
        p.add(this.alpha);
        this.alphaValue = new JLabel("1.0");
        this.alphaValue.setPreferredSize(labelSize);
        this.alphaValue.setAlignmentY(0.0f);
        this.alphaValue.setEnabled(false);
        p.add(this.alphaValue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        this.cc += 3;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel selLabel = new JLabel("Color table: ");
        selLabel.setForeground(Color.black);
        p.add(selLabel);
        this.selector = new JComboBox();
        this.selector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ndx = ColorToolPanel.this.selector.getSelectedIndex() + ColorToolPanel.this.cc;
                int i = ColorToolPanel.this.cc;
                while (i < ColorToolPanel.this.controls.getComponentCount()) {
                    ColorToolPanel.this.controls.getComponent(i).setVisible(i == ndx);
                    ++i;
                }
            }
        });
        p.add(this.selector);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
    }

    public void init() {
        this.red.removeItemListener(this);
        this.green.removeItemListener(this);
        this.blue.removeItemListener(this);
        this.red.guessType();
        this.green.guessType();
        this.blue.guessType();
        this.red.addItemListener(this);
        this.green.addItemListener(this);
        this.blue.addItemListener(this);
        this.doColorTable();
        this.bio.sm.syncColors();
    }

    public void setEnabled(boolean enabled) {
        this.brightnessLabel.setEnabled(enabled);
        this.brightness.setEnabled(enabled);
        this.contrastLabel.setEnabled(enabled);
        this.contrast.setEnabled(enabled);
    }

    public void addWidget(String s, JComponent c) {
        this.selector.addItem(s);
        c.setVisible(this.selector.getItemCount() == 1);
        this.controls.add(c);
    }

    public void removeAllWidgets() {
        this.selector.removeAllItems();
        int size = this.controls.getComponentCount();
        int i = this.controls.getComponentCount();
        while (i > this.cc) {
            this.controls.remove(this.cc);
            --i;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.doColorTable();
    }

    void doColorTable() {
        if (this.ignore) {
            return;
        }
        int bright = this.brightness.getValue();
        int cont = this.contrast.getValue();
        int model = this.rgb.isSelected() ? 0 : 1;
        boolean comp = this.composite.isSelected();
        this.bio.setImageColors(bright, cont, model, comp, this.red.getSelectedItem(), this.green.getSelectedItem(), this.blue.getSelectedItem());
        this.brightnessValue.setText("" + bright);
        this.contrastValue.setText("" + cont);
    }

    void doAlpha(boolean solid) {
        boolean invert;
        double value = (double)this.alpha.getValue() / 256.0;
        boolean bl = invert = value > 0.5;
        if (invert) {
            value = 1.0 - value;
        }
        double pow = 14.0 * (0.5 - value) + 1.0;
        if (invert) {
            pow = 1.0 / pow;
        }
        float[] alphaTable = new float[256];
        int i = 0;
        while (i < 256) {
            double inc = (double)i / 255.0;
            alphaTable[i] = (float)Math.pow(inc, pow);
            ++i;
        }
        LabeledColorWidget[] widgets = this.bio.sm.getColorWidgets();
        int j = 0;
        while (j < widgets.length) {
            float[][] table = widgets[j].getTable();
            if (table.length >= 4) {
                if (solid) {
                    Arrays.fill(table[3], 1.0f);
                } else {
                    int len = alphaTable.length < table[3].length ? alphaTable.length : table[3].length;
                    System.arraycopy(alphaTable, 0, table[3], 0, len);
                }
                widgets[j].setTable(table);
            }
            ++j;
        }
        this.bio.state.saveState(true);
        String s = "" + pow;
        if (s.length() > 4) {
            s = s.substring(0, 4);
        }
        this.alphaValue.setText(s);
        this.alphaLabel.setEnabled(!solid);
        this.alpha.setEnabled(!solid);
        this.alphaValue.setEnabled(!solid);
    }

    void setColors(int bright, int cont, int model, boolean comp, RealType r, RealType g, RealType b) {
        this.ignore = true;
        this.brightness.setValue(bright);
        this.contrast.setValue(cont);
        this.rgb.setSelected(model == 0);
        this.hsv.setSelected(model == 1);
        this.red.setModel(model);
        this.green.setModel(model);
        this.blue.setModel(model);
        this.composite.setSelected(comp);
        this.red.setSelectedItem(r);
        this.green.setSelectedItem(g);
        this.blue.setSelectedItem(b);
        this.ignore = false;
        this.doColorTable();
        this.bio.sm.syncColors();
    }
}

