/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.io.File;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.VisADRay;
import visad.bio.SliceManager;
import visad.data.DefaultFamily;

public class BioUtil {
    private static DefaultFamily loader = new DefaultFamily("bio_loader");

    public static double[] pixelToDomain(DisplayImpl d, int x, int y) {
        return BioUtil.cursorToDomain(d, BioUtil.pixelToCursor(d, x, y));
    }

    public static double[] pixelToCursor(DisplayImpl d, int x, int y) {
        MouseBehavior mb = d.getDisplayRenderer().getMouseBehavior();
        VisADRay ray = mb.findRay(x, y);
        return ray.position;
    }

    public static double[] cursorToDomain(DisplayImpl d, double[] cursor) {
        Vector maps = d.getMapVector();
        int numMaps = maps.size();
        ScalarMap map_x = null;
        ScalarMap map_y = null;
        ScalarMap map_z = null;
        int i = 0;
        while (i < numMaps) {
            if (map_x != null && map_y != null && map_z != null) break;
            ScalarMap map = (ScalarMap)maps.elementAt(i);
            DisplayRealType drt = map.getDisplayScalar();
            if (drt.equals(Display.XAxis)) {
                map_x = map;
            } else if (drt.equals(Display.YAxis)) {
                map_y = map;
            } else if (drt.equals(Display.ZAxis)) {
                map_z = map;
            }
            ++i;
        }
        double[] scale_offset = new double[2];
        double[] dummy = new double[2];
        double[] values = new double[3];
        if (map_x == null) {
            values[0] = Double.NaN;
        } else {
            map_x.getScale(scale_offset, dummy, dummy);
            values[0] = (cursor[0] - scale_offset[1]) / scale_offset[0];
        }
        if (map_y == null) {
            values[1] = Double.NaN;
        } else {
            map_y.getScale(scale_offset, dummy, dummy);
            values[1] = (cursor[1] - scale_offset[1]) / scale_offset[0];
        }
        if (map_z == null) {
            values[2] = Double.NaN;
        } else {
            map_z.getScale(scale_offset, dummy, dummy);
            values[2] = (cursor[2] - scale_offset[1]) / scale_offset[0];
        }
        return values;
    }

    public static double getDistance(double[] a, double[] b, double[] v, boolean segment) {
        int len = a.length;
        double[] ab = new double[len];
        double[] va = new double[len];
        int i = 0;
        while (i < len) {
            ab[i] = a[i] - b[i];
            va[i] = v[i] - a[i];
            ++i;
        }
        double numer = 0.0;
        double denom = 0.0;
        int i2 = 0;
        while (i2 < len) {
            numer += va[i2] * ab[i2];
            denom += ab[i2] * ab[i2];
            ++i2;
        }
        double c = numer / denom;
        double[] p = new double[len];
        int i3 = 0;
        while (i3 < len) {
            p[i3] = c * ab[i3] + a[i3];
            ++i3;
        }
        int flag = 0;
        if (segment) {
            int i4 = 0;
            while (i4 < len) {
                if (p[i4] > a[i4] && p[i4] > b[i4]) {
                    flag = a[i4] > b[i4] ? 1 : 2;
                    break;
                }
                if (p[i4] < a[i4] && p[i4] < b[i4]) {
                    flag = a[i4] < b[i4] ? 1 : 2;
                    break;
                }
                ++i4;
            }
        }
        double sum = 0.0;
        int i5 = 0;
        while (i5 < len) {
            double q = flag == 0 ? p[i5] - v[i5] : (flag == 1 ? a[i5] - v[i5] : b[i5] - v[i5]);
            sum += q * q;
            ++i5;
        }
        return Math.sqrt(sum);
    }

    public static double getDistance(double[] p, double[] q, double[] m) {
        int len = p.length;
        double sum = 0.0;
        int i = 0;
        while (i < len) {
            double dist = m[i] * (q[i] - p[i]);
            sum += dist * dist;
            ++i;
        }
        return Math.sqrt(sum);
    }

    public static boolean intersects(double x1, double y1, double x2, double y2, double ax, double ay, double bx, double by) {
        double t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        if (BioUtil.contains(x1, y1, x2, y2, ax, ay) || BioUtil.contains(x1, y1, x2, y2, bx, by)) {
            return true;
        }
        if (ax == bx) {
            if (ax < x1 || ax > x2) {
                return false;
            }
            return ay <= y1 && by >= y1 || ay <= y2 && by >= y2 || ay >= y1 && by <= y1 || ay >= y2 && by <= y2;
        }
        if (ay == by) {
            if (ay < y1 || ay > y2) {
                return false;
            }
            return ax <= x1 && bx >= x1 || ax <= x2 && bx >= x2 || ax >= x1 && bx <= x1 || ax >= x2 && bx <= x2;
        }
        double m = (by - ay) / (bx - ax);
        double b = ay - m * ax;
        double left_y = m * x1 + b;
        if (left_y >= y1 && left_y <= y2) {
            return true;
        }
        double right_y = m * x2 + b;
        if (right_y >= y1 && right_y <= y2) {
            return true;
        }
        double top_x = (y1 - b) / m;
        if (top_x >= x1 && top_x <= x2) {
            return true;
        }
        double bottom_x = (y2 - b) / m;
        return bottom_x >= x1 && bottom_x <= x2;
    }

    public static boolean contains(double x1, double y1, double x2, double y2, double vx, double vy) {
        double t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        return vx >= x1 && vx <= x2 && vy >= y1 && vy <= y2;
    }

    public static FieldImpl loadData(File file, boolean makeStack) throws VisADException, RemoteException {
        DataImpl data = loader.open(file.getPath());
        FieldImpl f = null;
        if (data instanceof FieldImpl) {
            f = (FieldImpl)data;
        } else if (data instanceof Tuple) {
            Tuple tuple = (Tuple)data;
            Data[] d = tuple.getComponents();
            int i = 0;
            while (i < d.length) {
                if (d[i] instanceof FieldImpl) {
                    f = (FieldImpl)d[i];
                    break;
                }
                ++i;
            }
        }
        return makeStack && f instanceof FlatField ? BioUtil.makeStack(new FlatField[]{(FlatField)f}) : f;
    }

    public static FieldImpl makeStack(FlatField[] f) throws VisADException, RemoteException {
        FunctionType func = new FunctionType(SliceManager.SLICE_TYPE, f[0].getType());
        FieldImpl stack = new FieldImpl(func, new Integer1DSet(f.length));
        int i = 0;
        while (i < f.length) {
            stack.setSample(i, (Data)f[i], false);
            ++i;
        }
        return stack;
    }

    public static RealTuple[] copy(RealTuple[] tuples) {
        return BioUtil.copy(tuples, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static RealTuple[] copy(RealTuple[] tuples, int slice) {
        try {
            void exc;
            RealTuple[] n_tuples = new RealTuple[tuples.length];
            int j = 0;
            while (j < tuples.length) {
                int dim = tuples[j].getDimension();
                Data[] comps = tuples[j].getComponents();
                Real[] n_comps = new Real[dim];
                int i = 0;
                while (i < dim) {
                    RealType type;
                    double value;
                    Real real = (Real)comps[i];
                    if (slice >= 0 && i == dim - 1) {
                        value = slice;
                        type = SliceManager.Z_TYPE;
                    } else {
                        value = real.getValue();
                        type = (RealType)real.getType();
                    }
                    n_comps[i] = new Real(type, value, real.getUnit(), real.getError());
                    ++i;
                }
                RealTupleType tuple_type = (RealTupleType)tuples[j].getType();
                RealType[] real_types = tuple_type.getRealComponents();
                RealType[] n_real_types = new RealType[dim];
                System.arraycopy(real_types, 0, n_real_types, 0, dim);
                n_tuples[j] = new RealTuple(new RealTupleType(n_real_types), n_comps, tuples[j].getCoordinateSystem());
                ++j;
            }
            return exc;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public static void dump(RealTuple tuple) {
        Data[] comps = tuple.getComponents();
        int i = 0;
        while (i < comps.length) {
            Real real = (Real)comps[i];
            System.out.println("#" + i + ": type=" + real.getType() + "; value=" + real.getValue());
            ++i;
        }
    }

    public static float[][] adjustColorTable(float[][] table, float[] alpha, boolean doAlpha) {
        if (table == null || table[0] == null) {
            return null;
        }
        if (table.length == 3) {
            if (!doAlpha) {
                return table;
            }
            int len = table[0].length;
            if (alpha == null || alpha.length != len) {
                alpha = new float[len];
                Arrays.fill(alpha, 1.0f);
            }
            return new float[][]{table[0], table[1], table[2], alpha};
        }
        if (doAlpha) {
            return table;
        }
        return new float[][]{table[0], table[1], table[2]};
    }

    public static boolean tablesEqual(float[][] t1, float[][] t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.length != t2.length) {
            return false;
        }
        if (t1.length == 0) {
            return true;
        }
        int len = t1[0].length;
        if (len != t2[0].length) {
            return false;
        }
        int i = 0;
        while (i < t1.length) {
            int j = 0;
            while (j < len) {
                if (t1[i][j] != t2[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static void project(float[] x, float[] y, float[] z, float p1x, float p1y, float p1z, float p2x, float p2y, float p2z, int p, float[] min, float[] max, float[] proj) {
        int numpts = x.length - 1;
        float x21 = p2x - p1x;
        float y21 = p2y - p1y;
        float z21 = p2z - p1z;
        float maxdist = x21 * x21 + y21 * y21 + z21 * z21;
        min[0] = p1x;
        min[1] = p1y;
        min[2] = p1z;
        max[0] = p2x;
        max[1] = p2y;
        max[2] = p2z;
        int p3 = 0;
        while (p3 < numpts) {
            float x31 = x[p3] - p1x;
            float y31 = y[p3] - p1y;
            float z31 = z[p3] - p1z;
            float u = (x31 * x21 + y31 * y21 + z31 * z21) / (x21 * x21 + y21 * y21 + z21 * z21);
            float px = p1x + u * x21;
            float py = p1y + u * y21;
            float pz = p1z + u * z21;
            if (p3 == p) {
                proj[0] = px;
                proj[1] = py;
                proj[2] = pz;
            }
            float pminx = px - min[0];
            float pminy = py - min[1];
            float pminz = pz - min[2];
            float pdistmin = pminx * pminx + pminy * pminy + pminz * pminz;
            float pmaxx = px - max[0];
            float pmaxy = py - max[1];
            float pmaxz = pz - max[2];
            float pdistmax = pmaxx * pmaxx + pmaxy * pmaxy + pmaxz * pmaxz;
            if (pdistmin > maxdist || pdistmax > maxdist) {
                if (pdistmin > pdistmax) {
                    maxdist = pdistmin;
                    max[0] = px;
                    max[1] = py;
                    max[2] = pz;
                } else {
                    maxdist = pdistmax;
                    min[0] = px;
                    min[1] = py;
                    min[2] = pz;
                }
            }
            ++p3;
        }
    }

    public static float[] corner(float[] c1, float[] c2, float[] c3) {
        float[] c4 = new float[c1.length];
        int i = 0;
        while (i < c1.length) {
            c4[i] = c3[i] + c2[i] - c1[i];
            ++i;
        }
        return c4;
    }
}

