/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BioSpinWidget
extends JPanel
implements MouseListener {
    private JTextField val;
    private JButton up;
    private JButton down;
    private Vector listeners = new Vector();
    private int min;
    private int max;
    private int value;
    private boolean upPressed;
    private boolean downPressed;
    private int pressTime;
    private long lastPress;

    public BioSpinWidget(int minimum, int maximum, int starting) {
        this.min = minimum;
        this.max = maximum;
        this.value = starting;
        this.val = new JTextField("" + this.value);
        this.val.setEditable(false);
        FontMetrics fm = ((Component)this).getFontMetrics(this.val.getFont());
        Dimension size = new Dimension(fm.stringWidth("x" + this.max), fm.getHeight());
        this.val.setPreferredSize(size);
        this.val.setMaximumSize(size);
        URL upImg = this.getClass().getResource("up.gif");
        URL downImg = this.getClass().getResource("down.gif");
        ImageIcon upIcon = null;
        ImageIcon downIcon = null;
        if (upImg != null && downImg != null) {
            upIcon = new ImageIcon(upImg);
            downIcon = new ImageIcon(downImg);
        }
        if (upIcon == null || downIcon == null) {
            this.up = new JButton();
            this.down = new JButton();
        } else {
            this.up = new JButton(upIcon);
            this.down = new JButton(downIcon);
        }
        this.up.setPreferredSize(new Dimension(upIcon.getIconWidth() + 2, upIcon.getIconHeight() + 2));
        this.down.setPreferredSize(new Dimension(downIcon.getIconWidth() + 2, downIcon.getIconHeight() + 2));
        this.up.addMouseListener(this);
        this.down.addMouseListener(this);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.val);
        this.add(Box.createHorizontalStrut(3));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.up);
        p.add(this.down);
        this.add(p);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        this.updateWidget();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void setEnabled(boolean enabled) {
        this.val.setEnabled(enabled);
        this.up.setEnabled(enabled);
        this.down.setEnabled(enabled);
    }

    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.up && this.up.isEnabled()) {
            this.upPressed = true;
            ++this.value;
            if (this.value > this.max) {
                this.value = this.max;
            }
        } else if (source == this.down && this.down.isEnabled()) {
            this.downPressed = true;
            --this.value;
            if (this.value < this.min) {
                this.value = this.min;
            }
        } else {
            return;
        }
        this.updateWidget();
        this.lastPress = System.currentTimeMillis();
        this.pressTime = 0;
        this.startSpinThread();
    }

    public void mouseReleased(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.up) {
            this.upPressed = false;
        } else if (source == this.down) {
            this.downPressed = false;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void updateWidget() {
        this.val.setText("" + this.value);
        this.notifyListeners();
    }

    private void notifyListeners() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ChangeListener l = (ChangeListener)this.listeners.elementAt(i);
            l.stateChanged(new ChangeEvent(this));
            ++i;
        }
    }

    private void startSpinThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException exc) {}
                while (BioSpinWidget.this.lastPress + 500L <= System.currentTimeMillis()) {
                    if (BioSpinWidget.this.upPressed) {
                        BioSpinWidget.this.value++;
                        if (BioSpinWidget.this.value > BioSpinWidget.this.max) {
                            BioSpinWidget.this.value = BioSpinWidget.this.max;
                        }
                    } else {
                        if (!BioSpinWidget.this.downPressed) break;
                        BioSpinWidget.this.value--;
                        if (BioSpinWidget.this.value < BioSpinWidget.this.min) {
                            BioSpinWidget.this.value = BioSpinWidget.this.min;
                        }
                    }
                    BioSpinWidget.this.pressTime++;
                    BioSpinWidget.this.updateWidget();
                    int waitTime = 75 - BioSpinWidget.this.pressTime;
                    if (waitTime < 1) {
                        waitTime = 1;
                    }
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        t.start();
    }
}

