/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.RealType;
import visad.bio.VisBio;

public class BioColorWidget
extends JPanel {
    public static final int RGB = 0;
    public static final int HSV = 1;
    public static final RealType SOLID = RealType.getRealType("bio_solid");
    private static final String[][] COLOR_NAMES = new String[][]{{"Red", "Green", "Blue"}, {"Hue", "Saturation", "Value"}};
    private JLabel color;
    private JComboBox scalars;
    private VisBio bio;
    private int model;
    private int type;

    public BioColorWidget(VisBio biovis, int colorType) {
        this.bio = biovis;
        this.model = 0;
        this.type = colorType;
        this.color = new JLabel(COLOR_NAMES[this.model][this.type] + ":");
        this.color.setForeground(Color.black);
        this.scalars = new JComboBox();
        this.scalars.addItem("None");
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(this.color);
        p.add(Box.createHorizontalGlue());
        this.add(p);
        this.add(this.scalars);
    }

    public RealType getSelectedItem() {
        Object o = this.scalars.getSelectedItem();
        if (o instanceof RealType) {
            return (RealType)o;
        }
        String s = (String)o;
        return s.equals("1.0") ? SOLID : null;
    }

    public int getModel() {
        return this.model;
    }

    public void setSelectedItem(RealType rt) {
        if (rt == null) {
            this.scalars.setSelectedIndex(0);
        } else {
            this.scalars.setSelectedItem(rt);
        }
    }

    public void setModel(int model) {
        this.model = model;
        this.color.setText(COLOR_NAMES[model][this.type] + ":");
    }

    public void addItemListener(ItemListener l) {
        this.scalars.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.scalars.removeItemListener(l);
    }

    public void setEnabled(boolean enabled) {
        this.color.setEnabled(enabled);
        this.scalars.setEnabled(enabled);
    }

    public void guessType() {
        this.scalars.removeAllItems();
        this.scalars.addItem("None");
        this.scalars.addItem("1.0");
        RealType[] rt = this.bio.sm.rtypes;
        int i = 0;
        while (i < rt.length) {
            this.scalars.addItem(rt[i]);
            ++i;
        }
        if (rt == null || rt.length == 0) {
            this.scalars.setSelectedIndex(0);
        } else if (rt.length == 1) {
            this.scalars.setSelectedItem(rt[0]);
        } else if (this.type == 0) {
            this.scalars.setSelectedItem(rt[0]);
        } else if (this.type == 1) {
            this.scalars.setSelectedItem(rt[1]);
        } else if (this.type == 2 && rt.length >= 3) {
            this.scalars.setSelectedItem(rt[2]);
        } else {
            this.scalars.setSelectedIndex(0);
        }
    }
}

