/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.VisADException;
import visad.bio.BioSpinWidget;
import visad.bio.VisBio;

public class BioAnimWidget
extends JPanel
implements ControlListener {
    private JButton go = new JButton("Animate");
    private JLabel fps;
    private BioSpinWidget spin;
    private AnimationControl control;

    public BioAnimWidget(VisBio biovis) {
        this.go.setPreferredSize(this.go.getPreferredSize());
        this.fps = new JLabel("FPS:");
        this.fps.setForeground(Color.black);
        this.spin = new BioSpinWidget(1, 999, 10);
        final VisBio bio = biovis;
        this.go.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BioAnimWidget.this.control != null) {
                    bio.sm.startAnimation();
                    try {
                        BioAnimWidget.this.control.toggle();
                    }
                    catch (VisADException exc) {
                        exc.printStackTrace();
                    }
                    catch (RemoteException exc) {
                        exc.printStackTrace();
                    }
                    BioAnimWidget.this.updateWidget();
                }
            }
        });
        this.spin.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (BioAnimWidget.this.control != null) {
                    try {
                        BioAnimWidget.this.control.setStep((int)(1000.0 / (double)BioAnimWidget.this.spin.getValue()));
                    }
                    catch (VisADException exc) {
                        exc.printStackTrace();
                    }
                    catch (RemoteException exc) {
                        exc.printStackTrace();
                    }
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.go);
        p.add(Box.createHorizontalStrut(3));
        p.add(this.fps);
        p.add(Box.createHorizontalStrut(3));
        p.add(this.spin);
        this.add(p);
    }

    public AnimationControl getControl() {
        return this.control;
    }

    public void setControl(AnimationControl control) {
        if (this.control == control) {
            return;
        }
        if (this.control != null) {
            this.control.removeControlListener(this);
        }
        this.control = control;
        if (control != null) {
            try {
                control.setStep((int)(1000.0 / (double)this.spin.getValue()));
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
            control.addControlListener(this);
            this.updateWidget();
        }
    }

    public void setEnabled(boolean enabled) {
        this.go.setEnabled(enabled);
        this.fps.setEnabled(enabled);
        this.spin.setEnabled(enabled);
    }

    public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        this.updateWidget();
    }

    private void updateWidget() {
        this.go.setText(this.control.getOn() ? "Stop" : "Animate");
    }
}

