/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.rmi.RemoteException;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.VisADException;
import visad.bio.BioUtil;
import visad.bio.PlaneSelector;

public class ArbitrarySlice
extends PlaneSelector {
    protected static final double EPS = 1.0E-10;

    public ArbitrarySlice(DisplayImpl display) {
        super(display);
    }

    public Field extractSlice(FieldImpl field, int resx, int resy, int x2, int y2) throws VisADException, RemoteException {
        if (this.lines == null) {
            return null;
        }
        float[][] samples = this.lines.getSamples(false);
        float[] x = samples[0];
        float[] y = samples[1];
        float[] z = samples[2];
        int numpts = x.length - 1;
        double longest = 0.0;
        int index = -1;
        int i = 0;
        while (i < numpts) {
            float dx = x[i] - x[i + 1];
            float dy = y[i] - y[i + 1];
            float dz = z[i] - z[i + 1];
            double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (len > longest) {
                longest = len;
                index = i;
            }
            ++i;
        }
        int p1 = index;
        int p2 = (index + 1) % numpts;
        int p = 0;
        while (p == p1 || p == p2) {
            ++p;
        }
        float[] c1 = new float[3];
        float[] c2 = new float[3];
        float[] proj = new float[3];
        BioUtil.project(x, y, z, x[p1], y[p1], z[p1], x[p2], y[p2], z[p2], p, c1, c2, proj);
        float[] c3 = new float[3];
        float[] l = BioUtil.corner(proj, c1, new float[]{x[p], y[p], z[p]});
        BioUtil.project(x, y, z, c1[0], c1[1], c1[2], l[0], l[1], l[2], -1, c1, c3, proj);
        float[] c4 = BioUtil.corner(c1, c2, c3);
        SetType type3 = (SetType)this.lines.getType();
        float[][] samp3 = new float[][]{{c1[0], c2[0], c3[0], c4[0]}, {c1[1], c2[1], c3[1], c4[1]}, {c1[2], c2[2], c3[2], c4[2]}};
        Gridded3DSet box3 = new Gridded3DSet((MathType)type3, (float[][])samp3, 2, 2, null, null, null, false);
        int rx = resx - 1;
        int ry = resy - 1;
        int len = resx * resy;
        float[][] grid = new float[2][len];
        int j = 0;
        while (j < resy) {
            int i2 = 0;
            while (i2 < resx) {
                index = j * resx + i2;
                grid[0][index] = (float)i2 / (float)rx;
                grid[1][index] = (float)j / (float)ry;
                ++i2;
            }
            ++j;
        }
        Gridded3DSet set3 = new Gridded3DSet((MathType)type3, box3.gridToValue(grid), resx, resy, null, null, null, false);
        FieldImpl slice3 = (FieldImpl)field.resample(set3, 101, 202);
        RealType[] rt = type3.getDomain().getRealComponents();
        RealTupleType type2 = new RealTupleType(new RealType[]{rt[0], rt[1]});
        float[][] samp2 = new float[2][resx * resy];
        int j2 = 0;
        while (j2 < resy) {
            int i3 = 0;
            while (i3 < resx) {
                index = resx * j2 + i3;
                samp2[0][index] = (float)x2 * (float)i3 / (float)resx;
                samp2[1][index] = (float)y2 * (float)j2 / (float)resy;
                ++i3;
            }
            ++j2;
        }
        Gridded2DSet set2 = new Gridded2DSet(type2, samp2, resx, resy, null, null, null, false);
        FunctionType ftype3 = (FunctionType)slice3.getType();
        FunctionType ftype2 = new FunctionType(type2, ftype3.getRange());
        FlatField slice2 = new FlatField(ftype2, set2);
        slice2.setSamples(slice3.getValues(false), false);
        return slice2;
    }

    protected boolean computePlane(RealTuple[] tuple) throws VisADException {
        int len = tuple.length;
        int vcount = 0;
        float[][] samples = null;
        RealTupleType type = (RealTupleType)tuple[0].getType();
        double[] x = new double[len];
        double[] y = new double[len];
        double[] z = new double[len];
        int i = 0;
        while (i < len) {
            boolean zm;
            boolean cz2;
            double[] values = tuple[i].getValues();
            double vx = values[0];
            double vy = values[1];
            double vz = values[2];
            boolean cx1 = vx < this.x1;
            boolean cx2 = vx > this.x2;
            boolean cy1 = vy < this.y1;
            boolean cy2 = vy > this.y2;
            boolean cz1 = vz < this.z1;
            boolean bl = cz2 = vz > this.z2;
            if (cx1) {
                vx = this.x1;
            } else if (cx2) {
                vx = this.x2;
            }
            if (cy1) {
                vy = this.y1;
            } else if (cy2) {
                vy = this.y2;
            }
            if (cz1) {
                vz = this.z1;
            } else if (cz2) {
                vz = this.z2;
            }
            boolean changed = cx1 || cx2 || cy1 || cy2 || cz1 || cz2;
            double rx = Math.abs(this.x2 - this.x1);
            double ry = Math.abs(this.y2 - this.y1);
            double rz = Math.abs(this.z2 - this.z1);
            double dx1 = Math.abs(vx - this.x1) / rx;
            double dx2 = Math.abs(vx - this.x2) / rx;
            double dy1 = Math.abs(vy - this.y1) / ry;
            double dy2 = Math.abs(vy - this.y2) / ry;
            double dz1 = Math.abs(vz - this.z1) / rz;
            double dz2 = Math.abs(vz - this.z2) / rz;
            boolean xm = dx1 == 0.0 || dx2 == 0.0;
            boolean ym = dy1 == 0.0 || dy2 == 0.0;
            boolean bl2 = zm = dz1 == 0.0 || dz2 == 0.0;
            if (!xm && !ym || !xm && !zm || !ym && !zm) {
                boolean snapz;
                boolean axisx = dx1 < dx2;
                boolean axisy = dy1 < dy2;
                boolean axisz = dz1 < dz2;
                double distx = axisx ? dx1 : dx2;
                double disty = axisy ? dy1 : dy2;
                double distz = axisz ? dz1 : dz2;
                boolean snapx = distx <= distz || distx <= disty;
                boolean snapy = disty <= distx || disty <= distz;
                boolean bl3 = snapz = !snapx || !snapy;
                if (snapx) {
                    double d = vx = axisx ? this.x1 : this.x2;
                }
                if (snapy) {
                    double d = vy = axisy ? this.y1 : this.y2;
                }
                if (snapz) {
                    vz = axisz ? this.z1 : this.z2;
                }
                changed = true;
            }
            if (changed) {
                this.setData(i, vx, vy, vz);
                return false;
            }
            x[i] = vx;
            y[i] = vy;
            z[i] = vz;
            ++i;
        }
        double NaN = Double.NaN;
        double[][] p = new double[][]{{NaN, this.x1, this.x1, this.x1, this.x1, NaN, this.x2, NaN, this.x2, NaN, this.x2, this.x2}, {this.y1, NaN, this.y1, NaN, this.y2, this.y2, this.y2, this.y2, NaN, this.y1, this.y1, NaN}, {this.z1, this.z1, NaN, this.z2, NaN, this.z1, NaN, this.z2, this.z2, this.z2, NaN, this.z1}};
        boolean[] valid = new boolean[12];
        int i2 = 0;
        while (i2 < 12) {
            double t;
            double s;
            double px0 = p[0][i2] - x[0];
            double py0 = p[1][i2] - y[0];
            double pz0 = p[2][i2] - z[0];
            double x10 = x[1] - x[0];
            double y10 = y[1] - y[0];
            double z10 = z[1] - z[0];
            double x20 = x[2] - x[0];
            double y20 = y[2] - y[0];
            double z20 = z[2] - z[0];
            if (px0 != px0) {
                s = (y20 * pz0 - z20 * py0) / (y20 * z10 - z20 * y10);
                t = y20 == 0.0 ? (pz0 - s * z10) / z20 : (py0 - s * y10) / y20;
                p[0][i2] = x[0] + s * x10 + t * x20;
                valid[i2] = p[0][i2] >= this.x1 && p[0][i2] <= this.x2;
            } else if (py0 != py0) {
                s = (z20 * px0 - x20 * pz0) / (z20 * x10 - x20 * z10);
                t = z20 == 0.0 ? (px0 - s * x10) / x20 : (pz0 - s * z10) / z20;
                p[1][i2] = y[0] + s * y10 + t * y20;
                valid[i2] = p[1][i2] >= this.y1 && p[1][i2] <= this.y2;
            } else {
                s = (x20 * py0 - y20 * px0) / (x20 * y10 - y20 * x10);
                t = x20 == 0.0 ? (py0 - s * y10) / y20 : (px0 - s * x10) / x20;
                p[2][i2] = z[0] + s * z10 + t * z20;
                boolean bl = valid[i2] = p[2][i2] >= this.z1 && p[2][i2] <= this.z2;
            }
            if (valid[i2]) {
                int j = 0;
                while (j < i2) {
                    if (valid[j] && Math.abs(p[0][i2] - p[0][j]) < 1.0E-10 && Math.abs(p[1][i2] - p[1][j]) < 1.0E-10 && Math.abs(p[2][i2] - p[2][j]) < 1.0E-10) {
                        valid[i2] = false;
                        break;
                    }
                    ++j;
                }
            }
            if (valid[i2]) {
                ++vcount;
            }
            ++i2;
        }
        if (vcount > 0) {
            float[] ux = new float[vcount];
            float[] uy = new float[vcount];
            float[] uz = new float[vcount];
            int i3 = 0;
            int c = 0;
            while (i3 < 12) {
                if (valid[i3]) {
                    ux[c] = (float)p[0][i3];
                    uy[c] = (float)p[1][i3];
                    uz[c] = (float)p[2][i3];
                    ++c;
                }
                ++i3;
            }
            boolean[] hull = new boolean[vcount];
            samples = new float[3][vcount + 1];
            samples[0][0] = ux[0];
            samples[1][0] = uy[0];
            samples[2][0] = uz[0];
            hull[0] = true;
            int i4 = 1;
            while (i4 < vcount) {
                double sx = samples[0][i4 - 1];
                double sy = samples[1][i4 - 1];
                double sz = samples[2][i4 - 1];
                boolean xok = sx == this.x1 || sx == this.x2;
                boolean yok = sy == this.y1 || sy == this.y2;
                boolean zok = sz == this.z1 || sz == this.z2;
                int j = 1;
                while (j < vcount) {
                    if (!hull[j] && (xok && sx == (double)ux[j] || yok && sy == (double)uy[j] || zok && sz == (double)uz[j])) {
                        samples[0][i4] = ux[j];
                        samples[1][i4] = uy[j];
                        samples[2][i4] = uz[j];
                        hull[j] = true;
                        break;
                    }
                    ++j;
                }
                ++i4;
            }
            samples[0][vcount] = samples[0][0];
            samples[1][vcount] = samples[1][0];
            samples[2][vcount] = samples[2][0];
            this.lines = new Gridded3DSet((MathType)type, samples, vcount + 1, null, null, null, false);
        }
        if (vcount == 3) {
            float[][] samps = new float[3][4];
            int i5 = 0;
            while (i5 < 3) {
                samps[i5][0] = samples[i5][0];
                samps[i5][1] = (samples[i5][0] + samples[i5][1]) / 2.0f;
                samps[i5][2] = samples[i5][2];
                samps[i5][3] = samples[i5][1];
                ++i5;
            }
            this.plane = new Gridded3DSet((MathType)type, samps, 2, 2, null, null, null, false);
        } else if (vcount == 4) {
            float[][] samps = new float[3][4];
            int i6 = 0;
            while (i6 < 3) {
                samps[i6][0] = samples[i6][0];
                samps[i6][1] = samples[i6][1];
                samps[i6][2] = samples[i6][3];
                samps[i6][3] = samples[i6][2];
                ++i6;
            }
            this.plane = new Gridded3DSet((MathType)type, samps, 2, 2, null, null, null, false);
        } else if (vcount == 5) {
            float[][] samps = new float[3][6];
            int i7 = 0;
            while (i7 < 3) {
                samps[i7][0] = samples[i7][0];
                samps[i7][1] = samples[i7][1];
                samps[i7][2] = samples[i7][4];
                samps[i7][3] = (samples[i7][1] + samples[i7][2]) / 2.0f;
                samps[i7][4] = samples[i7][3];
                samps[i7][5] = samples[i7][2];
                ++i7;
            }
            this.plane = new Gridded3DSet((MathType)type, samps, 2, 3, null, null, null, false);
        } else if (vcount == 6) {
            float[][] samps = new float[3][6];
            int i8 = 0;
            while (i8 < 3) {
                samps[i8][0] = samples[i8][0];
                samps[i8][1] = samples[i8][1];
                samps[i8][2] = samples[i8][5];
                samps[i8][3] = samples[i8][2];
                samps[i8][4] = samples[i8][4];
                samps[i8][5] = samples[i8][3];
                ++i8;
            }
            this.plane = new Gridded3DSet((MathType)type, samps, 2, 3, null, null, null, false);
        }
        return true;
    }
}

