/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.VisADException;
import visad.VisADRay;
import visad.bio.BioUtil;
import visad.bio.PlaneSelector;

public class AlignmentPlane
extends PlaneSelector
implements DisplayListener {
    protected boolean[][] locked = new boolean[this.maxIndex][3];
    protected double[][][] pos = new double[this.maxIndex][3][3];
    protected int numIndices;
    protected int index;
    protected int maxIndex = 10;
    private int mx;
    private int my;
    private boolean m_ctrl;

    public AlignmentPlane(DisplayImpl display) {
        super(display);
        display.addDisplayListener(this);
    }

    public void setIndex(int index) {
        if (this.index == index) {
            return;
        }
        this.index = index;
        if (index >= this.maxIndex) {
            int ndx = index + 1;
            boolean[][] nlock = new boolean[ndx][3];
            double[][][] npos = new double[ndx][3][3];
            System.arraycopy(this.locked, 0, nlock, 0, this.maxIndex);
            System.arraycopy(this.pos, 0, npos, 0, this.maxIndex);
            this.maxIndex = ndx;
        }
        int i = 0;
        while (i < 3) {
            this.setData(i, this.pos[index][i][0], this.pos[index][i][1], this.pos[index][i][2]);
            ++i;
        }
    }

    public void displayChanged(DisplayEvent e) {
        boolean ctrl;
        int id = e.getId();
        InputEvent event = e.getInputEvent();
        if (event == null || !(event instanceof MouseEvent)) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int mods = e.getModifiers();
        boolean left = (mods & 0x10) != 0;
        boolean bl = ctrl = (mods & 2) != 0;
        if (!left) {
            return;
        }
        if (id == 1) {
            this.mx = x;
            this.my = y;
            this.m_ctrl = ctrl;
        } else if (id == 7 && x == this.mx && y == this.my) {
            DisplayImpl d = (DisplayImpl)e.getDisplay();
            MouseBehavior mb = d.getDisplayRenderer().getMouseBehavior();
            VisADRay ray = mb.findRay(x, y);
            double[] a = ray.position;
            int len = a.length;
            double[] b = new double[len];
            int i = 0;
            while (i < len) {
                b[i] = a[i] + ray.vector[i];
                ++i;
            }
            double ndx = -1.0;
            double mindist = Double.POSITIVE_INFINITY;
            int j = 0;
            while (j < 3) {
                double[] v = this.pos[this.index][j];
                double dist = BioUtil.getDistance(a, b, v, false);
                if (dist < mindist) {
                    ndx = j;
                    mindist = dist;
                }
                ++j;
            }
            double[] e1 = BioUtil.pixelToDomain(this.display, 0, 0);
            double[] e2 = BioUtil.pixelToDomain(this.display, 10, 0);
            double threshold = e2[0] - e1[0];
            if (mindist <= threshold) {
                // empty if block
            }
        }
    }

    protected boolean refresh() {
        if (!super.refresh()) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            RealTuple tuple = (RealTuple)this.refs[i + 2].getData();
            try {
                Real[] r = tuple.getRealComponents();
                int j = 0;
                while (j < 3) {
                    this.pos[this.index][i][j] = r[j].getValue();
                    ++j;
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
            ++i;
        }
        return true;
    }

    protected void setData(int i, double x, double y, double z) {
        super.setData(i, x, y, z);
        this.pos[this.index][i][0] = x;
        this.pos[this.index][i][1] = y;
        this.pos[this.index][i][2] = z;
    }
}

