/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Enumeration;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADPointArray;
import visad.VisADSceneGraphObject;

public abstract class VisADGeometryArray
extends VisADSceneGraphObject
implements Cloneable {
    public int vertexCount = 0;
    public int vertexFormat = 0;
    public float[] coordinates = null;
    public float[] normals = null;
    public byte[] colors = null;
    public float[] texCoords = null;
    boolean any_longitude_rotate = false;
    int longitude_axis = -1;
    ScalarMap longitude_map = null;

    public VisADGeometryArray adjustSeam(DataRenderer renderer) throws VisADException {
        CoordinateSystem coord_sys = renderer.getDisplayCoordinateSystem();
        if (coord_sys == null || coord_sys instanceof SphericalCoordinateSystem) {
            return this;
        }
        return this;
    }

    public VisADGeometryArray adjustLongitudeBulk(DataRenderer renderer) throws VisADException {
        float[] lons = this.getLongitudes(renderer, true);
        return this;
    }

    public VisADGeometryArray adjustLongitude(DataRenderer renderer) throws VisADException {
        float[] lons = this.getLongitudes(renderer);
        if (this.any_longitude_rotate) {
            VisADPointArray array = new VisADPointArray();
            array.vertexCount = this.vertexCount;
            array.coordinates = this.coordinates;
            array.colors = this.colors;
            return array;
        }
        return this;
    }

    static float rotateOneLongitude(float lon, float base) {
        if (lon == lon) {
            float x;
            return x + ((x = (lon - base) % 360.0f) < 0.0f ? 360.0f + base : base);
        }
        return lon;
    }

    void rotateLongitudes(float[] lons, float base, int axis, ScalarMap map) {
        this.rotateLongitudes(lons, base, axis, map, false);
    }

    void rotateLongitudes(float[] lons, float base, int axis, ScalarMap map, boolean bulk) {
        boolean any = false;
        if (bulk) {
            float x;
            float mean_lon = 0.0f;
            int n = 0;
            int i = 0;
            while (i < this.vertexCount) {
                if (lons[i] == lons[i]) {
                    mean_lon += lons[i];
                    ++n;
                }
                ++i;
            }
            if ((x += (x = ((mean_lon /= (float)n) - base) % 360.0f) < 0.0f ? 360.0f + base : base) != mean_lon) {
                x -= mean_lon;
                any = true;
            }
            if (any) {
                int i2 = 0;
                while (i2 < this.vertexCount) {
                    if (lons[i2] == lons[i2]) {
                        int n2 = i2;
                        lons[n2] = lons[n2] + x;
                    }
                    ++i2;
                }
            }
        } else {
            int i = 0;
            while (i < this.vertexCount) {
                float x;
                if (lons[i] == lons[i] && (x += (x = (lons[i] - base) % 360.0f) < 0.0f ? 360.0f + base : base) != lons[i]) {
                    lons[i] = x;
                    any = true;
                }
                ++i;
            }
        }
        if (any) {
            float[] coords = map.scaleValues(lons);
            int i = 0;
            while (i < this.vertexCount) {
                this.coordinates[3 * i + axis] = coords[i];
                ++i;
            }
            this.any_longitude_rotate = true;
        }
    }

    float[] getLongitudes(DataRenderer renderer) throws VisADException {
        return this.getLongitudes(renderer, false);
    }

    float[] getLongitudes(DataRenderer renderer, boolean bulk) throws VisADException {
        this.any_longitude_rotate = false;
        this.longitude_map = null;
        this.longitude_axis = -1;
        Vector mapVector = renderer.getDisplay().getMapVector();
        Enumeration maps = mapVector.elements();
        while (maps.hasMoreElements()) {
            float map_delta;
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType dreal = map.getDisplayScalar();
            DisplayTupleType tuple = dreal.getTuple();
            if (!RealType.Longitude.equals(map.getScalar())) continue;
            if (Display.Longitude.equals(dreal)) {
                return null;
            }
            if (!Display.DisplaySpatialCartesianTuple.equals(tuple)) continue;
            double[] map_range = map.getRange();
            float map_min = (float)map_range[0];
            float map_max = (float)map_range[1];
            int axis = dreal.getTupleIndex();
            this.longitude_map = map;
            this.longitude_axis = axis;
            float[] lons = new float[this.vertexCount];
            int i = 0;
            while (i < this.vertexCount) {
                lons[i] = this.coordinates[3 * i + axis];
                ++i;
            }
            lons = map.inverseScaleValues(lons);
            float lon_min = Float.MAX_VALUE;
            float lon_max = -3.4028235E38f;
            int i2 = 0;
            while (i2 < this.vertexCount) {
                if (lons[i2] == lons[i2]) {
                    if (lons[i2] < lon_min) {
                        lon_min = lons[i2];
                    }
                    if (lons[i2] > lon_max) {
                        lon_max = lons[i2];
                    }
                }
                ++i2;
            }
            if (lon_min == Float.MAX_VALUE) {
                return lons;
            }
            boolean any_rotate = false;
            if (map_min == map_min && map_max == map_max && (map_min + (map_delta = 0.1f * (map_max - map_min)) < lon_min && map_max + map_delta < lon_max || lon_min < map_min - map_delta && lon_max < map_max - map_delta)) {
                float new_dist_max;
                float dist_max;
                float new_dist_min;
                float dist_min;
                float new_lon_min = VisADGeometryArray.rotateOneLongitude(lon_min, map_min);
                float new_lon_max = VisADGeometryArray.rotateOneLongitude(lon_max, map_min);
                float f = lon_min < map_min ? map_min - lon_min : (dist_min = map_max < lon_min ? lon_min - map_max : 0.0f);
                float f2 = new_lon_min < map_min ? map_min - new_lon_min : (new_dist_min = map_max < new_lon_min ? new_lon_min - map_max : 0.0f);
                float f3 = lon_max < map_min ? map_min - lon_max : (dist_max = map_max < lon_max ? lon_max - map_max : 0.0f);
                float f4 = new_lon_max < map_min ? map_min - new_lon_max : (new_dist_max = map_max < new_lon_max ? new_lon_max - map_max : 0.0f);
                if (new_dist_min + new_dist_max < dist_min + dist_max) {
                    any_rotate = true;
                    this.rotateLongitudes(lons, map_min, axis, map, bulk);
                }
            }
            if (!any_rotate && lon_min + 360.0f < lon_max) {
                this.rotateLongitudes(lons, lon_min, axis, map, bulk);
            }
            return lons;
        }
        int[] indices = renderer.getLatLonIndices();
        if (indices[0] < 0 || indices[1] < 0) {
            return null;
        }
        float[][] locs = new float[3][this.vertexCount];
        int k = 0;
        int i = 0;
        while (i < this.vertexCount) {
            locs[0][i] = this.coordinates[k++];
            locs[1][i] = this.coordinates[k++];
            locs[2][i] = this.coordinates[k++];
            ++i;
        }
        float[][] latlons = renderer.earthToSpatial(locs, null);
        return latlons[1];
    }

    float[] getLongitudeRange(float[] lons, int[] axis, float[] coords) {
        float[] lon_range = new float[]{Float.NaN, Float.NaN};
        axis[0] = -1;
        coords[0] = Float.NaN;
        coords[1] = Float.NaN;
        float lon_min = Float.MAX_VALUE;
        float lon_max = -3.4028235E38f;
        int i = 0;
        while (i < this.vertexCount) {
            if (lons[i] == lons[i]) {
                if (lons[i] < lon_min) {
                    lon_min = lons[i];
                }
                if (lons[i] > lon_max) {
                    lon_max = lons[i];
                }
            }
            ++i;
        }
        if (lon_max - lon_min < 1.0f) {
            lon_max += 0.5f;
            lon_min -= 0.5f;
        }
        if (lon_min <= lon_max) {
            float y;
            float x;
            float delta = (lon_max - lon_min) / 10.0f;
            if (delta > 1.0f) {
                delta = 1.0f;
            }
            if ((x = (lon_min + delta) % 180.0f) < 0.0f) {
                x += 180.0f;
            }
            if (lon_max - delta < (y = lon_min + delta - x) + 360.0f) {
                lon_range[0] = y;
                lon_range[1] = y + 360.0f;
            } else {
                lon_range[0] = lon_min;
                lon_range[1] = lon_min + 360.0f;
            }
            axis[0] = this.longitude_axis;
            if (this.longitude_map != null) {
                float[] xcoords = this.longitude_map.scaleValues(lon_range);
                coords[0] = xcoords[0];
                coords[1] = xcoords[1];
            } else {
                coords[0] = Float.NaN;
                coords[1] = Float.NaN;
            }
        }
        return lon_range;
    }

    public VisADGeometryArray removeMissing() {
        VisADPointArray array = new VisADPointArray();
        float[] coords = new float[this.coordinates.length];
        int color_length = 3;
        byte[] cols = null;
        if (this.colors != null) {
            cols = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int k = 0;
        int m = 0;
        int j = 0;
        boolean any_missing = false;
        int i = 0;
        while (i < this.coordinates.length) {
            if (this.coordinates[i] == this.coordinates[i] && this.coordinates[i + 1] == this.coordinates[i + 1] && this.coordinates[i + 2] == this.coordinates[i + 2]) {
                coords[k] = this.coordinates[i];
                coords[k + 1] = this.coordinates[i + 1];
                coords[k + 2] = this.coordinates[i + 2];
                if (this.colors != null) {
                    cols[m] = this.colors[j];
                    cols[m + 1] = this.colors[j + 1];
                    cols[m + 2] = this.colors[j + 2];
                    m += 3;
                    if (color_length == 4) {
                        cols[m++] = this.colors[j + 3];
                    }
                }
                k += 3;
            } else {
                any_missing = true;
            }
            j += color_length;
            i += 3;
        }
        if (!any_missing) {
            return this;
        }
        array.coordinates = new float[k];
        System.arraycopy(coords, 0, array.coordinates, 0, k);
        if (this.colors != null) {
            array.colors = new byte[m];
            System.arraycopy(cols, 0, array.colors, 0, m);
        }
        return array;
    }

    static void merge(VisADGeometryArray[] arrays, VisADGeometryArray array) throws VisADException {
        if (arrays == null || arrays.length == 0 || array == null) {
            return;
        }
        int n = arrays.length;
        int count = 0;
        boolean color_flag = false;
        boolean normal_flag = false;
        boolean texCoord_flag = false;
        boolean any = false;
        int vf = 0;
        int i = 0;
        while (i < n) {
            if (arrays[i] != null) {
                color_flag = arrays[i].colors != null;
                normal_flag = arrays[i].normals != null;
                texCoord_flag = arrays[i].texCoords != null;
                vf = arrays[i].vertexFormat;
                any = true;
            }
            ++i;
        }
        if (!any) {
            return;
        }
        int i2 = 0;
        while (i2 < n) {
            if (arrays[i2] != null) {
                count += arrays[i2].vertexCount;
                if (color_flag != (arrays[i2].colors != null) || normal_flag != (arrays[i2].normals != null) || texCoord_flag != (arrays[i2].texCoords != null)) {
                    throw new DisplayException("VisADGeometryArray.merge: formats don't match");
                }
            }
            ++i2;
        }
        float[] coordinates = new float[3 * count];
        byte[] colors = null;
        float[] normals = null;
        float[] texCoords = null;
        if (color_flag) {
            colors = new byte[3 * count];
        }
        if (normal_flag) {
            normals = new float[3 * count];
        }
        if (texCoord_flag) {
            texCoords = new float[3 * count];
        }
        int k = 0;
        int kc = 0;
        int kn = 0;
        int kt = 0;
        int i3 = 0;
        while (i3 < n) {
            if (arrays[i3] != null) {
                float[] c = arrays[i3].coordinates;
                int j = 0;
                while (j < 3 * arrays[i3].vertexCount) {
                    coordinates[k++] = c[j];
                    ++j;
                }
                if (color_flag) {
                    byte[] b = arrays[i3].colors;
                    int j2 = 0;
                    while (j2 < 3 * arrays[i3].vertexCount) {
                        colors[kc++] = b[j2];
                        ++j2;
                    }
                }
                if (normal_flag) {
                    c = arrays[i3].normals;
                    int j3 = 0;
                    while (j3 < 3 * arrays[i3].vertexCount) {
                        normals[kn++] = c[j3];
                        ++j3;
                    }
                }
                if (texCoord_flag) {
                    c = arrays[i3].texCoords;
                    int j4 = 0;
                    while (j4 < 3 * arrays[i3].vertexCount) {
                        texCoords[kt++] = c[j4];
                        ++j4;
                    }
                }
            }
            ++i3;
        }
        array.vertexCount = count;
        array.coordinates = coordinates;
        array.colors = colors;
        array.normals = normals;
        array.texCoords = texCoords;
        array.vertexFormat = vf;
    }

    public String toString() {
        String string = "GeometryArray, vertexCount = " + this.vertexCount + " vertexFormat = " + this.vertexFormat;
        if (this.coordinates != null) {
            string = string + "\n coordinates = " + VisADGeometryArray.floatArrayString(this.coordinates);
        }
        if (this.colors != null) {
            string = string + "\n colors = " + VisADGeometryArray.byteArrayString(this.colors);
        }
        if (this.normals != null) {
            string = string + "\n normals = " + VisADGeometryArray.floatArrayString(this.normals);
        }
        if (this.texCoords != null) {
            string = string + "\n texCoords = " + VisADGeometryArray.floatArrayString(this.texCoords);
        }
        return string;
    }

    static String floatArrayString(float[] value) {
        String string = "";
        int i = 0;
        while (i < value.length) {
            string = string + " " + value[i];
            ++i;
        }
        return string;
    }

    static String byteArrayString(byte[] value) {
        String string = "";
        int i = 0;
        while (i < value.length) {
            string = string + " " + value[i];
            ++i;
        }
        return string;
    }

    public void copy(VisADGeometryArray array) {
        array.vertexCount = this.vertexCount;
        array.vertexFormat = this.vertexFormat;
        if (this.coordinates != null) {
            array.coordinates = new float[this.coordinates.length];
            System.arraycopy(this.coordinates, 0, array.coordinates, 0, this.coordinates.length);
        }
        if (this.normals != null) {
            array.normals = new float[this.normals.length];
            System.arraycopy(this.normals, 0, array.normals, 0, this.normals.length);
        }
        if (this.colors != null) {
            array.colors = new byte[this.colors.length];
            System.arraycopy(this.colors, 0, array.colors, 0, this.colors.length);
        }
        if (this.texCoords != null) {
            array.texCoords = new float[this.texCoords.length];
            System.arraycopy(this.texCoords, 0, array.texCoords, 0, this.texCoords.length);
        }
    }

    public abstract Object clone();
}

