/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Irregular1DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADTriangleStripArray;

public class UnionSet
extends SampledSet {
    SampledSet[] Sets;

    public UnionSet(MathType type, SampledSet[] sets) throws VisADException {
        this(type, sets, null, null, null, true);
    }

    private UnionSet(MathType type, SampledSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, sets, coord_sys, units, errors, true);
    }

    private UnionSet(MathType type, SampledSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, UnionSet.find_manifold_dim(sets), sets[0].getCoordinateSystem(), sets[0].getSetUnits(), null);
        int i;
        this.DomainDimension = sets[0].DomainDimension;
        if (copy) {
            this.Sets = new SampledSet[sets.length];
            i = 0;
            while (i < sets.length) {
                this.Sets[i] = (SampledSet)sets[i].clone();
                ++i;
            }
        } else {
            this.Sets = sets;
        }
        this.Length = 0;
        i = 0;
        while (i < sets.length) {
            this.Length += this.Sets[i].Length;
            ++i;
        }
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
        int i2 = 0;
        while (i2 < this.DomainDimension) {
            this.Low[i2] = this.Sets[0].Low[i2];
            this.Hi[i2] = this.Sets[0].Hi[i2];
            int j = 1;
            while (j < sets.length) {
                if (sets[j].Low[i2] < this.Low[i2]) {
                    this.Low[i2] = sets[j].Low[i2];
                }
                if (sets[j].Hi[i2] > this.Hi[i2]) {
                    this.Hi[i2] = sets[j].Hi[i2];
                }
                ++j;
            }
            ++i2;
        }
    }

    private static int find_manifold_dim(SampledSet[] sets) throws VisADException {
        if (sets == null || sets.length == 0 || sets[0] == null) {
            throw new SetException("UnionSet: Sets cannot be missing");
        }
        if (sets.length < 2) {
            return sets[0].ManifoldDimension;
        }
        int dim = sets[0].DomainDimension;
        int mdim = sets[0].ManifoldDimension;
        CoordinateSystem cs0 = sets[0].getCoordinateSystem();
        Unit[] units0 = sets[0].getSetUnits();
        int i = 1;
        while (i < sets.length) {
            if (sets[i] == null) {
                throw new SetException("UnionSet: Sets cannot be missing");
            }
            if (sets[i].DomainDimension != dim) {
                throw new SetException("UnionSet: set #" + i + " Domain dimension is " + sets[i].DomainDimension + ", not " + dim);
            }
            if (sets[i].ManifoldDimension != mdim) {
                throw new SetException("UnionSet: set #" + i + " Manifold dimension is " + sets[i].ManifoldDimension + ", not " + mdim);
            }
            CoordinateSystem cs = sets[i].getCoordinateSystem();
            if (!(cs0 == null && cs == null || cs0 != null && cs != null && cs0.equals(cs))) {
                throw new CoordinateSystemException("UnionSet: Coordinate system #" + i + " (" + (cs == null ? null : cs.getReference()) + " must match #0 " + (cs0 == null ? null : cs0.getReference()));
            }
            Unit[] units = sets[i].getSetUnits();
            if (units0 != null || units != null) {
                if (units0 == null || units == null || units0.length != units.length) {
                    throw new SetException("UnionSet: Expected " + (units0 == null ? "null" : Integer.toString(units0.length)) + " units for set " + i + ", not " + (units == null ? "null" : Integer.toString(units.length)));
                }
                int j = 0;
                while (j < units0.length) {
                    if (!(units0[j] == null && units[j] == null || units0[j] != null && units[j] != null && units0[j].equals(units[j]))) {
                        throw new SetException("UnionSet: Expected set " + i + ", element " + j + " units to be " + units0[j] + " not " + units[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return mdim;
    }

    public SampledSet[] getSets() {
        return (SampledSet[])this.Sets.clone();
    }

    public UnionSet(SampledSet[] sets) throws VisADException {
        this(sets[0].getType(), sets, null, null, null, true);
    }

    public SampledSet product() throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        int count = 0;
        int i = 0;
        while (i < n) {
            if (this.Sets[i] instanceof GriddedSet || this.Sets[i] instanceof IrregularSet) {
                sets[i] = this.Sets[i];
            } else if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).product();
            } else if (this.Sets[i] instanceof UnionSet) {
                sets[i] = ((UnionSet)this.Sets[i]).product();
            } else {
                throw new UnimplementedException("UnionSet.product: " + this.Sets[i].getClass());
            }
            count = sets[i] instanceof UnionSet ? (count += ((UnionSet)sets[i]).Sets.length) : ++count;
            ++i;
        }
        SampledSet[] summands = new SampledSet[count];
        int k = 0;
        int i2 = 0;
        while (i2 < n) {
            if (sets[i2] instanceof UnionSet) {
                int j = 0;
                while (j < ((UnionSet)sets[i2]).Sets.length) {
                    summands[k++] = ((UnionSet)sets[i2]).Sets[j];
                    ++j;
                }
            } else {
                summands[k++] = sets[i2];
            }
            ++i2;
        }
        return new UnionSet(this.getType(), summands);
    }

    public SampledSet product(SampledSet set) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        boolean union_of_union = false;
        int i = 0;
        while (i < n) {
            if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).product(set);
            } else if (set instanceof ProductSet) {
                sets[i] = ((ProductSet)set).inverseProduct(this.Sets[i]);
            } else if (set instanceof UnionSet) {
                sets[i] = ((UnionSet)set).inverseProduct(this.Sets[i]);
                union_of_union = true;
            } else {
                sets[i] = new ProductSet(new SampledSet[]{this.Sets[i], set});
            }
            ++i;
        }
        SampledSet union = new UnionSet(sets);
        if (union_of_union) {
            union = union.product();
        }
        return union;
    }

    public SampledSet inverseProduct(SampledSet set) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        boolean union_of_union = false;
        int i = 0;
        while (i < n) {
            if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).inverseProduct(set);
            } else if (set instanceof ProductSet) {
                sets[i] = ((ProductSet)set).product(this.Sets[i]);
            } else if (set instanceof UnionSet) {
                sets[i] = ((UnionSet)set).product(this.Sets[i]);
                union_of_union = true;
            } else {
                sets[i] = new ProductSet(new SampledSet[]{set, this.Sets[i]});
            }
            ++i;
        }
        SampledSet union = new UnionSet(sets);
        if (union_of_union) {
            union = union.product();
        }
        return union;
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        int n = this.Sets.length;
        int dim = samples.length;
        SampledSet[] sets = new SampledSet[n];
        int base = 0;
        int i = 0;
        while (i < n) {
            int len = this.Sets[i].Length;
            float[][] s = new float[dim][len];
            int j = 0;
            while (j < dim) {
                int k = 0;
                while (k < len) {
                    s[j][k] = samples[j][base + k];
                    ++k;
                }
                ++j;
            }
            sets[i] = (SampledSet)this.Sets[i].makeSpatial(type, s);
            base += len;
            ++i;
        }
        UnionSet set = new UnionSet((MathType)((SetType)sets[0].getType()), sets);
        return set;
    }

    public void cram_missing(boolean[] range_select) {
        int rl = range_select.length;
        int n = this.Sets.length;
        int k = 0;
        int i = 0;
        while (i < n) {
            int len = 0;
            try {
                len = this.Sets[i].getLength();
            }
            catch (VisADException e) {
                return;
            }
            if (k + len > rl) {
                return;
            }
            boolean[] ri = new boolean[len];
            System.arraycopy(range_select, k, ri, 0, len);
            this.Sets[i].cram_missing(ri);
            k += len;
            ++i;
        }
    }

    public VisADGeometryArray make2DGeometry(byte[][] color_values, boolean indexed) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("UnionSet.make2DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("UnionSet.make2DGeometry: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = this.DomainDimension;
        if (color_values != null && dim != color_values.length) {
            throw new SetException("UnionSet.make2DGeometry: color_values dimension should be " + dim + ", not " + color_values.length);
        }
        if (indexed) {
            VisADIndexedTriangleStripArray[] arrays = new VisADIndexedTriangleStripArray[n];
            int base = 0;
            int i = 0;
            while (i < n) {
                VisADGeometryArray array;
                int len = this.Sets[i].Length;
                byte[][] c = null;
                if (color_values != null) {
                    c = new byte[dim][len];
                    int j = 0;
                    while (j < dim) {
                        int k = 0;
                        while (k < len) {
                            c[j][k] = color_values[j][base + k];
                            ++k;
                        }
                        ++j;
                    }
                }
                arrays[i] = (array = this.Sets[i].make2DGeometry(c, indexed)) instanceof VisADIndexedTriangleStripArray ? (VisADIndexedTriangleStripArray)array : null;
                base += len;
                ++i;
            }
            return VisADIndexedTriangleStripArray.merge(arrays);
        }
        VisADTriangleStripArray[] arrays = new VisADTriangleStripArray[n];
        int base = 0;
        int i = 0;
        while (i < n) {
            VisADGeometryArray array;
            int len = this.Sets[i].Length;
            byte[][] c = null;
            if (color_values != null) {
                c = new byte[dim][len];
                int j = 0;
                while (j < dim) {
                    int k = 0;
                    while (k < len) {
                        c[j][k] = color_values[j][base + k];
                        ++k;
                    }
                    ++j;
                }
            }
            arrays[i] = (array = this.Sets[i].make2DGeometry(c, indexed)) instanceof VisADTriangleStripArray ? (VisADTriangleStripArray)array : null;
            base += len;
            ++i;
        }
        return VisADTriangleStripArray.merge(arrays);
    }

    public VisADGeometryArray make1DGeometry(byte[][] color_values) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("UnionSet.make1DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 1) {
            throw new SetException("UnionSet.make1DGeometry: ManifoldDimension must be 1, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = this.DomainDimension;
        if (color_values != null && dim != color_values.length) {
            throw new SetException("UnionSet.make1DGeometry: color_values dimension should be " + dim + ", not " + color_values.length);
        }
        VisADLineStripArray[] arrays = new VisADLineStripArray[n];
        int base = 0;
        int i = 0;
        while (i < n) {
            VisADGeometryArray array;
            int len = this.Sets[i].Length;
            byte[][] c = null;
            if (color_values != null) {
                c = new byte[dim][len];
                int j = 0;
                while (j < dim) {
                    int k = 0;
                    while (k < len) {
                        c[j][k] = color_values[j][base + k];
                        ++k;
                    }
                    ++j;
                }
            }
            arrays[i] = (array = this.Sets[i].make1DGeometry(c)) instanceof VisADLineStripArray ? (VisADLineStripArray)array : null;
            base += len;
            ++i;
        }
        VisADLineStripArray array = VisADLineStripArray.merge(arrays);
        return array;
    }

    public VisADGeometryArray[] makeIsoLines(float[] intervals, float low, float hi, float base, float[] fieldValues, byte[][] color_values, boolean[] swap, boolean dash, boolean fill, ScalarMap[] smap) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoLines: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new DisplayException("UnionSet.makeIsoLines: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = color_values.length;
        if (dim != this.DomainDimension) {
            throw new SetException("UnionSet.makeIsoLines: color_values dimension should be " + this.DomainDimension + ", not " + dim);
        }
        VisADLineArray[][] arrays = new VisADLineArray[n][];
        int kbase = 0;
        int i = 0;
        while (i < n) {
            int k;
            int len = this.Sets[i].Length;
            byte[][] c = new byte[dim][len];
            float[] f = new float[len];
            int j = 0;
            while (j < dim) {
                k = 0;
                while (k < len) {
                    c[j][k] = color_values[j][kbase + k];
                    ++k;
                }
                ++j;
            }
            k = 0;
            while (k < len) {
                f[k] = fieldValues[kbase + k];
                ++k;
            }
            arrays[i] = (VisADLineArray[])this.Sets[i].makeIsoLines(intervals, low, hi, base, f, c, swap, dash, fill, smap);
            kbase += len;
            ++i;
        }
        VisADGeometryArray[] arrays2 = new VisADLineArray[3];
        int j = 0;
        while (j < 3) {
            VisADLineArray[] arrays3 = new VisADLineArray[n];
            int i2 = 0;
            while (i2 < n) {
                arrays3[i2] = arrays[i2][j];
                ++i2;
            }
            arrays2[j] = VisADLineArray.merge(arrays3);
            ++j;
        }
        return arrays2;
    }

    public VisADGeometryArray makeIsoSurface(float isolevel, float[] fieldValues, byte[][] color_values, boolean indexed) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = color_values.length;
        if (dim != this.DomainDimension) {
            throw new SetException("UnionSet.makeIsoSurface: color_values dimension should be " + this.DomainDimension + ", not " + dim);
        }
        if (indexed) {
            VisADIndexedTriangleStripArray[] arrays = new VisADIndexedTriangleStripArray[n];
            int base = 0;
            int i = 0;
            while (i < n) {
                int k;
                int len = this.Sets[i].Length;
                byte[][] c = new byte[dim][len];
                float[] f = new float[len];
                int j = 0;
                while (j < dim) {
                    k = 0;
                    while (k < len) {
                        c[j][k] = color_values[j][base + k];
                        ++k;
                    }
                    ++j;
                }
                k = 0;
                while (k < len) {
                    f[k] = fieldValues[base + k];
                    ++k;
                }
                arrays[i] = (VisADIndexedTriangleStripArray)this.Sets[i].makeIsoSurface(isolevel, f, c, indexed);
                base += len;
                ++i;
            }
            return VisADIndexedTriangleStripArray.merge(arrays);
        }
        VisADTriangleStripArray[] arrays = new VisADTriangleStripArray[n];
        int base = 0;
        int i = 0;
        while (i < n) {
            int k;
            int len = this.Sets[i].Length;
            byte[][] c = new byte[dim][len];
            float[] f = new float[len];
            int j = 0;
            while (j < dim) {
                k = 0;
                while (k < len) {
                    c[j][k] = color_values[j][base + k];
                    ++k;
                }
                ++j;
            }
            k = 0;
            while (k < len) {
                f[k] = fieldValues[base + k];
                ++k;
            }
            arrays[i] = (VisADTriangleStripArray)this.Sets[i].makeIsoSurface(isolevel, f, c, indexed);
            base += len;
            ++i;
        }
        return VisADTriangleStripArray.merge(arrays);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            indices[i] = i;
            ++i;
        }
        return this.indexToValue(indices);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int nsets = this.Sets.length;
        int npts = index.length;
        float[][] value = new float[this.DomainDimension][npts];
        if (npts == this.getLength()) {
            boolean ramp = true;
            int i = 0;
            while (i < npts) {
                if (index[i] != i) {
                    ramp = false;
                    break;
                }
                ++i;
            }
            if (ramp) {
                int k = 0;
                int j = 0;
                while (j < nsets) {
                    int sub_length = this.Sets[j].getLength();
                    int[] sub_inds = new int[sub_length];
                    int i2 = 0;
                    while (i2 < sub_length) {
                        sub_inds[i2] = i2;
                        ++i2;
                    }
                    float[][] sub_vals = this.Sets[j].indexToValue(sub_inds);
                    int m = 0;
                    while (m < this.DomainDimension) {
                        System.arraycopy(sub_vals[m], 0, value[m], k, sub_length);
                        ++m;
                    }
                    k += sub_length;
                    ++j;
                }
                return value;
            }
        }
        int[][] subindex = new int[nsets][];
        int[] ind_lens = new int[nsets];
        int[] set_num = new int[npts];
        int[] new_ind = new int[npts];
        int j = 0;
        while (j < npts) {
            int q = 0;
            int curind = index[j];
            while (q < nsets && curind >= this.Sets[q].Length) {
                curind -= this.Sets[q++].Length;
            }
            if (q == nsets) {
                curind += this.Sets[--q].Length;
            }
            int n = q;
            ind_lens[n] = ind_lens[n] + 1;
            set_num[j] = q;
            new_ind[j] = curind;
            ++j;
        }
        int i = 0;
        while (i < nsets) {
            subindex[i] = ind_lens[i] > 0 ? new int[ind_lens[i]] : null;
            ind_lens[i] = 0;
            ++i;
        }
        int j2 = 0;
        while (j2 < npts) {
            int n = set_num[j2];
            int n2 = ind_lens[n];
            ind_lens[n] = n2 + 1;
            subindex[set_num[j2]][n2] = new_ind[j2];
            ++j2;
        }
        float[][][] subvals = new float[nsets][][];
        int i3 = 0;
        while (i3 < nsets) {
            if (subindex[i3] != null) {
                subvals[i3] = this.Sets[i3].indexToValue(subindex[i3]);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < nsets) {
            ind_lens[i4] = 0;
            ++i4;
        }
        int j3 = 0;
        while (j3 < npts) {
            int k = 0;
            while (k < this.DomainDimension) {
                value[k][j3] = subvals[set_num[j3]][k][ind_lens[set_num[j3]]];
                ++k;
            }
            int n = set_num[j3];
            ind_lens[n] = ind_lens[n] + 1;
            ++j3;
        }
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        int nsets = this.Sets.length;
        int npts = value[0].length;
        int[] index = new int[npts];
        int[][] subindex = new int[nsets][];
        int i = 0;
        while (i < nsets) {
            subindex[i] = this.Sets[i].valueToIndex(value);
            ++i;
        }
        float[][][] subvalue = new float[nsets][][];
        int i2 = 0;
        while (i2 < nsets) {
            subvalue[i2] = this.Sets[i2].indexToValue(subindex[i2]);
            ++i2;
        }
        int j = 0;
        while (j < npts) {
            float[] dist_sqr = new float[nsets];
            int best_set = 0;
            int i3 = 0;
            while (i3 < nsets) {
                dist_sqr[i3] = 0.0f;
                int k = 0;
                while (k < this.DomainDimension) {
                    if (subindex[i3][j] == -1) {
                        dist_sqr[i3] = Float.MAX_VALUE;
                        break;
                    }
                    float d = subvalue[i3][k][j] - value[k][j];
                    int n = i3;
                    dist_sqr[n] = dist_sqr[n] + d * d;
                    ++k;
                }
                if (dist_sqr[best_set] > dist_sqr[i3]) {
                    best_set = i3;
                }
                ++i3;
            }
            int ind = subindex[best_set][j];
            while (best_set > 0) {
                ind += this.Sets[--best_set].Length;
            }
            index[j] = ind;
            ++j;
        }
        return index;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int nsets = this.Sets.length;
        int length = indices.length;
        int offset = 0;
        int i = 0;
        while (i < nsets) {
            int[][] temp_indices = new int[length][];
            float[][] temp_weights = new float[length][];
            this.Sets[i].valueToInterp(value, temp_indices, temp_weights);
            int j = 0;
            while (j < length) {
                if (indices[j] == null && temp_indices[j] != null) {
                    int m = temp_indices[j].length;
                    indices[j] = new int[m];
                    weights[j] = new float[m];
                    int k = 0;
                    while (k < m) {
                        indices[j][k] = temp_indices[j][k] + offset;
                        weights[j][k] = temp_weights[j][k];
                        ++k;
                    }
                }
                ++j;
            }
            offset += this.Sets[i].getLength();
            ++i;
        }
    }

    public Object clone() {
        try {
            return new UnionSet(this.Type, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException e) {
            throw new VisADError("UnionSet.clone: " + e.toString());
        }
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new UnionSet(type, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public boolean equals(Object set) {
        if (!(set instanceof UnionSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        UnionSet uset = (UnionSet)set;
        if (uset.DomainDimension != this.DomainDimension || uset.ManifoldDimension != this.ManifoldDimension) {
            return false;
        }
        int i = 0;
        while (i < this.Sets.length) {
            if (!this.Sets[i].equals(uset.Sets[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.DomainDimension ^ this.ManifoldDimension;
            int i = 0;
            while (i < this.Sets.length) {
                this.hashCode ^= this.Sets[i].hashCode();
                ++i;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public boolean isMissing() {
        int i = 0;
        while (i < this.Sets.length) {
            if (this.Sets[i].isMissing()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] argv) throws VisADException {
        RealType vis_xcoord = RealType.getRealType("1D");
        RealType[] vis_array = new RealType[]{vis_xcoord};
        RealTupleType vis_tuple = new RealTupleType(vis_array);
        float[][] sampG = new float[][]{{2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 16.0f}};
        Gridded1DSet gSet = new Gridded1DSet((MathType)vis_tuple, (float[][])sampG, 8);
        float[][] sampI = new float[][]{{100.0f, 90.0f, 110.0f, 80.0f, 120.0f, 70.0f, 130.0f, 60.0f}};
        Irregular1DSet iSet = new Irregular1DSet((MathType)vis_tuple, sampI);
        SampledSet[] sets = new SampledSet[]{gSet, iSet};
        UnionSet uSet = new UnionSet((MathType)vis_tuple, sets);
        System.out.println("UnionSet created.");
        System.out.println("ManifoldDimension = " + uSet.getManifoldDimension());
        System.out.println("-----------------");
        System.out.println("indexToValue test:");
        int[] index1 = new int[]{0, 3, 9, 12, 6, 15};
        float[][] value1 = uSet.indexToValue(index1);
        int i = 0;
        while (i < index1.length) {
            System.out.print("index " + index1[i] + " \t==> (" + value1[0][i]);
            int j = 1;
            while (j < value1.length) {
                System.out.print(", " + value1[j][i]);
                ++j;
            }
            System.out.println(")");
            ++i;
        }
        System.out.println("-----------------");
        System.out.println("valueToIndex test:");
        float[][] value2 = new float[][]{{15.0f, 40.0f, 92.0f, 25.0f, 50.0f, 103.0f, 37.0f, 77.0f}};
        int[] index2 = uSet.valueToIndex(value2);
        int i2 = 0;
        while (i2 < index2.length) {
            System.out.print("(" + value2[0][i2]);
            int j = 1;
            while (j < value2.length) {
                System.out.print(", " + value2[j][i2]);
                ++j;
            }
            System.out.println(")\t==> index " + index2[i2]);
            ++i2;
        }
        System.out.println("-----------------");
        System.out.println("valueToInterp test:");
        int n = value2[0].length;
        int[][] indices = new int[n][];
        float[][] weights = new float[n][];
        uSet.valueToInterp(value2, indices, weights);
        int i3 = 0;
        while (i3 < n) {
            System.out.print("(" + value2[0][i3]);
            int j = 1;
            while (j < value2.length) {
                System.out.print(", " + value2[j][i3]);
                ++j;
            }
            System.out.print(")\t==>");
            if (indices[i3] == null || indices[i3].length == 0) {
                System.out.println(" missing");
            } else {
                int m = indices[i3].length;
                int j2 = 0;
                while (j2 < m) {
                    System.out.print(" (" + indices[i3][j2] + "," + weights[i3][j2] + ")");
                    ++j2;
                }
                System.out.println(" ");
            }
            ++i3;
        }
        System.out.println();
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "UnionSet: Dimension = " + this.DomainDimension + " Length = " + this.getLength() + "\n";
        int n = this.Sets.length;
        int i = 0;
        while (i < n) {
            s = s + this.Sets[i].toString();
            ++i;
        }
        return s;
    }
}

