/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.Control;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.MouseHelper;
import visad.RemoteSlaveDisplay;
import visad.ScalarMap;
import visad.ScalarType;
import visad.VisADException;
import visad.browser.Convert;

public class SocketSlaveDisplay
implements RemoteSlaveDisplay {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_PORT = 4567;
    private static final Class[] supportedControls = new Class[]{class$visad$GraphicsModeControl == null ? (class$visad$GraphicsModeControl = SocketSlaveDisplay.class$("visad.GraphicsModeControl")) : class$visad$GraphicsModeControl, class$visad$ContourControl == null ? (class$visad$ContourControl = SocketSlaveDisplay.class$("visad.ContourControl")) : class$visad$ContourControl};
    private int port;
    private DisplayImpl display;
    private boolean flag;
    private byte[] pix;
    private int h;
    private int w;
    private ServerSocket serverSocket;
    private Vector clientSockets = new Vector();
    private Vector clientInputs = new Vector();
    private Vector clientOutputs = new Vector();
    private Vector clientIds = new Vector();
    private Thread connectThread = null;
    private Thread commThread = null;
    private boolean alive = true;
    private int clientID = 0;
    private final SocketSlaveDisplay socketSlave = this;
    private Runnable connect = new Runnable(){

        public void run() {
            while (SocketSlaveDisplay.this.alive) {
                try {
                    Socket socket = SocketSlaveDisplay.this.serverSocket.accept();
                    if (!SocketSlaveDisplay.this.alive) break;
                    if (socket == null) continue;
                    Vector vector = SocketSlaveDisplay.this.clientSockets;
                    synchronized (vector) {
                        SocketSlaveDisplay.this.clientSockets.add(socket);
                        DataInputStream in = new DataInputStream(socket.getInputStream());
                        SocketSlaveDisplay.this.clientInputs.add(in);
                        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                        SocketSlaveDisplay.this.clientOutputs.add(out);
                        out.writeInt(++SocketSlaveDisplay.this.clientID);
                        SocketSlaveDisplay.this.clientIds.add(new Integer(SocketSlaveDisplay.this.clientID));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    };
    private Runnable comm = new Runnable(){

        public void run() {
            while (SocketSlaveDisplay.this.alive) {
                Object[] cids;
                Object[] outputs;
                Object[] inputs;
                Object[] sockets;
                boolean silence = true;
                Vector vector = SocketSlaveDisplay.this.clientSockets;
                synchronized (vector) {
                    sockets = SocketSlaveDisplay.this.clientSockets.toArray();
                    inputs = SocketSlaveDisplay.this.clientInputs.toArray();
                    outputs = SocketSlaveDisplay.this.clientOutputs.toArray();
                    cids = SocketSlaveDisplay.this.clientIds.toArray();
                }
                int i = 0;
                while (i < sockets.length) {
                    block26: {
                        Socket socket = (Socket)sockets[i];
                        DataInputStream in = (DataInputStream)inputs[i];
                        DataOutputStream out = (DataOutputStream)outputs[i];
                        int cid = (Integer)cids[i];
                        try {
                            Control control;
                            Object mb;
                            int j;
                            if (in.available() <= 0) break block26;
                            silence = false;
                            int sid = in.readInt();
                            int eventType = in.readInt();
                            if (eventType == 0) {
                                SocketSlaveDisplay.this.updateClient(socket, in, out);
                                int j2 = 0;
                                while (j2 < supportedControls.length) {
                                    Class c = supportedControls[j2];
                                    Vector v = SocketSlaveDisplay.this.display.getControls(c);
                                    int k = 0;
                                    while (k < v.size()) {
                                        Control control2 = (Control)v.elementAt(k);
                                        String message = c.getName() + "\n" + k + "\n" + control2.getSaveString();
                                        SocketSlaveDisplay.this.updateClient(message, socket, in, out);
                                        ++k;
                                    }
                                    ++j2;
                                }
                                Vector maps = SocketSlaveDisplay.this.display.getMapVector();
                                j = 0;
                                while (j < maps.size()) {
                                    ScalarMap map = (ScalarMap)maps.elementAt(j);
                                    ScalarType scalar = map.getScalar();
                                    DisplayRealType displayScalar = map.getDisplayScalar();
                                    double[] range = map.getRange();
                                    String message = "visad.ScalarMap\n" + scalar.getName() + " " + displayScalar.getName() + " " + range[0] + " " + range[1];
                                    SocketSlaveDisplay.this.updateClient(message, socket, in, out);
                                    ++j;
                                }
                                break block26;
                            }
                            if (eventType == 1) {
                                int mid = in.readInt();
                                long when = in.readLong();
                                int mods = in.readInt();
                                int x = in.readInt();
                                int y = in.readInt();
                                int clicks = in.readInt();
                                boolean popup = in.readBoolean();
                                Component c = SocketSlaveDisplay.this.display.getComponent();
                                MouseEvent me = new MouseEvent(c, mid, when, mods, x, y, clicks, popup);
                                mb = SocketSlaveDisplay.this.display.getMouseBehavior();
                                MouseHelper mh = mb.getMouseHelper();
                                mh.processEvent(me, cid);
                                break block26;
                            }
                            if (eventType != 2) break block26;
                            int len = in.readInt();
                            char[] c = new char[len];
                            j = 0;
                            while (j < len) {
                                c[j] = in.readChar();
                                ++j;
                            }
                            String message = new String(c);
                            StringTokenizer st = new StringTokenizer(message, "\n");
                            String controlClass = st.nextToken();
                            int index = Convert.getInt(st.nextToken());
                            String save = st.nextToken();
                            Class<?> cls = null;
                            try {
                                cls = Class.forName(controlClass);
                            }
                            catch (ClassNotFoundException exc) {
                                // empty catch block
                            }
                            if (cls == null || (control = SocketSlaveDisplay.this.display.getControl(cls, index)) == null || save.equals(control.getSaveString())) break block26;
                            try {
                                mb = SocketSlaveDisplay.this.socketSlave;
                                synchronized (mb) {
                                    SocketSlaveDisplay.this.display.removeSlave(SocketSlaveDisplay.this.socketSlave);
                                    control.setSaveString(save);
                                    SocketSlaveDisplay.this.display.addSlave(SocketSlaveDisplay.this.socketSlave);
                                }
                                int k = 0;
                                while (k < sockets.length) {
                                    int kid = (Integer)cids[k];
                                    if (kid != cid) {
                                        Socket ksocket = (Socket)sockets[k];
                                        DataInputStream kin = (DataInputStream)inputs[k];
                                        DataOutputStream kout = (DataOutputStream)outputs[k];
                                        SocketSlaveDisplay.this.updateClient(message, ksocket, kin, kout);
                                    }
                                    ++k;
                                }
                            }
                            catch (VisADException exc) {
                            }
                            catch (RemoteException exc) {}
                        }
                        catch (SocketException exc) {
                            SocketSlaveDisplay.this.killSocket(socket, in, out);
                            break;
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                if (!silence) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
        }
    };
    static /* synthetic */ Class class$visad$GraphicsModeControl;
    static /* synthetic */ Class class$visad$ContourControl;

    public SocketSlaveDisplay(DisplayImpl d) throws IOException {
        this(d, 4567);
    }

    public SocketSlaveDisplay(DisplayImpl d, int port) throws IOException {
        this.display = d;
        this.port = port;
        this.serverSocket = new ServerSocket(port);
        this.connectThread = new Thread(this.connect, "SocketSlaveDisplay-Connect-" + this.display.getName());
        this.connectThread.start();
        this.commThread = new Thread(this.comm, "SocketSlaveDisplay-Comm-" + this.display.getName());
        this.commThread.start();
        this.display.addSlave(this);
    }

    public int getPort() {
        return this.port;
    }

    private void updateClient(Socket socket, DataInputStream in, DataOutputStream out) {
        if (this.pix != null) {
            try {
                out.writeInt(this.w);
                out.writeInt(this.h);
                out.writeInt(this.pix.length);
                out.write(this.pix);
            }
            catch (SocketException exc) {
                this.killSocket(socket, in, out);
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
    }

    private void updateClient(String message, Socket socket, DataInputStream in, DataOutputStream out) {
        try {
            out.writeInt(-1);
            out.writeInt(message.length());
            out.writeChars(message);
        }
        catch (SocketException exc) {
            this.killSocket(socket, in, out);
        }
        catch (IOException exc) {
            // empty catch block
        }
    }

    public synchronized void sendImage(int[] pixels, int width, int height, int type) throws RemoteException {
        Object[] outputs;
        Object[] inputs;
        Object[] sockets;
        this.pix = Convert.intToBytes(pixels);
        this.w = width;
        this.h = height;
        Vector vector = this.clientSockets;
        synchronized (vector) {
            sockets = this.clientSockets.toArray();
            inputs = this.clientInputs.toArray();
            outputs = this.clientOutputs.toArray();
        }
        int i = 0;
        while (i < sockets.length) {
            this.updateClient((Socket)sockets[i], (DataInputStream)inputs[i], (DataOutputStream)outputs[i]);
            ++i;
        }
    }

    public synchronized void sendMessage(String message) throws RemoteException {
        Object[] outputs;
        Object[] inputs;
        Object[] sockets;
        Vector vector = this.clientSockets;
        synchronized (vector) {
            sockets = this.clientSockets.toArray();
            inputs = this.clientInputs.toArray();
            outputs = this.clientOutputs.toArray();
        }
        int i = 0;
        while (i < sockets.length) {
            this.updateClient(message, (Socket)sockets[i], (DataInputStream)inputs[i], (DataOutputStream)outputs[i]);
            ++i;
        }
    }

    private void killSocket(Socket socket, DataInputStream in, DataOutputStream out) {
        try {
            in.close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        Vector vector = this.clientSockets;
        synchronized (vector) {
            int index = this.clientSockets.indexOf(socket);
            this.clientSockets.removeElementAt(index);
            this.clientInputs.removeElementAt(index);
            this.clientOutputs.removeElementAt(index);
            this.clientIds.removeElementAt(index);
        }
    }

    public void killServer() {
        this.alive = false;
        while (true) {
            Socket socket = null;
            DataInputStream in = null;
            DataOutputStream out = null;
            Vector vector = this.clientSockets;
            synchronized (vector) {
                if (this.clientSockets.size() > 0) {
                    socket = (Socket)this.clientSockets.elementAt(0);
                    in = (DataInputStream)this.clientInputs.elementAt(0);
                    out = (DataOutputStream)this.clientOutputs.elementAt(0);
                }
            }
            if (socket == null) break;
            this.killSocket(socket, in, out);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

