/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InvalidObjectException;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import visad.MathType;
import visad.TypeException;
import visad.VisADException;
import visad.util.WeakMapValue;

public abstract class ScalarType
extends MathType
implements Comparable {
    String Name;
    private static Map ScalarHash = new HashMap();
    private static Map Translations = new HashMap();
    private static Map ReverseTranslations = new HashMap();
    private static final ReferenceQueue queue = new ReferenceQueue();

    public ScalarType(String name) throws VisADException {
        this.Name = name;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ScalarType.checkQueue();
            ScalarType.validateName(name, "name");
            ScalarHash.put(name, new WeakMapValue(this.Name, this, queue));
        }
    }

    ScalarType(String name, boolean b) {
        super(b);
        this.Name = name;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ScalarType.checkQueue();
            ScalarHash.put(name, new WeakMapValue(this.Name, this, queue));
        }
    }

    public int compareTo(Object obj) {
        return this.getName().compareTo(((ScalarType)obj).getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof ScalarType && this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void alias(String alias) throws TypeException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.Name.equals(Translations.get(alias))) {
                ScalarType.validateName(alias, "alias");
                Translations.put(alias, this.Name);
            }
            ReverseTranslations.put(this.Name, alias);
        }
    }

    public String getName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String alias = (String)ReverseTranslations.get(this.Name);
            if (alias != null) {
                String string = alias;
                return string;
            }
        }
        return this.Name;
    }

    public String getNameWithBlanks() {
        return this.getName().replace('_', ' ');
    }

    public static synchronized ScalarType getScalarTypeByName(String name) {
        Object obj;
        if (name == null) {
            return null;
        }
        ScalarType.checkQueue();
        if (Translations.containsKey(name)) {
            name = (String)Translations.get(name);
        }
        ScalarType st = (obj = ScalarHash.get(name)) == null ? null : (ScalarType)((WeakMapValue)obj).getValue();
        return st;
    }

    public static synchronized void validateName(String name, String type) throws TypeException {
        if (name == null) {
            throw new TypeException("ScalarType: " + type + " cannot be null");
        }
        if (name.indexOf(".") > -1 || name.indexOf(" ") > -1 || name.indexOf("(") > -1 || name.indexOf(")") > -1) {
            throw new TypeException("ScalarType: " + type + " cannot contain " + "space . ( or ) " + name);
        }
        if (ScalarType.getScalarTypeByName(name) != null) {
            throw new TypeException("ScalarType: " + type + " already used");
        }
        if (Translations.containsKey(name)) {
            throw new TypeException("ScalarType: " + type + " already used" + " as an alias");
        }
    }

    protected final Object readResolve() throws InvalidObjectException {
        ScalarType st;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            st = ScalarType.getScalarTypeByName(this.Name);
            if (st == null) {
                ScalarHash.put(this.Name, new WeakMapValue(this.Name, this, queue));
                st = this;
            } else if (!this.equals(st)) {
                throw new InvalidObjectException(this.toString());
            }
        }
        return st;
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void checkQueue() {
        WeakMapValue ref;
        while ((ref = (WeakMapValue)queue.poll()) != null) {
            void var0;
            Object name = var0.getKey();
            ScalarHash.remove(name);
            Object alias = ReverseTranslations.remove(name);
            if (alias == null) continue;
            Translations.remove(alias);
        }
    }
}

