/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteVisADException;
import visad.VisADException;

public class RemoteServerImpl
extends UnicastRemoteObject
implements RemoteServer {
    private RemoteDataReferenceImpl[] refs;
    private RemoteDisplayImpl[] dpys;

    public RemoteServerImpl() throws RemoteException {
        this(null, null);
    }

    public RemoteServerImpl(RemoteDataReferenceImpl[] rs) throws RemoteException {
        this(rs, null);
    }

    public RemoteServerImpl(RemoteDisplayImpl[] rd) throws RemoteException {
        this(null, rd);
    }

    public RemoteServerImpl(RemoteDataReferenceImpl[] rs, RemoteDisplayImpl[] rd) throws RemoteException {
        this.refs = rs;
        this.dpys = rd;
    }

    public synchronized RemoteDataReference getDataReference(int index) throws RemoteException {
        if (this.refs != null && 0 <= index && index < this.refs.length) {
            return this.refs[index];
        }
        return null;
    }

    public synchronized RemoteDataReference getDataReference(String name) throws VisADException, RemoteException {
        if (name != null && this.refs != null) {
            int i = 0;
            while (i < this.refs.length) {
                if (name.equals(this.refs[i].getName())) {
                    return this.refs[i];
                }
                ++i;
            }
        }
        return null;
    }

    public synchronized RemoteDataReference[] getDataReferences() throws RemoteException {
        if (this.refs == null || this.refs.length == 0) {
            return null;
        }
        RemoteDataReference[] rs = new RemoteDataReference[this.refs.length];
        int i = 0;
        while (i < this.refs.length) {
            rs[i] = this.refs[i];
            ++i;
        }
        return rs;
    }

    public synchronized void setDataReference(int index, RemoteDataReferenceImpl ref) throws VisADException {
        if (index < 0) {
            throw new RemoteVisADException("RemoteServerImpl.setDataReference: negative index");
        }
        if (this.refs == null || index >= this.refs.length) {
            RemoteDataReferenceImpl[] rs = new RemoteDataReferenceImpl[index + 1];
            int i = 0;
            while (i < index) {
                rs[i] = this.refs != null && i < this.refs.length ? this.refs[i] : null;
                ++i;
            }
            this.refs = rs;
        }
        this.refs[index] = ref;
    }

    public void addDataReference(DataReferenceImpl ref) throws RemoteException {
        this.addDataReference(new RemoteDataReferenceImpl(ref));
    }

    public synchronized void addDataReference(RemoteDataReferenceImpl ref) {
        if (ref == null) {
            return;
        }
        int len = this.refs == null || this.refs.length == 0 ? 0 : this.refs.length;
        RemoteDataReferenceImpl[] nr = new RemoteDataReferenceImpl[len + 1];
        if (len > 0) {
            System.arraycopy(this.refs, 0, nr, 0, len);
        }
        nr[len] = ref;
        this.refs = nr;
    }

    public synchronized void setDataReferences(RemoteDataReferenceImpl[] rs) {
        if (rs == null) {
            this.refs = null;
            return;
        }
        this.refs = new RemoteDataReferenceImpl[rs.length];
        int i = 0;
        while (i < this.refs.length) {
            this.refs[i] = rs[i];
            ++i;
        }
    }

    public synchronized void removeDataReference(RemoteDataReferenceImpl ref) {
        int len = this.refs == null || this.refs.length == 0 ? 0 : this.refs.length;
        int index = -1;
        int i = 0;
        while (i < len) {
            if (this.refs[i] == ref) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return;
        }
        RemoteDataReferenceImpl[] nr = new RemoteDataReferenceImpl[len - 1];
        if (index > 0) {
            System.arraycopy(this.refs, 0, nr, 0, index);
        }
        if (index < len - 1) {
            System.arraycopy(this.refs, index + 1, nr, index, len - index - 1);
        }
        this.refs = nr;
    }

    public RemoteDisplay[] getDisplays() throws RemoteException {
        if (this.dpys == null || this.dpys.length == 0) {
            return null;
        }
        RemoteDisplay[] rd = new RemoteDisplay[this.dpys.length];
        int i = 0;
        while (i < this.dpys.length) {
            rd[i] = this.dpys[i];
            ++i;
        }
        return rd;
    }

    public RemoteDisplay getDisplay(int index) {
        if (this.dpys != null && index >= 0 && index < this.dpys.length) {
            return this.dpys[index];
        }
        return null;
    }

    public RemoteDisplay getDisplay(String name) throws VisADException, RemoteException {
        if (this.dpys == null) {
            throw new RemoteException("No displays associated with this server");
        }
        int i = 0;
        while (i < this.dpys.length) {
            if (this.dpys[i] != null && this.dpys[i].getName().equals(name)) {
                return this.dpys[i];
            }
            ++i;
        }
        throw new RemoteException("Display \"" + name + "\" not found");
    }

    public void addDisplay(DisplayImpl di) throws RemoteException {
        this.addDisplay(new RemoteDisplayImpl(di));
    }

    public synchronized void addDisplay(RemoteDisplayImpl rd) {
        if (rd == null) {
            return;
        }
        int len = this.dpys == null || this.dpys.length == 0 ? 0 : this.dpys.length;
        RemoteDisplayImpl[] nd = new RemoteDisplayImpl[len + 1];
        if (len > 0) {
            System.arraycopy(this.dpys, 0, nd, 0, len);
        }
        nd[len] = rd;
        this.dpys = nd;
    }

    public synchronized void setDisplays(RemoteDisplayImpl[] rd) {
        if (rd == null) {
            this.dpys = null;
            return;
        }
        this.dpys = new RemoteDisplayImpl[rd.length];
        int i = 0;
        while (i < this.dpys.length) {
            this.dpys[i] = rd[i];
            ++i;
        }
    }

    public synchronized void removeDisplay(RemoteDisplayImpl rd) {
        int len = this.dpys == null || this.dpys.length == 0 ? 0 : this.dpys.length;
        int index = -1;
        int i = 0;
        while (i < len) {
            if (this.dpys[i] == rd) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return;
        }
        RemoteDisplayImpl[] nd = new RemoteDisplayImpl[len - 1];
        if (index > 0) {
            System.arraycopy(this.dpys, 0, nd, 0, index);
        }
        if (index < len - 1) {
            System.arraycopy(this.dpys, index + 1, nd, index, len - index - 1);
        }
        this.dpys = nd;
    }
}

