/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class RealVectorType
extends RealTupleType {
    public RealVectorType(RealType[] types) throws VisADException {
        super(types);
    }

    public RealVectorType(RealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super(types, coord_sys, null);
    }

    public RealVectorType(RealType a) throws VisADException {
        super(a);
    }

    public RealVectorType(RealType a, RealType b) throws VisADException {
        super(a, b);
    }

    public RealVectorType(RealType a, RealType b, RealType c) throws VisADException {
        super(a, b, c);
    }

    public RealVectorType(RealType a, RealType b, RealType c, RealType d) throws VisADException {
        super(a, b, c, d);
    }

    public abstract double[][] transformVectors(RealTupleType var1, CoordinateSystem var2, Unit[] var3, ErrorEstimate[] var4, RealTupleType var5, CoordinateSystem var6, Unit[] var7, CoordinateSystem var8, ErrorEstimate[] var9, ErrorEstimate[] var10, double[][] var11, double[][] var12, double[][] var13) throws VisADException, RemoteException;

    public float[][] transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, ErrorEstimate[] errors_in, ErrorEstimate[] errors_out, float[][] inloc, float[][] outloc, float[][] value) throws VisADException, RemoteException {
        double[][] dinloc = Set.floatToDouble(inloc);
        double[][] doutloc = Set.floatToDouble(outloc);
        double[][] dvalue = Set.floatToDouble(value);
        dvalue = this.transformVectors(out, coord_out, units_out, loc_errors_out, in, coord_in, units_in, coord_vector, errors_in, errors_out, dinloc, doutloc, dvalue);
        return Set.doubleToFloat(dvalue);
    }

    public RealTuple transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, double[][] inloc, double[][] outloc, RealTuple tuple) throws VisADException, RemoteException {
        if (!tuple.getType().equals(this)) {
            throw new TypeException("RealVectorType.transformVectors");
        }
        int n = this.getDimension();
        double[][] value = new double[n][1];
        ErrorEstimate[] errors_in = new ErrorEstimate[n];
        int j = 0;
        while (j < n) {
            value[j][0] = ((Real)tuple.getComponent(j)).getValue();
            errors_in[j] = ((Real)tuple.getComponent(j)).getError();
            ++j;
        }
        ErrorEstimate[] errors_out = new ErrorEstimate[n];
        value = this.transformVectors(out, coord_out, units_out, loc_errors_out, in, coord_in, units_in, coord_vector, errors_in, errors_out, inloc, outloc, value);
        double[] vals = new double[n];
        Real[] reals = new Real[n];
        int j2 = 0;
        while (j2 < n) {
            reals[j2] = new Real((RealType)((Real)tuple.getComponent(j2)).getType(), value[j2][0], ((Real)tuple.getComponent(j2)).getUnit(), errors_out[j2]);
            ++j2;
        }
        return new RealTuple((RealTupleType)tuple.getType(), reals, tuple.getCoordinateSystem());
    }

    public RealTuple transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, float[][] inloc, float[][] outloc, RealTuple tuple) throws VisADException, RemoteException {
        double[][] dinloc = Set.floatToDouble(inloc);
        double[][] doutloc = Set.floatToDouble(outloc);
        return this.transformVectors(out, coord_out, units_out, loc_errors_out, in, coord_in, units_in, coord_vector, dinloc, doutloc, tuple);
    }
}

