/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Vector;
import visad.DelaunayCustom;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.browser.Convert;
import visad.util.HersheyFont;

public class PlotText {
    static final double XMIN = -1.0;
    static final double YMIN = -1.0;
    static final double ZMIN = -1.0;
    static final double WIDTH = 0.8;
    static double[] bx = new double[]{0.07, 0.0, 0.0};
    static double[] ux = new double[]{0.0, 0.07, 0.07};
    static double[] by = new double[]{0.0, 0.07, 0.0};
    static double[] uy = new double[]{-0.07, 0.0, -0.07};
    static double[] bz = new double[]{0.0, 0.0, -0.07};
    static double[] uz = new double[]{0.07, 0.07, 0.0};
    static float[][] charCodes = new float[][]{{100.0f, 0.0f}, {101.0f, 8.0f, 1.0f, 3.0f, 3.0f, 3.0f, 3.0f, 8.0f, 1.0f, 8.0f, 101.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 3.0f, 1.0f, 1.0f, 1.0f}, {101.0f, 8.0f, 0.0f, 5.0f, 104.0f, 8.0f, 3.0f, 5.0f}, {101.5f, 8.0f, 1.5f, 0.0f, 103.5f, 8.0f, 3.5f, 0.0f, 100.0f, 5.0f, 5.0f, 5.0f, 100.0f, 3.0f, 5.0f, 3.0f}, {101.5f, 8.0f, 1.5f, 0.0f, 102.5f, 8.0f, 2.5f, 0.0f, 104.0f, 5.5f, 3.0f, 7.0f, 1.0f, 7.0f, 0.0f, 5.5f, 0.0f, 4.5f, 4.0f, 3.5f, 4.0f, 2.5f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, 2.5f}, {100.0f, 8.0f, 0.0f, 7.0f, 1.0f, 7.0f, 1.0f, 8.0f, 0.0f, 8.0f, 105.0f, 8.0f, 0.0f, 0.0f, 104.0f, 1.0f, 4.0f, 0.0f, 5.0f, 0.0f, 5.0f, 1.0f, 4.0f, 1.0f}, {105.0f, 0.0f, 0.0f, 5.0f, 0.0f, 7.0f, 1.0f, 8.0f, 3.0f, 8.0f, 4.0f, 7.0f, 4.0f, 5.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 4.0f}, {101.0f, 8.0f, 0.0f, 5.0f}, {104.0f, 8.0f, 2.0f, 6.0f, 2.0f, 2.0f, 4.0f, 0.0f}, {101.0f, 8.0f, 3.0f, 6.0f, 3.0f, 2.0f, 1.0f, 0.0f}, {100.0f, 7.0f, 5.0f, 1.0f, 102.5f, 7.0f, 2.5f, 1.0f, 100.0f, 1.0f, 5.0f, 7.0f, 105.0f, 4.0f, 0.0f, 4.0f}, {102.5f, 7.0f, 2.5f, 1.0f, 100.0f, 4.0f, 5.0f, 4.0f}, {103.0f, 0.0f, 2.0f, 0.0f, 2.0f, 1.0f, 3.0f, 1.0f, 3.0f, 0.0f, 2.1f, -2.0f}, {100.0f, 4.0f, 5.0f, 4.0f}, {102.0f, 0.0f, 3.0f, 0.0f, 3.0f, 1.0f, 2.0f, 1.0f, 2.0f, 0.0f}, {100.0f, 0.0f, 5.0f, 8.0f}, {102.0f, 8.0f, 0.0f, 6.0f, 0.0f, 2.0f, 2.0f, 0.0f, 3.0f, 0.0f, 5.0f, 2.0f, 5.0f, 6.0f, 3.0f, 8.0f, 2.0f, 8.0f}, {101.0f, 7.0f, 2.5f, 8.0f, 2.5f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {103.0f, 8.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 0.0f, 5.0f, 0.0f, 8.0f, 5.0f, 8.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 0.0f, 4.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 3.0f, 0.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 4.0f, 4.0f, 5.0f, 5.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 101.0f, 4.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f}, {101.0f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 5.0f, 4.0f}, {102.0f, 7.0f, 2.0f, 5.0f, 3.0f, 5.0f, 3.0f, 7.0f, 2.0f, 7.0f, 102.0f, 3.0f, 2.0f, 1.0f, 3.0f, 1.0f, 3.0f, 3.0f, 2.0f, 3.0f}, {100.0f, 7.0f, 0.0f, 5.0f, 1.0f, 5.0f, 1.0f, 7.0f, 0.0f, 7.0f, 100.0f, 0.0f, 1.0f, 1.0f, 1.0f, 3.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {105.0f, 7.0f, 0.0f, 4.0f, 5.0f, 1.0f}, {100.0f, 5.0f, 5.0f, 5.0f, 100.0f, 3.0f, 5.0f, 3.0f}, {100.0f, 7.0f, 5.0f, 4.0f, 0.0f, 1.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 2.5f, 4.0f, 2.5f, 2.0f, 102.5f, 1.0f, 2.5f, 0.0f}, {104.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 3.0f, 4.0f, 1.5f, 3.0f, 2.0f, 1.5f, 4.0f, 1.5f, 5.0f, 2.5f, 6.0f, 4.0f, 5.0f, 3.0f, 2.0f}, {100.0f, 0.0f, 0.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 0.0f, 5.0f, 4.0f, 0.0f, 4.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 5.0f, 5.0f, 5.0f, 7.0f, 4.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 4.0f, 4.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 0.0f, 8.0f}, {105.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 4.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {105.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 4.0f, 0.0f, 0.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 3.0f, 4.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 2.5f, 8.0f, 2.5f, 0.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {105.0f, 8.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 3.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 8.0f, 0.0f, 4.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 2.5f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 0.0f, 4.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 103.0f, 3.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 0.0f, 4.0f, 3.0f, 4.0f, 5.0f, 0.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 2.5f, 8.0f, 2.5f, 0.0f}, {100.0f, 8.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 2.5f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 2.5f, 4.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 5.0f, 0.0f, 100.0f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 2.5f, 4.0f, 5.0f, 8.0f, 2.5f, 4.0f, 2.5f, 0.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {104.0f, 8.0f, 2.0f, 8.0f, 2.0f, 0.0f, 4.0f, 0.0f}, {100.0f, 8.0f, 5.0f, 0.0f}, {101.0f, 8.0f, 3.0f, 8.0f, 3.0f, 0.0f, 1.0f, 0.0f}, {102.0f, 6.0f, 3.0f, 8.0f, 4.0f, 6.0f}, {100.0f, -2.0f, 5.0f, -2.0f}, {102.0f, 8.0f, 4.0f, 6.0f}, {104.0f, 5.0f, 4.0f, 1.0f, 3.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 4.0f, 4.0f, 4.0f, 1.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 0.0f, 3.0f}, {105.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f}, {105.0f, 3.0f, 3.0f, 5.0f, 1.0f, 5.0f, 0.0f, 4.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {105.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 0.0f, 3.0f}, {103.0f, 0.0f, 3.0f, 7.0f, 4.0f, 8.0f, 5.0f, 8.0f, 5.0f, 7.0f, 101.0f, 4.0f, 4.0f, 4.0f}, {105.0f, 5.0f, 5.0f, -3.0f, 4.0f, -4.0f, 1.0f, -4.0f, 105.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 5.0f, 3.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 0.0f}, {103.0f, 4.0f, 3.0f, 0.0f, 4.0f, 0.0f, 1.0f, 0.0f, 103.0f, 6.5f, 3.0f, 5.5f}, {104.0f, 4.0f, 4.0f, -3.0f, 3.0f, -4.0f, 1.0f, -4.0f, 0.0f, -3.0f, 0.0f, -1.0f, 1.0f, 0.0f, 104.0f, 6.5f, 4.0f, 5.5f}, {101.0f, 8.0f, 1.0f, 0.0f, 101.0f, 3.0f, 5.0f, 5.0f, 101.0f, 3.0f, 5.0f, 0.0f}, {102.0f, 8.0f, 3.0f, 8.0f, 3.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 0.0f, 102.5f, 5.0f, 2.5f, 2.0f}, {100.0f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 3.0f, 5.0f, 0.0f}, {101.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f}, {100.0f, -4.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 0.0f, 3.0f, 0.0f, 1.0f, 0.0f, 5.0f}, {105.0f, -4.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 5.0f, 3.0f, 5.0f, 1.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f}, {105.0f, 4.0f, 3.0f, 5.0f, 2.0f, 5.0f, 0.0f, 4.0f, 0.0f, 3.0f, 5.0f, 2.0f, 5.0f, 1.0f, 3.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f}, {102.5f, 8.0f, 2.5f, 0.0f, 100.5f, 5.0f, 4.5f, 5.0f}, {100.0f, 5.0f, 0.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f, 5.0f, 0.0f}, {100.0f, 5.0f, 0.0f, 3.0f, 2.5f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 0.0f, 0.0f, 2.5f, 3.0f, 5.0f, 0.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 5.0f, 0.0f, 105.0f, 5.0f, 0.0f, 0.0f}, {100.0f, 5.0f, 0.0f, 3.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f, 5.0f, -3.0f, 3.0f, -4.0f}, {100.0f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {104.0f, 8.0f, 3.0f, 8.0f, 2.0f, 4.5f, 1.0f, 4.5f, 2.0f, 4.5f, 3.0f, 0.0f, 4.0f, 0.0f}, {103.5f, 8.0f, 3.5f, 0.0f}, {102.0f, 8.0f, 3.0f, 8.0f, 4.0f, 4.5f, 5.0f, 4.5f, 4.0f, 4.5f, 3.0f, 0.0f, 2.0f, 0.0f}, {100.0f, 4.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 5.0f}, {100.0f, 0.0f}};

    public static VisADLineArray render_label(int axis, double pos, String str, int line, long c) {
        double XMIN = -1.0;
        double YMIN = -1.0;
        double ZMIN = -1.0;
        double[] bx = new double[]{0.07, 0.0, 0.0};
        double[] ux = new double[]{0.0, 0.07, 0.07};
        double[] by = new double[]{0.0, 0.07, 0.0};
        double[] uy = new double[]{-0.07, 0.0, -0.07};
        double[] bz = new double[]{0.0, 0.0, -0.07};
        double[] uz = new double[]{0.07, 0.07, 0.0};
        double[] base = null;
        double[] up = null;
        double[] start = new double[3];
        if (axis == 0) {
            base = bx;
            up = ux;
            start[0] = pos;
            start[1] = YMIN * (1.1 + 0.07 * (double)line);
            start[2] = ZMIN * (1.1 + 0.07 * (double)line);
        } else if (axis == 1) {
            base = by;
            up = uy;
            start[0] = XMIN * (1.1 + 0.07 * (double)line);
            start[1] = pos;
            start[2] = ZMIN * (1.1 + 0.07 * (double)line);
        } else if (axis == 2) {
            base = bz;
            up = uz;
            start[0] = XMIN * (1.1 + 0.07 * (double)line);
            start[1] = YMIN * (1.1 + 0.07 * (double)line);
            start[2] = pos;
        }
        return PlotText.render_label(str, start, base, up, TextControl.Justification.CENTER);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, boolean center) {
        return PlotText.render_label(str, start, base, up, center ? TextControl.Justification.CENTER : TextControl.Justification.LEFT);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, TextControl.Justification justification) {
        double sw;
        double startx = 0.0;
        double starty = 0.0;
        double startz = 0.0;
        double cx = start[0];
        double cy = start[1];
        double cz = start[2];
        int len = str.length();
        float[] plot = new float[120 * len];
        if (justification == TextControl.Justification.CENTER) {
            sw = 0.8 * (double)len;
            cx -= sw * base[0] / 2.0;
            cy -= sw * base[1] / 2.0;
            cz -= sw * base[2] / 2.0;
        } else if (justification == TextControl.Justification.RIGHT) {
            sw = 0.8 * (double)len;
            cx -= sw * base[0];
            cy -= sw * base[1];
            cz -= sw * base[2];
        }
        int plot_index = 0;
        int i = 0;
        while (i < len) {
            int k = str.charAt(i) - 32;
            if (k >= 0 && k <= 127) {
                int verts = charCodes[k].length / 2;
                int temp_index = 0;
                int j = 0;
                while (j < verts) {
                    double x;
                    if (verts == 1) break;
                    boolean dup_point = true;
                    if (j == verts - 1) {
                        dup_point = false;
                    }
                    if ((x = (double)charCodes[k][temp_index] * 0.1) > 9.0) {
                        if (j != 0) {
                            plot_index -= 3;
                        }
                        x -= 10.0;
                        dup_point = false;
                    }
                    double y = (double)charCodes[k][++temp_index] * 0.1;
                    ++temp_index;
                    plot[plot_index] = (float)(cx + x * base[0] + y * up[0]);
                    plot[plot_index + 1] = (float)(cy + x * base[1] + y * up[1]);
                    plot[plot_index + 2] = (float)(cz + x * base[2] + y * up[2]);
                    if (dup_point) {
                        plot[plot_index + 3] = plot[plot_index];
                        plot[plot_index + 4] = plot[plot_index + 1];
                        plot[plot_index + 5] = plot[plot_index + 2];
                        plot_index += 3;
                    }
                    plot_index += 3;
                    ++j;
                }
                cx += 0.8 * base[0];
                cy += 0.8 * base[1];
                cz += 0.8 * base[2];
            }
            ++i;
        }
        if (plot_index <= 0) {
            return null;
        }
        VisADLineArray array = new VisADLineArray();
        float[] coordinates = new float[plot_index];
        System.arraycopy(plot, 0, coordinates, 0, plot_index);
        array.coordinates = coordinates;
        array.vertexCount = plot_index / 3;
        return array;
    }

    public static String shortString(double val) {
        return Convert.shortString(val);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, boolean center) {
        return PlotText.render_font(str, font, start, base, up, center ? TextControl.Justification.CENTER : TextControl.Justification.LEFT);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, TextControl.Justification justification) {
        int maxChars = font.getCharactersInSet();
        double width = 0.0;
        double startx = 0.0;
        double starty = 0.0;
        double startz = 0.0;
        double cx = start[0];
        double cy = start[1];
        double cz = start[2];
        int len = str.length();
        boolean isFixed = font.getFixedWidth();
        int maxSeg = font.getMaxPoints();
        float[] plot = new float[maxSeg * 6 * len];
        int plot_index = 0;
        int[] charMinX = font.getCharacterMinX();
        int[] charMaxX = font.getCharacterMaxX();
        int charMinY = font.getCharacterSetMinY();
        int charMaxY = font.getCharacterSetMaxY();
        int charSetMinX = font.getCharacterSetMinX();
        int charSetMaxX = font.getCharacterSetMaxX();
        boolean isCursive = font.getIsCursive();
        float oldpx = 0.0f;
        float oldpy = 0.0f;
        float oldpz = 0.0f;
        int i = 0;
        while (i < len) {
            int k = str.charAt(i) - 32;
            if (k >= 0 && k <= maxChars) {
                char[][] charVector = font.getCharacterVector(k);
                int verts = font.getNumberOfPoints(k);
                if (i > 0) {
                    width = 0.08;
                    if (isCursive) {
                        width = -0.08;
                    }
                    cx += width * base[0];
                    cy += width * base[1];
                    cz += width * base[2];
                }
                boolean skip = true;
                float maxX = 0.0f;
                int j = 1;
                while (j < verts) {
                    if (charVector[0][j] == ' ') {
                        skip = true;
                    } else {
                        float x = isFixed ? (float)(charVector[0][j] - charMinX[k]) / (float)(charSetMaxX - charSetMinX) : (float)(charVector[0][j] - charMinX[k]) / (float)(charMaxX[k] - charMinX[k]);
                        if (x > maxX) {
                            maxX = x;
                        }
                        float y = (float)(charMaxY - charVector[1][j]) / (float)(charMaxY - charMinY);
                        float px = (float)(cx + (double)x * base[0] + (double)y * up[0]);
                        float py = (float)(cy + (double)x * base[1] + (double)y * up[1]);
                        float pz = (float)(cz + (double)x * base[2] + (double)y * up[2]);
                        if (!skip) {
                            plot[plot_index] = oldpx;
                            plot[plot_index + 1] = oldpy;
                            plot[plot_index + 2] = oldpz;
                            plot[plot_index + 3] = px;
                            plot[plot_index + 4] = py;
                            plot[plot_index + 5] = pz;
                            plot_index += 6;
                        }
                        skip = false;
                        oldpx = px;
                        oldpy = py;
                        oldpz = pz;
                    }
                    ++j;
                }
                if (verts == 1) {
                    maxX = 0.5f;
                }
                cx += (width += (double)maxX) * base[0];
                cy += width * base[1];
                cz += width * base[2];
            }
            ++i;
        }
        if (plot_index <= 0) {
            return null;
        }
        float cxoff = Float.NaN;
        float cyoff = Float.NaN;
        float czoff = Float.NaN;
        if (justification == TextControl.Justification.CENTER) {
            cxoff = (float)((cx - start[0]) / 2.0);
            cyoff = (float)((cy - start[1]) / 2.0);
            czoff = (float)((cz - start[2]) / 2.0);
        } else if (justification == TextControl.Justification.RIGHT) {
            cxoff = (float)(cx - start[0]);
            cyoff = (float)(cy - start[1]);
            czoff = (float)(cz - start[2]);
        }
        if (cxoff == cxoff) {
            int i2 = 0;
            while (i2 < plot_index) {
                plot[i2] = plot[i2] - cxoff;
                plot[i2 + 1] = plot[i2 + 1] - cyoff;
                plot[i2 + 2] = plot[i2 + 2] - czoff;
                i2 += 3;
            }
        }
        VisADLineArray array = new VisADLineArray();
        float[] coordinates = new float[plot_index];
        System.arraycopy(plot, 0, coordinates, 0, plot_index);
        array.coordinates = coordinates;
        array.vertexCount = plot_index / 3;
        return array;
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, boolean center) {
        return PlotText.render_font(str, font, start, base, up, center ? TextControl.Justification.CENTER : TextControl.Justification.LEFT);
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, TextControl.Justification justification) {
        VisADTriangleArray array = null;
        float fsize = font.getSize();
        float fsize_inv = 1.0f / fsize;
        AffineTransform at = null;
        boolean isAntiAliased = false;
        boolean usesFractionalMetrics = false;
        FontRenderContext frc = new FontRenderContext(at, isAntiAliased, usesFractionalMetrics);
        double flatness = 0.05;
        Vector<Object> big_vector = new Vector<Object>();
        int big_len = 1000;
        float[][] big_samples = new float[2][big_len];
        float[] seg = new float[6];
        int str_len = str.length();
        float x_offset = 0.0f;
        int str_index = 0;
        while (str_index < str_len) {
            char[] chars = new char[]{str.charAt(str_index)};
            GlyphVector gv = font.createGlyphVector(frc, chars);
            int ng = gv.getNumGlyphs();
            if (ng != 0) {
                int path_count = 0;
                Vector<float[][]> samples_vector = new Vector<float[][]>();
                float x_plus = fsize_inv * gv.getGlyphMetrics(0).getAdvance();
                int ig = 0;
                while (ig < ng) {
                    Shape sh = gv.getGlyphOutline(ig);
                    PathIterator pi = sh.getPathIterator(at, flatness);
                    int k = 0;
                    while (!pi.isDone()) {
                        int segType = pi.currentSegment(seg);
                        switch (segType) {
                            case 0: {
                                float[][] samples;
                                if (k > 0) {
                                    samples = new float[2][k];
                                    System.arraycopy(big_samples[0], 0, samples[0], 0, k);
                                    System.arraycopy(big_samples[1], 0, samples[1], 0, k);
                                    samples_vector.addElement(samples);
                                    k = 0;
                                    ++path_count;
                                }
                            }
                            case 1: {
                                big_samples[0][k] = x_offset + fsize_inv * seg[0];
                                big_samples[1][k] = -fsize_inv * seg[1];
                                if (++k < big_len) break;
                                float[][] bs = new float[2][2 * big_len];
                                System.arraycopy(big_samples[0], 0, bs[0], 0, big_len);
                                System.arraycopy(big_samples[1], 0, bs[1], 0, big_len);
                                big_samples = bs;
                                big_len = 2 * big_len;
                                break;
                            }
                            case 4: {
                                if (k <= 0) break;
                                float[][] samples = new float[2][k];
                                System.arraycopy(big_samples[0], 0, samples[0], 0, k);
                                System.arraycopy(big_samples[1], 0, samples[1], 0, k);
                                samples_vector.addElement(samples);
                                k = 0;
                                ++path_count;
                            }
                        }
                        pi.next();
                    }
                    if (k > 0) {
                        float[][] samples = new float[2][k];
                        System.arraycopy(big_samples[0], 0, samples[0], 0, k);
                        System.arraycopy(big_samples[1], 0, samples[1], 0, k);
                        samples_vector.addElement(samples);
                        k = 0;
                        ++path_count;
                    }
                    ++ig;
                }
                if (path_count == 1) {
                    big_vector.addElement(samples_vector.elementAt(0));
                } else if (path_count > 1) {
                    float[][][] ss = new float[path_count][][];
                    int i = 0;
                    while (i < path_count) {
                        ss[i] = (float[][])samples_vector.elementAt(i);
                        ++i;
                    }
                    try {
                        if (path_count == 2 && !DelaunayCustom.inside(ss[0], ss[1][0][0], ss[1][1][0]) && !DelaunayCustom.inside(ss[1], ss[0][0][0], ss[0][1][0])) {
                            int i2 = 0;
                            while (i2 < path_count) {
                                big_vector.addElement(ss[i2]);
                                ++i2;
                            }
                        } else {
                            big_vector.addElement(DelaunayCustom.link(ss));
                        }
                    }
                    catch (VisADException ex) {
                        System.out.println(ex);
                    }
                }
                samples_vector.removeAllElements();
                x_offset += x_plus;
            }
            ++str_index;
        }
        x_offset = justification == TextControl.Justification.LEFT ? 0.0f : (justification == TextControl.Justification.CENTER ? -0.5f * x_offset : -1.0f * x_offset);
        int n = big_vector.size();
        VisADGeometryArray[] arrays = new VisADTriangleArray[n];
        int i = 0;
        while (i < n) {
            float[][] samples = (float[][])big_vector.elementAt(i);
            int[][] tris = null;
            try {
                tris = DelaunayCustom.fillCheck(samples, false);
            }
            catch (VisADException ex) {
                // empty catch block
            }
            if (tris != null && tris.length != 0) {
                int j3;
                int m = tris.length;
                float[] coordinates = new float[9 * m];
                int j = 0;
                while (j < m) {
                    int j9 = 9 * j;
                    int tj = 0;
                    while (tj < 3) {
                        j3 = j9 + 3 * tj;
                        coordinates[j3 + 0] = (float)(start[0] + base[0] * (double)(samples[0][tris[j][tj]] + x_offset) + up[0] * (double)samples[1][tris[j][tj]]);
                        coordinates[j3 + 1] = (float)(start[1] + base[1] * (double)(samples[0][tris[j][tj]] + x_offset) + up[1] * (double)samples[1][tris[j][tj]]);
                        coordinates[j3 + 2] = (float)(start[2] + base[2] * (double)(samples[0][tris[j][tj]] + x_offset) + up[2] * (double)samples[1][tris[j][tj]]);
                        ++tj;
                    }
                    ++j;
                }
                float[] normals = new float[9 * m];
                int j2 = 0;
                while (j2 < 3 * m) {
                    j3 = 3 * j2;
                    normals[j3 + 0] = 0.0f;
                    normals[j3 + 1] = 0.0f;
                    normals[j3 + 2] = 1.0f;
                    ++j2;
                }
                arrays[i] = new VisADTriangleArray();
                arrays[i].vertexCount = 3 * m;
                arrays[i].coordinates = coordinates;
                arrays[i].normals = normals;
            }
            ++i;
        }
        array = new VisADTriangleArray();
        try {
            VisADGeometryArray.merge(arrays, array);
        }
        catch (VisADException ex) {
            array = new VisADTriangleArray();
        }
        if (array.coordinates == null) {
            return null;
        }
        return array;
    }
}

