/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RendererSourceListener;
import visad.VisADException;
import visad.VisADRay;
import visad.browser.Convert;
import visad.java2d.MouseBehaviorJ2D;

public class MouseHelper
implements RendererSourceListener {
    MouseBehavior behavior;
    DisplayRenderer display_renderer;
    DisplayImpl display;
    private ProjectionControl proj;
    private double xymul;
    DataRenderer direct_renderer = null;
    private double[] tstart;
    private int start_x;
    private int start_y;
    private double xmul;
    private double ymul;
    private double[] xtrans = new double[3];
    private double[] ytrans = new double[3];
    private boolean mouseEntered;
    private boolean mousePressed1;
    private boolean mousePressed2;
    private boolean mousePressed3;
    private boolean mouseCombo1;
    private boolean mouseCombo2;
    private boolean mouseCombo3;
    private boolean z1Pressed;
    private boolean t1Pressed;
    private boolean z2Pressed;
    private boolean t2Pressed;
    private int mouseModifiers;
    private boolean mode2D;
    private boolean first = true;

    public MouseHelper(DisplayRenderer r, MouseBehavior b) {
        this.behavior = b;
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
        this.proj = this.display.getProjectionControl();
        this.mode2D = this.display_renderer.getMode2D();
        this.display.addRendererSourceListener(this);
        this.mouseEntered = false;
        this.mousePressed1 = false;
        this.mousePressed2 = false;
        this.mousePressed3 = false;
        this.mouseCombo1 = false;
        this.mouseCombo2 = false;
        this.mouseCombo3 = false;
        this.z1Pressed = false;
        this.t1Pressed = false;
        this.z2Pressed = false;
        this.t2Pressed = false;
    }

    public void processEvent(AWTEvent event) {
        this.processEvent(event, 0);
    }

    public void processEvent(AWTEvent event, int remoteId) {
        if (this.behavior == null) {
            return;
        }
        if (this.first) {
            this.start_x = 0;
            this.start_y = 0;
            VisADRay start_ray = this.behavior.findRay(this.start_x, this.start_y);
            VisADRay start_ray_x = this.behavior.findRay(this.start_x + 1, this.start_y);
            VisADRay start_ray_y = this.behavior.findRay(this.start_x, this.start_y + 1);
            if (start_ray != null && start_ray_x != null && start_ray_y != null) {
                double[] tstart = this.proj.getMatrix();
                double[] rot = new double[3];
                double[] scale = new double[1];
                double[] trans = new double[3];
                this.behavior.instance_unmake_matrix(rot, scale, trans, tstart);
                double[] trot = this.behavior.make_matrix(rot[0], rot[1], rot[2], scale[0], 0.0, 0.0, 0.0);
                double[] xmat = this.behavior.make_translate(start_ray_x.position[0] - start_ray.position[0], start_ray_x.position[1] - start_ray.position[1], start_ray_x.position[2] - start_ray.position[2]);
                double[] ymat = this.behavior.make_translate(start_ray_y.position[0] - start_ray.position[0], start_ray_y.position[1] - start_ray.position[1], start_ray_y.position[2] - start_ray.position[2]);
                double[] xmatmul = this.behavior.multiply_matrix(trot, xmat);
                double[] ymatmul = this.behavior.multiply_matrix(trot, ymat);
                this.behavior.instance_unmake_matrix(rot, scale, trans, xmatmul);
                double xmul = trans[0];
                this.behavior.instance_unmake_matrix(rot, scale, trans, ymatmul);
                double ymul = trans[1];
                this.xymul = Math.sqrt(xmul * xmul + ymul * ymul);
                this.first = false;
            }
        }
        if (!(event instanceof MouseEvent)) {
            System.out.println("MouseHelper.processStimulus: non-MouseEvent");
        }
        MouseEvent mouse_event = (MouseEvent)event;
        switch (event.getID()) {
            case 504: {
                DisplayEvent e;
                this.mouseEntered = true;
                try {
                    e = new DisplayEvent((Display)this.display, 19, mouse_event, remoteId);
                    this.display.notifyListeners(e);
                }
                catch (VisADException e2) {
                }
                catch (RemoteException e3) {}
                break;
            }
            case 505: {
                DisplayEvent e;
                this.mouseEntered = false;
                try {
                    e = new DisplayEvent((Display)this.display, 20, mouse_event, remoteId);
                    this.display.notifyListeners(e);
                }
                catch (VisADException e4) {
                }
                catch (RemoteException e5) {}
                break;
            }
            case 501: {
                int current_y;
                int current_x;
                VisADRay direct_ray;
                DisplayEvent e;
                if (!this.mouseEntered || this.mouseCombo1 || this.mouseCombo2 || this.mouseCombo3) break;
                this.display.updateBusyStatus();
                try {
                    e = new DisplayEvent((Display)this.display, 1, mouse_event, remoteId);
                    this.display.notifyListeners(e);
                }
                catch (VisADException e6) {
                }
                catch (RemoteException e7) {
                    // empty catch block
                }
                int m = ((InputEvent)event).getModifiers();
                int m1 = m & 0x10;
                int m2 = m & 8;
                int m3 = m & 4;
                int mctrl = m & 2;
                int mshift = m & 1;
                this.mouseModifiers = m;
                if (m1 != 0) {
                    if (this.mousePressed2 || m2 != 0) {
                        this.mouseCombo3 = true;
                        this.mousePressed1 = false;
                        this.z1Pressed = false;
                        this.t1Pressed = false;
                        this.mousePressed2 = false;
                        this.display_renderer.setCursorOn(false);
                        this.z2Pressed = false;
                        this.t2Pressed = false;
                    } else if (this.mousePressed3 || m3 != 0) {
                        this.mouseCombo2 = true;
                        this.mousePressed1 = false;
                        this.z1Pressed = false;
                        this.t1Pressed = false;
                        this.mousePressed3 = false;
                        this.display_renderer.setDirectOn(false);
                        this.direct_renderer = null;
                    } else {
                        if (this.mousePressed1) break;
                        this.mousePressed1 = true;
                    }
                } else if (m2 != 0) {
                    if (this.mousePressed1 || m1 != 0) {
                        this.mouseCombo3 = true;
                        this.mousePressed1 = false;
                        this.z1Pressed = false;
                        this.t1Pressed = false;
                        this.mousePressed2 = false;
                        this.display_renderer.setCursorOn(false);
                        this.z2Pressed = false;
                        this.t2Pressed = false;
                    } else if (this.mousePressed3 || m3 != 0) {
                        this.mouseCombo1 = true;
                        this.mousePressed2 = false;
                        this.display_renderer.setCursorOn(false);
                        this.z2Pressed = false;
                        this.t2Pressed = false;
                        this.mousePressed3 = false;
                        this.display_renderer.setDirectOn(false);
                        this.direct_renderer = null;
                    } else {
                        if (this.mousePressed2) break;
                        this.mousePressed2 = true;
                    }
                } else if (m3 != 0) {
                    if (this.mousePressed1 || m1 != 0) {
                        this.mouseCombo2 = true;
                        this.mousePressed1 = false;
                        this.z1Pressed = false;
                        this.t1Pressed = false;
                        this.mousePressed3 = false;
                        this.display_renderer.setDirectOn(false);
                        this.direct_renderer = null;
                    } else if (this.mousePressed2 || m2 != 0) {
                        this.mouseCombo1 = true;
                        this.mousePressed2 = false;
                        this.display_renderer.setCursorOn(false);
                        this.z2Pressed = false;
                        this.t2Pressed = false;
                        this.mousePressed3 = false;
                        this.display_renderer.setDirectOn(false);
                        this.direct_renderer = null;
                    } else {
                        if (this.mousePressed3) break;
                        this.mousePressed3 = true;
                    }
                }
                if (this.mousePressed1 || this.mouseCombo1) {
                    this.start_x = ((MouseEvent)event).getX();
                    this.start_y = ((MouseEvent)event).getY();
                    VisADRay start_ray = this.behavior.findRay(this.start_x, this.start_y);
                    VisADRay start_ray_x = this.behavior.findRay(this.start_x + 1, this.start_y);
                    VisADRay start_ray_y = this.behavior.findRay(this.start_x, this.start_y + 1);
                    this.tstart = this.proj.getMatrix();
                    double[] rot = new double[3];
                    double[] scale = new double[1];
                    double[] trans = new double[3];
                    this.behavior.instance_unmake_matrix(rot, scale, trans, this.tstart);
                    double sts = scale[0];
                    double[] trot = this.behavior.make_matrix(rot[0], rot[1], rot[2], scale[0], 0.0, 0.0, 0.0);
                    double[] xmat = this.behavior.make_translate(start_ray_x.position[0] - start_ray.position[0], start_ray_x.position[1] - start_ray.position[1], start_ray_x.position[2] - start_ray.position[2]);
                    double[] ymat = this.behavior.make_translate(start_ray_y.position[0] - start_ray.position[0], start_ray_y.position[1] - start_ray.position[1], start_ray_y.position[2] - start_ray.position[2]);
                    double[] xmatmul = this.behavior.multiply_matrix(trot, xmat);
                    double[] ymatmul = this.behavior.multiply_matrix(trot, ymat);
                    this.behavior.instance_unmake_matrix(rot, scale, trans, xmatmul);
                    this.xmul = trans[0];
                    this.behavior.instance_unmake_matrix(rot, scale, trans, ymatmul);
                    this.ymul = trans[1];
                    if (this.behavior instanceof MouseBehaviorJ2D) {
                        double factor = this.xymul / Math.sqrt(this.xmul * this.xmul + this.ymul * this.ymul);
                        this.xmul *= factor;
                        this.ymul *= factor;
                        this.xmul = Math.abs(this.xmul);
                        this.ymul = -Math.abs(this.ymul);
                    }
                    if (mshift != 0) {
                        this.z1Pressed = true;
                    } else if (mctrl != 0 || this.mode2D) {
                        this.t1Pressed = true;
                    }
                    if (mctrl != 0 || this.z1Pressed) break;
                    try {
                        DisplayEvent e8 = new DisplayEvent((Display)this.display, 5, mouse_event, remoteId);
                        this.display.notifyListeners(e8);
                    }
                    catch (VisADException e9) {
                    }
                    catch (RemoteException e10) {}
                    break;
                }
                if (this.mousePressed2 || this.mouseCombo2) {
                    VisADRay cursor_ray;
                    this.display_renderer.setCursorOn(true);
                    this.start_x = ((MouseEvent)event).getX();
                    this.start_y = ((MouseEvent)event).getY();
                    this.tstart = this.proj.getMatrix();
                    if (mshift != 0) {
                        this.z2Pressed = true;
                        if (!this.mode2D) {
                            cursor_ray = this.behavior.cursorRay(this.display_renderer.getCursor());
                            this.display_renderer.depth_cursor(cursor_ray);
                        }
                    } else if (mctrl != 0) {
                        this.t2Pressed = true;
                    } else {
                        cursor_ray = this.behavior.findRay(this.start_x, this.start_y);
                        if (cursor_ray != null) {
                            this.display_renderer.drag_cursor(cursor_ray, true);
                        }
                    }
                    if (this.t2Pressed || this.z2Pressed) break;
                    try {
                        DisplayEvent e11 = new DisplayEvent((Display)this.display, 4, mouse_event, remoteId);
                        this.display.notifyListeners(e11);
                    }
                    catch (VisADException e12) {
                    }
                    catch (RemoteException e13) {}
                    break;
                }
                if (!this.mousePressed3 && !this.mouseCombo3) break;
                if (this.display_renderer.anyDirects() && (direct_ray = this.behavior.findRay(current_x = ((MouseEvent)event).getX(), current_y = ((MouseEvent)event).getY())) != null) {
                    this.direct_renderer = this.display_renderer.findDirect(direct_ray, this.mouseModifiers);
                    if (this.direct_renderer != null) {
                        this.display_renderer.setDirectOn(true);
                        this.direct_renderer.setLastMouseModifiers(this.mouseModifiers);
                        this.direct_renderer.drag_direct(direct_ray, true, this.mouseModifiers);
                    }
                }
                try {
                    DisplayEvent e14 = new DisplayEvent((Display)this.display, 6, mouse_event, remoteId);
                    this.display.notifyListeners(e14);
                }
                catch (VisADException e15) {
                }
                catch (RemoteException e16) {}
                break;
            }
            case 502: {
                DisplayEvent e;
                int m = ((InputEvent)event).getModifiers();
                int m1 = m & 0x10;
                int m2 = m & 8;
                int m3 = m & 4;
                if (this.mousePressed1 || this.mousePressed2 || this.mousePressed3 || this.mouseCombo1 || this.mouseCombo2 || this.mouseCombo3) {
                    this.display.updateBusyStatus();
                    try {
                        e = new DisplayEvent((Display)this.display, 7, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e17) {
                    }
                    catch (RemoteException e18) {
                        // empty catch block
                    }
                }
                if ((this.mousePressed3 || this.mouseCombo3) && this.direct_renderer != null) {
                    this.direct_renderer.release_direct();
                }
                if (m1 != 0 && this.mousePressed1) {
                    this.mousePressed1 = false;
                    this.z1Pressed = false;
                    this.t1Pressed = false;
                    try {
                        e = new DisplayEvent((Display)this.display, 9, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e19) {
                    }
                    catch (RemoteException e20) {}
                } else if ((m2 != 0 || m3 != 0) && this.mouseCombo1) {
                    this.mouseCombo1 = false;
                    this.z1Pressed = false;
                    this.t1Pressed = false;
                    try {
                        e = new DisplayEvent((Display)this.display, 9, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e21) {
                    }
                    catch (RemoteException e22) {}
                } else if (m2 != 0 && this.mousePressed2) {
                    this.mousePressed2 = false;
                    this.display_renderer.setCursorOn(false);
                    this.z2Pressed = false;
                    this.t2Pressed = false;
                    try {
                        e = new DisplayEvent((Display)this.display, 8, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e23) {
                    }
                    catch (RemoteException e24) {}
                } else if ((m1 != 0 || m3 != 0) && this.mouseCombo2) {
                    this.mouseCombo2 = false;
                    this.display_renderer.setCursorOn(false);
                    this.z2Pressed = false;
                    this.t2Pressed = false;
                    try {
                        e = new DisplayEvent((Display)this.display, 8, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e25) {
                    }
                    catch (RemoteException e26) {}
                } else if (m3 != 0 && this.mousePressed3) {
                    this.mousePressed3 = false;
                    this.display_renderer.setDirectOn(false);
                    this.direct_renderer = null;
                    try {
                        e = new DisplayEvent((Display)this.display, 10, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e27) {
                    }
                    catch (RemoteException e28) {}
                } else if ((m1 != 0 || m2 != 0) && this.mouseCombo3) {
                    this.mouseCombo3 = false;
                    this.display_renderer.setDirectOn(false);
                    this.direct_renderer = null;
                    try {
                        e = new DisplayEvent((Display)this.display, 10, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e29) {
                    }
                    catch (RemoteException e30) {
                        // empty catch block
                    }
                }
                this.mouseModifiers = 0;
                break;
            }
            case 506: {
                VisADRay direct_ray;
                if (!this.mousePressed1 && !this.mousePressed2 && !this.mousePressed3 && !this.mouseCombo1 && !this.mouseCombo2 && !this.mouseCombo3) break;
                this.display.updateBusyStatus();
                Dimension d = ((MouseEvent)event).getComponent().getSize();
                int current_x = ((MouseEvent)event).getX();
                int current_y = ((MouseEvent)event).getY();
                if (this.mousePressed1 || this.mouseCombo1) {
                    double[] t1 = null;
                    if (this.z1Pressed) {
                        double scale = Math.exp((double)(this.start_y - current_y) / (double)d.height);
                        t1 = this.behavior.make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
                    } else if (this.t1Pressed) {
                        double transx = this.xmul * (double)(this.start_x - current_x);
                        double transy = this.ymul * (double)(this.start_y - current_y);
                        t1 = this.behavior.make_translate(-transx, -transy);
                    } else if (!this.mode2D) {
                        double angley = (double)(-(current_x - this.start_x)) * 100.0 / (double)d.width;
                        double anglex = (double)(-(current_y - this.start_y)) * 100.0 / (double)d.height;
                        t1 = this.behavior.make_matrix(anglex, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                    }
                    if (t1 != null) {
                        t1 = this.behavior.multiply_matrix(t1, this.tstart);
                        try {
                            this.proj.setMatrix(t1);
                        }
                        catch (VisADException e) {
                        }
                        catch (RemoteException e) {}
                    }
                } else if (this.mousePressed2 || this.mouseCombo2) {
                    if (this.z2Pressed) {
                        if (!this.mode2D) {
                            float diff = (float)(this.start_y - current_y) * 4.0f / (float)d.height;
                            this.display_renderer.drag_depth(diff);
                        }
                    } else if (this.t2Pressed) {
                        if (!this.mode2D) {
                            double angley = (double)(-(current_x - this.start_x)) * 100.0 / (double)d.width;
                            double anglex = (double)(-(current_y - this.start_y)) * 100.0 / (double)d.height;
                            double[] t1 = this.behavior.make_matrix(anglex, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                            t1 = this.behavior.multiply_matrix(t1, this.tstart);
                            try {
                                this.proj.setMatrix(t1);
                            }
                            catch (VisADException e) {
                            }
                            catch (RemoteException e) {}
                        }
                    } else {
                        VisADRay cursor_ray = this.behavior.findRay(current_x, current_y);
                        if (cursor_ray != null) {
                            this.display_renderer.drag_cursor(cursor_ray, false);
                        }
                    }
                } else if ((this.mousePressed3 || this.mouseCombo3) && this.direct_renderer != null && (direct_ray = this.behavior.findRay(current_x, current_y)) != null) {
                    this.direct_renderer.setLastMouseModifiers(this.mouseModifiers);
                    this.direct_renderer.drag_direct(direct_ray, false, this.mouseModifiers);
                }
                try {
                    DisplayEvent e = new DisplayEvent((Display)this.display, 18, mouse_event, remoteId);
                    this.display.notifyListeners(e);
                }
                catch (VisADException e) {
                }
                catch (RemoteException e) {}
                break;
            }
            case 503: {
                DisplayEvent e;
                try {
                    e = new DisplayEvent((Display)this.display, 21, mouse_event, remoteId);
                    this.display.notifyListeners(e);
                }
                catch (VisADException e31) {
                }
                catch (RemoteException e32) {}
                break;
            }
            default: {
                System.out.println("MouseHelper.processStimulus: event typenot recognized " + event.getID());
            }
        }
    }

    public void print_matrix(String title, double[] m) {
        if (this.behavior == null) {
            return;
        }
        double[] rot = new double[3];
        double[] scale = new double[1];
        double[] trans = new double[3];
        this.behavior.instance_unmake_matrix(rot, scale, trans, m);
        System.out.println(title + " = (" + Convert.shortString(rot[0]) + ", " + Convert.shortString(rot[1]) + ", " + Convert.shortString(rot[2]) + "), " + Convert.shortString(scale[0]) + ", (" + Convert.shortString(trans[0]) + ", " + Convert.shortString(trans[1]) + ", " + Convert.shortString(trans[2]) + ")");
    }

    public void rendererDeleted(DataRenderer renderer) {
        if (this.direct_renderer != null && (this.direct_renderer == renderer || this.direct_renderer.equals(renderer))) {
            this.direct_renderer = null;
        }
    }
}

