/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class IrregularSet
extends SampledSet {
    public Delaunay Delan = null;
    int[] oldToNew;
    int[] newToOld;

    public IrregularSet(MathType type, float[][] samples) throws VisADException {
        this(type, samples, samples.length, null, null, null, null, true);
    }

    public IrregularSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, samples.length, coord_sys, units, errors, null, true);
    }

    public IrregularSet(MathType type, float[][] samples, Delaunay delan) throws VisADException {
        this(type, samples, samples.length, null, null, null, delan, true);
    }

    public IrregularSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan) throws VisADException {
        this(type, samples, samples.length, coord_sys, units, errors, delan, true);
    }

    public IrregularSet(MathType type, float[][] samples, int manifold_dimension, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan) throws VisADException {
        this(type, samples, manifold_dimension, coord_sys, units, errors, delan, true);
    }

    public IrregularSet(MathType type, float[][] samples, int manifold_dimension, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan, boolean copy) throws VisADException {
        super(type, manifold_dimension, coord_sys, units, errors);
        if (samples == null) {
            throw new SetException("IrregularSet: samples cannot be null");
        }
        this.init_samples(samples, copy);
        if (this.ManifoldDimension > 1) {
            this.Delan = delan != null ? (copy ? (Delaunay)delan.clone() : delan) : Delaunay.factory(samples, false);
        }
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        float[][] value = new float[this.DomainDimension][index.length];
        int i = 0;
        while (i < index.length) {
            int j;
            if (index[i] >= 0 && index[i] < this.Length) {
                j = 0;
                while (j < this.DomainDimension) {
                    value[j][i] = this.Samples[j][index[i]];
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.DomainDimension) {
                    value[j][i] = Float.NaN;
                    ++j;
                }
            }
            ++i;
        }
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        throw new UnimplementedException("IrregularSet.valueToIndex");
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        throw new UnimplementedException("IrregularSet.valueToInterp");
    }

    public void getNeighbors(int[][] neighbors) throws VisADException {
        if (this.ManifoldDimension == 1) {
            neighbors[0] = new int[2];
            neighbors[this.Length - 1] = new int[2];
            neighbors[0][0] = 1;
            neighbors[this.Length - 1][0] = this.Length - 2;
            int ii = 1;
            while (ii < this.Length - 1) {
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii - 1;
                neighbors[ii][0] = ii + 1;
                ++ii;
            }
        } else if (this.ManifoldDimension < 4) {
            int[][] Vertices = this.Delan.Vertices;
            int[][] Tri = this.Delan.Tri;
            int n_samples = Vertices.length;
            int ii = 0;
            while (ii < n_samples) {
                int[] indeces = new int[n_samples];
                int n_triangles = Vertices[ii].length;
                int jj = 0;
                while (jj < n_triangles) {
                    int kk = 0;
                    while (kk < Tri[Vertices[ii][jj]].length) {
                        int index = Tri[Vertices[ii][jj]][kk];
                        if (index != ii) {
                            int n = index;
                            indeces[n] = indeces[n] + 1;
                        }
                        ++kk;
                    }
                    ++jj;
                }
                int cnt = 0;
                int tt = 0;
                while (tt < n_samples) {
                    if (indeces[tt] > 0) {
                        ++cnt;
                    }
                    ++tt;
                }
                neighbors[ii] = new int[cnt];
                cnt = 0;
                tt = 0;
                while (tt < n_samples) {
                    if (indeces[tt] > 0) {
                        neighbors[ii][cnt] = tt;
                        ++cnt;
                    }
                    ++tt;
                }
                indeces = null;
                ++ii;
            }
        } else {
            throw new UnimplementedException("getNeighbors(): ManifoldDimension > 3 ");
        }
    }

    public boolean equals(Object set) {
        if (!(set instanceof IrregularSet) || set == null || set instanceof LinearSet) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((IrregularSet)set).getDimension() || this.ManifoldDimension != ((IrregularSet)set).getManifoldDimension() || this.Length != ((IrregularSet)set).getLength()) {
                return false;
            }
            float[][] samples = ((IrregularSet)set).getSamples(false);
            int j = 0;
            while (j < this.DomainDimension) {
                int i = 0;
                while (i < this.Length) {
                    if (this.Samples[j][i] != samples[j][i]) {
                        this.addNotEqualsCache((Set)set);
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public Object clone() {
        try {
            return new IrregularSet(this.Type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
        }
        catch (VisADException e) {
            throw new VisADError("IrregularSet.clone: " + e.toString());
        }
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new IrregularSet(type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
    }

    public String longString(String pre) throws VisADException {
        String s;
        if (this.DomainDimension == this.ManifoldDimension) {
            s = pre + this.getClass().getName() + ": Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
            int j = 0;
            while (j < this.DomainDimension) {
                s = s + pre + "  Dimension " + j + ":" + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
                ++j;
            }
        } else {
            s = pre + this.getClass().getName() + ": DomainDimension = " + this.DomainDimension + " ManifoldDimension = " + this.ManifoldDimension + " Length = " + this.Length + "\n";
            int j = 0;
            while (j < this.DomainDimension) {
                s = s + pre + "  DomainDimension " + j + ":" + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
                ++j;
            }
        }
        return s;
    }
}

