/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSetIface;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Gridded1DSet
extends GriddedSet
implements Gridded1DSetIface {
    int LengthX;
    float LowX;
    float HiX;
    boolean Ascending;
    private static final WeakHashMap cache = new WeakHashMap();
    private int ig;

    public Gridded1DSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null);
    }

    public Gridded1DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded1DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        block8: {
            super(type, samples, Gridded1DSet.make_lengths(lengthX), coord_sys, units, errors, copy);
            this.ig = -1;
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.LengthX = this.Lengths[0];
            if (this.Samples == null || this.Lengths[0] <= 1) break block8;
            int i = 0;
            while (i < this.Length) {
                if (this.Samples[0][i] != this.Samples[0][i]) {
                    throw new SetException("Gridded1DSet: samples values may not be missing");
                }
                ++i;
            }
            boolean bl = this.Ascending = this.Samples[0][this.LengthX - 1] > this.Samples[0][0];
            if (this.Ascending) {
                int i2 = 1;
                while (i2 < this.LengthX) {
                    if (this.Samples[0][i2] < this.Samples[0][i2 - 1]) {
                        throw new SetException("Gridded1DSet: samples do not form a valid grid (" + i2 + ")");
                    }
                    ++i2;
                }
            } else {
                int i3 = 1;
                while (i3 < this.LengthX) {
                    if (this.Samples[0][i3] > this.Samples[0][i3 - 1]) {
                        throw new SetException("Gridded1DSet: samples do not form a valid grid (" + i3 + ")");
                    }
                    ++i3;
                }
            }
        }
    }

    public static synchronized Gridded1DSet create(MathType type, float[] samples, CoordinateSystem coordSys, Unit unit, ErrorEstimate error) throws VisADException {
        Gridded1DSet newSet = new Gridded1DSet(type, (float[][])new float[][]{samples}, samples.length, coordSys, new Unit[]{unit}, new ErrorEstimate[]{error}, false);
        WeakReference ref = (WeakReference)cache.get(newSet);
        if (ref == null) {
            cache.put(newSet, new WeakReference<Gridded1DSet>(newSet));
        } else {
            Gridded1DSet oldSet = (Gridded1DSet)ref.get();
            if (oldSet == null) {
                cache.put(newSet, new WeakReference<Gridded1DSet>(newSet));
            } else {
                newSet = oldSet;
            }
        }
        return newSet;
    }

    static int[] make_lengths(int lengthX) {
        int[] lens = new int[]{lengthX};
        return lens;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            float[][] grid = new float[this.ManifoldDimension][length];
            int i = 0;
            while (i < length) {
                grid[0][i] = 0 <= index[i] && index[i] < this.Length ? (float)index[i] : -1.0f;
                ++i;
            }
            return this.gridToValue(grid);
        }
        float[][] values = new float[1][length];
        int i = 0;
        while (i < length) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? this.Samples[0][index[i]] : Float.NaN;
            ++i;
        }
        return values;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded1DSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        float[][] grid = this.valueToGrid(value);
        float[] grid0 = grid[0];
        int i = 0;
        while (i < length) {
            float g = grid0[i];
            index[i] = Float.isNaN(g) ? -1 : (int)((double)g + 0.5);
            ++i;
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length < this.DomainDimension) {
            throw new SetException("Gridded1DSet.gridToValue: grid dimension " + grid.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int length = grid[0].length;
        float[][] value = new float[1][length];
        int i = 0;
        while (i < length) {
            float g = grid[0][i];
            if ((double)g < -0.5 || (double)g > (double)this.LengthX - 0.5) {
                value[0][i] = Float.NaN;
            } else {
                int ig = g < 0.0f ? 0 : (g >= (float)(this.LengthX - 1) ? this.LengthX - 2 : (int)g);
                float A = g - (float)ig;
                value[0][i] = (1.0f - A) * this.Samples[0][ig] + A * this.Samples[0][ig + 1];
            }
            ++i;
        }
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded1DSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        float[] vals = value[0];
        int length = vals.length;
        float[] samps = this.Samples[0];
        float[][] grid = new float[1][length];
        if (this.ig < 0 || this.ig >= this.LengthX) {
            this.ig = (this.LengthX - 1) / 2;
        }
        int i = 0;
        while (i < length) {
            if (Float.isNaN(vals[i])) {
                grid[0][i] = Float.NaN;
            } else {
                float solv;
                int lower = 0;
                int upper = this.LengthX - 1;
                while (lower < upper) {
                    if ((vals[i] - samps[this.ig]) * (vals[i] - samps[this.ig + 1]) <= 0.0f) break;
                    boolean bl = this.Ascending ? samps[this.ig + 1] < vals[i] : samps[this.ig + 1] > vals[i];
                    if (bl) {
                        lower = this.ig + 1;
                    } else {
                        boolean bl2 = this.Ascending ? samps[this.ig] > vals[i] : samps[this.ig] < vals[i];
                        if (bl2) {
                            upper = this.ig;
                        }
                    }
                    if (lower >= upper) continue;
                    this.ig = (lower + upper) / 2;
                }
                if ((double)(solv = (float)this.ig + (vals[i] - samps[this.ig]) / (samps[this.ig + 1] - samps[this.ig])) > -0.5 && (double)solv < (double)this.LengthX - 0.5) {
                    grid[0][i] = solv;
                } else {
                    grid[0][i] = Float.NaN;
                    this.ig = (this.LengthX - 1) / 2;
                }
            }
            ++i;
        }
        return grid;
    }

    public int getLengthX() {
        return this.LengthX;
    }

    public float getLowX() {
        return this.LowX;
    }

    public float getHiX() {
        return this.HiX;
    }

    public boolean isAscending() {
        return this.Ascending;
    }

    public Object clone() {
        try {
            return new Gridded1DSet(this.Type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException e) {
            throw new VisADError("Gridded1DSet.clone: " + e.toString());
        }
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new Gridded1DSet(type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] args) throws VisADException {
        InputStreamReader inStr = new InputStreamReader(System.in);
        int[] ints = new int[80];
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e) {
            System.out.println("Gridded1DSet: " + e);
        }
        int l = 0;
        while (ints[l] != 10) {
            try {
                ints[++l] = inStr.read();
            }
            catch (Exception e) {
                System.out.println("Gridded1DSet: " + e);
            }
        }
        char[] chars = new char[l];
        int i = 0;
        while (i < l) {
            chars[i] = (char)ints[i];
            ++i;
        }
        int num_coords = Integer.parseInt(new String(chars));
        float[][] samp = new float[1][num_coords];
        System.out.println("num_dimensions = 1, num_coords = " + num_coords + "\n");
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e) {
            System.out.println("Gridded1DSet: " + e);
        }
        int c = 0;
        while (c < num_coords) {
            l = 0;
            try {
                ints[0] = inStr.read();
            }
            catch (Exception e) {
                System.out.println("Gridded1DSet: " + e);
            }
            while (ints[l] != 32) {
                try {
                    ints[++l] = inStr.read();
                }
                catch (Exception e) {
                    System.out.println("Gridded1DSet: " + e);
                }
            }
            chars = new char[l];
            int i2 = 0;
            while (i2 < l) {
                chars[i2] = (char)ints[i2];
                ++i2;
            }
            samp[0][c] = Float.valueOf(new String(chars)).floatValue();
            ++c;
        }
        try {
            inStr.close();
        }
        catch (Exception e) {
            System.out.println("Gridded1DSet: " + e);
        }
        RealType vis_data = RealType.getRealType("vis_data");
        RealType[] vis_array = new RealType[]{vis_data};
        RealTupleType vis_tuple = new RealTupleType(vis_array);
        Gridded1DSet gSet1D = new Gridded1DSet((MathType)vis_tuple, samp, num_coords);
        System.out.println("Lengths = " + num_coords + " wedge = ");
        int[] wedge = gSet1D.getWedge();
        int i3 = 0;
        while (i3 < wedge.length) {
            System.out.println(" " + wedge[i3]);
            ++i3;
        }
        System.out.println("Samples (" + gSet1D.LengthX + "):");
        int i4 = 0;
        while (i4 < gSet1D.LengthX) {
            System.out.println("#" + i4 + ":\t" + gSet1D.Samples[0][i4]);
            ++i4;
        }
        System.out.println("\ngridToValue test:");
        int myLength = gSet1D.LengthX + 1;
        float[][] myGrid = new float[1][myLength];
        int i5 = 0;
        while (i5 < myLength) {
            myGrid[0][i5] = (float)i5 - 0.5f;
            ++i5;
        }
        float[] fArray = myGrid[0];
        fArray[0] = (float)((double)fArray[0] + 0.1);
        float[] fArray2 = myGrid[0];
        int n = myLength - 1;
        fArray2[n] = (float)((double)fArray2[n] - 0.1);
        float[][] myValue = gSet1D.gridToValue(myGrid);
        int i6 = 0;
        while (i6 < myLength) {
            System.out.println("(" + (float)Math.round(1000000.0f * myGrid[0][i6]) / 1000000.0f + ")\t-->  " + (float)Math.round(1000000.0f * myValue[0][i6]) / 1000000.0f);
            ++i6;
        }
        System.out.println("\nvalueToGrid test:");
        float[][] gridTwo = gSet1D.valueToGrid(myValue);
        int i7 = 0;
        while (i7 < gridTwo[0].length) {
            System.out.println((float)Math.round(1000000.0f * myValue[0][i7]) / 1000000.0f + "  \t-->  (" + (float)Math.round(1000000.0f * gridTwo[0][i7]) / 1000000.0f + ")");
            ++i7;
        }
        System.out.println();
    }
}

