/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowType;
import visad.SingletonSet;
import visad.TextType;
import visad.TupleType;
import visad.TypeException;
import visad.VisADException;

public class FunctionType
extends MathType {
    private RealTupleType Domain;
    private MathType Range;
    private RealTupleType FlatRange;
    private boolean Real;
    private boolean Flat;
    private RealType[] realComponents;
    private TextType[] textComponents;
    private int[] textIndices;
    public static final FunctionType REAL_1TO1_FUNCTION = new FunctionType(RealType.Generic, RealType.Generic, true);
    private static RealType[] real3 = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic};
    public static final FunctionType REAL_1TO3_FUNCTION = new FunctionType(RealType.Generic, new RealTupleType(real3, true), true);
    private static RealType[] real4 = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic, RealType.Generic};
    public static final FunctionType REAL_1TO4_FUNCTION = new FunctionType(RealType.Generic, new RealTupleType(real4, true), true);

    public FunctionType(MathType domain, MathType range) throws VisADException {
        if (!(domain instanceof RealTupleType) && !(domain instanceof RealType)) {
            throw new TypeException("FunctionType: domain must be RealTupleType or RealType");
        }
        this.Domain = FunctionType.makeFlat(domain);
        this.Real = range instanceof RealType || range instanceof RealTupleType;
        this.Flat = this.Real || range instanceof TupleType && ((TupleType)range).getFlat();
        this.Range = range;
        this.FlatRange = this.Flat ? FunctionType.makeFlat(range) : null;
        this.realComponents = FunctionType.getComponents(this.Range);
        this.makeTextComponents();
    }

    FunctionType(MathType domain, MathType range, boolean b) {
        super(b);
        this.Domain = FunctionType.makeFlatTrusted(domain);
        this.Real = range instanceof RealType || range instanceof RealTupleType;
        this.Flat = this.Real || range instanceof TupleType && ((TupleType)range).getFlat();
        this.Range = range;
        this.FlatRange = this.Flat ? FunctionType.makeFlatTrusted(range) : null;
        this.realComponents = FunctionType.getComponents(this.Range);
        this.makeTextComponents();
    }

    private void makeTextComponents() {
        int n = 0;
        this.textComponents = null;
        this.textIndices = null;
        if (this.Range instanceof TextType) {
            this.textComponents = new TextType[]{(TextType)this.Range};
            this.textIndices = new int[]{0};
            n = 1;
        } else if (this.Range instanceof TupleType) {
            try {
                int i = 0;
                while (i < ((TupleType)this.Range).getDimension()) {
                    if (((TupleType)this.Range).getComponent(i) instanceof TextType) {
                        ++n;
                    }
                    ++i;
                }
                if (n == 0) {
                    return;
                }
                this.textComponents = new TextType[n];
                this.textIndices = new int[n];
                int j = 0;
                int i2 = 0;
                while (i2 < ((TupleType)this.Range).getDimension()) {
                    if (((TupleType)this.Range).getComponent(i2) instanceof TextType) {
                        this.textComponents[j] = (TextType)((TupleType)this.Range).getComponent(i2);
                        this.textIndices[j] = i2;
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (VisADException e) {
                this.textComponents = null;
                this.textIndices = null;
            }
        }
    }

    public TextType[] getTextComponents() {
        return this.textComponents;
    }

    public int[] getTextIndices() {
        return this.textIndices;
    }

    private static RealType[] getComponents(MathType type) {
        if (type instanceof RealType) {
            RealType[] r = new RealType[]{(RealType)type};
            return r;
        }
        if (type instanceof TupleType) {
            return ((TupleType)type).getRealComponents();
        }
        return null;
    }

    private static RealTupleType makeFlat(MathType type) throws VisADException {
        if (type instanceof RealTupleType) {
            return (RealTupleType)type;
        }
        if (type instanceof RealType) {
            RealType[] types = new RealType[]{(RealType)type};
            return new RealTupleType(types, null, ((RealType)type).getDefaultSet());
        }
        if (type instanceof TupleType && ((TupleType)type).getFlat()) {
            return new RealTupleType(((TupleType)type).getRealComponents());
        }
        throw new TypeException("FunctionType: illegal input to makeFlat");
    }

    private static RealTupleType makeFlatTrusted(MathType type) {
        if (type instanceof RealTupleType) {
            return (RealTupleType)type;
        }
        if (type instanceof RealType) {
            RealType[] types = new RealType[]{(RealType)type};
            return new RealTupleType(types, true);
        }
        if (type instanceof TupleType && ((TupleType)type).getFlat()) {
            return new RealTupleType(((TupleType)type).getRealComponents(), true);
        }
        return null;
    }

    public RealTupleType getDomain() {
        return this.Domain;
    }

    public MathType getRange() {
        return this.Range;
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public boolean getReal() {
        return this.Real;
    }

    public RealTupleType getFlatRange() {
        return this.FlatRange;
    }

    public RealType[] getRealComponents() {
        return this.realComponents;
    }

    public boolean equals(Object type) {
        if (!(type instanceof FunctionType)) {
            return false;
        }
        return this.Domain.equals(((FunctionType)type).getDomain()) && this.Range.equals(((FunctionType)type).getRange());
    }

    public int hashCode() {
        return this.Domain.hashCode() ^ this.Range.hashCode();
    }

    public boolean equalsExceptName(MathType type) {
        if (!(type instanceof FunctionType)) {
            return false;
        }
        return this.Domain.equalsExceptName(((FunctionType)type).getDomain()) && this.Range.equalsExceptName(((FunctionType)type).getRange());
    }

    public boolean equalsExceptNameButUnits(MathType type) throws VisADException {
        if (!(type instanceof FunctionType)) {
            return false;
        }
        return this.Domain.equalsExceptNameButUnits(((FunctionType)type).getDomain()) && this.Range.equalsExceptNameButUnits(((FunctionType)type).getRange());
    }

    public MathType cloneDerivative(RealType d_partial) throws VisADException {
        return new FunctionType(this.Domain, this.Range.cloneDerivative(d_partial));
    }

    public MathType binary(MathType type, int op, Vector names) throws VisADException {
        if (type == null) {
            throw new TypeException("FunctionType.binary: type may not be null");
        }
        if (this.equalsExceptName(type)) {
            return new FunctionType(this.Domain, this.Range.binary(((FunctionType)type).getRange(), op, names));
        }
        if (type instanceof RealType || this.getRange().equalsExceptName(type)) {
            return new FunctionType(this.Domain, this.Range.binary(type, op, names));
        }
        if (type instanceof FunctionType && ((FunctionType)type).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)type).getDomain(), ((FunctionType)type).getRange().binary(this, DataImpl.invertOp(op), names));
        }
        throw new TypeException("FunctionType.binary: types don't match");
    }

    public MathType unary(int op, Vector names) throws VisADException {
        return new FunctionType(this.Domain, this.Range.unary(op, names));
    }

    public String prettyString(int indent) {
        String ds = "(" + this.Domain.prettyString(indent) + " -> ";
        int n = ds.length();
        String rs = this.Range.prettyString(indent + n) + ")";
        return ds + rs;
    }

    public Data missingData() throws VisADException, RemoteException {
        int n = this.Domain.getDimension();
        double[] values = new double[n];
        int i = 0;
        while (i < n) {
            values[i] = 0.0;
            ++i;
        }
        RealTuple tuple = new RealTuple(this.Domain, values);
        SingletonSet domainSet = new SingletonSet(tuple);
        return this.getFlat() ? new FlatField(this, domainSet) : new FieldImpl(this, domainSet);
    }

    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowFunctionType(this, link, parent);
    }
}

