/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Random;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatFieldIface;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearSet;
import visad.MathType;
import visad.PromiscuousUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class FlatField
extends FieldImpl
implements FlatFieldIface {
    private int TupleDimension;
    private Set[] RangeSet;
    private int[] RangeMode;
    private CoordinateSystem RangeCoordinateSystem;
    private CoordinateSystem[] RangeCoordinateSystems;
    private boolean MissingFlag;
    private Unit[] RangeUnits;
    private ErrorEstimate[] RangeErrors;
    private double[][] DoubleRange;
    private float[][] FloatRange;
    private long[][] LongRange;
    private int[][] IntRange;
    private short[][] ShortRange;
    private byte[][] ByteRange;
    private static final int MISSING1 = -128;
    private static final int MISSING2 = Short.MIN_VALUE;
    private static final int MISSING4 = Integer.MIN_VALUE;
    private static final int DOUBLE = 1;
    private static final int FLOAT = 2;
    private static final int LONG = 3;
    private static final int INT = 4;
    private static final int SHORT = 5;
    private static final int BYTE = 6;

    public FlatField(FunctionType type) throws VisADException {
        this(type, type.getDomain().getDefaultSet(), null, null, null, null);
    }

    public FlatField(FunctionType type, Set domain_set) throws VisADException {
        this(type, domain_set, null, null, null, null);
    }

    public FlatField(FunctionType type, Set domain_set, CoordinateSystem range_coord_sys, Set[] range_sets, Unit[] units) throws VisADException {
        this(type, domain_set, range_coord_sys, null, range_sets, units);
    }

    public FlatField(FunctionType type, Set domain_set, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException {
        this(type, domain_set, null, range_coord_syses, range_sets, units);
    }

    public FlatField(FunctionType type, Set domain_set, CoordinateSystem range_coord_sys, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException {
        super(type, domain_set);
        int i;
        int i2;
        if (!type.getFlat()) {
            throw new FieldException("FlatField: FunctionType must be Flat");
        }
        MathType RangeType = type.getRange();
        RealTupleType FlatRange = type.getFlatRange();
        this.TupleDimension = FlatRange.getDimension();
        this.DoubleRange = new double[this.TupleDimension][];
        this.RangeSet = new Set[this.TupleDimension];
        this.RangeMode = new int[this.TupleDimension];
        if (range_sets == null) {
            i2 = 0;
            while (i2 < this.TupleDimension) {
                this.RangeSet[i2] = ((RealType)FlatRange.getComponent(i2)).getDefaultSet();
                if (this.RangeSet[i2] == null) {
                    this.RangeSet[i2] = new FloatSet(new SetType(FlatRange.getComponent(i2)));
                }
                ++i2;
            }
        } else {
            if (this.TupleDimension != range_sets.length) {
                throw new SetException("FlatField: range set dimensions don't match");
            }
            i2 = 0;
            while (i2 < this.TupleDimension) {
                if (range_sets[i2] == null || range_sets[i2].getDimension() != 1) {
                    throw new SetException("FlatField: each range set dimension must be 1");
                }
                ++i2;
            }
            i = 0;
            while (i < this.TupleDimension) {
                this.RangeSet[i] = FlatRange.getComponent(i).equals(((SetType)range_sets[i].getType()).getDomain()) ? range_sets[i] : (Set)range_sets[i].cloneButType(new SetType(FlatRange.getComponent(i)));
                ++i;
            }
        }
        this.nullRanges();
        if (type.getReal()) {
            if (range_coord_syses != null) {
                throw new CoordinateSystemException("FlatField: Real Function Type requires single range coordinate system");
            }
            this.RangeCoordinateSystems = null;
            this.RangeCoordinateSystem = FlatRange.getCoordinateSystem();
            if (range_coord_sys != null) {
                if (!(RangeType instanceof RealTupleType)) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys supplied, but RangeType is not RealTupleType");
                }
                if (this.RangeCoordinateSystem == null || !this.RangeCoordinateSystem.getReference().equals(range_coord_sys.getReference())) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys " + (range_coord_sys == null ? null : range_coord_sys.getReference()) + " must match" + " default range CoordinateSystem " + (this.RangeCoordinateSystem == null ? null : this.RangeCoordinateSystem.getReference()));
                }
                this.RangeCoordinateSystem = range_coord_sys;
            }
            if (units == null) {
                this.RangeUnits = this.RangeCoordinateSystem == null ? FlatRange.getDefaultUnits() : this.RangeCoordinateSystem.getCoordinateSystemUnits();
            } else {
                if (units.length != this.TupleDimension) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.RangeUnits = new Unit[this.TupleDimension];
                i = 0;
                while (i < this.TupleDimension) {
                    RealType componentType = (RealType)FlatRange.getComponent(i);
                    Unit componentUnit = units[i];
                    this.RangeUnits[i] = componentUnit == null || !componentType.isInterval() ? componentUnit : componentUnit.getAbsoluteUnit();
                    ++i;
                }
            }
            Unit[] type_units = RangeType instanceof RealTupleType ? ((RealTupleType)RangeType).getDefaultUnits() : new Unit[]{((RealType)RangeType).getDefaultUnit()};
            if (this.RangeCoordinateSystem != null && !Unit.canConvertArray(this.RangeCoordinateSystem.getCoordinateSystemUnits(), type_units)) {
                throw new UnitException("FlatField: RangeCoordinateSystem Units must be convertable with RangeType default Units");
            }
            if (this.RangeCoordinateSystem != null && !Unit.canConvertArray(this.RangeCoordinateSystem.getCoordinateSystemUnits(), this.RangeUnits)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystem Units");
            }
            if (!Unit.canConvertArray(type_units, this.RangeUnits)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
            }
        } else {
            int j;
            if (range_coord_sys != null) {
                throw new CoordinateSystemException("FlatField: non-Real Function Type requires multiple range coordinate systems");
            }
            this.RangeCoordinateSystem = null;
            int n = ((TupleType)RangeType).getDimension();
            this.RangeCoordinateSystems = new CoordinateSystem[n];
            int i3 = 0;
            while (i3 < n) {
                MathType component = ((TupleType)RangeType).getComponent(i3);
                if (component instanceof RealTupleType) {
                    this.RangeCoordinateSystems[i3] = ((RealTupleType)component).getCoordinateSystem();
                    if (range_coord_syses != null && range_coord_syses[i3] != null) {
                        if (this.RangeCoordinateSystems[i3] == null || this.RangeCoordinateSystems[i3].getReference() != range_coord_syses[i3].getReference()) {
                            throw new TypeException("FlatField: range_coord_syses must match Range DefaultCoordinateSystem");
                        }
                        this.RangeCoordinateSystems[i3] = range_coord_syses[i3];
                    }
                } else {
                    this.RangeCoordinateSystems[i3] = null;
                }
                ++i3;
            }
            if (units == null) {
                this.RangeUnits = FlatRange.getDefaultUnits();
                j = 0;
                int i4 = 0;
                while (i4 < n) {
                    MathType component;
                    if (this.RangeCoordinateSystems[i4] != null) {
                        Unit[] sub_range_units = this.RangeCoordinateSystems[i4].getCoordinateSystemUnits();
                        int k = 0;
                        while (k < sub_range_units.length) {
                            this.RangeUnits[j + k] = sub_range_units[k];
                            ++k;
                        }
                    }
                    if ((component = ((TupleType)RangeType).getComponent(i4)) instanceof RealType) {
                        ++j;
                    } else if (component instanceof RealTupleType) {
                        j += ((RealTupleType)component).getDimension();
                    }
                    ++i4;
                }
            } else {
                if (units.length != this.TupleDimension) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.RangeUnits = new Unit[this.TupleDimension];
                int i5 = 0;
                while (i5 < this.TupleDimension) {
                    RealType componentType = (RealType)FlatRange.getComponent(i5);
                    Unit componentUnit = units[i5];
                    this.RangeUnits[i5] = componentUnit == null || !componentType.isInterval() ? componentUnit : componentUnit.getAbsoluteUnit();
                    ++i5;
                }
            }
            j = 0;
            int i6 = 0;
            while (i6 < n) {
                Unit[] sub_range_units;
                int m;
                Unit[] sub_type_units;
                MathType component = ((TupleType)RangeType).getComponent(i6);
                if (component instanceof RealTupleType) {
                    sub_type_units = ((RealTupleType)component).getDefaultUnits();
                    m = ((RealTupleType)component).getDimension();
                    sub_range_units = new Unit[m];
                    int k = 0;
                    while (k < m) {
                        sub_range_units[k] = this.RangeUnits[j + k];
                        ++k;
                    }
                } else {
                    sub_type_units = new Unit[]{((RealType)component).getDefaultUnit()};
                    m = 1;
                    sub_range_units = new Unit[]{this.RangeUnits[j]};
                }
                if (this.RangeCoordinateSystems[i6] != null && !Unit.canConvertArray(sub_type_units, this.RangeCoordinateSystems[i6].getCoordinateSystemUnits())) {
                    throw new UnitException("FlatField: RangeCoordinateSystems Units must be convertable with RangeType default Units");
                }
                if (this.RangeCoordinateSystems[i6] != null && !Unit.canConvertArray(sub_range_units, this.RangeCoordinateSystems[i6].getCoordinateSystemUnits())) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystems Units");
                }
                if (!Unit.canConvertArray(sub_type_units, sub_range_units)) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
                }
                j += m;
                ++i6;
            }
        }
        if (this.RangeUnits == null) {
            this.RangeUnits = new Unit[this.TupleDimension];
        }
        this.RangeErrors = new ErrorEstimate[this.TupleDimension];
        this.MissingFlag = true;
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws TypeException {
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (!((FunctionType)this.Type).getReal()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is not Real, need DefaultCoordinateSystem index");
        }
        CoordinateSystem[] cs = new CoordinateSystem[]{this.RangeCoordinateSystem};
        return cs;
    }

    public Set[] getRangeSets() {
        Set[] sets = new Set[this.RangeSet.length];
        System.arraycopy(this.RangeSet, 0, sets, 0, sets.length);
        return sets;
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int i) throws TypeException {
        if (((FunctionType)this.Type).getReal()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is Real, cannot specify CoordinateSystem index");
        }
        CoordinateSystem[] cs = new CoordinateSystem[]{this.RangeCoordinateSystems[i]};
        return cs;
    }

    public Unit[][] getRangeUnits() {
        Unit[][] units = new Unit[this.RangeUnits.length][1];
        int i = 0;
        while (i < this.RangeUnits.length) {
            units[i][0] = this.RangeUnits[i];
            ++i;
        }
        return units;
    }

    public ErrorEstimate[] getRangeErrors() {
        ErrorEstimate[] errorEstimateArray = this.RangeErrors;
        synchronized (errorEstimateArray) {
            ErrorEstimate[] errorEstimateArray2 = ErrorEstimate.copyErrorsArray(this.RangeErrors);
            return errorEstimateArray2;
        }
    }

    public void setRangeErrors(ErrorEstimate[] errors) throws VisADException {
        ErrorEstimate[] errorEstimateArray = this.RangeErrors;
        synchronized (errorEstimateArray) {
            if (errors == null) {
                int i = 0;
                while (i < this.TupleDimension) {
                    this.RangeErrors[i] = null;
                    ++i;
                }
            } else {
                if (errors.length != this.TupleDimension) {
                    throw new FieldException("FlatField.setRangeErrors: errors dimension does not match");
                }
                int i = 0;
                while (i < this.TupleDimension) {
                    this.RangeErrors[i] = errors[i];
                    ++i;
                }
            }
        }
    }

    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        if (range.length != this.Length) {
            throw new FieldException("setSamples: bad Data[] length");
        }
        int i = 0;
        while (i < this.Length) {
            this.setSample(i, range[i]);
            ++i;
        }
    }

    public void setSamples(double[][] range) throws VisADException, RemoteException {
        this.setSamples(range, null, true);
    }

    public void setSamples(float[][] range) throws VisADException, RemoteException {
        this.setSamples(range, (ErrorEstimate[])null, true);
    }

    public void setSamples(double[][] range, boolean copy) throws VisADException, RemoteException {
        this.setSamples(range, null, copy);
    }

    public void setSamples(float[][] range, boolean copy) throws VisADException, RemoteException {
        this.setSamples(range, (ErrorEstimate[])null, copy);
    }

    public void setSamples(double[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        if (range.length != this.TupleDimension || errors != null && errors.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int i = 0;
        while (i < this.TupleDimension) {
            if (range[i].length != this.Length) {
                throw new FieldException("setSamples: bad array length");
            }
            ++i;
        }
        this.packValues(range, copy);
        this.setRangeErrors(errors);
        this.notifyReferences();
    }

    public void setSamples(int start, double[][] range) throws VisADException, RemoteException {
        if (range.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int i = 0;
        while (i < this.TupleDimension) {
            if (range[i].length + start > this.Length) {
                throw new FieldException("setSamples: bad array length");
            }
            ++i;
        }
        boolean copy = false;
        int length = range[0].length;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            int i2 = 0;
            while (i2 < this.TupleDimension) {
                double[] rangeI = range[i2];
                double[][] range1 = new double[][]{rangeI};
                switch (this.RangeMode[i2]) {
                    case 1: {
                        if (this.DoubleRange[i2] == null) {
                            this.DoubleRange[i2] = new double[this.Length];
                        }
                        double[] DoubleRangeI = this.DoubleRange[i2];
                        System.arraycopy(rangeI, 0, DoubleRangeI, start, length);
                        break;
                    }
                    case 2: {
                        if (this.FloatRange[i2] == null) {
                            this.FloatRange[i2] = new float[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.FloatRange[i2][j] = Float.NaN;
                                ++j;
                            }
                        }
                        float[] FloatRangeI = this.FloatRange[i2];
                        int j = 0;
                        while (j < length) {
                            FloatRangeI[start + j] = (float)rangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 6: {
                        int[] index = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ByteRange[i2] == null) {
                            this.ByteRange[i2] = new byte[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.ByteRange[i2][j] = -128;
                                ++j;
                            }
                        }
                        byte[] ByteRangeI = this.ByteRange[i2];
                        int j = 0;
                        while (j < length) {
                            ByteRangeI[start + j] = (byte)(index[j] + -128 + 1);
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        int[] index = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ShortRange[i2] == null) {
                            this.ShortRange[i2] = new short[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.ShortRange[i2][j] = Short.MIN_VALUE;
                                ++j;
                            }
                        }
                        short[] ShortRangeI = this.ShortRange[i2];
                        int j = 0;
                        while (j < length) {
                            ShortRangeI[start + j] = (short)(index[j] + Short.MIN_VALUE + 1);
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        int[] index = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(range1));
                        if (this.IntRange[i2] == null) {
                            this.IntRange[i2] = new int[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.IntRange[i2][j] = Integer.MIN_VALUE;
                                ++j;
                            }
                        }
                        int[] IntRangeI = this.IntRange[i2];
                        int j = 0;
                        while (j < length) {
                            IntRangeI[start + j] = index[j] + Integer.MIN_VALUE + 1;
                            ++j;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++i2;
            }
            this.clearMissing();
        }
        this.setRangeErrors(null);
        this.notifyReferences();
    }

    public void setSamples(int[] indices, double[][] range) throws VisADException, RemoteException {
        int length = indices.length;
        if (range.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        if (length > this.Length) {
            throw new FieldException("setSamples: indices array too long");
        }
        int i = 0;
        while (i < this.TupleDimension) {
            if (range[i].length != length) {
                throw new FieldException("setSamples: bad data array length");
            }
            ++i;
        }
        boolean copy = false;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            int i2 = 0;
            while (i2 < this.TupleDimension) {
                double[] rangeI = range[i2];
                double[][] range1 = new double[][]{rangeI};
                switch (this.RangeMode[i2]) {
                    case 1: {
                        if (this.DoubleRange[i2] == null) {
                            this.DoubleRange[i2] = new double[this.Length];
                        }
                        double[] DoubleRangeI = this.DoubleRange[i2];
                        int j = 0;
                        while (j < length) {
                            DoubleRangeI[indices[j]] = rangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        if (this.FloatRange[i2] == null) {
                            this.FloatRange[i2] = new float[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.FloatRange[i2][j] = Float.NaN;
                                ++j;
                            }
                        }
                        float[] FloatRangeI = this.FloatRange[i2];
                        int j = 0;
                        while (j < length) {
                            FloatRangeI[indices[j]] = (float)rangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 6: {
                        int[] index = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ByteRange[i2] == null) {
                            this.ByteRange[i2] = new byte[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.ByteRange[i2][j] = -128;
                                ++j;
                            }
                        }
                        byte[] ByteRangeI = this.ByteRange[i2];
                        int j = 0;
                        while (j < length) {
                            ByteRangeI[indices[j]] = (byte)(index[j] + -128 + 1);
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        int[] index = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ShortRange[i2] == null) {
                            this.ShortRange[i2] = new short[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.ShortRange[i2][j] = Short.MIN_VALUE;
                                ++j;
                            }
                        }
                        short[] ShortRangeI = this.ShortRange[i2];
                        int j = 0;
                        while (j < length) {
                            ShortRangeI[indices[j]] = (short)(index[j] + Short.MIN_VALUE + 1);
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        int[] index = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(range1));
                        if (this.IntRange[i2] == null) {
                            this.IntRange[i2] = new int[this.Length];
                            int j = 0;
                            while (j < this.Length) {
                                this.IntRange[i2][j] = Integer.MIN_VALUE;
                                ++j;
                            }
                        }
                        int[] IntRangeI = this.IntRange[i2];
                        int j = 0;
                        while (j < length) {
                            IntRangeI[indices[j]] = index[j] + Integer.MIN_VALUE + 1;
                            ++j;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++i2;
            }
            this.clearMissing();
        }
        this.setRangeErrors(null);
        this.notifyReferences();
    }

    public void setSamples(float[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        if (range.length != this.TupleDimension || errors != null && errors.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int i = 0;
        while (i < this.TupleDimension) {
            if (range[i].length != this.Length) {
                throw new FieldException("setSamples: bad array length");
            }
            ++i;
        }
        this.packValues(range, copy);
        this.setRangeErrors(errors);
        this.notifyReferences();
    }

    private void packValues(double[][] range, boolean copy) throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            this.nullRanges();
            int i = 0;
            while (i < this.TupleDimension) {
                double[] rangeI = range[i];
                double[][] range1 = new double[][]{rangeI};
                switch (this.RangeMode[i]) {
                    case 1: {
                        if (copy) {
                            this.DoubleRange[i] = new double[this.Length];
                            double[] DoubleRangeI = this.DoubleRange[i];
                            System.arraycopy(rangeI, 0, DoubleRangeI, 0, this.Length);
                            break;
                        }
                        this.DoubleRange[i] = rangeI;
                        break;
                    }
                    case 2: {
                        this.FloatRange[i] = new float[this.Length];
                        float[] FloatRangeI = this.FloatRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            FloatRangeI[j] = (float)rangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 6: {
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        this.ByteRange[i] = new byte[this.Length];
                        byte[] ByteRangeI = this.ByteRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            ByteRangeI[j] = (byte)(index[j] + -128 + 1);
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        this.ShortRange[i] = new short[this.Length];
                        short[] ShortRangeI = this.ShortRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            ShortRangeI[j] = (short)(index[j] + Short.MIN_VALUE + 1);
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        this.IntRange[i] = new int[this.Length];
                        int[] IntRangeI = this.IntRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            IntRangeI[j] = index[j] + Integer.MIN_VALUE + 1;
                            ++j;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++i;
            }
            this.clearMissing();
        }
    }

    private void packValues(float[][] range, boolean copy) throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            this.nullRanges();
            int i = 0;
            while (i < this.TupleDimension) {
                float[] rangeI = range[i];
                float[][] range1 = new float[][]{rangeI};
                switch (this.RangeMode[i]) {
                    case 1: {
                        this.DoubleRange[i] = new double[this.Length];
                        double[] DoubleRangeI = this.DoubleRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            DoubleRangeI[j] = rangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        if (copy) {
                            this.FloatRange[i] = new float[this.Length];
                            float[] FloatRangeI = this.FloatRange[i];
                            System.arraycopy(rangeI, 0, FloatRangeI, 0, this.Length);
                            break;
                        }
                        this.FloatRange[i] = rangeI;
                        break;
                    }
                    case 6: {
                        int[] index = this.RangeSet[i].valueToIndex(range1);
                        this.ByteRange[i] = new byte[this.Length];
                        byte[] ByteRangeI = this.ByteRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            ByteRangeI[j] = (byte)(index[j] + -128 + 1);
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        int[] index = this.RangeSet[i].valueToIndex(range1);
                        this.ShortRange[i] = new short[this.Length];
                        short[] ShortRangeI = this.ShortRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            ShortRangeI[j] = (short)(index[j] + Short.MIN_VALUE + 1);
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        int[] index = this.RangeSet[i].valueToIndex(range1);
                        this.IntRange[i] = new int[this.Length];
                        int[] IntRangeI = this.IntRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            IntRangeI[j] = index[j] + Integer.MIN_VALUE + 1;
                            ++j;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++i;
            }
            this.clearMissing();
        }
    }

    public byte[][] grabBytes() {
        return this.ByteRange;
    }

    public double[][] unpackValues() throws VisADException {
        return this.unpackValues(true);
    }

    private double[][] unpackValues(boolean copy) throws VisADException {
        double[][] range2;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            if (this.isMissing()) {
                double[][] range2 = new double[this.TupleDimension][this.Length];
                int i = 0;
                while (i < this.TupleDimension) {
                    int j = 0;
                    while (j < this.Length) {
                        range2[i][j] = Double.NaN;
                        ++j;
                    }
                    ++i;
                }
                double[][] j = range2;
                return j;
            }
            range2 = new double[this.TupleDimension][];
            int i = 0;
            while (i < this.TupleDimension) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        double[] rangeI;
                        if (copy) {
                            range2[i] = new double[this.Length];
                            rangeI = range2[i];
                            double[] DoubleRangeI = this.DoubleRange[i];
                            System.arraycopy(DoubleRangeI, 0, rangeI, 0, this.Length);
                            break;
                        }
                        range2[i] = this.DoubleRange[i];
                        break;
                    }
                    case 2: {
                        range2[i] = new double[this.Length];
                        double[] rangeI = range2[i];
                        float[] FloatRangeI = this.FloatRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            rangeI[j] = FloatRangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 6: {
                        int[] index = new int[this.Length];
                        byte[] ByteRangeI = this.ByteRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                            ++j;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range2[i] = range0[0];
                        break;
                    }
                    case 5: {
                        int[] index = new int[this.Length];
                        short[] ShortRangeI = this.ShortRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                            ++j;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range2[i] = range0[0];
                        break;
                    }
                    case 4: {
                        int[] index = new int[this.Length];
                        int[] IntRangeI = this.IntRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                            ++j;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range2[i] = range0[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++i;
            }
        }
        return range2;
    }

    private float[][] unpackFloats(boolean copy) throws VisADException {
        float[][] range2;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            if (this.isMissing()) {
                float[][] range2 = new float[this.TupleDimension][this.Length];
                int i = 0;
                while (i < this.TupleDimension) {
                    int j = 0;
                    while (j < this.Length) {
                        range2[i][j] = Float.NaN;
                        ++j;
                    }
                    ++i;
                }
                float[][] j = range2;
                return j;
            }
            range2 = new float[this.TupleDimension][];
            int i = 0;
            while (i < this.TupleDimension) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range2[i] = new float[this.Length];
                        float[] rangeI = range2[i];
                        double[] DoubleRangeI = this.DoubleRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            rangeI[j] = (float)DoubleRangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        float[] rangeI;
                        if (copy) {
                            range2[i] = new float[this.Length];
                            rangeI = range2[i];
                            float[] FloatRangeI = this.FloatRange[i];
                            System.arraycopy(FloatRangeI, 0, rangeI, 0, this.Length);
                            break;
                        }
                        range2[i] = this.FloatRange[i];
                        break;
                    }
                    case 6: {
                        int[] index = new int[this.Length];
                        byte[] ByteRangeI = this.ByteRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                            ++j;
                        }
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range2[i] = range0[0];
                        break;
                    }
                    case 5: {
                        int[] index = new int[this.Length];
                        short[] ShortRangeI = this.ShortRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                            ++j;
                        }
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range2[i] = range0[0];
                        break;
                    }
                    case 4: {
                        int[] index = new int[this.Length];
                        int[] IntRangeI = this.IntRange[i];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                            ++j;
                        }
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range2[i] = range0[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackFloats: bad RangeMode");
                    }
                }
                ++i;
            }
        }
        return range2;
    }

    private double[] unpackOneRangeComp(int comp) throws VisADException {
        double[] range = null;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            if (this.isMissing()) {
                range = new double[this.Length];
                int j = 0;
                while (j < this.Length) {
                    range[j] = Double.NaN;
                    ++j;
                }
                double[] dArray2 = range;
                return dArray2;
            }
            int i = 0;
            while (i < this.TupleDimension) {
                switch (this.RangeMode[comp]) {
                    case 1: {
                        range = new double[this.Length];
                        double[] DoubleRangeI = this.DoubleRange[comp];
                        System.arraycopy(DoubleRangeI, 0, range, 0, this.Length);
                        break;
                    }
                    case 2: {
                        range = new double[this.Length];
                        float[] FloatRangeI = this.FloatRange[comp];
                        int j = 0;
                        while (j < this.Length) {
                            range[j] = FloatRangeI[j];
                            ++j;
                        }
                        break;
                    }
                    case 6: {
                        int[] index = new int[this.Length];
                        byte[] ByteRangeI = this.ByteRange[comp];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                            ++j;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[comp].indexToValue(index));
                        range = range0[0];
                        break;
                    }
                    case 5: {
                        int[] index = new int[this.Length];
                        short[] ShortRangeI = this.ShortRange[comp];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                            ++j;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[comp].indexToValue(index));
                        range = range0[0];
                        break;
                    }
                    case 4: {
                        int[] index = new int[this.Length];
                        int[] IntRangeI = this.IntRange[comp];
                        int j = 0;
                        while (j < this.Length) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                            ++j;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[comp].indexToValue(index));
                        range = range0[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++i;
            }
        }
        return range;
    }

    private double[] unpackValues(int s_index) throws VisADException {
        double[] range2;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            if (this.isMissing()) {
                double[] range2 = new double[this.TupleDimension];
                int i = 0;
                while (i < this.TupleDimension) {
                    range2[i] = Double.NaN;
                    ++i;
                }
                double[] dArray2 = range2;
                return dArray2;
            }
            range2 = new double[this.TupleDimension];
            int i = 0;
            while (i < this.TupleDimension) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range2[i] = this.DoubleRange[i][s_index];
                        break;
                    }
                    case 2: {
                        range2[i] = this.FloatRange[i][s_index];
                        break;
                    }
                    case 6: {
                        int[] index = new int[1];
                        byte[] ByteRangeI = this.ByteRange[i];
                        index[0] = ByteRangeI[s_index] - -128 - 1;
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range2[i] = range0[0][0];
                        break;
                    }
                    case 5: {
                        int[] index = new int[1];
                        short[] ShortRangeI = this.ShortRange[i];
                        index[0] = ShortRangeI[s_index] - Short.MIN_VALUE - 1;
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range2[i] = range0[0][0];
                        break;
                    }
                    case 4: {
                        int[] index = new int[1];
                        int[] IntRangeI = this.IntRange[i];
                        index[0] = IntRangeI[s_index] - Integer.MIN_VALUE - 1;
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range2[i] = range0[0][0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++i;
            }
        }
        return range2;
    }

    public float[][] getFloats() throws VisADException {
        return this.getFloats(true);
    }

    public float[][] getFloats(boolean copy) throws VisADException {
        float[][] values = this.unpackFloats(copy);
        Unit[] units_out = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        return Unit.convertTuple(values, this.RangeUnits, units_out);
    }

    public double[][] getValues() throws VisADException {
        return this.getValues(true);
    }

    public double[][] getValues(boolean copy) throws VisADException {
        double[][] values = this.unpackValues(copy);
        Unit[] units_out = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        return Unit.convertTuple(values, this.RangeUnits, units_out);
    }

    public String[][] getStringValues() throws VisADException, RemoteException {
        return null;
    }

    public double[] getValues(int s_index) throws VisADException {
        double[] values = new double[this.TupleDimension];
        values = this.unpackValues(s_index);
        double[][] n_values = new double[this.TupleDimension][1];
        int ii = 0;
        while (ii < this.TupleDimension) {
            n_values[ii][0] = values[ii];
            ++ii;
        }
        Unit[] units_out = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        double[][] r_values = Unit.convertTuple(n_values, this.RangeUnits, units_out);
        int ii2 = 0;
        while (ii2 < values.length) {
            values[ii2] = r_values[ii2][0];
            ++ii2;
        }
        return values;
    }

    public Unit[] getDefaultRangeUnits() {
        return ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
    }

    public Data getSample(int index) throws VisADException, RemoteException {
        if (this.isMissing() || index < 0 || index >= this.Length) {
            return ((FunctionType)this.Type).getRange().missingData();
        }
        double[][] range = new double[this.TupleDimension][1];
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            int i = 0;
            while (i < this.TupleDimension) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range[i][0] = this.DoubleRange[i][index];
                        break;
                    }
                    case 2: {
                        range[i][0] = this.FloatRange[i][index];
                        break;
                    }
                    case 6: {
                        int[] inds = new int[]{this.ByteRange[i][index] - -128 - 1};
                        double[][] range1 = Set.floatToDouble(this.RangeSet[i].indexToValue(inds));
                        range[i] = range1[0];
                        break;
                    }
                    case 5: {
                        int[] inds = new int[]{this.ShortRange[i][index] - Short.MIN_VALUE - 1};
                        double[][] range1 = Set.floatToDouble(this.RangeSet[i].indexToValue(inds));
                        range[i] = range1[0];
                        break;
                    }
                    case 4: {
                        int[] inds = new int[]{this.IntRange[i][index] - Integer.MIN_VALUE - 1};
                        double[][] range1 = Set.floatToDouble(this.RangeSet[i].indexToValue(inds));
                        range[i] = range1[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.getSample: bad RangeMode");
                    }
                }
                ++i;
            }
        }
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (RangeType instanceof RealType) {
            return new Real((RealType)RangeType, range[0][0], this.RangeUnits[0], this.RangeErrors[0]);
        }
        if (RangeType instanceof RealTupleType) {
            Real[] reals = new Real[this.TupleDimension];
            int j = 0;
            while (j < this.TupleDimension) {
                MathType type = ((RealTupleType)RangeType).getComponent(j);
                reals[j] = new Real((RealType)type, range[j][0], this.RangeUnits[j], this.RangeErrors[j]);
                ++j;
            }
            return new RealTuple((RealTupleType)RangeType, reals, this.RangeCoordinateSystem);
        }
        int n = ((TupleType)RangeType).getDimension();
        int j = 0;
        Data[] datums = new Data[n];
        int i = 0;
        while (i < n) {
            MathType type = ((TupleType)RangeType).getComponent(i);
            if (type instanceof RealType) {
                datums[i] = new Real((RealType)type, range[j][0], this.RangeUnits[j], this.RangeErrors[j]);
                ++j;
            } else {
                int m = ((RealTupleType)type).getDimension();
                Real[] reals = new Real[m];
                int k = 0;
                while (k < m) {
                    RealType ctype = (RealType)((RealTupleType)type).getComponent(k);
                    reals[k] = new Real(ctype, range[j][0], this.RangeUnits[j], this.RangeErrors[j]);
                    ++j;
                    ++k;
                }
                datums[i] = new RealTuple((RealTupleType)type, reals, this.RangeCoordinateSystems[i]);
            }
            ++i;
        }
        return new Tuple(datums);
    }

    public Data getSample(int index, boolean metadataOnly) throws VisADException, RemoteException {
        return this.getSample(index);
    }

    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        this.setSample(index, range);
    }

    public void setSample(int index, Data range) throws VisADException, RemoteException {
        int j;
        if (this.DomainSet == null) {
            throw new FieldException("Field.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getRange().equals(range.getType())) {
            throw new TypeException("Field.setSample: sample range type " + range.getType() + " does not match expected type " + ((FunctionType)this.Type).getRange());
        }
        if (index < 0 || index >= this.Length) {
            return;
        }
        double[] vals = new double[this.TupleDimension];
        ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
        if (range instanceof Real) {
            vals[0] = ((Real)range).getValue();
            vals = Unit.transformUnits(this.RangeUnits[0], errors_out, ((Real)range).getUnit(), ((Real)range).getError(), vals);
        } else if (range instanceof RealTuple) {
            double[][] value = new double[this.TupleDimension][1];
            int j2 = 0;
            while (j2 < this.TupleDimension) {
                value[j2][0] = ((Real)((RealTuple)range).getComponent(j2)).getValue();
                ++j2;
            }
            value = CoordinateSystem.transformCoordinates((RealTupleType)((FunctionType)this.Type).getRange(), this.RangeCoordinateSystem, this.RangeUnits, errors_out, (RealTupleType)range.getType(), ((RealTuple)range).getCoordinateSystem(), ((RealTuple)range).getTupleUnits(), ((RealTuple)range).getErrors(), value);
            j = 0;
            while (j < this.TupleDimension) {
                vals[j] = value[j][0];
                ++j;
            }
        } else {
            MathType RangeType = ((FunctionType)this.Type).getRange();
            int n = ((TupleIface)range).getDimension();
            j = 0;
            int i = 0;
            while (i < n) {
                Data component = ((TupleIface)range).getComponent(i);
                if (component instanceof Real) {
                    double[] value = new double[]{((Real)component).getValue()};
                    ErrorEstimate[] sub_errors_out = new ErrorEstimate[1];
                    value = Unit.transformUnits(this.RangeUnits[0], sub_errors_out, ((Real)component).getUnit(), ((Real)component).getError(), value);
                    vals[j] = value[0];
                    errors_out[j] = sub_errors_out[0];
                    ++j;
                } else {
                    int m = ((RealTuple)component).getDimension();
                    double[][] value = new double[m][1];
                    Unit[] units_out = new Unit[m];
                    ErrorEstimate[] sub_errors_out = ((RealTuple)component).getErrors();
                    int k = 0;
                    while (k < m) {
                        value[k][0] = ((Real)((RealTuple)component).getComponent(k)).getValue();
                        units_out[k] = this.RangeUnits[j + k];
                        ++k;
                    }
                    value = CoordinateSystem.transformCoordinates((RealTupleType)((TupleType)RangeType).getComponent(i), this.RangeCoordinateSystems[i], units_out, sub_errors_out, (RealTupleType)component.getType(), ((RealTuple)component).getCoordinateSystem(), ((RealTuple)component).getTupleUnits(), ((RealTuple)component).getErrors(), value);
                    int k2 = 0;
                    while (k2 < m) {
                        vals[j] = value[k2][0];
                        errors_out[j] = sub_errors_out[k2];
                        ++j;
                        ++k2;
                    }
                }
                ++i;
            }
        }
        int[] incs = new int[this.TupleDimension];
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            int i = 0;
            while (i < this.TupleDimension) {
                incs[i] = vals[i] != vals[i] ? 0 : 1;
                switch (this.RangeMode[i]) {
                    case 1: {
                        int j3;
                        if (this.DoubleRange[i] == null) {
                            this.DoubleRange[i] = new double[this.Length];
                            j3 = 0;
                            while (j3 < this.Length) {
                                this.DoubleRange[i][j3] = Double.NaN;
                                ++j3;
                            }
                        }
                        int n = i;
                        incs[n] = incs[n] - (this.DoubleRange[i][index] != this.DoubleRange[i][index] ? 0 : 1);
                        this.DoubleRange[i][index] = vals[i];
                        break;
                    }
                    case 2: {
                        int j3;
                        if (this.FloatRange[i] == null) {
                            this.FloatRange[i] = new float[this.Length];
                            j3 = 0;
                            while (j3 < this.Length) {
                                this.FloatRange[i][j3] = Float.NaN;
                                ++j3;
                            }
                        }
                        int n = i;
                        incs[n] = incs[n] - (this.FloatRange[i][index] != this.FloatRange[i][index] ? 0 : 1);
                        this.FloatRange[i][index] = (float)vals[i];
                        break;
                    }
                    case 6: {
                        int j3;
                        double[][] values = new double[1][1];
                        values[0][0] = vals[i];
                        int[] indices = this.RangeSet[i].valueToIndex(Set.doubleToFloat(values));
                        if (this.ByteRange[i] == null) {
                            this.ByteRange[i] = new byte[this.Length];
                            j3 = 0;
                            while (j3 < this.Length) {
                                this.ByteRange[i][j3] = -128;
                                ++j3;
                            }
                        }
                        int n = i;
                        incs[n] = incs[n] - (this.ByteRange[i][index] == -128 ? 0 : 1);
                        this.ByteRange[i][index] = (byte)(indices[0] + -128 + 1);
                        break;
                    }
                    case 5: {
                        int j3;
                        double[][] values = new double[1][1];
                        values[0][0] = vals[i];
                        int[] indices = this.RangeSet[i].valueToIndex(Set.doubleToFloat(values));
                        if (this.ShortRange[i] == null) {
                            this.ShortRange[i] = new short[this.Length];
                            j3 = 0;
                            while (j3 < this.Length) {
                                this.ShortRange[i][j3] = Short.MIN_VALUE;
                                ++j3;
                            }
                        }
                        int n = i;
                        incs[n] = incs[n] - (this.ShortRange[i][index] == Short.MIN_VALUE ? 0 : 1);
                        this.ShortRange[i][index] = (short)(indices[0] + Short.MIN_VALUE + 1);
                        break;
                    }
                    case 4: {
                        int j3;
                        double[][] values = new double[1][1];
                        values[0][0] = vals[i];
                        int[] indices = this.RangeSet[i].valueToIndex(Set.doubleToFloat(values));
                        if (this.IntRange[i] == null) {
                            this.IntRange[i] = new int[this.Length];
                            j3 = 0;
                            while (j3 < this.Length) {
                                this.IntRange[i][j3] = Integer.MIN_VALUE;
                                ++j3;
                            }
                        }
                        int n = i;
                        incs[n] = incs[n] - (this.IntRange[i][index] == Integer.MIN_VALUE ? 0 : 1);
                        this.IntRange[i][index] = indices[0] + Integer.MIN_VALUE + 1;
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.setSample: bad RangeMode");
                    }
                }
                ++i;
            }
            ErrorEstimate[] errorEstimateArray = this.RangeErrors;
            synchronized (errorEstimateArray) {
                int i2 = 0;
                while (i2 < this.TupleDimension) {
                    this.RangeErrors[i2] = new ErrorEstimate(this.RangeErrors[i2], errors_out[i2], vals[i2], incs[i2]);
                    ++i2;
                }
            }
        }
        this.clearMissing();
        this.notifyReferences();
    }

    private void nullRanges() throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            int i = 0;
            while (i < this.TupleDimension) {
                this.DoubleRange[i] = null;
                ++i;
            }
            this.FloatRange = new float[this.TupleDimension][];
            this.LongRange = new long[this.TupleDimension][];
            this.IntRange = new int[this.TupleDimension][];
            this.ShortRange = new short[this.TupleDimension][];
            this.ByteRange = new byte[this.TupleDimension][];
            int i2 = 0;
            while (i2 < this.TupleDimension) {
                int SetLength;
                this.RangeMode[i2] = this.RangeSet[i2] instanceof DoubleSet ? 1 : (this.RangeSet[i2] instanceof FloatSet ? 2 : ((SetLength = this.RangeSet[i2].getLength()) < 256 ? 6 : (SetLength < 65536 ? 5 : 4)));
                ++i2;
            }
        }
    }

    public boolean isMissing() {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            boolean bl = this.MissingFlag;
            return bl;
        }
    }

    public void clearMissing() {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            this.MissingFlag = false;
        }
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Field) {
            FunctionType data_type = (FunctionType)data.getType();
            if (data_type.getRange().equalsExceptName(this.Type)) {
                if (!data_type.equalsExceptName(new_type)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.binary(this, DataImpl.invertOp(op), new_type, sampling_mode, error_mode);
            }
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("FlatField.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException();
            }
            if (!((Field)data).isFlatField()) {
                return this.convertToField().binary(data, op, new_type, sampling_mode, error_mode);
            }
            data = data.local();
            if (this.isMissing() || data.isMissing()) {
                return new_type.missingData();
            }
            data = ((FlatField)data).resample(this.DomainSet, sampling_mode, error_mode);
            double[][] values = this.unpackValues();
            double[][] value2 = ((FlatField)data).unpackValues();
            Unit[][] temp_units = ((FlatField)data).getRangeUnits();
            Unit[] units_in = new Unit[temp_units.length];
            int i = 0;
            while (i < temp_units.length) {
                units_in[i] = temp_units[i][0];
                ++i;
            }
            ErrorEstimate[] errors_in = ((FlatField)data).getRangeErrors();
            if (units_in == null) {
                units_in = new Unit[this.TupleDimension];
            }
            if (errors_in == null) {
                errors_in = new ErrorEstimate[this.TupleDimension];
            }
            Unit[] units_out = new Unit[this.TupleDimension];
            ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
            if (((FunctionType)this.Type).getReal()) {
                CoordinateSystem[] cs = ((FlatField)data).getRangeCoordinateSystem();
                value2 = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, units_out, errors_out, ((FunctionType)data.getType()).getFlatRange(), cs[0], units_in, errors_in, value2);
            } else if (this.RangeCoordinateSystems != null) {
                TupleType rtype = (TupleType)((FunctionType)this.Type).getRange();
                TupleType dtype = (TupleType)((FunctionType)data.getType()).getRange();
                int n = rtype.getDimension();
                int j = 0;
                int i2 = 0;
                while (i2 < n) {
                    MathType crtype = rtype.getComponent(i2);
                    MathType cdtype = dtype.getComponent(i2);
                    if (crtype instanceof RealTupleType) {
                        int m = ((RealTupleType)crtype).getDimension();
                        Object vals = new double[m][];
                        Unit[] sub_units_out = new Unit[m];
                        Unit[] sub_units_in = new Unit[m];
                        ErrorEstimate[] sub_errors_out = new ErrorEstimate[m];
                        ErrorEstimate[] sub_errors_in = new ErrorEstimate[m];
                        int k = 0;
                        while (k < m) {
                            vals[k] = value2[j + k];
                            sub_units_in[k] = units_in[j + k];
                            sub_errors_in[k] = errors_in[j + k];
                            ++k;
                        }
                        CoordinateSystem[] cs = ((FlatField)data).getRangeCoordinateSystem(i2);
                        vals = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)crtype, this.RangeCoordinateSystems[i2], sub_units_out, sub_errors_out, (RealTupleType)cdtype, cs[0], sub_units_in, sub_errors_in, vals);
                        int k2 = 0;
                        while (k2 < m) {
                            value2[j + k2] = vals[k2];
                            errors_out[j + k2] = sub_errors_out[k2];
                            units_out[j + k2] = sub_units_out[k2];
                            ++k2;
                        }
                        j += m;
                    } else {
                        errors_out[j] = errors_in[j];
                        units_out[j] = units_in[j];
                        ++j;
                    }
                    ++i2;
                }
            }
            units_in = (Unit[])this.RangeUnits.clone();
            errors_in = (ErrorEstimate[])this.RangeErrors.clone();
            FlatField.makeRational(values, units_in, errors_in);
            FlatField.makeRational(value2, units_out, errors_out);
            block0 : switch (op) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        Unit u;
                        if (units_in[j] == null || units_out[j] == null) {
                            u = null;
                        } else if (units_in[j] == CommonUnit.promiscuous) {
                            u = units_out[j];
                        } else if (units_out[j] == CommonUnit.promiscuous) {
                            u = units_in[j];
                        } else if (Unit.canConvert(units_in[j], units_out[j])) {
                            u = units_in[j];
                            value2[j] = units_in[j].toThis(value2[j], units_out[j]);
                            if (error_mode != 202 && errors_out[j] != null) {
                                double error = 0.5 * errors_out[j].getErrorValue();
                                double mean = errors_out[j].getMean();
                                double a = units_in[j].toThis(mean + error, units_out[j]);
                                double b = units_in[j].toThis(mean - error, units_out[j]);
                                double new_error = Math.abs(a - b);
                                double new_mean = 0.5 * (a + b);
                                errors_out[j] = new ErrorEstimate(new_mean, new_error, units_in[j]);
                            }
                        } else {
                            u = null;
                        }
                        units_out[j] = u;
                        ++j;
                    }
                    switch (op) {
                        case 1: {
                            j = 0;
                            while (j < this.TupleDimension) {
                                double[] valuesJ = values[j];
                                double[] value2J = value2[j];
                                int i3 = 0;
                                while (i3 < this.Length) {
                                    int n = i3;
                                    valuesJ[n] = valuesJ[n] + value2J[i3];
                                    ++i3;
                                }
                                ++j;
                            }
                            break block0;
                        }
                        case 2: {
                            j = 0;
                            while (j < this.TupleDimension) {
                                double[] valuesJ = values[j];
                                double[] value2J = value2[j];
                                int i3 = 0;
                                while (i3 < this.Length) {
                                    int n = i3;
                                    valuesJ[n] = valuesJ[n] - value2J[i3];
                                    ++i3;
                                }
                                ++j;
                            }
                            break block0;
                        }
                        case 3: {
                            j = 0;
                            while (j < this.TupleDimension) {
                                double[] valuesJ = values[j];
                                double[] value2J = value2[j];
                                int i3 = 0;
                                while (i3 < this.Length) {
                                    valuesJ[i3] = value2J[i3] - valuesJ[i3];
                                    ++i3;
                                }
                                ++j;
                            }
                            break block0;
                        }
                        case 9: {
                            j = 0;
                            while (j < this.TupleDimension) {
                                double[] valuesJ = values[j];
                                double[] value2J = value2[j];
                                int i3 = 0;
                                while (i3 < this.Length) {
                                    valuesJ[i3] = Math.max(valuesJ[i3], value2J[i3]);
                                    ++i3;
                                }
                                ++j;
                            }
                            break block0;
                        }
                        default: {
                            j = 0;
                            while (j < this.TupleDimension) {
                                double[] valuesJ = values[j];
                                double[] value2J = value2[j];
                                int i3 = 0;
                                while (i3 < this.Length) {
                                    valuesJ[i3] = Math.min(valuesJ[i3], value2J[i3]);
                                    ++i3;
                                }
                                ++j;
                            }
                            break block0;
                        }
                    }
                }
                case 4: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            int n = i3;
                            valuesJ[n] = valuesJ[n] * value2J[i3];
                            ++i3;
                        }
                        units_out[j] = units_in[j] == null || units_out[j] == null ? null : units_in[j].multiply(units_out[j]);
                        ++j;
                    }
                    break;
                }
                case 5: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            int n = i3;
                            valuesJ[n] = valuesJ[n] / value2J[i3];
                            ++i3;
                        }
                        units_out[j] = units_in[j] == null || units_out[j] == null ? null : units_in[j].divide(units_out[j]);
                        ++j;
                    }
                    break;
                }
                case 6: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = value2J[i3] / valuesJ[i3];
                            ++i3;
                        }
                        units_out[j] = units_in[j] == null || units_out[j] == null ? null : units_out[j].divide(units_in[j]);
                        ++j;
                    }
                    break;
                }
                case 7: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = Math.pow(valuesJ[i3], value2J[i3]);
                            ++i3;
                        }
                        units_out[j] = null;
                        ++j;
                    }
                    break;
                }
                case 8: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = Math.pow(value2J[i3], valuesJ[i3]);
                            ++i3;
                        }
                        units_out[j] = null;
                        ++j;
                    }
                    break;
                }
                case 11: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = Math.atan2(valuesJ[i3], value2J[i3]);
                            ++i3;
                        }
                        units_out[j] = CommonUnit.radian;
                        ++j;
                    }
                    break;
                }
                case 12: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = 57.29577951308232 * Math.atan2(valuesJ[i3], value2J[i3]);
                            ++i3;
                        }
                        units_out[j] = CommonUnit.degree;
                        ++j;
                    }
                    break;
                }
                case 13: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = Math.atan2(value2J[i3], valuesJ[i3]);
                            ++i3;
                        }
                        units_out[j] = CommonUnit.radian;
                        ++j;
                    }
                    break;
                }
                case 14: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = 57.29577951308232 * Math.atan2(value2J[i3], valuesJ[i3]);
                            ++i3;
                        }
                        units_out[j] = CommonUnit.degree;
                        ++j;
                    }
                    break;
                }
                case 15: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            int n = i3;
                            valuesJ[n] = valuesJ[n] % value2J[i3];
                            ++i3;
                        }
                        units_out[j] = units_in[j];
                        ++j;
                    }
                    break;
                }
                case 16: {
                    int j = 0;
                    while (j < this.TupleDimension) {
                        double[] valuesJ = values[j];
                        double[] value2J = value2[j];
                        int i3 = 0;
                        while (i3 < this.Length) {
                            valuesJ[i3] = value2J[i3] % valuesJ[i3];
                            ++i3;
                        }
                        ++j;
                    }
                    break;
                }
            }
            int j = 0;
            while (j < this.TupleDimension) {
                errors_out[j] = error_mode == 202 || errors_in[j] == null || errors_out[j] == null ? null : new ErrorEstimate(values[j], units_out[j], op, errors_in[j], errors_out[j], error_mode);
                ++j;
            }
            FlatField new_field = this.cloneDouble(new_type, units_out, errors_out);
            new_field.packValues(values, false);
            new_field.clearMissing();
            return new_field;
        }
        if (data instanceof Real || data instanceof RealTuple || data instanceof TupleIface && ((TupleType)data.getType()).getFlat()) {
            int j;
            MathType RangeType = ((FunctionType)this.Type).getRange();
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            if (this.isMissing() || data.isMissing()) {
                return new_type.missingData();
            }
            double[][] values = this.unpackValues();
            double[][] vals = new double[this.TupleDimension][1];
            Unit[] units_out = new Unit[this.TupleDimension];
            ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
            if (data instanceof Real) {
                j = 0;
                while (j < this.TupleDimension) {
                    vals[j][0] = ((Real)data).getValue();
                    units_out[j] = ((Real)data).getUnit();
                    errors_out[j] = ((Real)data).getError();
                    ++j;
                }
            } else if (data instanceof RealTuple) {
                j = 0;
                while (j < this.TupleDimension) {
                    vals[j][0] = ((Real)((RealTuple)data).getComponent(j)).getValue();
                    ++j;
                }
                vals = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, units_out, errors_out, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), vals);
            } else {
                int n = ((TupleIface)data).getDimension();
                int j2 = 0;
                int i = 0;
                while (i < n) {
                    Data component = ((TupleIface)data).getComponent(i);
                    if (component instanceof Real) {
                        vals[j2][0] = ((Real)component).getValue();
                        units_out[j2] = ((Real)component).getUnit();
                        errors_out[j2] = ((Real)component).getError();
                        ++j2;
                    } else {
                        int m = ((TupleIface)component).getDimension();
                        double[][] tvals = new double[m][1];
                        Unit[] sub_units_out = new Unit[m];
                        ErrorEstimate[] sub_errors_out = new ErrorEstimate[m];
                        int k = 0;
                        while (k < m) {
                            tvals[k][0] = ((Real)((TupleIface)component).getComponent(k)).getValue();
                            ++k;
                        }
                        tvals = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)((TupleType)RangeType).getComponent(i), this.RangeCoordinateSystems[i], sub_units_out, sub_errors_out, (RealTupleType)component.getType(), ((RealTuple)component).getCoordinateSystem(), ((RealTuple)component).getTupleUnits(), ((RealTuple)component).getErrors(), tvals);
                        int k3 = 0;
                        while (k3 < m) {
                            vals[j2 + k3][0] = tvals[k3][0];
                            units_out[j2 + k3] = sub_units_out[k3];
                            errors_out[j2 + k3] = sub_errors_out[k3];
                            ++k3;
                        }
                        j2 += m;
                    }
                    ++i;
                }
            }
            Unit[] units_in = (Unit[])this.RangeUnits.clone();
            ErrorEstimate[] errors_in = (ErrorEstimate[])this.RangeErrors.clone();
            FlatField.makeRational(values, units_in, errors_in);
            FlatField.makeRational(vals, units_out, errors_out);
            int j3 = 0;
            while (j3 < this.TupleDimension) {
                double value = vals[j3][0];
                double[] valuesJ = values[j3];
                block20 : switch (op) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        Unit u;
                        if (units_in[j3] == null || units_out[j3] == null) {
                            u = null;
                        } else if (units_in[j3] == CommonUnit.promiscuous) {
                            u = units_out[j3];
                        } else if (units_out[j3] == CommonUnit.promiscuous) {
                            u = units_in[j3];
                        } else if (Unit.canConvert(units_in[j3], units_out[j3])) {
                            u = units_in[j3];
                            value = units_in[j3].toThis(value, units_out[j3]);
                            if (error_mode == 202 && errors_out[j3] != null) {
                                double error = 0.5 * errors_out[j3].getErrorValue();
                                double mean = errors_out[j3].getMean();
                                double a = units_in[j3].toThis(mean + error, units_out[j3]);
                                double b = units_in[j3].toThis(mean - error, units_out[j3]);
                                double new_error = Math.abs(a - b);
                                double new_mean = 0.5 * (a + b);
                                errors_out[j3] = new ErrorEstimate(new_mean, new_error, units_in[j3]);
                            }
                        } else {
                            u = null;
                        }
                        units_out[j3] = u;
                        switch (op) {
                            case 1: {
                                int i = 0;
                                while (i < this.Length) {
                                    int n = i++;
                                    valuesJ[n] = valuesJ[n] + value;
                                }
                                break block20;
                            }
                            case 2: {
                                int i = 0;
                                while (i < this.Length) {
                                    int n = i++;
                                    valuesJ[n] = valuesJ[n] - value;
                                }
                                break block20;
                            }
                            case 3: {
                                int i = 0;
                                while (i < this.Length) {
                                    valuesJ[i] = value - valuesJ[i];
                                    ++i;
                                }
                                break block20;
                            }
                            case 9: {
                                int i = 0;
                                while (i < this.Length) {
                                    valuesJ[i] = Math.max(valuesJ[i], value);
                                    ++i;
                                }
                                break block20;
                            }
                            default: {
                                int i = 0;
                                while (i < this.Length) {
                                    valuesJ[i] = Math.min(valuesJ[i], value);
                                    ++i;
                                }
                                break block20;
                            }
                        }
                    }
                    case 4: {
                        int i = 0;
                        while (i < this.Length) {
                            int n = i++;
                            valuesJ[n] = valuesJ[n] * value;
                        }
                        if (units_in[j3] == null || units_out[j3] == null) {
                            units_out[j3] = null;
                            break;
                        }
                        units_out[j3] = units_in[j3].multiply(units_out[j3]);
                        break;
                    }
                    case 5: {
                        int i = 0;
                        while (i < this.Length) {
                            int n = i++;
                            valuesJ[n] = valuesJ[n] / value;
                        }
                        if (units_in[j3] == null || units_out[j3] == null) {
                            units_out[j3] = null;
                            break;
                        }
                        units_out[j3] = units_in[j3].divide(units_out[j3]);
                        break;
                    }
                    case 6: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = value / valuesJ[i];
                            ++i;
                        }
                        if (units_in[j3] == null || units_out[j3] == null) {
                            units_out[j3] = null;
                            break;
                        }
                        units_out[j3] = units_out[j3].divide(units_in[j3]);
                        break;
                    }
                    case 7: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.pow(valuesJ[i], value);
                            ++i;
                        }
                        units_out[j3] = CommonUnit.dimensionless.equals(units_in[j3]) ? CommonUnit.dimensionless : null;
                        break;
                    }
                    case 8: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.pow(value, valuesJ[i]);
                            ++i;
                        }
                        units_out[j3] = null;
                        break;
                    }
                    case 11: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.atan2(valuesJ[i], value);
                            ++i;
                        }
                        units_out[j3] = CommonUnit.radian;
                        break;
                    }
                    case 12: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = 57.29577951308232 * Math.atan2(valuesJ[i], value);
                            ++i;
                        }
                        units_out[j3] = CommonUnit.degree;
                        break;
                    }
                    case 13: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.atan2(value, valuesJ[i]);
                            ++i;
                        }
                        units_out[j3] = CommonUnit.radian;
                        break;
                    }
                    case 14: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = 57.29577951308232 * Math.atan2(value, valuesJ[i]);
                            ++i;
                        }
                        units_out[j3] = CommonUnit.degree;
                        break;
                    }
                    case 15: {
                        int i = 0;
                        while (i < this.Length) {
                            int n = i++;
                            valuesJ[n] = valuesJ[n] % value;
                        }
                        units_out[j3] = units_in[j3];
                        break;
                    }
                    case 16: {
                        int i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = value % valuesJ[i];
                            ++i;
                        }
                        break;
                    }
                }
                ++j3;
            }
            int j4 = 0;
            while (j4 < this.TupleDimension) {
                errors_out[j4] = error_mode == 202 || errors_in[j4] == null || errors_out[j4] == null ? null : new ErrorEstimate(values[j4], units_out[j4], op, errors_in[j4], errors_out[j4], error_mode);
                ++j4;
            }
            FlatField new_field = this.cloneDouble(new_type, units_out, errors_out);
            new_field.packValues(values, false);
            new_field.clearMissing();
            return new_field;
        }
        throw new TypeException("Field.binary");
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        int j;
        if (this.isMissing()) {
            return this.cloneDouble();
        }
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        double[][] values = this.unpackValues();
        Unit[] units_out = new Unit[this.TupleDimension];
        Unit[] units_in = (Unit[])this.RangeUnits.clone();
        ErrorEstimate[] errors_in = (ErrorEstimate[])this.RangeErrors.clone();
        FlatField.makeRational(values, units_in, errors_in);
        switch (op) {
            case 21: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.abs(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
            case 22: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.acos(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.radian;
                    ++j;
                }
                break;
            }
            case 23: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = 57.29577951308232 * Math.acos(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.degree;
                    ++j;
                }
                break;
            }
            case 24: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.asin(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.radian;
                    ++j;
                }
                break;
            }
            case 25: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = 57.29577951308232 * Math.asin(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.degree;
                    ++j;
                }
                break;
            }
            case 26: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.atan(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.radian;
                    ++j;
                }
                break;
            }
            case 27: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = 57.29577951308232 * Math.atan(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.degree;
                    ++j;
                }
                break;
            }
            case 28: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.ceil(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
            case 29: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    if (CommonUnit.degree.equals(units_in[j])) {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.cos(Math.PI / 180 * valuesJ[i]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.cos(valuesJ[i]);
                            ++i;
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 30: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    if (CommonUnit.radian.equals(units_in[j])) {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.cos(valuesJ[i]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.cos(Math.PI / 180 * valuesJ[i]);
                            ++i;
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 31: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.exp(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 32: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.floor(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
            case 33: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.log(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 34: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.rint(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
            case 35: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.round(valuesJ[i]);
                        ++i;
                    }
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
            case 36: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    if (CommonUnit.degree.equals(units_in[j])) {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.sin(Math.PI / 180 * valuesJ[i]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.sin(valuesJ[i]);
                            ++i;
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 37: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    if (CommonUnit.radian.equals(units_in[j])) {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.sin(valuesJ[i]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.sin(Math.PI / 180 * valuesJ[i]);
                            ++i;
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 38: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = Math.sqrt(valuesJ[i]);
                        ++i;
                    }
                    if (units_in[j] == null) {
                        units_out[j] = null;
                    } else {
                        try {
                            units_out[j] = units_in[j].sqrt();
                        }
                        catch (IllegalArgumentException e) {
                            units_out[j] = null;
                        }
                        catch (UnitException e) {
                            units_out[j] = null;
                        }
                    }
                    ++j;
                }
                break;
            }
            case 39: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    if (CommonUnit.degree.equals(units_in[j])) {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.tan(Math.PI / 180 * valuesJ[i]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.tan(valuesJ[i]);
                            ++i;
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 40: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    if (CommonUnit.radian.equals(units_in[j])) {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.tan(valuesJ[i]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.Length) {
                            valuesJ[i] = Math.tan(Math.PI / 180 * valuesJ[i]);
                            ++i;
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                    ++j;
                }
                break;
            }
            case 41: {
                int i;
                double[] valuesJ;
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    i = 0;
                    while (i < this.Length) {
                        valuesJ[i] = -valuesJ[i];
                        ++i;
                    }
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
            case 42: {
                j = 0;
                while (j < this.TupleDimension) {
                    units_out[j] = units_in[j];
                    ++j;
                }
                break;
            }
        }
        ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
        j = 0;
        while (j < this.TupleDimension) {
            errors_out[j] = error_mode == 202 || errors_in[j] == null ? null : new ErrorEstimate(values[j], units_out[j], op, errors_in[j], error_mode);
            ++j;
        }
        FlatField new_field = this.cloneDouble(new_type, units_out, errors_out);
        new_field.packValues(values, false);
        new_field.clearMissing();
        return new_field;
    }

    protected static void makeRational(double[][] values, Unit[] units, ErrorEstimate[] errors) throws UnitException {
        int j = 0;
        while (j < values.length) {
            Unit inputUnit = units[j];
            if (inputUnit != null && !(inputUnit instanceof PromiscuousUnit)) {
                Unit outputUnit = inputUnit.getAbsoluteUnit();
                if (Unit.canConvert(outputUnit, CommonUnit.dimensionless)) {
                    outputUnit = CommonUnit.dimensionless;
                }
                if (!outputUnit.equals(inputUnit)) {
                    values[j] = outputUnit.toThis(values[j], inputUnit);
                    if (errors[j] != null) {
                        errors[j] = new ErrorEstimate(outputUnit.toThis(errors[j].getMean(), inputUnit), errors[j].getErrorValue(), outputUnit);
                    }
                    units[j] = outputUnit;
                }
            }
            ++j;
        }
    }

    public Field extract(int component) throws VisADException, RemoteException {
        CoordinateSystem coord_sys;
        int[] flat_indeces;
        int compSize;
        Set domainSet = this.getDomainSet();
        int n_samples = domainSet.getLength();
        MathType rangeType = ((FunctionType)this.Type).getRange();
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        if (rangeType instanceof RealType) {
            if (component != 0) {
                throw new VisADException("extract: component index must be zero");
            }
            return this;
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        if (component + 1 > n_comps) {
            throw new VisADException("extract: component index too large");
        }
        MathType new_range = ((TupleType)rangeType).getComponent(component);
        FunctionType new_type = new FunctionType(domainType, new_range);
        int cnt = 0;
        int t_cnt = 0;
        int ii = 0;
        while (ii < component) {
            MathType m_type = ((TupleType)rangeType).getComponent(ii);
            if (m_type instanceof RealType) {
                ++cnt;
            } else {
                cnt += ((RealTupleType)m_type).getDimension();
                ++t_cnt;
            }
            ++ii;
        }
        if (new_range instanceof RealType) {
            compSize = 1;
            flat_indeces = new int[compSize];
            flat_indeces[0] = cnt;
            coord_sys = null;
        } else {
            compSize = ((RealTupleType)new_range).getDimension();
            flat_indeces = new int[compSize];
            int jj = 0;
            while (jj < compSize) {
                flat_indeces[jj] = cnt++;
                ++jj;
            }
            coord_sys = this.RangeCoordinateSystems[t_cnt];
        }
        ErrorEstimate[] errors_out = new ErrorEstimate[compSize];
        Unit[] units_out = new Unit[compSize];
        Set[] rangeSet_out = new Set[compSize];
        ii = 0;
        while (ii < compSize) {
            units_out[ii] = this.RangeUnits[flat_indeces[ii]];
            errors_out[ii] = this.RangeErrors[flat_indeces[ii]];
            rangeSet_out[ii] = this.RangeSet[flat_indeces[ii]];
            ++ii;
        }
        FlatField new_field = new FlatField(new_type, domainSet, coord_sys, null, rangeSet_out, units_out);
        new_field.setRangeErrors(errors_out);
        double[][] new_values = new double[compSize][n_samples];
        double[] values = null;
        ii = 0;
        while (ii < compSize) {
            values = this.unpackOneRangeComp(flat_indeces[ii]);
            System.arraycopy(values, 0, new_values[ii], 0, n_samples);
            ++ii;
        }
        new_field.setSamples(new_values);
        return new_field;
    }

    public Data derivative(RealTuple location, RealType[] d_partial_s, MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        int pp;
        boolean transform;
        int jj;
        int n_partials;
        Set domainSet = this.getDomainSet();
        int domainDim = domainSet.getDimension();
        int manifoldDimension = domainSet.getManifoldDimension();
        int n_samples = domainSet.getLength();
        CoordinateSystem d_coordsys = this.getDomainCoordinateSystem();
        RealTupleType d_reference = d_coordsys == null ? null : d_coordsys.getReference();
        MathType m_type = null;
        Object m_types = null;
        Object r_type = null;
        Object r_types = null;
        Object t_type = null;
        boolean thisDomainFlag = true;
        if (manifoldDimension != domainDim) {
            throw new SetException("derivative: manifoldDimension must equal domain dimension");
        }
        error_mode = 202;
        if (location != null) {
            thisDomainFlag = false;
        }
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        RealType[] r_comps = domainType.getRealComponents();
        RealType[] r_compsRange = ((FunctionType)this.Type).getFlatRange().getRealComponents();
        RealType[] r_compsRef = d_reference == null ? null : d_reference.getRealComponents();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (d_partial_s == null) {
            n_partials = domainDim;
            d_partial_s = r_comps;
        } else {
            n_partials = d_partial_s.length;
            if (n_partials > domainDim) {
                throw new VisADException("derivative: too many d_partial components");
            }
        }
        int[] u_index = new int[n_partials];
        double[][] u_vectors = new double[n_partials][domainDim];
        int found = 0;
        int foundRef = 0;
        int ii = 0;
        while (ii < n_partials) {
            jj = 0;
            while (jj < domainDim) {
                u_vectors[ii][jj] = 0.0;
                if (r_comps[jj].equals(d_partial_s[ii])) {
                    u_index[ii] = jj;
                    u_vectors[ii][jj] = 1.0;
                    ++found;
                } else if (d_reference != null && r_compsRef[jj].equals(d_partial_s[ii])) {
                    u_index[ii] = jj;
                    u_vectors[jj][ii] = 1.0;
                    ++foundRef;
                }
                ++jj;
            }
            ++ii;
        }
        if (found == 0) {
            if (foundRef == 0) {
                throw new VisADException("derivative: d_partial_s not in domain or reference");
            }
            if (0 < foundRef && foundRef < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = true;
        } else {
            if (0 < found && found < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = false;
        }
        Unit[] D_units = null;
        Unit[][] R_units = this.getRangeUnits();
        Object derivNames = null;
        Unit[][] derivUnits = new Unit[n_partials][this.TupleDimension];
        MathType[] new_range = new MathType[n_partials];
        MathType[] new_types = new MathType[n_partials];
        D_units = !transform ? domainSet.getSetUnits() : d_reference.getDefaultUnits();
        ii = 0;
        while (ii < n_partials) {
            jj = 0;
            while (jj < this.TupleDimension) {
                derivUnits[ii][jj] = R_units == null || D_units == null ? null : (R_units[jj][0] == null || D_units[u_index[ii]] == null ? null : R_units[jj][0].divide(D_units[u_index[ii]]));
                ++jj;
            }
            ++ii;
        }
        if (derivType_s == null) {
            ii = 0;
            while (ii < n_partials) {
                MathType M_type = this.Type.cloneDerivative(d_partial_s[ii]);
                new_types[ii] = thisDomainFlag ? M_type : ((FunctionType)M_type).getRange();
                ++ii;
            }
            derivType_s = new_types;
        } else {
            if (derivType_s.length != n_partials) {
                throw new VisADException("derivative: must be a single MathType for each domain RealType");
            }
            ii = 0;
            while (ii < n_partials) {
                if (thisDomainFlag ? !this.Type.equalsExceptName(derivType_s[ii]) : !((FunctionType)this.Type).getRange().equalsExceptName(derivType_s[ii])) {
                    throw new TypeException("derivative: incompatible with function range");
                }
                ++ii;
            }
        }
        double[][][] p_derivatives = null;
        Data[] datums = new DataImpl[n_partials];
        ErrorEstimate[][] rangeErrors_out = new ErrorEstimate[n_partials][this.TupleDimension];
        if (thisDomainFlag) {
            p_derivatives = new double[n_partials][this.TupleDimension][n_samples];
            ii = 0;
            while (ii < n_partials) {
                datums[ii] = this.cloneDouble(derivType_s[ii], derivUnits[ii], null);
                ++ii;
            }
            if (this.isMissing()) {
                if (n_partials == 1) {
                    return datums[0];
                }
                return new Tuple(datums);
            }
        } else {
            p_derivatives = new double[n_partials][this.TupleDimension][1];
            if (this.isMissing()) {
                ii = 0;
                while (ii < n_partials) {
                    jj = 0;
                    while (jj < this.TupleDimension) {
                        p_derivatives[ii][jj][0] = Double.NaN;
                        rangeErrors_out[ii][jj] = null;
                        ++jj;
                    }
                    ++ii;
                }
            }
        }
        if (!this.isMissing()) {
            int rr;
            int kk;
            double[][] rangeValues = null;
            Object neighbors = null;
            ErrorEstimate[] domainErrors = domainSet.getSetErrors();
            if (domainSet instanceof LinearSet && thisDomainFlag) {
                rangeValues = this.getValues();
                kk = 0;
                while (kk < n_partials) {
                    int m_index = u_index[kk];
                    neighbors = domainSet.getNeighbors(m_index);
                    float step = (float)((LinearSet)((Object)domainSet)).getLinear1DComponent(kk).getStep();
                    ii = 0;
                    while (ii < n_samples) {
                        int index;
                        int n_index;
                        float distance;
                        if (neighbors[ii][0] == -1) {
                            distance = step;
                            n_index = neighbors[ii][1];
                            index = ii;
                        } else if (neighbors[ii][1] == -1) {
                            distance = step;
                            n_index = ii;
                            index = neighbors[ii][0];
                        } else {
                            distance = 2.0f * step;
                            n_index = neighbors[ii][1];
                            index = neighbors[ii][0];
                        }
                        rr = 0;
                        while (rr < this.TupleDimension) {
                            p_derivatives[kk][rr][ii] = (rangeValues[rr][n_index] - rangeValues[rr][index]) / (double)distance;
                            ++rr;
                        }
                        ++ii;
                    }
                    if (error_mode != 202) {
                        rr = 0;
                        while (rr < this.TupleDimension) {
                            double[] d_values = p_derivatives[kk][rr];
                            rangeErrors_out[kk][rr] = new ErrorEstimate(d_values, derivUnits[kk][rr], 5, this.RangeErrors[rr], domainErrors[m_index], error_mode);
                            ++rr;
                        }
                    }
                    ++kk;
                }
                neighbors = null;
                rangeValues = null;
            } else {
                int n_points;
                float[][] Samples;
                float[][] weights = null;
                if (thisDomainFlag) {
                    rangeValues = this.getValues();
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    domainSet.getNeighbors((int[][])neighbors, weights);
                    if (transform) {
                        Samples = domainSet.getSamples(true);
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    } else {
                        Samples = domainSet.getSamples(false);
                    }
                } else {
                    n_samples = 1;
                    float[][] org_Samples = domainSet.getSamples(false);
                    FlatField new_field = (FlatField)this.resample(new SingletonSet(location, null, null, null), 101, error_mode);
                    float[][] evalSamples = new_field.getDomainSet().getSamples(false);
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    ((SimpleSet)this.DomainSet).valueToInterp(evalSamples, (int[][])neighbors, weights);
                    n_points = neighbors[0].length;
                    int[][] new_neighbors = new int[n_samples][n_points];
                    double[][] new_rangeValues = new double[this.TupleDimension][n_points + 1];
                    float[][] new_Samples = new float[domainDim][n_points + 1];
                    ii = 0;
                    while (ii < domainDim) {
                        new_Samples[ii][0] = evalSamples[ii][0];
                        ++ii;
                    }
                    double[] d_array = new_field.unpackValues(0);
                    ii = 0;
                    while (ii < this.TupleDimension) {
                        new_rangeValues[ii][0] = d_array[ii];
                        ++ii;
                    }
                    kk = 0;
                    while (kk < n_points) {
                        d_array = this.unpackValues(neighbors[0][kk]);
                        new_neighbors[0][kk] = kk + 1;
                        ii = 0;
                        while (ii < this.TupleDimension) {
                            new_rangeValues[ii][kk + 1] = d_array[ii];
                            ++ii;
                        }
                        ii = 0;
                        while (ii < domainDim) {
                            new_Samples[ii][kk + 1] = org_Samples[ii][neighbors[0][kk]];
                            ++ii;
                        }
                        ++kk;
                    }
                    neighbors = new_neighbors;
                    rangeValues = new_rangeValues;
                    Samples = new_Samples;
                    if (transform) {
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    }
                }
                ii = 0;
                while (ii < n_samples) {
                    int dd;
                    n_points = neighbors[ii].length;
                    double[] distances = new double[n_points];
                    double[][] derivatives = new double[n_points][this.TupleDimension];
                    double[][] uvecPoint = new double[n_points][domainDim];
                    kk = 0;
                    while (kk < n_points) {
                        float f_sum = 0.0f;
                        dd = 0;
                        while (dd < domainDim) {
                            f_sum += (Samples[dd][neighbors[ii][kk]] - Samples[dd][ii]) * (Samples[dd][neighbors[ii][kk]] - Samples[dd][ii]);
                            uvecPoint[kk][dd] = Samples[dd][neighbors[ii][kk]] - Samples[dd][ii];
                            ++dd;
                        }
                        distances[kk] = Math.sqrt(f_sum);
                        rr = 0;
                        while (rr < this.TupleDimension) {
                            derivatives[kk][rr] = rangeValues[rr][neighbors[ii][kk]] - rangeValues[rr][ii];
                            ++rr;
                        }
                        ++kk;
                    }
                    pp = 0;
                    while (pp < n_partials) {
                        float sum_weights = 0.0f;
                        kk = 0;
                        while (kk < n_points) {
                            float dotproduct = 0.0f;
                            dd = 0;
                            while (dd < domainDim) {
                                dotproduct = (float)((double)dotproduct + uvecPoint[kk][dd] * u_vectors[pp][dd]);
                                ++dd;
                            }
                            float inv_dotproduct = 1.0f / dotproduct;
                            if (!Float.isInfinite(inv_dotproduct)) {
                                sum_weights += weights[ii][kk];
                                rr = 0;
                                while (rr < this.TupleDimension) {
                                    double[] dArray = p_derivatives[pp][rr];
                                    int n = ii;
                                    dArray[n] = dArray[n] + derivatives[kk][rr] * (double)inv_dotproduct * (double)weights[ii][kk];
                                    ++rr;
                                }
                            }
                            ++kk;
                        }
                        rr = 0;
                        while (rr < this.TupleDimension) {
                            double[] dArray = p_derivatives[pp][rr];
                            int n = ii;
                            dArray[n] = dArray[n] / (double)sum_weights;
                            ++rr;
                        }
                        ++pp;
                    }
                    ++ii;
                }
            }
        }
        double[][] s_samples = null;
        pp = 0;
        while (pp < n_partials) {
            s_samples = p_derivatives[pp];
            if (thisDomainFlag) {
                ((FlatField)datums[pp]).setSamples(s_samples);
                ((FlatField)datums[pp]).setRangeErrors(rangeErrors_out[pp]);
            } else {
                MathType M_type = derivType_s[pp];
                if (M_type instanceof RealType) {
                    datums[pp] = new Real((RealType)M_type, s_samples[0][0], derivUnits[pp][0], rangeErrors_out[pp][0]);
                } else if (M_type instanceof RealTupleType) {
                    Real[] reals = new Real[this.TupleDimension];
                    ii = 0;
                    while (ii < this.TupleDimension) {
                        reals[ii] = new Real((RealType)((TupleType)M_type).getComponent(ii), s_samples[ii][0], derivUnits[pp][ii], rangeErrors_out[pp][0]);
                        ++ii;
                    }
                    datums[pp] = new RealTuple((RealTupleType)M_type, reals, this.RangeCoordinateSystem);
                } else if (M_type instanceof TupleType) {
                    int ss = 0;
                    int tt = 0;
                    int n_comps = ((TupleType)M_type).getDimension();
                    Data[] s_datums = new Data[n_comps];
                    ii = 0;
                    while (ii < n_comps) {
                        m_type = ((TupleType)M_type).getComponent(ii);
                        if (m_type instanceof RealType) {
                            s_datums[ii] = new Real((RealType)m_type, s_samples[tt][0], derivUnits[pp][ii], rangeErrors_out[pp][ii]);
                            ++tt;
                        } else if (m_type instanceof RealTupleType) {
                            int n_compsI = ((TupleType)m_type).getDimension();
                            Real[] reals = new Real[n_compsI];
                            jj = 0;
                            while (jj < n_compsI) {
                                reals[jj] = new Real((RealType)((TupleType)m_type).getComponent(jj), s_samples[tt][0], derivUnits[pp][jj], rangeErrors_out[pp][jj]);
                                ++tt;
                                ++jj;
                            }
                            s_datums[ii] = new RealTuple((RealTupleType)m_type, reals, this.RangeCoordinateSystems[ss]);
                            ++ss;
                        }
                        ++ii;
                    }
                    datums[pp] = new Tuple((TupleType)M_type, s_datums);
                }
            }
            ++pp;
        }
        if (n_partials == 1) {
            return datums[0];
        }
        return new Tuple(datums);
    }

    public Data derivative(int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = null;
        return this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Data derivative(MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        return this.derivative(null, null, derivType_s, error_mode);
    }

    public Function derivative(RealType d_partial, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = new RealType[]{d_partial};
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Function derivative(RealType d_partial, MathType derivType, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = new MathType[1];
        RealType[] d_partial_s = new RealType[1];
        derivType_s[0] = derivType;
        d_partial_s[0] = d_partial;
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        double[] new_valuesJ;
        float[] valuesJ;
        int j;
        Object indices;
        int i;
        boolean sampling_errors;
        ErrorEstimate[] range_errors_in;
        if (this.DomainSet.equals(set)) {
            return this;
        }
        int dim = this.DomainSet.getDimension();
        if (dim != set.getDimension()) {
            throw new SetException("FlatField.resample: bad Set Dimension");
        }
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = error_mode == 202 ? new ErrorEstimate[dim] : set.getSetErrors();
        Set[] sets = new Set[this.TupleDimension];
        int i2 = 0;
        while (i2 < this.TupleDimension) {
            SetType set_type = new SetType(((FunctionType)this.Type).getFlatRange().getComponent(i2));
            sets[i2] = sampling_mode == 100 ? this.RangeSet[i2] : new FloatSet(set_type);
            ++i2;
        }
        MathType range_type = ((FunctionType)this.Type).getRange();
        RealTupleType domain_type = ((SetType)set.getType()).getDomain();
        FunctionType func_type = new FunctionType(domain_type, range_type);
        FlatField new_field = new FlatField(func_type, set, this.RangeCoordinateSystem, this.RangeCoordinateSystems, sets, this.RangeUnits);
        if (this.isMissing()) {
            return new_field;
        }
        ErrorEstimate[] range_errors_out = range_errors_in = error_mode == 202 ? new ErrorEstimate[this.TupleDimension] : this.RangeErrors;
        int length = set.getLength();
        int[] wedge = set.getWedge();
        float[][] vals = set.indexToValue(wedge);
        ErrorEstimate[] errors_out = new ErrorEstimate[dim];
        float[][] oldvals = vals;
        try {
            vals = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, errors, vals);
        }
        catch (UnitException ue) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean coord_transform = vals != oldvals;
        boolean bl = sampling_errors = error_mode != 202;
        if (sampling_errors) {
            i = 0;
            while (i < dim) {
                if (errors_out[i] == null) {
                    sampling_errors = false;
                }
                ++i;
            }
            boolean any_range_error = false;
            i = 0;
            while (i < this.TupleDimension) {
                if (range_errors_in[i] != null) {
                    any_range_error = true;
                }
                ++i;
            }
            if (!any_range_error) {
                sampling_errors = false;
            }
        }
        float[][] sampling_partials = new float[this.TupleDimension][dim];
        float[][] error_values = new float[1][1];
        if (sampling_errors) {
            error_values = Set.doubleToFloat(ErrorEstimate.init_error_values(errors_out));
        }
        float[][] values = null;
        if (sampling_errors || 10 * length > this.getLength()) {
            values = this.unpackFloats(false);
        }
        double[][] new_values = new double[this.TupleDimension][length];
        if (sampling_mode == 101 && this.DomainSet instanceof SimpleSet) {
            int k;
            indices = new int[length][];
            float[][] coefs = new float[length][];
            ((SimpleSet)this.DomainSet).valueToInterp(vals, (int[][])indices, coefs);
            if (values != null) {
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    new_valuesJ = new_values[j];
                    i = 0;
                    while (i < length) {
                        int len;
                        float v = Float.NaN;
                        int n = len = indices[i] == null ? 0 : ((int)indices[i]).length;
                        if (len > 0) {
                            v = valuesJ[indices[i][0]] * coefs[i][0];
                            k = 1;
                            while (k < len) {
                                v += valuesJ[indices[i][k]] * coefs[i][k];
                                ++k;
                            }
                            new_valuesJ[wedge[i]] = v;
                        } else {
                            new_valuesJ[wedge[i]] = Double.NaN;
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                i = 0;
                while (i < length) {
                    int len;
                    int n = len = indices[i] == null ? 0 : ((int)indices[i]).length;
                    if (len > 0) {
                        double[][] xvals = new double[len][];
                        k = 0;
                        while (k < len) {
                            xvals[k] = this.unpackValues((int)indices[i][k]);
                            ++k;
                        }
                        j = 0;
                        while (j < this.TupleDimension) {
                            float v = (float)xvals[0][j] * coefs[i][0];
                            k = 1;
                            while (k < len) {
                                v += (float)xvals[k][j] * coefs[i][k];
                                ++k;
                            }
                            new_values[j][wedge[i]] = v;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.TupleDimension) {
                            new_values[j][wedge[i]] = Double.NaN;
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (sampling_errors) {
                int[][] error_indices = new int[2 * dim][];
                float[][] error_coefs = new float[2 * dim][];
                ((SimpleSet)this.DomainSet).valueToInterp(error_values, error_indices, error_coefs);
                j = 0;
                while (j < this.TupleDimension) {
                    i = 0;
                    while (i < dim) {
                        float a = Float.NaN;
                        float b = Float.NaN;
                        int len = error_indices[2 * i].length;
                        if (len > 0) {
                            a = values[j][error_indices[2 * i][0]] * error_coefs[2 * i][0];
                            k = 1;
                            while (k < len) {
                                a += values[j][error_indices[2 * i][k]] * error_coefs[2 * i][k];
                                ++k;
                            }
                        }
                        if ((len = error_indices[2 * i + 1].length) > 0) {
                            b = values[j][error_indices[2 * i + 1][0]] * error_coefs[2 * i + 1][0];
                            k = 1;
                            while (k < len) {
                                b += values[j][error_indices[2 * i + 1][k]] * error_coefs[2 * i + 1][k];
                                ++k;
                            }
                        }
                        sampling_partials[j][i] = Math.abs(b - a);
                        ++i;
                    }
                    ++j;
                }
            }
        } else {
            indices = this.DomainSet.valueToIndex(vals);
            if (values != null) {
                j = 0;
                while (j < this.TupleDimension) {
                    valuesJ = values[j];
                    new_valuesJ = new_values[j];
                    i = 0;
                    while (i < length) {
                        new_valuesJ[wedge[i]] = indices[i] >= 0 ? (double)valuesJ[indices[i]] : Double.NaN;
                        ++i;
                    }
                    ++j;
                }
            } else {
                i = 0;
                while (i < length) {
                    if (indices[i] >= 0) {
                        double[] xvals = this.unpackValues(indices[i]);
                        j = 0;
                        while (j < this.TupleDimension) {
                            new_values[j][wedge[i]] = (float)xvals[j];
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.TupleDimension) {
                            new_values[j][wedge[i]] = Double.NaN;
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (sampling_errors) {
                int[] error_indices = this.DomainSet.valueToIndex(error_values);
                j = 0;
                while (j < this.TupleDimension) {
                    i = 0;
                    while (i < dim) {
                        float a = error_indices[2 * i] >= 0 ? values[j][error_indices[2 * i]] : Float.NaN;
                        float b = error_indices[2 * i + 1] >= 0 ? values[j][error_indices[2 * i + 1]] : Float.NaN;
                        sampling_partials[j][i] = Math.abs(b - a);
                        ++i;
                    }
                    ++j;
                }
            }
        }
        if (sampling_errors) {
            j = 0;
            while (j < this.TupleDimension) {
                if (range_errors_in[j] != null) {
                    float error = (float)range_errors_in[j].getErrorValue();
                    if (error_mode == 200) {
                        error *= error;
                        i = 0;
                        while (i < dim) {
                            error += sampling_partials[j][i] * sampling_partials[j][i];
                            ++i;
                        }
                        error = (float)Math.sqrt(error);
                    } else {
                        i = 0;
                        while (i < dim) {
                            error += sampling_partials[j][i];
                            ++i;
                        }
                    }
                    range_errors_out[j] = new ErrorEstimate(new_values[j], (double)error, this.RangeUnits[j]);
                }
                ++j;
            }
        } else if (error_mode != 202) {
            j = 0;
            while (j < this.TupleDimension) {
                if (range_errors_in[j] != null) {
                    range_errors_out[j] = new ErrorEstimate(new_values[j], range_errors_in[j].getErrorValue(), this.RangeUnits[j]);
                }
                ++j;
            }
        }
        if (coord_transform) {
            range_errors_in = range_errors_out;
            MathType Range = ((FunctionType)this.Type).getRange();
            if (Range instanceof RealVectorType) {
                new_values = ((RealVectorType)Range).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, this.RangeCoordinateSystem, range_errors_in, range_errors_out, Set.floatToDouble(oldvals), Set.floatToDouble(vals), new_values);
            } else if (Range instanceof TupleType && !(Range instanceof RealTupleType)) {
                int offset = 0;
                int m = ((TupleType)Range).getDimension();
                j = 0;
                while (j < m) {
                    MathType comp_type = ((TupleType)Range).getComponent(j);
                    if (comp_type instanceof RealVectorType) {
                        int mm = ((RealVectorType)comp_type).getDimension();
                        Object comp_vals = new double[mm][];
                        int jj = 0;
                        while (jj < mm) {
                            comp_vals[jj] = new_values[offset + jj];
                            ++jj;
                        }
                        ErrorEstimate[] comp_errors_in = new ErrorEstimate[mm];
                        int jj2 = 0;
                        while (jj2 < mm) {
                            comp_errors_in[jj2] = range_errors_in[offset + jj2];
                            ++jj2;
                        }
                        ErrorEstimate[] comp_errors_out = comp_errors_in;
                        comp_vals = ((RealVectorType)comp_type).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, this.RangeCoordinateSystems[j], comp_errors_in, comp_errors_out, Set.floatToDouble(oldvals), Set.floatToDouble(vals), (double[][])comp_vals);
                        int jj3 = 0;
                        while (jj3 < mm) {
                            new_values[offset + jj3] = comp_vals[jj3];
                            ++jj3;
                        }
                        int jj4 = 0;
                        while (jj4 < mm) {
                            range_errors_out[offset + jj4] = comp_errors_out[jj4];
                            ++jj4;
                        }
                    }
                    offset = comp_type instanceof RealType ? ++offset : (offset += ((RealTupleType)comp_type).getDimension());
                    ++j;
                }
            }
        }
        new_field.packValues(new_values, false);
        new_field.setRangeErrors(range_errors_out);
        new_field.clearMissing();
        return new_field;
    }

    public Field convertToField() throws VisADException, RemoteException {
        FieldImpl new_field = new FieldImpl((FunctionType)this.Type, this.DomainSet);
        if (this.isMissing()) {
            return new_field;
        }
        int i = 0;
        while (i < this.Length) {
            new_field.setSample(i, this.getSample(i));
            ++i;
        }
        return new_field;
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        boolean anyRangeRef;
        if (this.isMissing()) {
            return shadow;
        }
        ShadowRealTupleType domain_type = ((ShadowFunctionType)type).getDomain();
        int n = domain_type.getDimension();
        double[][] ranges = new double[2][n];
        shadow = this.DomainSet.computeRanges(domain_type, shadow, ranges, true);
        int[] indices = ((ShadowFunctionType)type).getRangeDisplayIndices();
        boolean any_mapped = false;
        int i = 0;
        while (i < this.TupleDimension) {
            if (indices[i] >= 0) {
                any_mapped = true;
            }
            ++i;
        }
        if (!any_mapped) {
            return shadow;
        }
        boolean bl = anyRangeRef = this.RangeCoordinateSystem != null;
        if (this.RangeCoordinateSystems != null) {
            int i2 = 0;
            while (i2 < this.RangeCoordinateSystems.length) {
                anyRangeRef |= this.RangeCoordinateSystems[i2] != null;
                ++i2;
            }
        }
        ranges = anyRangeRef ? new double[2][this.TupleDimension] : null;
        double[][] values = this.unpackValues();
        int i3 = 0;
        while (i3 < this.TupleDimension) {
            double[] valuesI = values[i3];
            int k = indices[i3];
            if (k >= 0 || anyRangeRef) {
                double min = Double.MAX_VALUE;
                double max = -1.7976931348623157E308;
                int j = 0;
                while (j < this.Length) {
                    if (valuesI[j] == valuesI[j]) {
                        min = Math.min(min, valuesI[j]);
                        max = Math.max(max, valuesI[j]);
                    }
                    ++j;
                }
                Unit dunit = ((RealType)((FunctionType)this.Type).getFlatRange().getComponent(i3)).getDefaultUnit();
                if (dunit != null && !dunit.equals(this.RangeUnits[i3])) {
                    min = dunit.toThis(min, this.RangeUnits[i3]);
                    max = dunit.toThis(max, this.RangeUnits[i3]);
                }
                if (anyRangeRef) {
                    ranges[0][i3] = Math.min(ranges[0][i3], min);
                    ranges[1][i3] = Math.max(ranges[1][i3], max);
                }
                if (k >= 0 && k < shadow.ranges[0].length) {
                    shadow.ranges[0][k] = Math.min(shadow.ranges[0][k], min);
                    shadow.ranges[1][k] = Math.max(shadow.ranges[1][k], max);
                }
            }
            ++i3;
        }
        if (this.RangeCoordinateSystem != null) {
            ShadowRealTupleType range_type = (ShadowRealTupleType)((ShadowFunctionType)type).getRange();
            ShadowRealTupleType shad_ref = range_type.getReference();
            shadow = this.computeReferenceRanges(range_type, this.RangeCoordinateSystem, this.RangeUnits, shadow, shad_ref, ranges);
        } else if (this.RangeCoordinateSystems != null) {
            TupleType RangeType = (TupleType)((FunctionType)this.Type).getRange();
            int j = 0;
            int i4 = 0;
            while (i4 < this.RangeCoordinateSystems.length) {
                MathType component = RangeType.getComponent(i4);
                if (component instanceof RealType) {
                    ++j;
                } else {
                    int m = ((RealTupleType)component).getDimension();
                    if (this.RangeCoordinateSystems[i4] != null) {
                        double[][] sub_ranges = new double[2][m];
                        Unit[] sub_units = new Unit[m];
                        int k = 0;
                        while (k < m) {
                            sub_ranges[0][k] = ranges[0][j];
                            sub_ranges[1][k] = ranges[1][j];
                            sub_units[k] = this.RangeUnits[j];
                            ++j;
                            ++k;
                        }
                        ShadowRealTupleType range_type = (ShadowRealTupleType)((ShadowTupleType)((ShadowFunctionType)type).getRange()).getComponent(i4);
                        ShadowRealTupleType shad_ref = range_type.getReference();
                        shadow = this.computeReferenceRanges(range_type, this.RangeCoordinateSystems[i4], sub_units, shadow, shad_ref, sub_ranges);
                    } else {
                        j += m;
                    }
                }
                ++i4;
            }
        }
        return shadow;
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || error == null || error.isMissing()) {
            return this;
        }
        FlatField field = new FlatField((FunctionType)this.Type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
        if (this.isMissing()) {
            return field;
        }
        FlatField new_error = (FlatField)((FlatField)error).resample(this.DomainSet, 100, 202);
        double[][] values = this.unpackValues();
        field.packValues(values, false);
        ErrorEstimate[] errors = new ErrorEstimate[this.TupleDimension];
        double[][] error_values = new_error.unpackValues();
        int i = 0;
        while (i < this.TupleDimension) {
            double a = 0.0;
            int k = 0;
            while (k < error_values[i].length) {
                a += error_values[i][k];
                ++k;
            }
            double b = this.RangeErrors[i].getErrorValue();
            double e = error_mode == 200 ? Math.sqrt(a * a + b * b) : Math.abs(a /= (double)error_values.length) + Math.abs(b);
            errors[i] = new ErrorEstimate(values[i], e, this.RangeUnits[i]);
            ++i;
        }
        field.setRangeErrors(errors);
        return field;
    }

    public boolean isFlatField() {
        return true;
    }

    private FlatField cloneDouble() throws VisADException {
        return this.cloneDouble(this.RangeUnits, this.RangeErrors);
    }

    private FlatField cloneDouble(Unit[] units, ErrorEstimate[] errors) throws VisADException {
        return this.cloneDouble(null, units, errors);
    }

    private FlatField cloneDouble(MathType f_type, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        MathType N_type = f_type == null ? this.Type : f_type;
        Set[] sets = new Set[this.TupleDimension];
        int i = 0;
        while (i < this.TupleDimension) {
            SetType set_type = new SetType(((FunctionType)N_type).getFlatRange().getComponent(i));
            sets[i] = new DoubleSet(set_type);
            ++i;
        }
        FlatField field = new FlatField((FunctionType)N_type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, sets, units);
        double[][] values = this.unpackValues();
        field.packValues(values, false);
        field.setRangeErrors(errors);
        field.clearMissing();
        return field;
    }

    private FlatField cloneMissing() throws VisADException {
        return new FlatField((FunctionType)this.Type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
    }

    public Object clone() {
        FlatField field;
        try {
            field = new FlatField((FunctionType)this.Type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
            if (this.isMissing()) {
                return field;
            }
            double[][] values = this.unpackValues();
            field.packValues(values, true);
            field.setRangeErrors(this.RangeErrors);
        }
        catch (VisADException e) {
            throw new VisADError("FlatField.clone: VisADException occurred");
        }
        return field;
    }

    String valuesString() throws VisADException {
        StringBuffer s = new StringBuffer("");
        int ncolumns = 8 / this.TupleDimension;
        if (ncolumns < 1) {
            ncolumns = 1;
        }
        int rowlength = this.DomainSet instanceof GriddedSet ? ((GriddedSet)this.DomainSet).getLength(0) : this.Length;
        RealTupleType range = ((FunctionType)this.Type).getFlatRange();
        RealType[] types = range.getRealComponents();
        double[][] values = this.unpackValues();
        int rl = rowlength;
        int i = 0;
        while (i < this.Length) {
            int nc = Math.min(rl, Math.min(ncolumns, this.Length - i));
            int ip = i + nc;
            int k = i;
            while (k < ip) {
                if (k > i) {
                    s.append(", ");
                }
                if (this.TupleDimension == 1) {
                    s.append(new Real(types[0], values[0][k], this.RangeUnits[0]).toString());
                } else if (((FunctionType)this.Type).getReal()) {
                    String t = "(" + new Real(types[0], values[0][k], this.RangeUnits[0]);
                    int j = 1;
                    while (j < this.TupleDimension) {
                        t = t + ", " + new Real(types[j], values[j][k], this.RangeUnits[j]);
                        ++j;
                    }
                    t = t + ")";
                    s.append(t);
                } else {
                    TupleType RangeType = (TupleType)((FunctionType)this.Type).getRange();
                    String t = "(";
                    int j = 0;
                    int l = 0;
                    while (l < RangeType.getDimension()) {
                        MathType type;
                        if (j > 0) {
                            t = t + ", ";
                        }
                        if ((type = RangeType.getComponent(l)) instanceof RealType) {
                            t = t + new Real(types[j], values[j][k], this.RangeUnits[j]);
                            ++j;
                        } else {
                            int mm = ((TupleType)type).getDimension();
                            t = t + "(" + new Real(types[j], values[j][k], this.RangeUnits[j]);
                            ++j;
                            int kk = 1;
                            while (kk < mm) {
                                t = t + ", " + new Real(types[j], values[j][k], this.RangeUnits[j]);
                                ++j;
                                ++kk;
                            }
                            t = t + ")";
                        }
                        ++l;
                    }
                    t = t + ")";
                    s.append(t);
                }
                ++k;
            }
            s.append("\n");
            i = ip;
            if ((rl -= nc) > 0) continue;
            rl = rowlength;
            s.append("\n");
        }
        return s.toString();
    }

    public String toString() {
        try {
            if (this.isMissing()) {
                return "FlatField  missing\n";
            }
            return "FlatField\n    " + this.Type + "\n" + this.valuesString();
        }
        catch (VisADException e) {
            return e.toString();
        }
    }

    public String longString(String pre) throws VisADException {
        String t = pre + "FlatField\n" + pre + "  Type: " + this.Type.toString() + "\n";
        t = this.DomainSet != null ? t + pre + "  DomainSet:\n" + this.DomainSet.longString(pre + "    ") : t + pre + "  DomainSet: undefined\n";
        int i = 0;
        while (i < this.TupleDimension) {
            t = this.RangeSet[i] != null ? t + pre + "  RangeSet[" + i + "]:\n" + this.RangeSet[i].longString(pre + "    ") : t + pre + "  RangeSet[" + i + "]: undefined\n";
            ++i;
        }
        if (this.isMissing()) {
            return t + "  missing\n";
        }
        return t + this.valuesString();
    }

    public int getRangeDimension() {
        return this.TupleDimension;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null || !(obj instanceof FlatField)) {
            return false;
        }
        FlatField fld = (FlatField)obj;
        if (this.RangeMode == null || fld.RangeMode == null) {
            if (this.RangeMode != null || fld.RangeMode != null) {
                return false;
            }
        } else {
            if (this.RangeMode.length != fld.RangeMode.length) {
                return false;
            }
            i = 0;
            while (i < this.RangeMode.length) {
                if (this.RangeMode[i] != fld.RangeMode[i]) {
                    return false;
                }
                ++i;
            }
        }
        if (this.RangeSet == null || fld.RangeSet == null) {
            if (this.RangeSet != null || fld.RangeSet != null) {
                return false;
            }
        } else {
            if (this.RangeSet.length != fld.RangeSet.length) {
                return false;
            }
            i = 0;
            while (i < this.RangeSet.length) {
                if (!this.RangeSet[i].equals(fld.RangeSet[i])) {
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.TupleDimension) {
            switch (this.RangeMode[i]) {
                case 1: {
                    if (Arrays.equals(this.DoubleRange[i], fld.DoubleRange[i])) break;
                    return false;
                }
                case 2: {
                    if (Arrays.equals(this.FloatRange[i], fld.FloatRange[i])) break;
                    return false;
                }
                case 6: {
                    if (Arrays.equals(this.ByteRange[i], fld.ByteRange[i])) break;
                    return false;
                }
                case 5: {
                    if (Arrays.equals(this.ShortRange[i], fld.ShortRange[i])) break;
                    return false;
                }
                case 4: {
                    if (Arrays.equals(this.IntRange[i], fld.IntRange[i])) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return super.equals(obj);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FlatField makeField(FunctionType type, int length, boolean irregular) throws VisADException, RemoteException {
        void var15_18;
        double first = 0.0;
        double last = (double)length - 1.0;
        double step = 1.0;
        double half = 0.5 * last;
        RealTupleType dtype = type.getDomain();
        RealTupleType rtype = type.getFlatRange();
        int domain_dim = dtype.getDimension();
        int range_dim = rtype.getDimension();
        Object var15_11 = null;
        int dsize = 0;
        Random random = new Random();
        if (irregular) {
            float[][] samples;
            if (domain_dim == 1) {
                dsize = length;
                samples = new float[1][dsize];
                int i = 0;
                while (i < dsize) {
                    samples[0][i] = (float)(last * (double)random.nextFloat());
                    ++i;
                }
                Irregular1DSet irregular1DSet = new Irregular1DSet((MathType)dtype, samples);
            } else if (domain_dim == 2) {
                dsize = length * length;
                samples = new float[2][dsize];
                int i = 0;
                while (i < dsize) {
                    samples[0][i] = (float)(last * (double)random.nextFloat());
                    samples[1][i] = (float)(last * (double)random.nextFloat());
                    ++i;
                }
                Irregular2DSet irregular2DSet = new Irregular2DSet((MathType)dtype, samples);
            } else {
                if (domain_dim != 3) throw new FieldException("FlatField.makeField: bad domain dimension");
                dsize = length * length * length;
                samples = new float[3][dsize];
                int i = 0;
                while (i < dsize) {
                    samples[0][i] = (float)(last * (double)random.nextFloat());
                    samples[1][i] = (float)(last * (double)random.nextFloat());
                    samples[2][i] = (float)(last * (double)random.nextFloat());
                    ++i;
                }
                Irregular3DSet irregular3DSet = new Irregular3DSet((MathType)dtype, samples);
            }
        } else if (domain_dim == 1) {
            Linear1DSet linear1DSet = new Linear1DSet((MathType)dtype, first, last, length);
            dsize = length;
        } else if (domain_dim == 2) {
            Linear2DSet linear2DSet = new Linear2DSet((MathType)dtype, first, last, length, first, last, length);
            dsize = length * length;
        } else {
            if (domain_dim != 3) throw new FieldException("FlatField.makeField: bad domain dimension");
            Linear3DSet linear3DSet = new Linear3DSet((MathType)dtype, first, last, length, first, last, length, first, last, length);
            dsize = length * length * length;
        }
        FlatField image = new FlatField(type, (Set)var15_18);
        FlatField.fillField(image, step, half);
        return image;
    }

    public static void fillField(FlatField image, double step, double half) throws VisADException, RemoteException {
        Random random = new Random();
        FunctionType type = (FunctionType)image.getType();
        RealTupleType dtype = type.getDomain();
        RealTupleType rtype = type.getFlatRange();
        int domain_dim = dtype.getDimension();
        int range_dim = rtype.getDimension();
        SampledSet domain_set = (SampledSet)image.getDomainSet();
        int dsize = domain_set.getLength();
        double[][] data = new double[range_dim][dsize];
        float[][] samples = domain_set.getSamples();
        int k = 0;
        while (k < range_dim) {
            float y;
            float x;
            int i;
            if (domain_dim == 1) {
                i = 0;
                while (i < dsize) {
                    x = samples[0][i];
                    data[k][i] = k == 0 ? (double)((float)Math.abs(step * ((double)x - half))) : (k == 1 ? (double)x : random.nextDouble());
                    ++i;
                }
            } else if (domain_dim == 2) {
                i = 0;
                while (i < dsize) {
                    x = samples[0][i];
                    y = samples[1][i];
                    data[k][i] = k == 0 ? (double)((float)(step * Math.sqrt(((double)x - half) * ((double)x - half) + ((double)y - half) * ((double)y - half)))) : (k == 1 ? (double)x : (k == 2 ? (double)y : random.nextDouble()));
                    ++i;
                }
            } else if (domain_dim == 3) {
                i = 0;
                while (i < dsize) {
                    x = samples[0][i];
                    y = samples[1][i];
                    float z = samples[2][i];
                    data[k][i] = k == 0 ? (double)((float)(step * Math.sqrt(((double)x - half) * ((double)x - half) + ((double)y - half) * ((double)y - half) + ((double)z - half) * ((double)z - half)))) : (k == 1 ? (double)x : (k == 2 ? (double)y : (k == 3 ? (double)z : random.nextDouble())));
                    ++i;
                }
            }
            ++k;
        }
        image.setSamples(data);
    }

    public static FlatField makeField1(FunctionType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        double step1 = (last1 - first1) / (double)(length1 - 1);
        double step2 = (last2 - first2) / (double)(length2 - 1);
        Linear2DSet imageset = new Linear2DSet((MathType)type.getDomain(), first1, last1, length1, first2, last2, length2);
        FlatField image = new FlatField(type, imageset);
        double[][] data = new double[1][length1 * length2];
        int i = 0;
        while (i < length1) {
            int j = 0;
            while (j < length2) {
                data[0][i + length1 * j] = first1 + step1 * (double)i + (first2 + step2 * (double)j);
                ++j;
            }
            ++i;
        }
        image.setSamples(data);
        return image;
    }

    public static FlatField makeField2(FunctionType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        double step1 = (last1 - first1) / (double)(length1 - 1);
        double step2 = (last2 - first2) / (double)(length2 - 1);
        Linear2DSet imageset = new Linear2DSet((MathType)type.getDomain(), first1, last1, length1, first2, last2, length2);
        FlatField image = new FlatField(type, imageset);
        double[][] data = new double[2][length1 * length2];
        int i = 0;
        while (i < length1) {
            int j = 0;
            while (j < length2) {
                data[0][i + length1 * j] = first1 + step1 * (double)i;
                data[1][i + length1 * j] = first2 + step2 * (double)j;
                ++j;
            }
            ++i;
        }
        image.setSamples(data);
        return image;
    }

    static FlatField makeRandomField2(FunctionType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        double step1 = (last1 - first1) / (double)(length1 - 1);
        double step2 = (last2 - first2) / (double)(length2 - 1);
        Linear2DSet imageset = new Linear2DSet((MathType)type.getDomain(), first1, last1, length1, first2, last2, length2);
        FlatField image = new FlatField(type, imageset);
        Random random = new Random();
        double[][] data = new double[2][length1 * length2];
        int i = 0;
        while (i < length1) {
            int j = 0;
            while (j < length2) {
                data[0][i + length1 * j] = random.nextDouble();
                data[1][i + length1 * j] = random.nextDouble();
                ++j;
            }
            ++i;
        }
        image.setSamples(data);
        return image;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int b = 10;
        Real w = new Real(b);
        RealType X = RealType.getRealType("X");
        RealType Y = RealType.getRealType("Y");
        RealType Z = RealType.getRealType("Z");
        RealType A = RealType.getRealType("A");
        RealType B = RealType.getRealType("B");
        RealType[] domain2d = new RealType[]{X, Y};
        RealTupleType Domain2d = new RealTupleType(domain2d, null, null);
        Integer2DSet Domain2dSet = new Integer2DSet((MathType)Domain2d, 4, 4);
        Domain2d.setDefaultSet(Domain2dSet);
        RealType[] range2d = new RealType[]{A, B};
        RealTupleType Range2d = new RealTupleType(range2d);
        FunctionType Field2d1 = new FunctionType(Domain2d, A);
        FunctionType Field2d2 = new FunctionType(Domain2d, Range2d);
        double first11 = 0.0;
        double last11 = 3.0;
        int length11 = 4;
        double first12 = 0.0;
        double last12 = 3.0;
        int length12 = 4;
        FlatField image1 = FlatField.makeField1(Field2d1, first11, last11, length11, first12, last12, length12);
        FlatField image3 = FlatField.makeField2(Field2d2, first11, last11, length11, first12, last12, length12);
        Real[] reals = new Real[]{new Real(X, 1.5), new Real(Y, 2.5)};
        RealTuple val = new RealTuple(reals);
        double first21 = 0.0;
        double last21 = 3.0;
        int length21 = 7;
        double first22 = 0.0;
        double last22 = 3.0;
        int length22 = 7;
        FlatField image2 = FlatField.makeField1(Field2d1, first21, last21, length21, first22, last22, length22);
        FlatField image4 = FlatField.makeField2(Field2d2, first21, last21, length21, first22, last22, length22);
        System.out.println("image1 = " + image1);
        System.out.println("image2 = " + image2);
        System.out.println("image3 = " + image3);
        System.out.println("image4 = " + image4);
        System.out.println("sampling mode is NEAREST_NEIGHBOR");
        System.out.println("image3 + image4 = " + image3.add(image4));
        System.out.println("image4 - image3 = " + image4.subtract(image3));
        System.out.println("image3 * image4 = " + image3.multiply(image4));
        System.out.println("image4 / image3 = " + image4.divide(image3));
        System.out.println("sqrt(image3) = " + image3.sqrt());
        System.out.println("val = " + val + " image1(val) = " + image1.evaluate(val));
        System.out.println("val = " + val + " image3(val) = " + image3.evaluate(val) + "\n");
        System.out.println("image3 + val = " + image3.add(val));
        System.out.println("val - image3 = " + val.subtract(image3));
        System.out.println("image3 * val = " + image3.multiply(val));
        System.out.println("val / image3 = " + val.divide(image3));
        System.out.println("Field.Mode is WEIGHTED_AVERAGE");
        System.out.println("image3 + image4 = " + image3.add(image4, 101, 200));
        System.out.println("image4 - image3 = " + image4.subtract(image3, 101, 200));
        System.out.println("image3 * image4 = " + image3.multiply(image4, 101, 200));
        System.out.println("image4 / image3 = " + image4.divide(image3, 101, 200));
        System.out.println("val = " + val + " image1(val) = " + image1.evaluate(val, 101, 200));
        System.out.println("val = " + val + " image3(val) = " + image3.evaluate(val, 101, 200) + "\n");
        System.out.println("image3 + val = " + image3.add(val, 101, 200));
        System.out.println("val - image3 = " + val.subtract(image3, 101, 200));
        System.out.println("image3 * val = " + image3.multiply(val, 101, 200));
        System.out.println("val / image3 = " + val.divide(image3, 101, 200));
        System.out.println("sampling mode is NEAREST_NEIGHBOR");
        System.out.println("image1 + w = " + image1.add(w));
        System.out.println("image1 - w = " + image1.subtract(w));
        System.out.println("image1 * w = " + image1.multiply(w));
        System.out.println("image1 / w = " + image1.divide(w));
        System.out.println("w + image2 = " + w.add(image2));
        System.out.println("w - image2 = " + w.subtract(image2));
        System.out.println("w * image2 = " + w.multiply(image2));
        System.out.println("w / image2 = " + w.divide(image2));
        RealType[] range2t = new RealType[]{A, RealType.Time};
        RealTupleType Range2t = new RealTupleType(range2t);
        FunctionType Field2t2 = new FunctionType(Domain2d, Range2t);
        FlatField imaget = FlatField.makeField2(Field2t2, first11, last11, length11, first12, last12, length12);
        System.out.println("imaget = " + imaget);
    }
}

