/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class DisplayTupleType
extends RealTupleType {
    public DisplayTupleType(DisplayRealType[] types) throws VisADException {
        this(types, null);
    }

    public DisplayTupleType(DisplayRealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super((RealType[])types, coord_sys, null);
        if (coord_sys != null) {
            RealTupleType ref = coord_sys.getReference();
            if (!(ref instanceof DisplayTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference must be a DisplayTupleType");
            }
            if (Display.DisplaySpatialOffsetTuple.equals(ref)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplaySpatialOffsetTuple");
            }
            if (Display.DisplayFlow1Tuple.equals(ref)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplayFlow1Tuple");
            }
            if (Display.DisplayFlow2Tuple.equals(ref)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplayFlow2Tuple");
            }
            Unit[] default_units = this.getDefaultUnits();
            Unit[] coord_sys_units = coord_sys.getCoordinateSystemUnits();
            int n = default_units.length;
            boolean match = true;
            int i = 0;
            while (i < n) {
                if (default_units[i] == null) {
                    if (coord_sys_units[i] != null) {
                        match = false;
                    }
                } else if (!default_units[i].equals(coord_sys_units[i])) {
                    match = false;
                }
                ++i;
            }
            if (!match) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must equal default Units");
            }
        }
        int i = 0;
        while (i < types.length) {
            if (types[i].getTuple() != null) {
                throw new DisplayException("DisplayTupleType: DisplayRealType already part of a DisplayTupleType");
            }
            types[i].setTuple(this, i);
            ++i;
        }
    }

    DisplayTupleType(DisplayRealType[] types, boolean b) {
        this(types, (CoordinateSystem)null, b);
    }

    DisplayTupleType(DisplayRealType[] types, CoordinateSystem coord_sys, boolean b) {
        super((RealType[])types, coord_sys, b);
        int i = 0;
        while (i < types.length) {
            types[i].setTuple(this, i);
            ++i;
        }
    }
}

