/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import visad.ActionImpl;
import visad.ActivityHandler;
import visad.AnimationControl;
import visad.BadMappingException;
import visad.ConstantMap;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayActivity;
import visad.DisplayEvent;
import visad.DisplayException;
import visad.DisplayListener;
import visad.DisplayMapEvent;
import visad.DisplayRealType;
import visad.DisplayReferenceEvent;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.MathType;
import visad.MessageEvent;
import visad.MessageListener;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.ReferenceActionLink;
import visad.ReferenceException;
import visad.RemoteDataReference;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteReferenceLink;
import visad.RemoteSlaveDisplay;
import visad.RemoteSourceListener;
import visad.RemoteVisADException;
import visad.RendererSourceListener;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ThingReference;
import visad.TypeException;
import visad.ValueControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.browser.Divider;
import visad.collab.CollabUtil;
import visad.collab.ControlMonitorEvent;
import visad.collab.DisplayMonitor;
import visad.collab.DisplayMonitorImpl;
import visad.collab.DisplaySync;
import visad.collab.DisplaySyncImpl;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;
import visad.util.Delay;
import visad.util.GMCWidget;
import visad.util.LabeledColorWidget;
import visad.util.RangeWidget;
import visad.util.SelectRangeWidget;
import visad.util.VisADSlider;

public abstract class DisplayImpl
extends ActionImpl
implements LocalDisplay {
    private Vector MapVector = new Vector();
    private Vector ConstantMapVector = new Vector();
    private Vector RealTypeVector = new Vector();
    private Vector DisplayRealTypeVector = new Vector();
    private Vector ControlVector = new Vector();
    private Vector RendererVector = new Vector();
    private Vector RendererSourceListeners = new Vector();
    private Vector RmtSrcListeners = new Vector();
    private Vector MessageListeners = new Vector();
    private DisplayRenderer displayRenderer;
    Component component;
    private boolean initialize = true;
    private boolean always_initialize = false;
    private boolean redisplay_all = false;
    private int valueArrayLength;
    private int[] valueToScalar;
    private int[] valueToMap;
    private transient Vector ListenerVector = new Vector();
    private Object mapslock = new Object();
    private MouseBehavior mouse = null;
    private transient DisplayMonitor displayMonitor = null;
    private transient DisplaySync displaySync = null;
    private transient DisplayActivity displayActivity = null;
    private Printable printer;
    private boolean cluster = false;
    private RemoteDisplayImpl rd = null;
    private Vector Slaves = new Vector();
    private boolean[] eventStatus = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false};
    private boolean needWidgetRefresh = true;
    private JPanel widgetPanel = null;
    static /* synthetic */ Class class$visad$AnimationControl;
    static /* synthetic */ Class class$visad$ValueControl;

    public DisplayImpl(String name, DisplayRenderer renderer) throws VisADException, RemoteException {
        super(name);
        int i = 0;
        while (i < Display.DisplayRealArray.length) {
            this.DisplayRealTypeVector.addElement(Display.DisplayRealArray[i]);
            ++i;
        }
        this.displayMonitor = new DisplayMonitorImpl(this);
        this.displaySync = new DisplaySyncImpl(this);
        this.displayRenderer = renderer != null ? renderer : this.getDefaultDisplayRenderer();
        this.displayRenderer.setDisplay(this);
        this.clearMaps();
    }

    public DisplayImpl(RemoteDisplay rmtDpy, DisplayRenderer renderer) throws VisADException, RemoteException {
        this(rmtDpy, renderer, false);
    }

    public DisplayImpl(RemoteDisplay rmtDpy, DisplayRenderer renderer, boolean cl) throws VisADException, RemoteException {
        super(rmtDpy.getName() + ".remote");
        Class<?> rmtClass;
        this.cluster = cl;
        String className = rmtDpy.getDisplayClassName();
        try {
            rmtClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DisplayException("Cannot find remote display class " + className);
        }
        if (!rmtClass.isInstance(this)) {
            throw new DisplayException("Cannot construct " + this.getClass().getName() + " from remote " + className);
        }
        int i = 0;
        while (i < Display.DisplayRealArray.length) {
            this.DisplayRealTypeVector.addElement(Display.DisplayRealArray[i]);
            ++i;
        }
        this.displayMonitor = new DisplayMonitorImpl(this, this.cluster);
        this.displaySync = new DisplaySyncImpl(this, this.cluster);
        if (renderer != null) {
            this.displayRenderer = renderer;
        } else {
            try {
                String name = rmtDpy.getDisplayRendererClassName();
                Object obj = Class.forName(name).newInstance();
                this.displayRenderer = (DisplayRenderer)obj;
            }
            catch (Exception e) {
                this.displayRenderer = this.getDefaultDisplayRenderer();
            }
        }
        this.displayRenderer.setDisplay(this);
        this.clearMaps();
    }

    void copyScalarMaps(RemoteDisplay rmtDpy) {
        Vector m;
        try {
            m = rmtDpy.getMapVector();
        }
        catch (Exception e) {
            System.err.println("Couldn't copy ScalarMaps");
            return;
        }
        Enumeration me = m.elements();
        while (me.hasMoreElements()) {
            ScalarMap sm = (ScalarMap)me.nextElement();
            try {
                this.addMap((ScalarMap)sm.clone());
            }
            catch (DisplayException de) {
                try {
                    this.addMap(new ScalarMap(sm.getScalar(), sm.getDisplayScalar()));
                }
                catch (Exception e) {
                    System.err.println("Couldn't copy remote ScalarMap " + sm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void copyConstantMaps(RemoteDisplay rmtDpy) {
        Vector c;
        try {
            c = rmtDpy.getConstantMapVector();
        }
        catch (Exception e) {
            System.err.println("Couldn't copy ConstantMaps");
            return;
        }
        Enumeration ce = c.elements();
        while (ce.hasMoreElements()) {
            ConstantMap cm = (ConstantMap)ce.nextElement();
            try {
                this.addMap((ConstantMap)cm.clone());
            }
            catch (DisplayException de) {
                try {
                    this.addMap(new ConstantMap(cm.getConstant(), cm.getDisplayScalar()));
                }
                catch (Exception e) {
                    System.err.println("Couldn't copy remote ConstantMap " + cm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void copyGraphicsModeControl(RemoteDisplay rmtDpy) {
        try {
            this.getGraphicsModeControl().syncControl(rmtDpy.getGraphicsModeControl());
        }
        catch (UnmarshalException ue) {
            System.err.println("Couldn't copy remote GraphicsModeControl");
            return;
        }
        catch (ConnectException ce) {
            System.err.println("Couldn't copy remote GraphicsModeControl");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void copyRefLinks(RemoteDisplay rmtDpy, DataReference[] localRefs) {
        String[] refNames;
        Vector ml;
        try {
            ml = rmtDpy.getReferenceLinks();
        }
        catch (UnmarshalException ue) {
            System.err.println("Couldn't copy remote DataReferences");
            return;
        }
        catch (ConnectException ce) {
            System.err.println("Couldn't copy remote DataReferences");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (localRefs == null) {
            refNames = null;
        } else {
            refNames = new String[localRefs.length];
            int i = 0;
            while (i < refNames.length) {
                try {
                    refNames[i] = localRefs[i].getName();
                }
                catch (VisADException ve) {
                    refNames[i] = null;
                }
                catch (RemoteException re) {
                    refNames[i] = null;
                }
                ++i;
            }
        }
        Enumeration mle = ml.elements();
        if (mle.hasMoreElements()) {
            DataRenderer dr = this.displayRenderer.makeDefaultRenderer();
            String defaultClass = dr.getClass().getName();
            while (mle.hasMoreElements()) {
                DataRenderer renderer;
                RemoteDataReference ref;
                RemoteReferenceLink link = (RemoteReferenceLink)mle.nextElement();
                try {
                    ref = link.getReference();
                }
                catch (Exception e) {
                    System.err.println("Couldn't copy remote DataReference");
                    ref = null;
                }
                if (ref != null && refNames != null) {
                    String rName;
                    try {
                        rName = ref.getName();
                    }
                    catch (VisADException ve) {
                        System.err.println("Couldn't get DataReference name");
                        rName = null;
                    }
                    catch (RemoteException re) {
                        System.err.println("Couldn't get remote DataReference name");
                        rName = null;
                    }
                    if (rName != null) {
                        int i = 0;
                        while (i < refNames.length) {
                            if (rName.equals(refNames[i])) {
                                ref = null;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (ref == null) continue;
                ConstantMap[] cm = null;
                try {
                    Vector v = link.getConstantMapVector();
                    int len = v.size();
                    if (len > 0) {
                        cm = new ConstantMap[len];
                        int i = 0;
                        while (i < len) {
                            cm[i] = (ConstantMap)v.elementAt(i);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Couldn't copy ConstantMaps for remote DataReference");
                }
                try {
                    String newClass = link.getRendererClassName();
                    if (newClass.equals(defaultClass)) {
                        renderer = null;
                    } else {
                        Object obj = Class.forName(newClass).newInstance();
                        renderer = (DataRenderer)obj;
                    }
                }
                catch (Exception e) {
                    System.err.println("Couldn't copy remote DataRenderer name; using " + defaultClass);
                    renderer = null;
                }
                try {
                    RemoteDisplayImpl rd = new RemoteDisplayImpl(this);
                    if (renderer == null) {
                        rd.addReference(ref, cm);
                        continue;
                    }
                    rd.addReferences(renderer, ref, cm);
                }
                catch (Exception e) {
                    System.err.println("Couldn't add remote DataReference " + ref);
                }
            }
        }
    }

    protected void syncRemoteData(RemoteDisplay rmtDpy) throws VisADException, RemoteException {
        this.copyScalarMaps(rmtDpy);
        this.copyConstantMaps(rmtDpy);
        this.copyGraphicsModeControl(rmtDpy);
        if (!this.cluster) {
            this.copyRefLinks(rmtDpy, null);
        }
        this.notifyAction();
        if (!this.cluster) {
            this.waitForTasks();
        }
        this.displayMonitor.addRemoteListener(rmtDpy);
        this.initializeControls();
    }

    private void initializeControls() {
        ListIterator iter = ((AbstractList)this.ControlVector).listIterator();
        while (iter.hasNext()) {
            try {
                Control ctl = (Control)iter.next();
                ControlMonitorEvent evt = new ControlMonitorEvent(20, (Control)ctl.clone());
                this.displayMonitor.notifyListeners(evt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyListeners(int id, int x, int y) throws VisADException, RemoteException {
        this.notifyListeners(new DisplayEvent((Display)this, id, x, y));
    }

    public void notifyListeners(DisplayEvent evt) throws VisADException, RemoteException {
        if (!this.eventStatus[evt.getId()]) {
            return;
        }
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                Enumeration listeners = this.ListenerVector.elements();
                while (listeners.hasMoreElements()) {
                    DisplayListener listener = (DisplayListener)listeners.nextElement();
                    if (listener instanceof Remote) {
                        if (this.rd == null) {
                            this.rd = new RemoteDisplayImpl(this);
                        }
                        listener.displayChanged(evt.cloneButDisplay(this.rd));
                        continue;
                    }
                    listener.displayChanged(evt.cloneButDisplay(this));
                }
            }
        }
    }

    public void addDisplayListener(DisplayListener listener) {
        this.ListenerVector.addElement(listener);
    }

    public void removeDisplayListener(DisplayListener listener) {
        if (listener != null) {
            this.ListenerVector.removeElement(listener);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component c) {
        this.component = c;
    }

    public void reAutoScale() {
        this.initialize = true;
    }

    public void setAlwaysAutoScale(boolean a) {
        this.always_initialize = a;
    }

    public void reDisplayAll() {
        this.redisplay_all = true;
        this.notifyAction();
    }

    public void addSlave(RemoteSlaveDisplay display) {
        if (!this.Slaves.contains(display)) {
            this.Slaves.add(display);
        }
    }

    public void removeSlave(RemoteSlaveDisplay display) {
        if (this.Slaves.contains(display)) {
            this.Slaves.remove(display);
        }
    }

    public void removeAllSlaves() {
        this.Slaves.removeAllElements();
    }

    public boolean hasSlaves() {
        return !this.Slaves.isEmpty();
    }

    public void updateSlaves(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int type = img.getType();
        int[] pixels = new int[width * height];
        img.getRGB(0, 0, width, height, pixels, 0, width);
        int[] encoded = Convert.encodeRLE(pixels);
        Vector vector = this.Slaves;
        synchronized (vector) {
            int i = 0;
            while (i < this.Slaves.size()) {
                RemoteSlaveDisplay d = (RemoteSlaveDisplay)this.Slaves.elementAt(i);
                try {
                    d.sendImage(encoded, width, height, type);
                }
                catch (ConnectException exc) {
                    this.Slaves.remove(i--);
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void updateSlaves(String message) {
        Vector vector = this.Slaves;
        synchronized (vector) {
            int i = 0;
            while (i < this.Slaves.size()) {
                RemoteSlaveDisplay d = (RemoteSlaveDisplay)this.Slaves.elementAt(i);
                try {
                    d.sendMessage(message);
                }
                catch (ConnectException exc) {
                    this.Slaves.remove(i--);
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void enableEvent(int id) {
        if (id < 1 || id >= this.eventStatus.length) {
            return;
        }
        this.eventStatus[id] = true;
    }

    public void disableEvent(int id) {
        if (id < 1 || id >= this.eventStatus.length) {
            return;
        }
        this.eventStatus[id] = false;
    }

    public boolean isEventEnabled(int id) {
        return id < 1 || id >= this.eventStatus.length ? false : this.eventStatus[id];
    }

    public void addReference(ThingReference ref) throws VisADException, RemoteException {
        if (!(ref instanceof DataReference)) {
            throw new ReferenceException("DisplayImpl.addReference: ref must be DataReference");
        }
        this.addReference((DataReference)ref, null);
    }

    public void replaceReference(RemoteDisplay rDpy, ThingReference ref) throws VisADException, RemoteException {
        if (!(ref instanceof DataReference)) {
            throw new ReferenceException("DisplayImpl.replaceReference: ref must be DataReference");
        }
        this.replaceReference(rDpy, (DataReference)ref, null);
    }

    void addLink(DataDisplayLink link) throws VisADException, RemoteException {
        this.addLink(link, true);
    }

    private void addLink(DataDisplayLink link, boolean syncRemote) throws VisADException, RemoteException {
        super.addLink(link);
        if (syncRemote) {
            this.notifyListeners(new DisplayReferenceEvent((Display)this, 13, link));
        }
    }

    public void addReference(DataReference ref, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        if (!(ref instanceof DataReferenceImpl)) {
            throw new RemoteVisADException("DisplayImpl.addReference: requires DataReferenceImpl");
        }
        if (this.findReference(ref) != null) {
            throw new TypeException("DisplayImpl.addReference: link already exists");
        }
        DataRenderer renderer = this.displayRenderer.makeDefaultRenderer();
        DataDisplayLink[] links = new DataDisplayLink[]{new DataDisplayLink(ref, this, this, constant_maps, renderer, this.getLinkId())};
        this.addLink(links[0]);
        renderer.setLinks(links, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(renderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void replaceReference(RemoteDisplay rDpy, DataReference ref, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        this.replaceReferences(rDpy, null, new DataReference[]{ref}, new ConstantMap[][]{constant_maps});
    }

    private boolean computeInitialize() {
        boolean init = false;
        Vector tmap = (Vector)this.MapVector.clone();
        Enumeration maps = tmap.elements();
        while (maps.hasMoreElements()) {
            ScalarMap map = (ScalarMap)maps.nextElement();
            init |= map.doInitialize();
        }
        AnimationControl control = (AnimationControl)((Object)this.getControl(class$visad$AnimationControl == null ? (class$visad$AnimationControl = DisplayImpl.class$("visad.AnimationControl")) : class$visad$AnimationControl));
        if (control != null) {
            init |= control.getSet() == null;
        }
        return init;
    }

    void adaptedAddReference(RemoteDataReference ref, RemoteDisplay display, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        if (this.findReference(ref) != null) {
            throw new TypeException("DisplayImpl.adaptedAddReference: link already exists");
        }
        DataRenderer renderer = this.displayRenderer.makeDefaultRenderer();
        DataDisplayLink[] links = new DataDisplayLink[]{new DataDisplayLink(ref, this, display, constant_maps, renderer, this.getLinkId())};
        this.addLink(links[0]);
        renderer.setLinks(links, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(renderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void addReferences(DataRenderer renderer, DataReference ref) throws VisADException, RemoteException {
        this.addReferences(renderer, new DataReference[]{ref}, null);
    }

    public void replaceReferences(RemoteDisplay rDpy, DataRenderer renderer, DataReference ref) throws VisADException, RemoteException {
        this.replaceReferences(rDpy, renderer, new DataReference[]{ref}, null);
    }

    public void addReferences(DataRenderer renderer, DataReference ref, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        this.addReferences(renderer, new DataReference[]{ref}, new ConstantMap[][]{constant_maps});
    }

    public void replaceReferences(RemoteDisplay rDpy, DataRenderer renderer, DataReference ref, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        this.replaceReferences(rDpy, renderer, new DataReference[]{ref}, new ConstantMap[][]{constant_maps});
    }

    public void addReferences(DataRenderer renderer, DataReference[] refs) throws VisADException, RemoteException {
        this.addReferences(renderer, refs, null);
    }

    public void replaceReferences(RemoteDisplay rDpy, DataRenderer renderer, DataReference[] refs) throws VisADException, RemoteException {
        this.replaceReferences(rDpy, renderer, refs, null);
    }

    public void addReferences(DataRenderer renderer, DataReference[] refs, ConstantMap[][] constant_maps) throws VisADException, RemoteException {
        this.addReferences(renderer, refs, constant_maps, true);
    }

    private void addReferences(DataRenderer renderer, DataReference[] refs, ConstantMap[][] constant_maps, boolean syncRemote) throws VisADException, RemoteException {
        if (refs.length < 1) {
            throw new DisplayException("DisplayImpl.addReferences: must have at least one DataReference");
        }
        if (constant_maps != null && refs.length != constant_maps.length) {
            throw new DisplayException("DisplayImpl.addReferences: constant_maps length must match refs length");
        }
        if (!this.displayRenderer.legalDataRenderer(renderer)) {
            throw new DisplayException("DisplayImpl.addReferences: illegal DataRenderer class");
        }
        DataDisplayLink[] links = new DataDisplayLink[refs.length];
        int i = 0;
        while (i < refs.length) {
            if (!(refs[i] instanceof DataReferenceImpl)) {
                throw new RemoteVisADException("DisplayImpl.addReferences: requires DataReferenceImpl");
            }
            if (this.findReference(refs[i]) != null) {
                throw new TypeException("DisplayImpl.addReferences: link already exists");
            }
            links[i] = constant_maps == null ? new DataDisplayLink(refs[i], this, this, null, renderer, this.getLinkId()) : new DataDisplayLink(refs[i], this, this, constant_maps[i], renderer, this.getLinkId());
            this.addLink(links[i], syncRemote);
            ++i;
        }
        renderer.setLinks(links, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(renderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void replaceReferences(RemoteDisplay rDpy, DataRenderer renderer, DataReference[] refs, ConstantMap[][] constant_maps) throws VisADException, RemoteException {
        if (renderer == null) {
            renderer = this.displayRenderer.makeDefaultRenderer();
        }
        this.removeAllReferences();
        this.addReferences(renderer, refs, constant_maps, false);
        this.copyRefLinks(rDpy, refs);
    }

    void adaptedAddReferences(DataRenderer renderer, DataReference[] refs, RemoteDisplay display, ConstantMap[][] constant_maps) throws VisADException, RemoteException {
        if (refs.length < 1) {
            throw new DisplayException("DisplayImpl.addReferences: must have at least one DataReference");
        }
        if (constant_maps != null && refs.length != constant_maps.length) {
            throw new DisplayException("DisplayImpl.addReferences: constant_maps length must match refs length");
        }
        if (!this.displayRenderer.legalDataRenderer(renderer)) {
            throw new DisplayException("DisplayImpl.addReferences: illegal DataRenderer class");
        }
        DataDisplayLink[] links = new DataDisplayLink[refs.length];
        int i = 0;
        while (i < refs.length) {
            if (this.findReference(refs[i]) != null) {
                throw new TypeException("DisplayImpl.addReferences: link already exists");
            }
            links[i] = refs[i] instanceof DataReferenceImpl ? (constant_maps == null ? new DataDisplayLink(refs[i], this, this, null, renderer, this.getLinkId()) : new DataDisplayLink(refs[i], this, this, constant_maps[i], renderer, this.getLinkId())) : (constant_maps == null ? new DataDisplayLink(refs[i], this, display, null, renderer, this.getLinkId()) : new DataDisplayLink(refs[i], this, display, constant_maps[i], renderer, this.getLinkId()));
            this.addLink(links[i]);
            ++i;
        }
        renderer.setLinks(links, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(renderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void removeReference(ThingReference ref) throws VisADException, RemoteException {
        if (!(ref instanceof DataReferenceImpl)) {
            throw new RemoteVisADException("ActionImpl.removeReference: requires DataReferenceImpl");
        }
        this.adaptedDisplayRemoveReference((DataReference)ref);
    }

    void removeLinks(DataDisplayLink[] links) throws RemoteException, VisADException {
        int i = links.length - 1;
        while (i >= 0) {
            if (links[i] != null) {
                links[i].clearMaps();
            }
            --i;
        }
        super.removeLinks(links);
    }

    void adaptedDisplayRemoveReference(DataReference ref) throws VisADException, RemoteException {
        DataDisplayLink link = (DataDisplayLink)this.findReference(ref);
        if (link == null) {
            return;
        }
        DataRenderer renderer = link.getRenderer();
        DataDisplayLink[] links = renderer.getLinks();
        Object object = this.mapslock;
        synchronized (object) {
            renderer.clearAVControls();
            renderer.clearScene();
            this.RendererVector.removeElement(renderer);
        }
        this.removeLinks(links);
    }

    public void removeAllReferences() throws VisADException, RemoteException {
        Vector temp = (Vector)this.RendererVector.clone();
        Object object = this.mapslock;
        synchronized (object) {
            Iterator renderers = ((AbstractList)temp).iterator();
            while (renderers.hasNext()) {
                DataRenderer renderer = (DataRenderer)renderers.next();
                renderer.clearAVControls();
                renderer.clearScene();
                DataDisplayLink[] links = renderer.getLinks();
                renderers.remove();
                this.removeLinks(links);
            }
            this.RendererVector.removeAllElements();
            this.initialize = true;
        }
    }

    public void controlChanged() {
        this.notifyAction();
    }

    public boolean checkTicks() {
        return true;
    }

    public void destroy() throws VisADException, RemoteException {
        VisADException thrownVE = null;
        RemoteException thrownRE = null;
        this.stop();
        if (this.displayActivity != null) {
            this.displayActivity.destroy();
        }
        this.notifyListeners(new DisplayEvent(this, 15));
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                this.ListenerVector.removeAllElements();
            }
        }
        try {
            this.removeAllReferences();
        }
        catch (RemoteException re) {
            thrownRE = re;
        }
        catch (VisADException ve) {
            thrownVE = ve;
        }
        try {
            this.clearMaps();
        }
        catch (RemoteException re) {
            thrownRE = re;
        }
        catch (VisADException ve) {
            thrownVE = ve;
        }
        AnimationControl control = (AnimationControl)((Object)this.getControl(class$visad$AnimationControl == null ? (class$visad$AnimationControl = DisplayImpl.class$("visad.AnimationControl")) : class$visad$AnimationControl));
        if (control != null) {
            control.stop();
        }
        if (thrownVE != null) {
            throw thrownVE;
        }
        if (thrownRE != null) {
            throw thrownRE;
        }
    }

    public void doAction() throws VisADException, RemoteException {
        if (this.mapslock == null) {
            return;
        }
        Object object = this.mapslock;
        synchronized (object) {
            if (this.RendererVector == null || this.displayRenderer == null) {
                return;
            }
            this.displayRenderer.setWaitFlag(true);
            Vector tmap = (Vector)this.MapVector.clone();
            Enumeration maps = tmap.elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                map.setTicks();
            }
            int n = this.getDisplayScalarCount();
            int[] scalarToValue = new int[n];
            int i = 0;
            while (i < n) {
                scalarToValue[i] = -1;
                ++i;
            }
            this.valueArrayLength = 0;
            maps = tmap.elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                DisplayRealType dreal = map.getDisplayScalar();
                map.setValueIndex(this.valueArrayLength);
                ++this.valueArrayLength;
            }
            this.valueToScalar = new int[this.valueArrayLength];
            this.valueToMap = new int[this.valueArrayLength];
            int i2 = 0;
            while (i2 < tmap.size()) {
                ScalarMap map = (ScalarMap)tmap.elementAt(i2);
                DisplayRealType dreal = map.getDisplayScalar();
                this.valueToScalar[map.getValueIndex()] = this.getDisplayScalarIndex(dreal);
                this.valueToMap[map.getValueIndex()] = i2++;
            }
            Vector temp = (Vector)this.RendererVector.clone();
            Enumeration renderers = temp.elements();
            boolean go = false;
            if (this.initialize) {
                renderers = temp.elements();
                while (!go && renderers.hasMoreElements()) {
                    DataRenderer renderer = (DataRenderer)renderers.nextElement();
                    go |= renderer.checkAction();
                }
            }
            if (this.redisplay_all) {
                go = true;
                this.redisplay_all = false;
            }
            if (!this.initialize || go) {
                this.displayRenderer.prepareAction(temp, tmap, go, this.initialize);
                boolean anyBadMap = false;
                maps = tmap.elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    if (!map.badRange()) continue;
                    anyBadMap = true;
                }
                renderers = temp.elements();
                boolean badScale = false;
                while (renderers.hasMoreElements()) {
                    DataRenderer renderer = (DataRenderer)renderers.nextElement();
                    badScale |= renderer.getBadScale(anyBadMap);
                }
                this.initialize = badScale;
                if (this.always_initialize) {
                    this.initialize = true;
                }
                boolean transform_done = false;
                renderers = temp.elements();
                while (renderers.hasMoreElements()) {
                    DataRenderer renderer = (DataRenderer)renderers.nextElement();
                    boolean this_transform = renderer.doAction();
                    transform_done |= this_transform;
                }
                if (transform_done) {
                    AnimationControl control = (AnimationControl)((Object)this.getControl(class$visad$AnimationControl == null ? (class$visad$AnimationControl = DisplayImpl.class$("visad.AnimationControl")) : class$visad$AnimationControl));
                    if (control != null) {
                        control.init();
                    }
                    Vector vector = this.ControlVector;
                    synchronized (vector) {
                        Enumeration controls = this.ControlVector.elements();
                        while (controls.hasMoreElements()) {
                            Control cont;
                            if (!(class$visad$ValueControl == null ? DisplayImpl.class$("visad.ValueControl") : class$visad$ValueControl).isInstance(cont = (Control)controls.nextElement())) continue;
                            ((ValueControl)((Object)cont)).init();
                        }
                    }
                    this.notifyListeners(2, 0, 0);
                }
            }
            maps = tmap.elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                map.resetTicks();
            }
            this.displayRenderer.setWaitFlag(false);
        }
    }

    protected abstract DisplayRenderer getDefaultDisplayRenderer();

    public DisplayRenderer getDisplayRenderer() {
        return this.displayRenderer;
    }

    public Vector getRendererVector() {
        return (Vector)this.RendererVector.clone();
    }

    public int getDisplayScalarCount() {
        return this.DisplayRealTypeVector.size();
    }

    public DisplayRealType getDisplayScalar(int index) {
        return (DisplayRealType)this.DisplayRealTypeVector.elementAt(index);
    }

    public int getDisplayScalarIndex(DisplayRealType dreal) {
        int dindex;
        Vector vector = this.DisplayRealTypeVector;
        synchronized (vector) {
            DisplayTupleType tuple = dreal.getTuple();
            if (tuple != null) {
                int n = tuple.getDimension();
                int i = 0;
                while (i < n) {
                    try {
                        DisplayRealType ereal = (DisplayRealType)tuple.getComponent(i);
                        int eindex = this.DisplayRealTypeVector.indexOf(ereal);
                        if (eindex < 0) {
                            this.DisplayRealTypeVector.addElement(ereal);
                        }
                    }
                    catch (VisADException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if ((dindex = this.DisplayRealTypeVector.indexOf(dreal)) < 0) {
                this.DisplayRealTypeVector.addElement(dreal);
                dindex = this.DisplayRealTypeVector.indexOf(dreal);
            }
        }
        return dindex;
    }

    public int getScalarCount() {
        return this.RealTypeVector.size();
    }

    public ScalarType getScalar(int index) {
        return (ScalarType)this.RealTypeVector.elementAt(index);
    }

    public int getScalarIndex(ScalarType real) throws RemoteException {
        return this.RealTypeVector.indexOf(real);
    }

    public void addMap(ScalarMap map) throws VisADException, RemoteException {
        this.addMap(map, 0);
    }

    public void addMap(ScalarMap map, int remoteId) throws VisADException, RemoteException {
        Object object = this.mapslock;
        synchronized (object) {
            DisplayRealType type;
            Vector temp;
            ScalarType st;
            if (!this.RendererVector.isEmpty() && (st = map.getScalar()) != null) {
                temp = (Vector)this.RendererVector.clone();
                Iterator renderers = ((AbstractList)temp).iterator();
                while (renderers.hasNext()) {
                    DataRenderer renderer = (DataRenderer)renderers.next();
                    DataDisplayLink[] links = renderer.getLinks();
                    int i = 0;
                    while (i < links.length) {
                        if (MathType.findScalarType(links[i].getType(), st)) {
                            throw new DisplayException("DisplayImpl.addMap(): ScalarType may not occur in any DataReference");
                        }
                        ++i;
                    }
                }
            }
            if (!this.displayRenderer.legalDisplayScalar(type = map.getDisplayScalar())) {
                throw new BadMappingException("DisplayImpl.addMap: " + map.getDisplayScalar() + " illegal for this DisplayRenderer");
            }
            if ((Display.LineWidth.equals(type) || Display.PointSize.equals(type) || Display.LineStyle.equals(type)) && !(map instanceof ConstantMap)) {
                throw new BadMappingException("DisplayImpl.addMap: " + map.getDisplayScalar() + " for ConstantMap only");
            }
            map.setDisplay(this);
            if (map instanceof ConstantMap) {
                temp = this.ConstantMapVector;
                synchronized (temp) {
                    Enumeration maps = this.ConstantMapVector.elements();
                    while (maps.hasMoreElements()) {
                        ConstantMap map2 = (ConstantMap)maps.nextElement();
                        if (!map2.getDisplayScalar().equals(map.getDisplayScalar())) continue;
                        throw new BadMappingException("Display.addMap: two ConstantMaps have the same DisplayScalar");
                    }
                    this.ConstantMapVector.addElement(map);
                }
                if (!this.RendererVector.isEmpty()) {
                    this.reDisplayAll();
                }
            } else {
                int index;
                ScalarType real = map.getScalar();
                DisplayRealType dreal = map.getDisplayScalar();
                Vector vector = this.MapVector;
                synchronized (vector) {
                    Enumeration maps = this.MapVector.elements();
                    while (maps.hasMoreElements()) {
                        ScalarMap map2 = (ScalarMap)maps.nextElement();
                        if (real.equals(map2.getScalar()) && dreal.equals(map2.getDisplayScalar()) && !dreal.equals(Display.Shape)) {
                            throw new BadMappingException("Display.addMap: two ScalarMaps with the same RealType & DisplayRealType");
                        }
                        if (!dreal.equals(Display.Animation) || !map2.getDisplayScalar().equals(Display.Animation)) continue;
                        throw new BadMappingException("Display.addMap: two RealTypes are mapped to Animation");
                    }
                    this.MapVector.addElement(map);
                    this.needWidgetRefresh = true;
                }
                Vector vector2 = this.RealTypeVector;
                synchronized (vector2) {
                    index = this.RealTypeVector.indexOf(real);
                    if (index < 0) {
                        this.RealTypeVector.addElement(real);
                        index = this.RealTypeVector.indexOf(real);
                    }
                }
                map.setScalarIndex(index);
                map.setControl();
                if (!this.RendererVector.isEmpty() && map.doInitialize()) {
                    this.reAutoScale();
                }
            }
            this.addDisplayScalar(map);
            this.notifyListeners(new DisplayMapEvent((Display)this, 11, map, remoteId));
            map.addScalarMapListener(this.displayMonitor);
        }
    }

    void addDisplayScalar(ScalarMap map) {
        int index;
        DisplayRealType dreal = map.getDisplayScalar();
        Vector vector = this.DisplayRealTypeVector;
        synchronized (vector) {
            DisplayTupleType tuple = dreal.getTuple();
            if (tuple != null) {
                int n = tuple.getDimension();
                int i = 0;
                while (i < n) {
                    try {
                        DisplayRealType ereal = (DisplayRealType)tuple.getComponent(i);
                        int eindex = this.DisplayRealTypeVector.indexOf(ereal);
                        if (eindex < 0) {
                            this.DisplayRealTypeVector.addElement(ereal);
                        }
                    }
                    catch (VisADException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if ((index = this.DisplayRealTypeVector.indexOf(dreal)) < 0) {
                this.DisplayRealTypeVector.addElement(dreal);
                index = this.DisplayRealTypeVector.indexOf(dreal);
            }
        }
        map.setDisplayScalarIndex(index);
    }

    public void clearMaps() throws VisADException, RemoteException {
        Object object = this.mapslock;
        synchronized (object) {
            Enumeration maps;
            if (!this.RendererVector.isEmpty()) {
                throw new DisplayException("DisplayImpl.clearMaps: RendererVector must be empty");
            }
            Vector vector = this.MapVector;
            synchronized (vector) {
                maps = this.MapVector.elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    map.nullDisplay();
                    map.removeScalarMapListener(this.displayMonitor);
                }
                this.MapVector.removeAllElements();
                this.needWidgetRefresh = true;
            }
            Vector vector2 = this.ConstantMapVector;
            synchronized (vector2) {
                maps = this.ConstantMapVector.elements();
                while (maps.hasMoreElements()) {
                    ConstantMap map = (ConstantMap)maps.nextElement();
                    map.nullDisplay();
                    map.removeScalarMapListener(this.displayMonitor);
                }
                this.ConstantMapVector.removeAllElements();
            }
            Vector vector3 = this.ControlVector;
            synchronized (vector3) {
                maps = this.ControlVector.elements();
                while (maps.hasMoreElements()) {
                    Control ctl = (Control)maps.nextElement();
                    ctl.removeControlListener(this.displayMonitor);
                    ctl.setInstanceNumber(-1);
                }
                this.ControlVector.removeAllElements();
                Control control = this.getGraphicsModeControl();
                if (control != null) {
                    this.addControl(control);
                }
                if ((control = this.getProjectionControl()) != null) {
                    this.addControl(control);
                }
                if ((control = this.displayRenderer.getRendererControl()) != null) {
                    this.addControl(control);
                }
            }
            this.RealTypeVector.removeAllElements();
            Vector vector4 = this.DisplayRealTypeVector;
            synchronized (vector4) {
                this.DisplayRealTypeVector.removeAllElements();
                int i = 0;
                while (i < Display.DisplayRealArray.length) {
                    this.DisplayRealTypeVector.addElement(Display.DisplayRealArray[i]);
                    ++i;
                }
            }
            this.displayRenderer.clearAxisOrdinals();
            this.displayRenderer.setAnimationString(new String[]{null, null});
        }
        this.notifyListeners(new DisplayEvent(this, 12));
    }

    public Vector getMapVector() {
        return (Vector)this.MapVector.clone();
    }

    public Vector getConstantMapVector() {
        return (Vector)this.ConstantMapVector.clone();
    }

    private int getInstanceNumber(Control ctl) {
        Class<?> ctlClass = ctl.getClass();
        int num = 0;
        Enumeration enumeration = this.ControlVector.elements();
        while (enumeration.hasMoreElements()) {
            Control c = (Control)enumeration.nextElement();
            if (!ctlClass.isInstance(c)) continue;
            if (ctl == c) {
                return num;
            }
            ++num;
        }
        return -1;
    }

    public int getConnectionID(RemoteDisplay rmtDpy) throws RemoteException {
        return this.displayMonitor.getConnectionID(rmtDpy);
    }

    public void addControl(Control control) {
        if (control != null && !this.ControlVector.contains(control)) {
            this.ControlVector.addElement(control);
            control.setIndex(this.ControlVector.indexOf(control));
            control.setInstanceNumber(this.getInstanceNumber(control));
            control.addControlListener(this.displayMonitor);
        }
    }

    public Control getControl(Class c) {
        return this.getControl(c, 0);
    }

    public Control getControl(Class c, int inst) {
        return this.getControls(c, null, inst);
    }

    public Vector getControls(Class c) {
        Vector v = new Vector();
        this.getControls(c, v, -1);
        return v;
    }

    private Control getControls(Class ctlClass, Vector v, int inst) {
        if (ctlClass == null) {
            return null;
        }
        GraphicsModeControl gmc = this.getGraphicsModeControl();
        if (ctlClass.isInstance(gmc)) {
            if (v == null) {
                return gmc;
            }
            v.addElement(gmc);
        } else {
            Vector vector = this.ControlVector;
            synchronized (vector) {
                Enumeration enumeration = this.ControlVector.elements();
                while (enumeration.hasMoreElements()) {
                    Control c = (Control)enumeration.nextElement();
                    if (!ctlClass.isInstance(c)) continue;
                    if (v != null) {
                        v.addElement(c);
                        continue;
                    }
                    if (c.getInstanceNumber() != inst) continue;
                    Control control = c;
                    return control;
                }
            }
        }
        return null;
    }

    public int getNumberOfControls() {
        return this.ControlVector.size();
    }

    public Vector getControlVector() {
        return (Vector)this.ControlVector.clone();
    }

    public Container getWidgetPanel() {
        if (this.needWidgetRefresh) {
            Vector vector = this.MapVector;
            synchronized (vector) {
                if (this.widgetPanel == null) {
                    this.widgetPanel = new JPanel();
                    this.widgetPanel.setLayout(new BoxLayout(this.widgetPanel, 1));
                } else {
                    this.widgetPanel.removeAll();
                }
                if (this.getLinks().size() > 0) {
                    GMCWidget gmcw = new GMCWidget(this.getGraphicsModeControl());
                    this.addToWidgetPanel(gmcw, false);
                }
                int i = 0;
                while (i < this.MapVector.size()) {
                    ScalarMap sm = (ScalarMap)this.MapVector.elementAt(i);
                    DisplayRealType drt = sm.getDisplayScalar();
                    try {
                        double[] a = new double[2];
                        double[] b = new double[2];
                        double[] c = new double[2];
                        boolean scale = sm.getScale(a, b, c);
                        if (scale) {
                            RangeWidget rw = new RangeWidget(sm);
                            this.addToWidgetPanel(rw, true);
                        }
                    }
                    catch (VisADException exc) {
                        // empty catch block
                    }
                    try {
                        if (drt.equals(Display.RGB) || drt.equals(Display.RGBA)) {
                            try {
                                LabeledColorWidget lw = new LabeledColorWidget(sm);
                                this.addToWidgetPanel(lw, true);
                            }
                            catch (VisADException exc) {
                            }
                            catch (RemoteException exc) {}
                        } else if (drt.equals(Display.SelectValue)) {
                            VisADSlider vs = new VisADSlider(sm);
                            vs.setAlignmentX(0.5f);
                            this.addToWidgetPanel(vs, true);
                        } else if (drt.equals(Display.SelectRange)) {
                            SelectRangeWidget srw = new SelectRangeWidget(sm);
                            this.addToWidgetPanel(srw, true);
                        } else if (drt.equals(Display.IsoContour)) {
                            ContourWidget cw = new ContourWidget(sm);
                            this.addToWidgetPanel(cw, true);
                        } else if (drt.equals(Display.Animation)) {
                            AnimationWidget aw = new AnimationWidget(sm);
                            this.addToWidgetPanel(aw, true);
                        }
                    }
                    catch (VisADException exc) {
                    }
                    catch (RemoteException exc) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            this.needWidgetRefresh = false;
        }
        return this.widgetPanel;
    }

    private void addToWidgetPanel(Component c, boolean divide) {
        if (divide) {
            this.widgetPanel.add(new Divider());
        }
        this.widgetPanel.add(c);
    }

    public int getValueArrayLength() {
        return this.valueArrayLength;
    }

    public int[] getValueToScalar() {
        return this.valueToScalar;
    }

    public int[] getValueToMap() {
        return this.valueToMap;
    }

    public abstract ProjectionControl getProjectionControl();

    public abstract GraphicsModeControl getGraphicsModeControl();

    public static void delay(int millis) {
        new Delay(millis);
    }

    public static void printStack(String message) {
        try {
            throw new DisplayException("printStack: " + message);
        }
        catch (DisplayException e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public Vector getRenderers() {
        return (Vector)this.RendererVector.clone();
    }

    public int getAPI() throws VisADException {
        throw new VisADException("No API specified");
    }

    public DisplayMonitor getDisplayMonitor() {
        return this.displayMonitor;
    }

    public DisplaySync getDisplaySync() {
        return this.displaySync;
    }

    public void setMouseBehavior(MouseBehavior m) {
        this.mouse = m;
    }

    public MouseBehavior getMouseBehavior() {
        return this.mouse;
    }

    public double[] make_matrix(double rotx, double roty, double rotz, double scale, double transx, double transy, double transz) {
        if (this.mouse != null) {
            return this.mouse.make_matrix(rotx, roty, rotz, scale, transx, transy, transz);
        }
        return null;
    }

    public double[] multiply_matrix(double[] a, double[] b) {
        if (this.mouse != null && a != null && b != null) {
            return this.mouse.multiply_matrix(a, b);
        }
        return null;
    }

    public BufferedImage getImage() {
        return this.getImage(false);
    }

    public BufferedImage getImage(boolean sync) {
        Thread thread = Thread.currentThread();
        String name = thread.getName();
        if (thread.equals(this.getCurrentActionThread()) || name.startsWith("J3D-Renderer") || name.startsWith("AWT-EventQueue")) {
            throw new VisADError("cannot call getImage() from Thread: " + name);
        }
        if (sync) {
            new Syncher(this);
        }
        return this.displayRenderer.getImage();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pre) {
        ScalarMap map;
        String s = pre + "Display\n";
        Enumeration maps = this.MapVector.elements();
        while (maps.hasMoreElements()) {
            map = (ScalarMap)maps.nextElement();
            s = s + map.toString(pre + "    ");
        }
        maps = this.ConstantMapVector.elements();
        while (maps.hasMoreElements()) {
            map = (ConstantMap)maps.nextElement();
            s = s + ((ConstantMap)map).toString(pre + "    ");
        }
        return s;
    }

    public Printable getPrintable() {
        if (this.printer == null) {
            this.printer = new Printable(){

                public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
                    if (pi >= 1) {
                        return 1;
                    }
                    BufferedImage image = DisplayImpl.this.getImage();
                    g.drawImage(image, (int)pf.getImageableX(), (int)pf.getImageableY(), DisplayImpl.this.component);
                    return 0;
                }
            };
        }
        return this.printer;
    }

    void handleRunDisconnectException(ReferenceActionLink raLink) {
        if (!(raLink instanceof DataDisplayLink)) {
            return;
        }
        DataDisplayLink dataDisplayLink = (DataDisplayLink)raLink;
    }

    public void connectionFailed(DataRenderer renderer, DataDisplayLink link) {
        DataDisplayLink[] links;
        try {
            this.removeLinks(new DataDisplayLink[]{link});
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        if (renderer != null && (links = renderer.getLinks()).length <= 1) {
            this.deleteRenderer(renderer);
        }
        Enumeration enumeration = this.RmtSrcListeners.elements();
        while (enumeration.hasMoreElements()) {
            RemoteSourceListener l = (RemoteSourceListener)enumeration.nextElement();
            l.dataSourceLost(link.getName());
        }
    }

    public void addRendererSourceListener(RendererSourceListener listener) {
        this.RendererSourceListeners.addElement(listener);
    }

    public void removeRendererSourceListener(RendererSourceListener listener) {
        this.RendererSourceListeners.removeElement(listener);
    }

    private void deleteRenderer(DataRenderer renderer) {
        this.RendererVector.removeElement(renderer);
        Enumeration enumeration = this.RendererSourceListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RendererSourceListener)enumeration.nextElement()).rendererDeleted(renderer);
        }
    }

    public void addDataSourceListener(RemoteSourceListener listener) {
        this.addRemoteSourceListener(listener);
    }

    public void removeDataSourceListener(RemoteSourceListener listener) {
        this.removeRemoteSourceListener(listener);
    }

    public void addRemoteSourceListener(RemoteSourceListener listener) {
        this.RmtSrcListeners.addElement(listener);
    }

    public void removeRemoteSourceListener(RemoteSourceListener listener) {
        this.RmtSrcListeners.removeElement(listener);
    }

    public void lostCollabConnection(int id) {
        Enumeration enumeration = this.RmtSrcListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RemoteSourceListener)enumeration.nextElement()).collabSourceLost(id);
        }
    }

    public void addMessageListener(MessageListener listener) {
        this.MessageListeners.addElement(listener);
    }

    public void removeMessageListener(MessageListener listener) {
        this.MessageListeners.removeElement(listener);
    }

    public void sendMessage(MessageEvent msg) throws RemoteException {
        RemoteException exception = null;
        Enumeration enumeration = this.MessageListeners.elements();
        while (enumeration.hasMoreElements()) {
            MessageListener l = (MessageListener)enumeration.nextElement();
            try {
                l.receiveMessage(msg);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.MessageListeners.removeElement(l);
                    continue;
                }
                exception = re;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    void setAspectCartesian(double[] aspect) throws VisADException, RemoteException {
        if (this.mapslock == null) {
            return;
        }
        Object object = this.mapslock;
        synchronized (object) {
            ScalarMap map;
            Vector tmap = (Vector)this.MapVector.clone();
            Enumeration maps = tmap.elements();
            while (maps.hasMoreElements()) {
                map = (ScalarMap)maps.nextElement();
                map.setAspectCartesian(aspect);
            }
            tmap = (Vector)this.ConstantMapVector.clone();
            maps = tmap.elements();
            while (maps.hasMoreElements()) {
                map = (ConstantMap)maps.nextElement();
                ((ConstantMap)map).setAspectCartesian(aspect);
            }
            this.getDisplayRenderer().setBoxAspect(aspect);
            this.reDisplayAll();
        }
    }

    public void addActivityHandler(ActivityHandler ah) throws VisADException {
        if (this.displayActivity == null) {
            this.displayActivity = new DisplayActivity(this);
        }
        this.displayActivity.addHandler(ah);
    }

    public void removeActivityHandler(ActivityHandler ah) throws VisADException {
        if (this.displayActivity == null) {
            this.displayActivity = new DisplayActivity(this);
        }
        this.displayActivity.removeHandler(ah);
    }

    public void updateBusyStatus() {
        if (this.displayActivity != null) {
            this.displayActivity.updateBusyStatus();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Syncher
    implements DisplayListener {
        private ProjectionControl control;
        int count;

        Syncher(DisplayImpl display) {
            try {
                Syncher syncher = this;
                synchronized (syncher) {
                    this.control = display.getProjectionControl();
                    this.count = -1;
                    display.disableAction();
                    display.addDisplayListener(this);
                    display.reDisplayAll();
                    display.enableAction();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            display.removeDisplayListener(this);
        }

        public void displayChanged(DisplayEvent e) throws VisADException, RemoteException {
            if (e.getId() == 2) {
                this.count = 2;
                this.control.setMatrix(this.control.getMatrix());
            } else if (e.getId() == 3) {
                if (this.count > 0) {
                    this.control.setMatrix(this.control.getMatrix());
                    --this.count;
                } else if (this.count == 0) {
                    Syncher syncher = this;
                    synchronized (syncher) {
                        this.notify();
                    }
                    --this.count;
                }
            }
        }
    }
}

