/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import visad.Display;
import visad.DisplayImpl;
import visad.VisADEvent;

public class DisplayEvent
extends VisADEvent {
    public static final int MOUSE_PRESSED = 1;
    public static final int TRANSFORM_DONE = 2;
    public static final int FRAME_DONE = 3;
    public static final int MOUSE_PRESSED_CENTER = 4;
    public static final int MOUSE_PRESSED_LEFT = 5;
    public static final int MOUSE_PRESSED_RIGHT = 6;
    public static final int MOUSE_RELEASED = 7;
    public static final int MOUSE_RELEASED_CENTER = 8;
    public static final int MOUSE_RELEASED_LEFT = 9;
    public static final int MOUSE_RELEASED_RIGHT = 10;
    public static final int MAP_ADDED = 11;
    public static final int MAPS_CLEARED = 12;
    public static final int REFERENCE_ADDED = 13;
    public static final int REFERENCE_REMOVED = 14;
    public static final int DESTROYED = 15;
    public static final int KEY_PRESSED = 16;
    public static final int KEY_RELEASED = 17;
    public static final int MOUSE_DRAGGED = 18;
    public static final int MOUSE_ENTERED = 19;
    public static final int MOUSE_EXITED = 20;
    public static final int MOUSE_MOVED = 21;
    public static final int WAIT_ON = 22;
    public static final int WAIT_OFF = 23;
    private static final String[] ids = new String[]{"?", "MOUSE_PRESSED", "TRANSFORM_DONE", "FRAME_DONE", "MOUSE_PRESSED_CENTER", "MOUSE_PRESSED_LEFT", "MOUSE_PRESSED_RIGHT", "MOUSE_RELEASED", "MOUSE_RELEASED_CENTER", "MOUSE_RELEASED_LEFT", "MOUSE_RELEASED_RIGHT", "MAP_ADDED", "MAPS_CLEARED", "REFERENCE_ADDED", "REFERENCE_REMOVED", "DESTROYED", "KEY_PRESSED", "KEY_RELEASED", "MOUSE_DRAGGED", "MOUSE_ENTERED", "MOUSE_EXITED", "MOUSE_MOVED", "WAIT_ON", "WAIT_OFF"};
    private static Component DUMMY = null;
    private int id = 0;
    private InputEvent input_event = null;
    private Display display;

    public DisplayEvent(Display d, int id_d) {
        this(d, id_d, 0);
    }

    public DisplayEvent(Display d, int id_d, int remoteId) {
        super(null, 0, null, remoteId);
        this.display = d;
        this.id = id_d;
    }

    public DisplayEvent(Display d, int id_d, int x, int y) {
        this(d, id_d, x, y, 0);
    }

    public DisplayEvent(Display d, int id_d, InputEvent e) {
        this(d, id_d, e, 0);
    }

    protected static Component getDisplayComponent(Display d) {
        if (!(d instanceof DisplayImpl)) {
            return DUMMY;
        }
        DisplayImpl di = (DisplayImpl)d;
        Component c = di.getComponent();
        return c == null ? DUMMY : c;
    }

    public DisplayEvent(Display d, int id_d, int x, int y, int remoteId) {
        this(d, id_d, DisplayEvent.makeInputEvent(d, x, y), remoteId);
    }

    public DisplayEvent(Display d, int id_d, InputEvent e, int remoteId) {
        super(null, 0, null, remoteId);
        this.display = d;
        this.id = id_d;
        this.input_event = e;
    }

    private static InputEvent makeInputEvent(Display d, int x, int y) {
        Component c = DisplayEvent.getDisplayComponent(d);
        if (c != null) {
            return new MouseEvent(c, 0, System.currentTimeMillis(), 0, x, y, 1, false);
        }
        return null;
    }

    public DisplayEvent cloneButDisplay(Display dpy) {
        return new DisplayEvent(dpy, this.id, this.input_event, this.getRemoteId());
    }

    public Display getDisplay() {
        return this.display;
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.input_event == null || !(this.input_event instanceof MouseEvent) ? -1 : ((MouseEvent)this.input_event).getX();
    }

    public int getY() {
        return this.input_event == null || !(this.input_event instanceof MouseEvent) ? -1 : ((MouseEvent)this.input_event).getY();
    }

    public int getModifiers() {
        return this.input_event == null ? -1 : this.input_event.getModifiers();
    }

    public InputEvent getInputEvent() {
        return this.input_event;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DisplayEvent: ");
        try {
            String display = this.getDisplay().getName();
            buf.append("Display=");
            buf.append(display);
            buf.append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("Id=");
        buf.append(ids[this.getId()]);
        buf.append(", X=");
        buf.append(this.getX());
        buf.append(", Y=");
        buf.append(this.getY());
        buf.append(", remoteId=");
        buf.append(this.getRemoteId());
        return buf.toString();
    }

    static {
        try {
            DUMMY = new JPanel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

