/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Action;
import visad.CMYCoordinateSystem;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.CylindricalCoordinateSystem;
import visad.DataReference;
import visad.DataRenderer;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FlowSphericalCoordinateSystem;
import visad.HSVCoordinateSystem;
import visad.MessageEvent;
import visad.RealTupleType;
import visad.RemoteSlaveDisplay;
import visad.ScalarMap;
import visad.SphericalCoordinateSystem;
import visad.VisADException;

public interface Display
extends Action {
    public static final DisplayRealType XAxis = new DisplayRealType("XAxis", true, -1.0, 1.0, 0.0, true);
    public static final DisplayRealType YAxis = new DisplayRealType("YAxis", true, -1.0, 1.0, 0.0, true);
    public static final DisplayRealType ZAxis = new DisplayRealType("ZAxis", true, -1.0, 1.0, 0.0, true);
    public static final DisplayRealType Latitude = new DisplayRealType("Latitude", true, -90.0, 90.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Longitude = new DisplayRealType("Longitude", true, 0.0, 360.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Radius = new DisplayRealType("Radius", true, 0.01, 2.0, 1.0, true);
    public static final DisplayRealType CylRadius = new DisplayRealType("CylRadius", true, 0.01, 2.0, 1.0, true);
    public static final DisplayRealType CylAzimuth = new DisplayRealType("CylAzimuth", true, 0.0, 360.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType CylZAxis = new DisplayRealType("CylZAxis", true, -1.0, 1.0, 0.0, true);
    public static final DisplayRealType List = new DisplayRealType("List", false, 0.0, true);
    public static final DisplayRealType Red = new DisplayRealType("Red", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType Green = new DisplayRealType("Green", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType Blue = new DisplayRealType("Blue", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType RGB = new DisplayRealType("RGB", false, 0.0, 1.0, 0.0, true);
    public static final DisplayRealType RGBA = new DisplayRealType("RGBA", false, 0.0, 1.0, 0.0, true);
    public static final DisplayRealType Hue = new DisplayRealType("Hue", false, 0.0, 360.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Saturation = new DisplayRealType("Saturation", false, 0.0, 1.0, 0.0, null, true);
    public static final DisplayRealType Value = new DisplayRealType("Value", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType HSV = new DisplayRealType("HSV", false, 0.0, 1.0, 0.0, true);
    public static final DisplayRealType Cyan = new DisplayRealType("Cyan", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType Magenta = new DisplayRealType("Magenta", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType Yellow = new DisplayRealType("Yellow", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType CMY = new DisplayRealType("CMY", false, 0.0, 1.0, 0.0, true);
    public static final DisplayRealType Alpha = new DisplayRealType("Alpha", false, 0.0, 1.0, 1.0, null, true);
    public static final DisplayRealType Animation = new DisplayRealType("Animation", true, 0.0, true);
    public static final DisplayRealType SelectValue = new DisplayRealType("SelectValue", false, 0.0, true);
    public static final DisplayRealType SelectRange = new DisplayRealType("SelectRange", false, 0.0, true);
    public static final DisplayRealType IsoContour = new DisplayRealType("IsoContour", false, 0.0, true);
    public static final DisplayRealType Flow1X = new DisplayRealType("Flow1X", true, -1.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow1Y = new DisplayRealType("Flow1Y", true, -1.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow1Z = new DisplayRealType("Flow1Z", true, -1.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow1Elevation = new DisplayRealType("Flow1Elevation", true, -90.0, 90.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Flow1Azimuth = new DisplayRealType("Flow1Azimuth", true, 0.0, 360.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Flow1Radial = new DisplayRealType("Flow1Radial", true, 0.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow2X = new DisplayRealType("Flow2X", true, -1.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow2Y = new DisplayRealType("Flow2Y", true, -1.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow2Z = new DisplayRealType("Flow2Z", true, -1.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType Flow2Elevation = new DisplayRealType("Flow2Elevation", true, -90.0, 90.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Flow2Azimuth = new DisplayRealType("Flow2Azimuth", true, 0.0, 360.0, 0.0, CommonUnit.degree, true);
    public static final DisplayRealType Flow2Radial = new DisplayRealType("Flow2Radial", true, 0.0, 1.0, 0.0, CommonUnit.meterPerSecond, true);
    public static final DisplayRealType XAxisOffset = new DisplayRealType("XAxisOffset", false, -1.0, 1.0, 0.0, null, true);
    public static final DisplayRealType YAxisOffset = new DisplayRealType("YAxisOffset", false, -1.0, 1.0, 0.0, null, true);
    public static final DisplayRealType ZAxisOffset = new DisplayRealType("ZAxisOffset", false, -1.0, 1.0, 0.0, null, true);
    public static final DisplayRealType Shape = new DisplayRealType("Shape", false, 0.0, true);
    public static final DisplayRealType ShapeScale = new DisplayRealType("ShapeScale", true, 0.01, 1.0, 1.0, true);
    public static final DisplayRealType Text = new DisplayRealType("Text", true, true);
    public static final DisplayRealType LineWidth = new DisplayRealType("LineWidth", true, 1.0, true);
    public static final DisplayRealType PointSize = new DisplayRealType("PointSize", true, 1.0, true);
    public static final DisplayRealType LineStyle = new DisplayRealType("LineStyle", true, 1.0, true);
    public static final DisplayRealType[] DisplayRealArray = new DisplayRealType[]{XAxis, YAxis, ZAxis, Latitude, Longitude, Radius, List, Red, Green, Blue, RGB, RGBA, Hue, Saturation, Value, HSV, Cyan, Magenta, Yellow, CMY, Alpha, Animation, SelectValue, SelectRange, IsoContour, Flow1X, Flow1Y, Flow1Z, Flow2X, Flow2Y, Flow2Z, XAxisOffset, YAxisOffset, ZAxisOffset, Shape, Text, ShapeScale, LineWidth, PointSize, CylRadius, CylAzimuth, CylZAxis, Flow1Elevation, Flow1Azimuth, Flow1Radial, Flow2Elevation, Flow2Azimuth, Flow2Radial, LineStyle};
    public static final DisplayRealType[] components3c = new DisplayRealType[]{XAxis, YAxis, ZAxis};
    public static final DisplayTupleType DisplaySpatialCartesianTuple = new DisplayTupleType(components3c, true);
    public static final CoordinateSystem DisplaySphericalCoordSys = new SphericalCoordinateSystem((RealTupleType)DisplaySpatialCartesianTuple, true);
    public static final DisplayRealType[] components3s = new DisplayRealType[]{Latitude, Longitude, Radius};
    public static final DisplayTupleType DisplaySpatialSphericalTuple = new DisplayTupleType(components3s, DisplaySphericalCoordSys, true);
    public static final CoordinateSystem DisplayCylindricalCoordSys = new CylindricalCoordinateSystem((RealTupleType)DisplaySpatialCartesianTuple, true);
    public static final DisplayRealType[] componentscyl = new DisplayRealType[]{CylRadius, CylAzimuth, CylZAxis};
    public static final DisplayTupleType DisplaySpatialCylindricalTuple = new DisplayTupleType(componentscyl, DisplayCylindricalCoordSys, true);
    public static final DisplayRealType[] componentsrgb = new DisplayRealType[]{Red, Green, Blue};
    public static final DisplayTupleType DisplayRGBTuple = new DisplayTupleType(componentsrgb, true);
    public static final CoordinateSystem DisplayHSVCoordSys = new HSVCoordinateSystem((RealTupleType)DisplayRGBTuple, true);
    public static final DisplayRealType[] componentshsv = new DisplayRealType[]{Hue, Saturation, Value};
    public static final DisplayTupleType DisplayHSVTuple = new DisplayTupleType(componentshsv, DisplayHSVCoordSys, true);
    public static final CoordinateSystem DisplayCMYCoordSys = new CMYCoordinateSystem((RealTupleType)DisplayRGBTuple, true);
    public static final DisplayRealType[] componentscmy = new DisplayRealType[]{Cyan, Magenta, Yellow};
    public static final DisplayTupleType DisplayCMYTuple = new DisplayTupleType(componentscmy, DisplayCMYCoordSys, true);
    public static final DisplayRealType[] componentsflow1 = new DisplayRealType[]{Flow1X, Flow1Y, Flow1Z};
    public static final DisplayTupleType DisplayFlow1Tuple = new DisplayTupleType(componentsflow1, true);
    public static final DisplayRealType[] componentsflow2 = new DisplayRealType[]{Flow2X, Flow2Y, Flow2Z};
    public static final DisplayTupleType DisplayFlow2Tuple = new DisplayTupleType(componentsflow2, true);
    public static final CoordinateSystem DisplayFlow1SphericalCoordSys = new FlowSphericalCoordinateSystem((RealTupleType)DisplayFlow1Tuple, true);
    public static final DisplayRealType[] componentsflow1s = new DisplayRealType[]{Flow1Elevation, Flow1Azimuth, Flow1Radial};
    public static final DisplayTupleType DisplayFlow1SphericalTuple = new DisplayTupleType(componentsflow1s, DisplayFlow1SphericalCoordSys, true);
    public static final CoordinateSystem DisplayFlow2SphericalCoordSys = new FlowSphericalCoordinateSystem((RealTupleType)DisplayFlow2Tuple, true);
    public static final DisplayRealType[] componentsflow2s = new DisplayRealType[]{Flow2Elevation, Flow2Azimuth, Flow2Radial};
    public static final DisplayTupleType DisplayFlow2SphericalTuple = new DisplayTupleType(componentsflow2s, DisplayFlow2SphericalCoordSys, true);
    public static final DisplayRealType[] componentsso = new DisplayRealType[]{XAxisOffset, YAxisOffset, ZAxisOffset};
    public static final DisplayTupleType DisplaySpatialOffsetTuple = new DisplayTupleType(componentsso, true);

    public void addReference(DataReference var1, ConstantMap[] var2) throws VisADException, RemoteException;

    public void addReferences(DataRenderer var1, DataReference var2, ConstantMap[] var3) throws VisADException, RemoteException;

    public void addMap(ScalarMap var1) throws VisADException, RemoteException;

    public void clearMaps() throws VisADException, RemoteException;

    public void destroy() throws VisADException, RemoteException;

    public Vector getConstantMapVector() throws VisADException, RemoteException;

    public void sendMessage(MessageEvent var1) throws RemoteException;

    public void addSlave(RemoteSlaveDisplay var1) throws VisADException, RemoteException;

    public void removeSlave(RemoteSlaveDisplay var1) throws VisADException, RemoteException;

    public void removeAllSlaves() throws VisADException, RemoteException;

    public boolean hasSlaves() throws VisADException, RemoteException;
}

