/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.Gridded2DSet;
import visad.Irregular2DSet;
import visad.SampledSet;
import visad.SetException;
import visad.UnionSet;
import visad.VisADException;

public class DelaunayCustom
extends Delaunay {
    private static final float SELF = 0.9999f;
    private static final float PULL = 1.00016594E-4f;
    private static final float PULL2 = 5.0008297E-5f;

    public DelaunayCustom(float[][] samples, int[][] tri) throws VisADException {
        this(samples, tri, null, null, null, 0, true);
    }

    public DelaunayCustom(float[][] samples, int[][] tri, int[][] vertices, int[][] walk, int[][] edges, int num_edges) throws VisADException {
        this(samples, tri, vertices, walk, edges, num_edges, true);
    }

    public DelaunayCustom(float[][] samples, int[][] tri, int[][] vertices, int[][] walk, int[][] edges, int num_edges, boolean copy) throws VisADException {
        if (tri == null) {
            throw new VisADException("DelaunayCustom: Tri array must be specified!");
        }
        if (samples == null && vertices == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Vertices without samples!");
        }
        if (samples == null && walk == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Walk without samples!");
        }
        if (samples == null && edges == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Edges without samples!");
        }
        if (copy) {
            int i;
            this.Tri = new int[tri.length][];
            int i2 = 0;
            while (i2 < tri.length) {
                this.Tri[i2] = new int[tri[i2].length];
                System.arraycopy(tri[i2], 0, this.Tri[i2], 0, tri[i2].length);
                ++i2;
            }
            if (vertices != null) {
                this.Vertices = new int[vertices.length][];
                i = 0;
                while (i < vertices.length) {
                    this.Vertices[i] = new int[vertices[i].length];
                    System.arraycopy(vertices[i], 0, this.Vertices[i], 0, vertices[i].length);
                    ++i;
                }
            }
            if (walk != null) {
                this.Walk = new int[walk.length][];
                i = 0;
                while (i < walk.length) {
                    this.Walk[i] = new int[walk[i].length];
                    System.arraycopy(walk[i], 0, this.Walk[i], 0, walk[i].length);
                    ++i;
                }
            }
            if (edges != null) {
                this.Edges = new int[edges.length][];
                i = 0;
                while (i < edges.length) {
                    this.Edges[i] = new int[edges[i].length];
                    System.arraycopy(edges[i], 0, this.Edges[i], 0, edges[i].length);
                    ++i;
                }
            }
        } else {
            this.Tri = tri;
            this.Vertices = vertices;
            this.Walk = walk;
            this.Edges = edges;
        }
        this.NumEdges = num_edges;
        if (samples != null) {
            super.finish_triang(samples);
        }
    }

    public static boolean checkSelfIntersection(Gridded2DSet set) throws VisADException {
        if (set == null) {
            return false;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        return DelaunayCustom.checkSelfIntersection(set.getSamples());
    }

    public static boolean checkSelfIntersection(float[][] samples) throws VisADException {
        if (samples == null) {
            return false;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = samples[0].length;
        int[] next = new int[n];
        int i = 0;
        while (i < n - 1) {
            next[i] = i + 1;
            ++i;
        }
        next[n - 1] = 0;
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < n) {
                float d0;
                float c0;
                float a1;
                float b1;
                float d1;
                float c1;
                float a0;
                float b0;
                float det;
                if (i2 != j && i2 != next[j] && next[i2] != j && !((double)Math.abs(det = ((b0 = samples[0][next[i2]]) - (a0 = samples[0][i2])) * ((c1 = samples[1][j]) - (d1 = samples[1][next[j]])) - ((b1 = samples[1][next[i2]]) - (a1 = samples[1][i2])) * ((c0 = samples[0][j]) - (d0 = samples[0][next[j]]))) < 1.0E-7)) {
                    float x = ((b0 - a0) * (c1 - a1) - (b1 - a1) * (c0 - a0)) / det;
                    float y = ((c0 - a0) * (c1 - d1) - (c1 - a1) * (c0 - d0)) / det;
                    if (0.0f < x && x < 1.0f && 0.0f < y && y < 1.0f) {
                        return true;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return false;
    }

    public static boolean checkAndFixSelfIntersection(float[][] samples) throws VisADException {
        if (samples == null) {
            return false;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = samples[0].length;
        boolean intersect = false;
        int[] next = new int[n];
        int i = 0;
        while (i < n - 1) {
            next[i] = i + 1;
            ++i;
        }
        next[n - 1] = 0;
        float[][] new_samples = new float[2][n];
        int k = 0;
        int i2 = 0;
        while (i2 < n) {
            if (samples[0][i2] != samples[0][next[i2]] || samples[1][i2] != samples[1][next[i2]]) {
                new_samples[0][k] = samples[0][i2];
                new_samples[1][k] = samples[1][i2];
                ++k;
            }
            ++i2;
        }
        if (k != n) {
            samples[0] = new float[k];
            samples[1] = new float[k];
            if (k == 0) {
                return false;
            }
            System.arraycopy(new_samples[0], 0, samples[0], 0, k);
            System.arraycopy(new_samples[1], 0, samples[1], 0, k);
            n = k;
            next = new int[n];
            int i3 = 0;
            while (i3 < n - 1) {
                next[i3] = i3 + 1;
                ++i3;
            }
            next[n - 1] = 0;
        }
        int[] prev = new int[n];
        int i4 = 1;
        while (i4 < n) {
            prev[i4] = i4 - 1;
            ++i4;
        }
        prev[0] = n - 1;
        int i5 = 0;
        while (i5 < n) {
            if (samples[0][i5] == samples[0][next[i5]] && samples[1][i5] == samples[1][next[i5]]) {
                System.out.println("equal consecutive points");
            }
            int j = 0;
            while (j < n) {
                float d0;
                float c0;
                float a1;
                float b1;
                float d1;
                float c1;
                float a0;
                float b0;
                float det;
                if (i5 != j && i5 != next[j] && next[i5] != j && !((double)Math.abs(det = ((b0 = samples[0][next[i5]]) - (a0 = samples[0][i5])) * ((c1 = samples[1][j]) - (d1 = samples[1][next[j]])) - ((b1 = samples[1][next[i5]]) - (a1 = samples[1][i5])) * ((c0 = samples[0][j]) - (d0 = samples[0][next[j]]))) < 1.0E-7)) {
                    float x = ((b0 - a0) * (c1 - a1) - (b1 - a1) * (c0 - a0)) / det;
                    float y = ((c0 - a0) * (c1 - d1) - (c1 - a1) * (c0 - d0)) / det;
                    if (0.0f < x && x < 1.0f && 0.0f < y && y < 1.0f) {
                        intersect = true;
                    } else if (!(0.0f != x && x != 1.0f || 0.0f != y && y != 1.0f)) {
                        if (x == 0.0f) {
                            samples[0][i5] = 0.9999f * a0 + 5.0008297E-5f * (b0 + samples[0][prev[i5]]);
                            samples[1][i5] = 0.9999f * a1 + 5.0008297E-5f * (b1 + samples[1][prev[i5]]);
                        } else if (x == 1.0f) {
                            k = next[i5];
                            samples[0][k] = 0.9999f * b0 + 5.0008297E-5f * (a0 + samples[0][next[k]]);
                            samples[1][k] = 0.9999f * b1 + 5.0008297E-5f * (a1 + samples[1][next[k]]);
                        }
                        if (y == 0.0f) {
                            samples[0][j] = 0.9999f * c0 + 5.0008297E-5f * (d0 + samples[0][prev[j]]);
                            samples[1][j] = 0.9999f * c1 + 5.0008297E-5f * (d1 + samples[1][prev[j]]);
                        } else if (y == 1.0f) {
                            k = next[j];
                            samples[0][k] = 0.9999f * d0 + 5.0008297E-5f * (c0 + samples[0][next[k]]);
                            samples[1][k] = 0.9999f * d1 + 5.0008297E-5f * (c1 + samples[1][next[k]]);
                        }
                    }
                }
                ++j;
            }
            ++i5;
        }
        return intersect;
    }

    public static float computeArea(UnionSet set) throws VisADException {
        if (set == null) {
            return 0.0f;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("UnionSet must have manifold dimension = 1");
        }
        SampledSet[] sets = set.getSets();
        if (sets == null) {
            return 0.0f;
        }
        int n = sets.length;
        if (n == 0) {
            return 0.0f;
        }
        float[][][] ss = new float[n][][];
        int k = 0;
        int i = 0;
        while (i < n) {
            if (!(sets[i] instanceof Gridded2DSet)) {
                throw new SetException("UnionSet must contain only Gridded2DSets");
            }
            ss[k] = sets[i].getSamples();
            if (ss[k] != null && ss[k].length == 2 && ss[k][0].length > 2) {
                ++k;
            }
            ++i;
        }
        if (k == 0) {
            return 0.0f;
        }
        float[][][] new_ss = new float[k][][];
        System.arraycopy(ss, 0, new_ss, 0, k);
        ss = new_ss;
        float[][] samples = DelaunayCustom.link(ss);
        if (samples == null) {
            return 0.0f;
        }
        return DelaunayCustom.computeArea(samples);
    }

    public static float computeArea(Gridded2DSet set) throws VisADException {
        if (set == null) {
            return 0.0f;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        return DelaunayCustom.computeArea(set.getSamples());
    }

    public static float computeArea(float[][] samples) throws VisADException {
        if (samples == null) {
            return 0.0f;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        if (samples[0].length < 3) {
            return 0.0f;
        }
        if (DelaunayCustom.checkSelfIntersection(samples)) {
            throw new VisADException("path self intersects");
        }
        int n = samples[0].length;
        int[] next = new int[n];
        int i = 0;
        while (i < n - 1) {
            next[i] = i + 1;
            ++i;
        }
        next[n - 1] = 0;
        float area = 0.0f;
        int i2 = 0;
        while (i2 < n) {
            area += samples[0][i2] * samples[1][next[i2]] - samples[0][next[i2]] * samples[1][i2];
            ++i2;
        }
        return (float)Math.abs(0.5 * (double)area);
    }

    public static Irregular2DSet fill(Gridded2DSet set) throws VisADException {
        return DelaunayCustom.fillCheck(set, true);
    }

    public static Irregular2DSet fillCheck(Gridded2DSet set, boolean check) throws VisADException {
        if (set == null) {
            return null;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        float[][] samples = set.getSamples();
        int[][] tris = DelaunayCustom.fillCheck(samples, check);
        if (tris == null || tris[0].length == 0) {
            return null;
        }
        DelaunayCustom delaunay = new DelaunayCustom(samples, tris);
        if (delaunay == null) {
            return null;
        }
        return new Irregular2DSet(set.getType(), samples, null, null, null, delaunay);
    }

    public static int[][] fill(float[][] samples) throws VisADException {
        return DelaunayCustom.fillCheck(samples, true);
    }

    public static int[][] fillCheck(float[][] samples, boolean check) throws VisADException {
        if (samples == null) {
            return null;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        if (samples[0].length < 3) {
            return null;
        }
        if (DelaunayCustom.checkAndFixSelfIntersection(samples) && check) {
            throw new VisADException("path self intersects");
        }
        int n = samples[0].length;
        int[] next = new int[n];
        int i = 0;
        while (i < n - 1) {
            next[i] = i + 1;
            ++i;
        }
        next[n - 1] = 0;
        int[] prev = new int[n];
        int i2 = 1;
        while (i2 < n) {
            prev[i2] = i2 - 1;
            ++i2;
        }
        prev[0] = n - 1;
        float area = 0.0f;
        int i3 = 0;
        while (i3 < n) {
            area += samples[0][i3] * samples[1][next[i3]] - samples[0][next[i3]] * samples[1][i3];
            ++i3;
        }
        boolean pos = (double)area > 0.0;
        int[][] tris = new int[n - 2][];
        int i4 = 0;
        int t = 0;
        int bad = 0;
        boolean bug = false;
        while (n - t > 2) {
            boolean in;
            int j = next[i4];
            float a0 = samples[0][j] - samples[0][i4];
            int k = next[j];
            float b1 = samples[1][k] - samples[1][j];
            float b0 = samples[0][k] - samples[0][j];
            float a1 = samples[1][j] - samples[1][i4];
            boolean bl = in = (double)(a0 * b1 - b0 * a1) > 0.0 == pos;
            if (in && i4 != next[k]) {
                float ip1;
                int ip;
                float ip0;
                float ik1 = samples[1][i4] - samples[1][k];
                float ik0 = samples[0][i4] - samples[0][k];
                float ik = samples[1][k] * ik0 - samples[0][k] * ik1;
                float ji1 = samples[1][j] - samples[1][i4];
                float ji0 = samples[0][j] - samples[0][i4];
                float ji = samples[1][i4] * ji0 - samples[0][i4] * ji1;
                float kj1 = samples[1][k] - samples[1][j];
                float kj0 = samples[0][k] - samples[0][j];
                float kj = samples[1][j] * kj0 - samples[0][j] * kj1;
                int kn = next[k];
                float kn0 = samples[0][kn];
                float kn1 = samples[1][kn];
                if ((double)(ik + kn0 * ik1 - kn1 * ik0) > 0.0 != pos && (double)(kj + kn0 * kj1 - kn1 * kj0) > 0.0 != pos) {
                    in = false;
                }
                if ((double)(ik + (ip0 = samples[0][ip = prev[i4]]) * ik1 - (ip1 = samples[1][ip]) * ik0) > 0.0 != pos && (double)(ji + ip0 * ji1 - ip1 * ji0) > 0.0 != pos) {
                    in = false;
                }
                if (in) {
                    int p = next[k];
                    int q = next[p];
                    a0 = samples[0][i4];
                    a1 = samples[1][i4];
                    b0 = samples[0][k];
                    b1 = samples[1][k];
                    while (q != i4) {
                        float c0 = samples[0][p];
                        float c1 = samples[1][p];
                        float d0 = samples[0][q];
                        float d1 = samples[1][q];
                        float det = (b0 - a0) * (c1 - d1) - (b1 - a1) * (c0 - d0);
                        p = q;
                        q = next[p];
                        if ((double)Math.abs(det) == 0.0) continue;
                        float x = ((b0 - a0) * (c1 - a1) - (b1 - a1) * (c0 - a0)) / det;
                        float y = ((c0 - a0) * (c1 - d1) - (c1 - a1) * (c0 - d0)) / det;
                        if (!(0.0f <= x) || !(x <= 1.0f) || !(0.0f <= y) || !(y <= 1.0f)) continue;
                        in = false;
                        break;
                    }
                }
            }
            if (in) {
                tris[t++] = new int[]{i4, j, k};
                next[i4] = k;
                prev[k] = i4;
                bad = 0;
                continue;
            }
            i4 = j;
            if (bad++ <= n - t) continue;
            if (bug) {
                if (t > 0) {
                    int[][] new_tris = new int[t][];
                    System.arraycopy(tris, 0, new_tris, 0, t);
                    return new_tris;
                }
                return null;
            }
            bug = true;
            bad = 0;
        }
        return tris;
    }

    public static Irregular2DSet fill(UnionSet set) throws VisADException {
        return DelaunayCustom.fillCheck(set, true);
    }

    public static Irregular2DSet fillCheck(UnionSet set, boolean check) throws VisADException {
        if (set == null) {
            return null;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("UnionSet must have manifold dimension = 1");
        }
        SampledSet[] sets = set.getSets();
        if (sets == null) {
            return null;
        }
        int n = sets.length;
        if (n == 0) {
            return null;
        }
        float[][][] ss = new float[n][][];
        int k = 0;
        int i = 0;
        while (i < n) {
            if (!(sets[i] instanceof Gridded2DSet)) {
                throw new SetException("UnionSet must contain only Gridded2DSets");
            }
            ss[k] = sets[i].getSamples();
            if (ss[k] != null && ss[k].length == 2 && ss[k][0].length > 2) {
                ++k;
            }
            ++i;
        }
        if (k == 0) {
            return null;
        }
        float[][][] new_ss = new float[k][][];
        System.arraycopy(ss, 0, new_ss, 0, k);
        ss = new_ss;
        float[][] samples = DelaunayCustom.link(ss);
        int[][] tris = DelaunayCustom.fillCheck(samples, check);
        if (tris == null || tris[0].length == 0) {
            return null;
        }
        DelaunayCustom delaunay = new DelaunayCustom(samples, tris);
        if (delaunay == null) {
            return null;
        }
        return new Irregular2DSet(set.getType(), samples, null, null, null, delaunay);
    }

    public static float[][] link(float[][][] ss) throws VisADException {
        if (ss == null || ((float[][][])ss).length == 0) {
            return null;
        }
        int nn = ((float[][][])ss).length;
        int ii = 0;
        while (ii < nn) {
            if (ss[ii].length != 2 || ss[ii][0].length != ss[ii][1].length) {
                throw new VisADException("samples argument bad dimensions");
            }
            if (DelaunayCustom.checkAndFixSelfIntersection(ss[ii])) {
                throw new VisADException("path self intersects");
            }
            ++ii;
        }
        float[][][] new_ss = new float[nn][][];
        int k = 0;
        int ii2 = 0;
        while (ii2 < nn) {
            if (ss[ii2][0].length > 2) {
                new_ss[k] = ss[ii2];
                ++k;
            }
            ++ii2;
        }
        if (k == 0) {
            return null;
        }
        if (k == 1) {
            return new_ss[0];
        }
        ss = new float[k][][];
        System.arraycopy(new_ss, 0, ss, 0, k);
        nn = k;
        boolean[][] in = new boolean[nn][nn];
        int ii3 = 0;
        while (ii3 < nn) {
            int jj = 0;
            while (jj < nn) {
                in[ii3][jj] = ii3 == jj ? false : DelaunayCustom.inside(ss[ii3], ss[jj][0][0], ss[jj][1][0]);
                ++jj;
            }
            ++ii3;
        }
        int ii4 = 0;
        while (ii4 < nn) {
            boolean any_outer = false;
            int jj = ii4;
            while (jj < nn) {
                boolean in_any = false;
                int kk = ii4;
                while (kk < nn) {
                    if (in[kk][jj]) {
                        in_any = true;
                        break;
                    }
                    ++kk;
                }
                if (!in_any) {
                    any_outer = true;
                    if (ii4 == jj) break;
                    float[][] tss = ss[ii4];
                    ss[ii4] = ss[jj];
                    ss[jj] = tss;
                    boolean[] tin = in[ii4];
                    in[ii4] = in[jj];
                    in[jj] = tin;
                    int kk2 = 0;
                    while (kk2 < nn) {
                        boolean tb = in[kk2][ii4];
                        in[kk2][ii4] = in[kk2][jj];
                        in[kk2][jj] = tb;
                        ++kk2;
                    }
                    break;
                }
                ++jj;
            }
            if (!any_outer) {
                // empty if block
            }
            ++ii4;
        }
        boolean[] orient = new boolean[nn];
        int ii5 = 0;
        while (ii5 < nn) {
            float area = 0.0f;
            float[][] t = ss[ii5];
            int m = t[0].length;
            int i = 0;
            while (i < m - 1) {
                area += t[0][i] * t[1][i + 1] - t[0][i + 1] * t[1][i];
                ++i;
            }
            orient[ii5] = (double)(area += t[0][m - 1] * t[1][0] - t[0][0] * t[1][m - 1]) > 0.0;
            ++ii5;
        }
        float[][] s = ss[0];
        int ii6 = 1;
        while (ii6 < nn) {
            float[][] t = ss[ii6];
            if (t[0].length >= 3) {
                int n = s[0].length;
                int m = t[0].length;
                float distance = Float.MAX_VALUE;
                int near_i = -1;
                int near_j = -1;
                int i = 0;
                while (i < n) {
                    int j = 0;
                    while (j < m) {
                        float d = (s[0][i] - t[0][j]) * (s[0][i] - t[0][j]) + (s[1][i] - t[1][j]) * (s[1][i] - t[1][j]);
                        if (d < distance) {
                            distance = d;
                            near_i = i;
                            near_j = j;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (near_i >= 0) {
                    boolean inn = in[0][ii6];
                    boolean flip = orient[0] == orient[ii6] == inn;
                    int new_n = n + m + 2;
                    float[][] new_s = new float[2][new_n];
                    k = 0;
                    System.arraycopy(s[0], 0, new_s[0], k, near_i + 1);
                    System.arraycopy(s[1], 0, new_s[1], k, near_i + 1);
                    int b1 = (k += near_i + 1) - 1;
                    int a1 = k;
                    if (flip) {
                        int j = near_j;
                        while (j >= 0) {
                            new_s[0][k] = t[0][j];
                            new_s[1][k] = t[1][j];
                            ++k;
                            --j;
                        }
                        int j2 = m - 1;
                        while (j2 >= near_j) {
                            new_s[0][k] = t[0][j2];
                            new_s[1][k] = t[1][j2];
                            ++k;
                            --j2;
                        }
                    } else {
                        System.arraycopy(t[0], near_j, new_s[0], k, m - near_j);
                        System.arraycopy(t[1], near_j, new_s[1], k, m - near_j);
                        System.arraycopy(t[0], 0, new_s[0], k += m - near_j, near_j + 1);
                        System.arraycopy(t[1], 0, new_s[1], k, near_j + 1);
                        k += near_j + 1;
                    }
                    int b2 = k - 1;
                    int a2 = k;
                    System.arraycopy(s[0], near_i, new_s[0], k, n - near_i);
                    System.arraycopy(s[1], near_i, new_s[1], k, n - near_i);
                    s[0] = new_s[0];
                    s[1] = new_s[1];
                    int b1m = b1 > 0 ? b1 - 1 : new_n - 1;
                    int a1p = a1 < new_n - 1 ? a1 + 1 : 0;
                    int b2m = b2 > 0 ? b2 - 1 : new_n - 1;
                    int a2p = a2 < new_n - 1 ? a2 + 1 : 0;
                    new_s[0][b1] = 0.9999f * new_s[0][b1] + 1.00016594E-4f * new_s[0][b1m];
                    new_s[1][b1] = 0.9999f * new_s[1][b1] + 1.00016594E-4f * new_s[1][b1m];
                    new_s[0][a1] = 0.9999f * new_s[0][a1] + 1.00016594E-4f * new_s[0][a1p];
                    new_s[1][a1] = 0.9999f * new_s[1][a1] + 1.00016594E-4f * new_s[1][a1p];
                    new_s[0][b2] = 0.9999f * new_s[0][b2] + 1.00016594E-4f * new_s[0][b2m];
                    new_s[1][b2] = 0.9999f * new_s[1][b2] + 1.00016594E-4f * new_s[1][b2m];
                    new_s[0][a2] = 0.9999f * new_s[0][a2] + 1.00016594E-4f * new_s[0][a2p];
                    new_s[1][a2] = 0.9999f * new_s[1][a2] + 1.00016594E-4f * new_s[1][a2p];
                }
            }
            ++ii6;
        }
        return s;
    }

    public static boolean inside(float[][] s, float x, float y) throws VisADException {
        if (s == null) {
            return false;
        }
        if (s.length != 2 || s[0].length != s[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = s[0].length;
        double angle = 0.0;
        int i = 0;
        while (i < n) {
            int ip = i < n - 1 ? i + 1 : 0;
            double a = Math.atan2(s[0][i] - x, s[1][i] - y) - Math.atan2(s[0][ip] - x, s[1][ip] - y);
            if (a < -Math.PI) {
                a += Math.PI;
            }
            if (a > Math.PI) {
                a -= Math.PI;
            }
            angle += a;
            ++i;
        }
        return Math.abs(angle) > 0.5;
    }

    public static void clip(float[][] samples, int[][] tris, float xc, float yc, float v, float[][][] outs, int[][][] outt) throws VisADException {
        float[][] s = null;
        int[][] t = null;
        if (samples == null || tris == null) {
            outs[0] = s;
            outt[0] = t;
            return;
        }
        int nsamples = samples[0].length;
        int ns = 0;
        s = new float[2][2 * nsamples];
        int ntris = tris.length;
        int nt = 0;
        t = new int[2 * ntris][];
        int[] smap = new int[nsamples];
        int[][] sother = new int[nsamples][6];
        int[][] snew = new int[nsamples][6];
        int[] minus1s = new int[]{-1, -1, -1, -1, -1, -1};
        int i = 0;
        while (i < nsamples) {
            System.arraycopy(minus1s, 0, sother[i], 0, 6);
            if (xc * samples[0][i] + yc * samples[1][i] <= v) {
                s[0][ns] = samples[0][i];
                s[1][ns] = samples[1][i];
                smap[i] = ns++;
            } else {
                smap[i] = -1;
            }
            ++i;
        }
        int nskept = ns;
        int[] incounts = new int[]{0, 1, 1, 2, 1, 2, 2, 3};
        int[] firsts = new int[]{-1, 0, 1, 0, 2, 0, 1, 0};
        int[] seconds = new int[]{-1, 1, 0, 1, 0, 2, 2, 1};
        int[] thirds = new int[]{-1, 2, 2, 2, 1, 1, 0, 2};
        int i2 = 0;
        while (i2 < ntris) {
            int a = tris[i2][0];
            int b = tris[i2][1];
            int c = tris[i2][2];
            int flags = smap[a] < 0 ? 0 : 1;
            flags += smap[b] < 0 ? 0 : 2;
            switch (incounts[flags += smap[c] < 0 ? 0 : 4]) {
                case 0: {
                    break;
                }
                case 3: {
                    t[nt] = new int[]{smap[tris[i2][0]], smap[tris[i2][1]], smap[tris[i2][2]]};
                    ++nt;
                    break;
                }
                case 1: {
                    int ao = tris[i2][firsts[flags]];
                    int bo = tris[i2][seconds[flags]];
                    int co = tris[i2][thirds[flags]];
                    float av = v - (xc * samples[0][ao] + yc * samples[1][ao]);
                    float bv = v - (xc * samples[0][bo] + yc * samples[1][bo]);
                    float cv = v - (xc * samples[0][co] + yc * samples[1][co]);
                    float bw = av / (av - bv);
                    float bwm = 1.0f - bw;
                    float cw = av / (av - cv);
                    float cwm = 1.0f - cw;
                    float[] sb = new float[]{bwm * samples[0][ao] + bw * samples[0][bo], bwm * samples[1][ao] + bw * samples[1][bo]};
                    float[] sc = new float[]{cwm * samples[0][ao] + cw * samples[0][co], cwm * samples[1][ao] + cw * samples[1][co]};
                    int sbi = -1;
                    int sci = -1;
                    int jmax = -1;
                    int j = 0;
                    while (j < 6) {
                        if (sother[ao][j] < 0) break;
                        jmax = j;
                        if (sother[ao][j] == bo) {
                            sbi = snew[ao][j];
                        }
                        if (sother[ao][j] == co) {
                            sci = snew[ao][j];
                        }
                        ++j;
                    }
                    if (sbi < 0) {
                        s[0][ns] = sb[0];
                        s[1][ns] = sb[1];
                        if (jmax < 5) {
                            sother[ao][++jmax] = bo;
                            snew[ao][jmax] = ns;
                        }
                        sbi = ns++;
                    }
                    if (sci < 0) {
                        s[0][ns] = sc[0];
                        s[1][ns] = sc[1];
                        if (jmax < 5) {
                            sother[ao][++jmax] = co;
                            snew[ao][jmax] = ns;
                        }
                        sci = ns++;
                    }
                    t[nt] = new int[]{smap[ao], sbi, sci};
                    ++nt;
                    break;
                }
                case 2: {
                    int ao = tris[i2][firsts[flags]];
                    int bo = tris[i2][seconds[flags]];
                    int co = tris[i2][thirds[flags]];
                    float av = v - (xc * samples[0][ao] + yc * samples[1][ao]);
                    float bv = v - (xc * samples[0][bo] + yc * samples[1][bo]);
                    float cv = v - (xc * samples[0][co] + yc * samples[1][co]);
                    float aw = av / (av - cv);
                    float awm = 1.0f - aw;
                    float bw = bv / (bv - cv);
                    float bwm = 1.0f - bw;
                    float[] sa = new float[]{awm * samples[0][ao] + aw * samples[0][co], awm * samples[1][ao] + aw * samples[1][co]};
                    float[] sb = new float[]{bwm * samples[0][bo] + bw * samples[0][co], bwm * samples[1][bo] + bw * samples[1][co]};
                    int sai = -1;
                    int sbi = -1;
                    int jamax = -1;
                    int j = 0;
                    while (j < 6) {
                        if (sother[ao][j] < 0) break;
                        jamax = j;
                        if (sother[ao][j] == co) {
                            sai = snew[ao][j];
                        }
                        ++j;
                    }
                    int jbmax = -1;
                    int j2 = 0;
                    while (j2 < 6) {
                        if (sother[bo][j2] < 0) break;
                        jbmax = j2;
                        if (sother[bo][j2] == co) {
                            sbi = snew[bo][j2];
                        }
                        ++j2;
                    }
                    if (sai < 0) {
                        s[0][ns] = sa[0];
                        s[1][ns] = sa[1];
                        if (jamax < 5) {
                            sother[ao][++jamax] = co;
                            snew[ao][jamax] = ns;
                        }
                        sai = ns++;
                    }
                    if (sbi < 0) {
                        s[0][ns] = sb[0];
                        s[1][ns] = sb[1];
                        if (jbmax < 5) {
                            sother[bo][++jbmax] = co;
                            snew[bo][jbmax] = ns;
                        }
                        sbi = ns++;
                    }
                    t[nt] = new int[]{smap[ao], smap[bo], sai};
                    t[++nt] = new int[]{smap[bo], sai, sbi};
                    ++nt;
                }
            }
            ++i2;
        }
        if (ns == 0 || nt == 0) {
            outs[0] = null;
            outt[0] = null;
        } else {
            float[][] ss = new float[2][ns];
            System.arraycopy(s[0], 0, ss[0], 0, ns);
            System.arraycopy(s[1], 0, ss[1], 0, ns);
            int[][] tt = new int[nt][];
            System.arraycopy(t, 0, tt, 0, nt);
            outs[0] = ss;
            outt[0] = tt;
        }
    }
}

