/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.DelaunayClarkson;
import visad.DelaunayCustom;
import visad.DelaunayFast;
import visad.DelaunayWatson;
import visad.Set;
import visad.SetException;
import visad.UnimplementedException;
import visad.VisADError;
import visad.VisADException;

public abstract class Delaunay
implements Serializable {
    public int[][] Tri = null;
    public int[][] Vertices = null;
    public int[][] Walk = null;
    public int[][] Edges = null;
    public int NumEdges = 0;

    public Object clone() {
        try {
            return new DelaunayCustom(null, this.Tri, this.Vertices, this.Walk, this.Edges, this.NumEdges);
        }
        catch (VisADException e) {
            throw new VisADError("Delaunay.clone: " + e.toString());
        }
    }

    public static Delaunay factory(float[][] samples, boolean exact) throws VisADException {
        block11: {
            int choice;
            int FAST = 0;
            int CLARKSON = 1;
            int WATSON = 2;
            int dim = samples.length;
            if (dim < 2) {
                throw new VisADException("Delaunay.factory: dimension must be 2 or higher");
            }
            if (dim > 3) {
                choice = CLARKSON;
            } else {
                int nrs = samples[0].length;
                int i = 1;
                while (i < dim) {
                    nrs = Math.min(nrs, samples[i].length);
                    ++i;
                }
                choice = dim == 2 && !exact && nrs > 10000 ? FAST : (nrs > 3000 ? CLARKSON : WATSON);
            }
            try {
                if (choice == FAST) {
                    DelaunayFast delan = new DelaunayFast(samples);
                    delan.improve(samples, 1);
                    return delan;
                }
                if (choice == CLARKSON) {
                    DelaunayClarkson delan = new DelaunayClarkson(samples);
                    return delan;
                }
                if (choice == WATSON) {
                    DelaunayWatson delan = new DelaunayWatson(samples);
                    return delan;
                }
            }
            catch (Exception e) {
                if (choice == CLARKSON) break block11;
                try {
                    DelaunayClarkson delan = new DelaunayClarkson(samples);
                    return delan;
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static float[][] scale(float[][] samples, float mult, boolean copy) {
        int dim = samples.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            if (samples[i].length < nrs) {
                nrs = samples[i].length;
            }
            ++i;
        }
        float[][] samp = copy ? Set.copyFloats(samples) : samples;
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < nrs) {
                float[] fArray = samp[i2];
                int n = j++;
                fArray[n] = fArray[n] * mult;
            }
            ++i2;
        }
        return samp;
    }

    public static float[][] perturb(float[][] samples, float epsilon, boolean copy) {
        int dim = samples.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            if (samples[i].length < nrs) {
                nrs = samples[i].length;
            }
            ++i;
        }
        float[][] samp = copy ? Set.copyFloats(samples) : samples;
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < nrs) {
                float[] fArray = samp[i2];
                int n = j++;
                fArray[n] = fArray[n] + (float)((double)(2.0f * epsilon) * (Math.random() - 0.5));
            }
            ++i2;
        }
        return samp;
    }

    public boolean test(float[][] samples) {
        int k;
        int k2;
        int dim = samples.length;
        int dim1 = dim + 1;
        int ntris = this.Tri.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            nrs = Math.min(nrs, samples[i].length);
            ++i;
        }
        int i2 = 0;
        while (i2 < ntris) {
            if (this.Tri[i2].length < dim1) {
                return false;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < ntris) {
            int j = 0;
            while (j < dim1) {
                if (this.Tri[i3][j] < 0 || this.Tri[i3][j] >= nrs) {
                    return false;
                }
                ++j;
            }
            ++i3;
        }
        int[] nverts = new int[nrs];
        int i4 = 0;
        while (i4 < nrs) {
            nverts[i4] = 0;
            ++i4;
        }
        int i5 = 0;
        while (i5 < ntris) {
            int j = 0;
            while (j < dim1) {
                int n = this.Tri[i5][j];
                nverts[n] = nverts[n] + 1;
                ++j;
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < nrs) {
            if (nverts[i6] == 0) {
                return false;
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < ntris) {
            int j = i7 + 1;
            while (j < ntris) {
                boolean[] m = new boolean[dim1];
                int mi = 0;
                while (mi < dim1) {
                    m[mi] = false;
                    ++mi;
                }
                k2 = 0;
                while (k2 < dim1) {
                    int l = 0;
                    while (l < dim1) {
                        if (this.Tri[i7][k2] == this.Tri[j][l] && !m[l]) {
                            m[l] = true;
                        }
                        ++l;
                    }
                    ++k2;
                }
                boolean mtot = true;
                k = 0;
                while (k < dim1) {
                    if (!m[k]) {
                        mtot = false;
                    }
                    ++k;
                }
                if (mtot) {
                    return false;
                }
                ++j;
            }
            ++i7;
        }
        int i8 = 0;
        while (i8 < ntris) {
            int j = 0;
            while (j < dim1) {
                if (this.Walk[i8][j] != -1) {
                    boolean found = false;
                    k2 = 0;
                    while (k2 < dim1) {
                        if (this.Walk[this.Walk[i8][j]][k2] == i8) {
                            found = true;
                        }
                        ++k2;
                    }
                    if (!found) {
                        return false;
                    }
                    int sb = 0;
                    k = 0;
                    while (k < dim1) {
                        int l = 0;
                        while (l < dim1) {
                            if (this.Tri[i8][k] == this.Tri[this.Walk[i8][j]][l]) {
                                ++sb;
                            }
                            ++l;
                        }
                        ++k;
                    }
                    if (sb != dim) {
                        return false;
                    }
                }
                ++j;
            }
            ++i8;
        }
        return true;
    }

    public void improve(float[][] samples, int pass) throws VisADException {
        int dim = samples.length;
        int dim1 = dim + 1;
        if (this.Tri[0].length != dim1) {
            throw new SetException("Delaunay.improve: samples dimension does not match");
        }
        if (dim > 2) {
            throw new UnimplementedException("Delaunay.improve: dimension must be 2!");
        }
        int ntris = this.Tri.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            nrs = Math.min(nrs, samples[i].length);
            ++i;
        }
        float[] samp0 = samples[0];
        float[] samp1 = samples[1];
        boolean eflipped = false;
        int p = 0;
        while (p < pass) {
            eflipped = false;
            boolean[] edge = new boolean[this.NumEdges];
            int i2 = 0;
            while (i2 < this.NumEdges) {
                edge[i2] = true;
                ++i2;
            }
            int t = 0;
            while (t < ntris) {
                int[] trit = this.Tri[t];
                int[] walkt = this.Walk[t];
                int[] edgest = this.Edges[t];
                int e = 0;
                while (e < 2) {
                    int curedge = edgest[e];
                    if (edge[curedge]) {
                        int t2 = walkt[e];
                        if (t2 >= 0) {
                            boolean sig;
                            int[] trit2 = this.Tri[t2];
                            int[] walkt2 = this.Walk[t2];
                            int[] edgest2 = this.Edges[t2];
                            int f = walkt2[0] == t ? 0 : (walkt2[1] == t ? 1 : 2);
                            int A = (e + 2) % 3;
                            int B = (A + 1) % 3;
                            int C = (B + 1) % 3;
                            int D = (f + 2) % 3;
                            float ax = samp0[trit[A]];
                            float ay = samp1[trit[A]];
                            float bx = samp0[trit[B]];
                            float by = samp1[trit[B]];
                            float cx = samp0[trit[C]];
                            float cy = samp1[trit[C]];
                            float dx = samp0[trit2[D]];
                            float dy = samp1[trit2[D]];
                            float abx = ax - bx;
                            float aby = ay - by;
                            float acx = ax - cx;
                            float acy = ay - cy;
                            float dbx = dx - bx;
                            float dby = dy - by;
                            float dcx = dx - cx;
                            float dcy = dy - cy;
                            float Q = abx * acx + aby * acy;
                            float R = dbx * abx + dby * aby;
                            float S = acx * dcx + acy * dcy;
                            float T = dbx * dcx + dby * dcy;
                            boolean QD = abx * acy - aby * acx >= 0.0f;
                            boolean RD = dbx * aby - dby * abx >= 0.0f;
                            boolean SD = acx * dcy - acy * dcx >= 0.0f;
                            boolean TD = dcx * dby - dcy * dbx >= 0.0f;
                            boolean bl = sig = (QD ? 1 : 0) + (RD ? 1 : 0) + (SD ? 1 : 0) + (TD ? 1 : 0) < 2;
                            boolean d = QD == sig ? true : (RD == sig ? false : (SD == sig ? false : (TD == sig ? true : (Q < 0.0f && T < 0.0f || R > 0.0f && S > 0.0f ? true : (R < 0.0f && S < 0.0f || Q > 0.0f && T > 0.0f ? false : (Q < 0.0f ? Q : T) < (R < 0.0f ? R : S))))));
                            if (d) {
                                int val;
                                int e4;
                                int e3;
                                int w4;
                                int w3;
                                eflipped = true;
                                int n1 = trit[A];
                                int n2 = trit[B];
                                int n3 = trit[C];
                                int n4 = trit2[D];
                                int w1 = walkt[A];
                                int w2 = walkt[C];
                                int e1 = edgest[A];
                                int e2 = edgest[C];
                                if (trit2[(D + 1) % 3] == trit[C]) {
                                    w3 = walkt2[D];
                                    w4 = walkt2[(D + 2) % 3];
                                    e3 = edgest2[D];
                                    e4 = edgest2[(D + 2) % 3];
                                } else {
                                    w3 = walkt2[(D + 2) % 3];
                                    w4 = walkt2[D];
                                    e3 = edgest2[(D + 2) % 3];
                                    e4 = edgest2[D];
                                }
                                trit[0] = n1;
                                trit[1] = n2;
                                trit[2] = n4;
                                trit2[0] = n1;
                                trit2[1] = n4;
                                trit2[2] = n3;
                                walkt[0] = w1;
                                walkt[1] = w4;
                                walkt[2] = t2;
                                walkt2[0] = t;
                                walkt2[1] = w3;
                                walkt2[2] = w2;
                                if (w2 >= 0) {
                                    val = this.Walk[w2][0] == t ? 0 : (this.Walk[w2][1] == t ? 1 : 2);
                                    this.Walk[w2][val] = t2;
                                }
                                if (w4 >= 0) {
                                    val = this.Walk[w4][0] == t2 ? 0 : (this.Walk[w4][1] == t2 ? 1 : 2);
                                    this.Walk[w4][val] = t;
                                }
                                edgest[0] = e1;
                                edgest[1] = e4;
                                edgest2[1] = e3;
                                edgest2[2] = e2;
                                int[] vertn1 = this.Vertices[n1];
                                int[] vertn2 = this.Vertices[n2];
                                int[] vertn3 = this.Vertices[n3];
                                int[] vertn4 = this.Vertices[n4];
                                int ln1 = vertn1.length;
                                int ln2 = vertn2.length;
                                int ln3 = vertn3.length;
                                int ln4 = vertn4.length;
                                int[] tn1 = new int[ln1 + 1];
                                int[] tn2 = new int[ln2 - 1];
                                int[] tn3 = new int[ln3 - 1];
                                int[] tn4 = new int[ln4 + 1];
                                System.arraycopy(vertn1, 0, tn1, 0, ln1);
                                tn1[ln1] = t2;
                                int c = 0;
                                int i3 = 0;
                                while (i3 < ln2) {
                                    if (vertn2[i3] != t2) {
                                        tn2[c++] = vertn2[i3];
                                    }
                                    ++i3;
                                }
                                c = 0;
                                int i4 = 0;
                                while (i4 < ln3) {
                                    if (vertn3[i4] != t) {
                                        tn3[c++] = vertn3[i4];
                                    }
                                    ++i4;
                                }
                                System.arraycopy(vertn4, 0, tn4, 0, ln4);
                                tn4[ln4] = t;
                                this.Vertices[n1] = tn1;
                                this.Vertices[n2] = tn2;
                                this.Vertices[n3] = tn3;
                                this.Vertices[n4] = tn4;
                            }
                        }
                        edge[curedge] = false;
                    }
                    ++e;
                }
                ++t;
            }
            if (!eflipped) break;
            ++p;
        }
    }

    public void finish_triang(float[][] samples) throws VisADException {
        block40: {
            int i;
            int j;
            int i2;
            int mdim = this.Tri[0].length - 1;
            int mdim1 = mdim + 1;
            int dim = samples.length;
            int dim1 = dim + 1;
            int ntris = this.Tri.length;
            int nrs = samples[0].length;
            int i3 = 1;
            while (i3 < dim) {
                nrs = Math.min(nrs, samples[i3].length);
                ++i3;
            }
            if (this.Vertices == null) {
                this.Vertices = new int[nrs][];
                int[] nverts = new int[nrs];
                i2 = 0;
                while (i2 < ntris) {
                    j = 0;
                    while (j < mdim1) {
                        int n = this.Tri[i2][j];
                        nverts[n] = nverts[n] + 1;
                        ++j;
                    }
                    ++i2;
                }
                i = 0;
                while (i < nrs) {
                    this.Vertices[i] = new int[nverts[i]];
                    nverts[i] = 0;
                    ++i;
                }
                int i4 = 0;
                while (i4 < ntris) {
                    int j2 = 0;
                    while (j2 < mdim1) {
                        int n = this.Tri[i4][j2];
                        int n2 = nverts[n];
                        nverts[n] = n2 + 1;
                        this.Vertices[this.Tri[i4][j2]][n2] = i4;
                        ++j2;
                    }
                    ++i4;
                }
            }
            if (this.Walk == null && mdim <= 3) {
                this.Walk = new int[ntris][mdim1];
                int i5 = 0;
                while (i5 < ntris) {
                    int j3 = 0;
                    while (j3 < mdim1) {
                        int v1 = j3;
                        int v2 = (v1 + 1) % mdim1;
                        this.Walk[i5][j3] = -1;
                        int k = 0;
                        block8: while (k < this.Vertices[this.Tri[i5][v1]].length) {
                            int temp = this.Vertices[this.Tri[i5][v1]][k];
                            if (temp != i5) {
                                int l = 0;
                                while (l < this.Vertices[this.Tri[i5][v2]].length) {
                                    if (mdim == 2) {
                                        if (temp == this.Vertices[this.Tri[i5][v2]][l]) {
                                            this.Walk[i5][j3] = temp;
                                            break block8;
                                        }
                                    } else {
                                        int temp2 = this.Vertices[this.Tri[i5][v2]][l];
                                        int v3 = (v2 + 1) % mdim1;
                                        if (temp == temp2) {
                                            int m = 0;
                                            while (m < this.Vertices[this.Tri[i5][v3]].length) {
                                                if (temp == this.Vertices[this.Tri[i5][v3]][m]) {
                                                    this.Walk[i5][j3] = temp;
                                                    break block8;
                                                }
                                                ++m;
                                            }
                                        }
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                        ++j3;
                    }
                    ++i5;
                }
            }
            if (this.Edges != null || mdim > 3) break block40;
            int edim = 3 * (mdim - 1);
            this.Edges = new int[ntris][edim];
            i2 = 0;
            while (i2 < ntris) {
                j = 0;
                while (j < edim) {
                    this.Edges[i2][j] = -1;
                    ++j;
                }
                ++i2;
            }
            this.NumEdges = 0;
            if (mdim == 2) {
                i = 0;
                while (i < ntris) {
                    int j4 = 0;
                    while (j4 < 3) {
                        if (this.Edges[i][j4] < 0) {
                            int othtri = this.Walk[i][j4];
                            if (othtri >= 0) {
                                int cside = -1;
                                int k = 0;
                                while (k < 3) {
                                    if (this.Walk[othtri][k] == i) {
                                        cside = k;
                                    }
                                    ++k;
                                }
                                if (cside != -1) {
                                    this.Edges[othtri][cside] = this.NumEdges;
                                } else {
                                    throw new SetException("Delaunay.finish_triang: error in triangulation!");
                                }
                            }
                            this.Edges[i][j4] = this.NumEdges++;
                        }
                        ++j4;
                    }
                    ++i;
                }
            } else {
                int[] ptlook1 = new int[]{0, 0, 0, 1, 1, 2};
                int[] ptlook2 = new int[]{1, 2, 3, 2, 3, 3};
                int i6 = 0;
                while (i6 < ntris) {
                    int j5 = 0;
                    while (j5 < 6) {
                        if (this.Edges[i6][j5] < 0) {
                            int endpt1 = this.Tri[i6][ptlook1[j5]];
                            int endpt2 = this.Tri[i6][ptlook2[j5]];
                            int[] set = new int[this.Vertices[endpt1].length];
                            int setlen = 0;
                            int p1 = 0;
                            while (p1 < this.Vertices[endpt1].length) {
                                int temp = this.Vertices[endpt1][p1];
                                int p2 = 0;
                                while (p2 < this.Vertices[endpt2].length) {
                                    if (temp == this.Vertices[endpt2][p2]) {
                                        set[setlen++] = temp;
                                        break;
                                    }
                                    ++p2;
                                }
                                ++p1;
                            }
                            int kk = 0;
                            while (kk < setlen) {
                                int k = set[kk];
                                int l = 0;
                                while (l < edim) {
                                    if (this.Tri[k][ptlook1[l]] == endpt1 && this.Tri[k][ptlook2[l]] == endpt2 || this.Tri[k][ptlook1[l]] == endpt2 && this.Tri[k][ptlook2[l]] == endpt1) {
                                        this.Edges[k][l] = this.NumEdges;
                                    }
                                    ++l;
                                }
                                ++kk;
                            }
                            this.Edges[i6][j5] = this.NumEdges++;
                        }
                        ++j5;
                    }
                    ++i6;
                }
            }
        }
    }

    public String toString() {
        return this.sampleString(null);
    }

    public String sampleString(float[][] samples) {
        int i;
        StringBuffer s = new StringBuffer("");
        if (samples != null) {
            s.append("\nsamples " + samples[0].length + "\n");
            i = 0;
            while (i < samples[0].length) {
                s.append("  " + i + " -> " + samples[0][i] + " " + samples[1][i] + " " + samples[2][i] + "\n");
                ++i;
            }
            s.append("\n");
        }
        s.append("\nTri (triangles -> vertices) " + this.Tri.length + "\n");
        i = 0;
        while (i < this.Tri.length) {
            s.append("  " + i + " -> ");
            int j = 0;
            while (j < this.Tri[i].length) {
                s.append(" " + this.Tri[i][j]);
                ++j;
            }
            s.append("\n");
            ++i;
        }
        s.append("\nVertices (vertices -> triangles) " + this.Vertices.length + "\n");
        int i2 = 0;
        while (i2 < this.Vertices.length) {
            s.append("  " + i2 + " -> ");
            int j = 0;
            while (j < this.Vertices[i2].length) {
                s.append(" " + this.Vertices[i2][j]);
                ++j;
            }
            s.append("\n");
            ++i2;
        }
        s.append("\nWalk (triangles -> triangles) " + this.Walk.length + "\n");
        int i3 = 0;
        while (i3 < this.Walk.length) {
            s.append("  " + i3 + " -> ");
            int j = 0;
            while (j < this.Walk[i3].length) {
                s.append(" " + this.Walk[i3][j]);
                ++j;
            }
            s.append("\n");
            ++i3;
        }
        s.append("\nEdges (triangles -> global edges) " + this.Edges.length + "\n");
        int i4 = 0;
        while (i4 < this.Edges.length) {
            s.append("  " + i4 + " -> ");
            int j = 0;
            while (j < this.Edges[i4].length) {
                s.append(" " + this.Edges[i4][j]);
                ++j;
            }
            s.append("\n");
            ++i4;
        }
        return s.toString();
    }
}

