/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.CommonUnit;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public abstract class Control
implements Cloneable,
Serializable {
    private long NewTick = -9223372036854775807L;
    private long OldTick;
    private boolean tickFlag = false;
    private boolean isSet = false;
    transient DisplayImpl display;
    transient DisplayRenderer displayRenderer;
    private int Index;
    private int Instance;
    private transient Vector ListenerVector = new Vector();

    public Control(DisplayImpl d) {
        this.OldTick = Long.MIN_VALUE;
        this.display = d;
        this.Instance = -1;
        this.Index = -1;
        if (this.display != null) {
            this.displayRenderer = this.display.getDisplayRenderer();
        }
    }

    public DisplayRenderer getDisplayRenderer() {
        return this.displayRenderer;
    }

    public void changeControl(boolean tick) throws VisADException, RemoteException {
        if (tick) {
            this.incTick();
        }
        if (this.ListenerVector != null) {
            Vector clv = null;
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                clv = (Vector)this.ListenerVector.clone();
            }
            Enumeration listeners = clv.elements();
            while (listeners.hasMoreElements()) {
                ControlListener listener = (ControlListener)listeners.nextElement();
                listener.controlChanged(new ControlEvent(this));
            }
        }
    }

    public void addControlListener(ControlListener listener) {
        this.ListenerVector.addElement(listener);
    }

    public void removeControlListener(ControlListener listener) {
        if (listener != null) {
            this.ListenerVector.removeElement(listener);
        }
    }

    public void nullControl() {
        this.ListenerVector.removeAllElements();
    }

    public long incTick() {
        ++this.NewTick;
        if (this.NewTick == Long.MAX_VALUE) {
            this.NewTick = -9223372036854775807L;
        }
        if (this.display != null) {
            this.display.controlChanged();
        }
        return this.NewTick;
    }

    public synchronized void setTicks() {
        if (this.isSet) {
            return;
        }
        this.isSet = true;
        this.tickFlag = this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        this.OldTick = this.NewTick;
        this.subSetTicks();
    }

    public synchronized boolean peekTicks(DataRenderer r, DataDisplayLink link) {
        return (this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick) && r.isTransformControl(this, link) || this.subPeekTicks(r, link);
    }

    public synchronized boolean checkTicks(DataRenderer r, DataDisplayLink link) {
        return this.tickFlag && r.isTransformControl(this, link) || this.subCheckTicks(r, link);
    }

    public synchronized void resetTicks() {
        this.tickFlag = false;
        this.subResetTicks();
        this.isSet = false;
    }

    public void subSetTicks() {
    }

    public boolean subCheckTicks(DataRenderer r, DataDisplayLink link) {
        return false;
    }

    public boolean subPeekTicks(DataRenderer r, DataDisplayLink link) {
        return false;
    }

    public void subResetTicks() {
    }

    public void animation_string(RealType real, Set set, double value, int current) throws VisADException {
        Unit[] units = set.getSetUnits();
        Vector tmap = this.display.getMapVector();
        Unit overrideUnit = null;
        int i = 0;
        while (i < tmap.size()) {
            ScalarMap map = (ScalarMap)tmap.elementAt(i);
            Control c = map.getControl();
            if (this.equals(c)) {
                overrideUnit = map.getOverrideUnit();
            }
            ++i;
        }
        if (!(overrideUnit == null || units == null || overrideUnit.equals(units[0]) || Unit.canConvert(units[0], CommonUnit.secondsSinceTheEpoch) && !units[0].getAbsoluteUnit().equals(units[0]))) {
            value = overrideUnit.toThis(value, units[0]);
            units[0] = overrideUnit;
        }
        String s = real.getName() + " = " + new Real(real, value, units == null ? null : units[0]).toValueString();
        String t = Integer.toString(current + 1) + " of " + Integer.toString(set.getLength());
        this.getDisplayRenderer().setAnimationString(new String[]{s, t});
    }

    void setIndex(int index) {
        this.Index = index;
    }

    int getIndex() {
        return this.Index;
    }

    void setInstanceNumber(int instance) {
        this.Instance = instance;
    }

    public int getInstanceNumber() {
        return this.Instance;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public abstract String getSaveString();

    public abstract void setSaveString(String var1) throws VisADException, RemoteException;

    public abstract void syncControl(Control var1) throws VisADException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        return this.Instance == ((Control)o).Instance;
    }

    public String toString() {
        String cn = this.getClass().getName();
        int pt = cn.lastIndexOf(46);
        int ds = cn.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        pt = pt == -1 ? 0 : ++pt;
        return cn.substring(pt) + "@" + this.Index + "#" + this.Instance;
    }
}

