/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Contour2D;
import visad.Control;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class ContourControl
extends Control {
    private boolean mainContours = true;
    private float surfaceValue = Float.NaN;
    private float contourInterval = Float.NaN;
    private float lowLimit = Float.NaN;
    private float hiLimit = Float.NaN;
    private float base = Float.NaN;
    private boolean labels = false;
    private boolean arithmeticProgression = true;
    private float[] levels = null;
    private boolean dash = false;
    private boolean horizontalContourSlice = false;
    private boolean verticalContourSlice = false;
    private float horizontalSliceLow = Float.NaN;
    private float horizontalSliceHi = Float.NaN;
    private float horizontalSliceStep = Float.NaN;
    private float verticalSliceLow = Float.NaN;
    private float verticalSliceHi = Float.NaN;
    private float verticalSliceStep = Float.NaN;
    boolean contourFill = false;

    public ContourControl(DisplayImpl d) {
        super(d);
    }

    void setMainContours(boolean[] bvalues, float[] fvalues) throws VisADException, RemoteException {
        this.setMainContours(bvalues, fvalues, false, false);
    }

    void setMainContours(boolean[] bvalues, float[] fvalues, boolean noChange) throws VisADException, RemoteException {
        this.setMainContours(bvalues, fvalues, noChange, false);
    }

    void setMainContours(boolean[] bvalues, float[] fvalues, boolean noChange, boolean override) throws VisADException, RemoteException {
        if (fvalues == null || fvalues.length != 5 || bvalues == null || bvalues.length != 2) {
            throw new DisplayException("ContourControl.setMainContours: bad array length");
        }
        boolean setLevels = false;
        float[] levs = null;
        boolean[] dashes = null;
        float myBase = 0.0f;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.mainContours = bvalues[0];
            this.labels = bvalues[1];
            if (override) {
                this.surfaceValue = fvalues[0];
                this.contourInterval = fvalues[1];
                this.lowLimit = fvalues[2];
                this.hiLimit = fvalues[3];
                this.base = fvalues[4];
            } else {
                if (this.surfaceValue != this.surfaceValue) {
                    this.surfaceValue = fvalues[0];
                }
                if (this.contourInterval != this.contourInterval) {
                    this.contourInterval = fvalues[1];
                }
                if (this.lowLimit != this.lowLimit) {
                    this.lowLimit = fvalues[2];
                }
                if (this.hiLimit != this.hiLimit) {
                    this.hiLimit = fvalues[3];
                }
                if (this.base != this.base) {
                    this.base = fvalues[4];
                }
            }
            if (this.arithmeticProgression) {
                if (this.contourInterval == this.contourInterval && this.base == this.base && this.lowLimit == this.lowLimit && this.hiLimit == this.hiLimit) {
                    dashes = new boolean[]{false};
                    levs = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, dashes);
                    myBase = this.base;
                    setLevels = true;
                } else {
                    this.dash = false;
                    this.levels = null;
                }
            }
        }
        if (setLevels) {
            this.setLevels(levs, myBase, (boolean)dashes[0], false);
        }
        this.changeControl(!noChange);
    }

    public void setSurfaceValue(float value) throws VisADException, RemoteException {
        boolean change;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = !Util.isApproximatelyEqual(this.surfaceValue, value);
            this.surfaceValue = value;
        }
        if (change) {
            this.changeControl(true);
        }
    }

    public void setContourInterval(float interval, float low, float hi, float ba) throws VisADException, RemoteException {
        float[] levs;
        float myBase;
        boolean change;
        boolean[] dashes = new boolean[]{false};
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = this.contourInterval != interval || this.base != ba || !Util.isApproximatelyEqual(this.lowLimit, low) || !Util.isApproximatelyEqual(this.hiLimit, hi);
            this.contourInterval = interval;
            this.lowLimit = low;
            this.hiLimit = hi;
            myBase = this.base = ba;
            levs = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, dashes);
            this.arithmeticProgression = true;
        }
        this.setLevels(levs, myBase, dashes[0], change);
    }

    public void setContourLimits(float low, float hi) throws VisADException, RemoteException {
        boolean setLevels;
        boolean change;
        float[] levs = null;
        float myBase = 0.0f;
        boolean[] dashes = null;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = !Util.isApproximatelyEqual(this.lowLimit, low) || !Util.isApproximatelyEqual(this.hiLimit, hi);
            this.lowLimit = low;
            this.hiLimit = hi;
            if (this.arithmeticProgression) {
                setLevels = true;
                dashes = new boolean[]{false};
                levs = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, dashes);
                myBase = this.base;
            } else {
                setLevels = false;
                int n = 0;
                int i = 0;
                while (i < this.levels.length) {
                    if (this.lowLimit < this.levels[i] && this.levels[i] < this.hiLimit) {
                        ++n;
                    }
                    ++i;
                }
                if (n != this.levels.length) {
                    levs = new float[n];
                    int k = 0;
                    int i2 = 0;
                    while (i2 < this.levels.length) {
                        if (this.lowLimit < this.levels[i2] && this.levels[i2] < this.hiLimit) {
                            levs[k++] = this.levels[i2];
                        }
                        ++i2;
                    }
                    this.levels = levs;
                } else {
                    change = false;
                }
            }
        }
        if (setLevels) {
            this.setLevels(levs, myBase, dashes[0], false);
        }
        if (change) {
            this.changeControl(true);
        }
    }

    public void setLevels(float[] levels, float base, boolean dash) throws VisADException, RemoteException {
        this.setLevels(levels, base, dash, true);
    }

    private void setLevels(float[] levs, float ba, boolean da, boolean by_user) throws VisADException, RemoteException {
        if (levs == null) {
            return;
        }
        float[] newLevels = new float[levs.length];
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        int i = 0;
        while (i < levs.length) {
            if (levs[i] < min) {
                min = levs[i];
            }
            if (levs[i] > max) {
                max = levs[i];
            }
            newLevels[i] = levs[i];
            ++i;
        }
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.levels = newLevels;
            this.dash = da;
            this.base = ba;
            if (by_user) {
                this.lowLimit = min - Math.abs(0.01f * min);
                this.hiLimit = max + Math.abs(0.01f * max);
            }
        }
        if (by_user) {
            this.changeControl(true);
        }
    }

    public synchronized float[] getLevels(float[] lowhibase, boolean[] dashes) {
        float[] levs = null;
        if (this.levels != null) {
            levs = new float[this.levels.length];
            System.arraycopy(this.levels, 0, levs, 0, this.levels.length);
        }
        lowhibase[0] = this.lowLimit;
        lowhibase[1] = this.hiLimit;
        lowhibase[2] = this.base;
        dashes[0] = this.dash;
        return levs;
    }

    public void enableLabels(boolean on) throws VisADException, RemoteException {
        boolean change;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = this.labels != on;
            this.labels = on;
        }
        if (change) {
            this.changeControl(true);
        }
    }

    public void enableContours(boolean on) throws VisADException, RemoteException {
        boolean change;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = this.mainContours != on;
            this.mainContours = on;
        }
        if (change) {
            this.changeControl(true);
        }
    }

    public void getMainContours(boolean[] bvalues, float[] fvalues) throws VisADException {
        if (fvalues == null || fvalues.length != 5 || bvalues == null || bvalues.length != 2) {
            throw new DisplayException("ContourControl.getMainContours: bad array length");
        }
        ContourControl contourControl = this;
        synchronized (contourControl) {
            bvalues[0] = this.mainContours;
            bvalues[1] = this.labels;
            fvalues[0] = this.surfaceValue;
            fvalues[1] = this.contourInterval;
            fvalues[2] = this.lowLimit;
            fvalues[3] = this.hiLimit;
            fvalues[4] = this.base;
        }
    }

    public void setContourFill(boolean flag) throws VisADException, RemoteException {
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.contourFill = flag;
        }
        this.changeControl(true);
    }

    public synchronized boolean contourFilled() {
        return this.contourFill;
    }

    public synchronized String getSaveString() {
        return this.mainContours + " " + this.labels + " " + this.surfaceValue + " " + this.contourInterval + " " + this.lowLimit + " " + this.hiLimit + " " + this.base;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        if (st.countTokens() < 7) {
            throw new VisADException("Invalid save string");
        }
        boolean[] b = new boolean[2];
        float[] f = new float[5];
        int i = 0;
        while (i < 2) {
            b[i] = Convert.getBoolean(st.nextToken());
            ++i;
        }
        int i2 = 0;
        while (i2 < 5) {
            f[i2] = Convert.getFloat(st.nextToken());
            ++i2;
        }
        this.setMainContours(b, f, false, true);
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ContourControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ContourControl cc = (ContourControl)rmt;
        boolean changed = false;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            ContourControl contourControl2 = cc;
            synchronized (contourControl2) {
                if (this.mainContours != cc.mainContours) {
                    changed = true;
                    this.mainContours = cc.mainContours;
                }
                if (!Util.isApproximatelyEqual(this.surfaceValue, cc.surfaceValue)) {
                    changed = true;
                    this.surfaceValue = cc.surfaceValue;
                }
                if (!Util.isApproximatelyEqual(this.contourInterval, cc.contourInterval)) {
                    changed = true;
                    this.contourInterval = cc.contourInterval;
                }
                if (!Util.isApproximatelyEqual(this.lowLimit, cc.lowLimit)) {
                    changed = true;
                    this.lowLimit = cc.lowLimit;
                }
                if (!Util.isApproximatelyEqual(this.hiLimit, cc.hiLimit)) {
                    changed = true;
                    this.hiLimit = cc.hiLimit;
                }
                if (!Util.isApproximatelyEqual(this.base, cc.base)) {
                    changed = true;
                    this.base = cc.base;
                }
                if (this.labels != cc.labels) {
                    changed = true;
                    this.labels = cc.labels;
                }
                if (this.arithmeticProgression != cc.arithmeticProgression) {
                    changed = true;
                    this.arithmeticProgression = cc.arithmeticProgression;
                }
                if (cc.levels == null) {
                    if (this.levels != null) {
                        changed = true;
                        this.levels = null;
                    }
                } else {
                    int i;
                    if (this.levels == null || this.levels.length != cc.levels.length) {
                        changed = true;
                        this.levels = new float[cc.levels.length];
                        i = 0;
                        while (i < this.levels.length) {
                            this.levels[i] = 0.0f;
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < this.levels.length) {
                        if (!Util.isApproximatelyEqual(this.levels[i], cc.levels[i])) {
                            changed = true;
                            this.levels[i] = cc.levels[i];
                        }
                        ++i;
                    }
                }
                if (this.dash != cc.dash) {
                    changed = true;
                    this.dash = cc.dash;
                }
                if (this.horizontalContourSlice != cc.horizontalContourSlice) {
                    changed = true;
                    this.horizontalContourSlice = cc.horizontalContourSlice;
                }
                if (this.verticalContourSlice != cc.verticalContourSlice) {
                    changed = true;
                    this.verticalContourSlice = cc.verticalContourSlice;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceLow, cc.horizontalSliceLow)) {
                    changed = true;
                    this.horizontalSliceLow = cc.horizontalSliceLow;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceHi, cc.horizontalSliceHi)) {
                    changed = true;
                    this.horizontalSliceHi = cc.horizontalSliceHi;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceStep, cc.horizontalSliceStep)) {
                    changed = true;
                    this.horizontalSliceStep = cc.horizontalSliceStep;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceLow, cc.verticalSliceLow)) {
                    changed = true;
                    this.verticalSliceLow = cc.verticalSliceLow;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceHi, cc.verticalSliceHi)) {
                    changed = true;
                    this.verticalSliceHi = cc.verticalSliceHi;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceStep, cc.verticalSliceStep)) {
                    changed = true;
                    this.verticalSliceStep = cc.verticalSliceStep;
                }
                if (this.contourFill != cc.contourFill) {
                    changed = true;
                    this.contourFill = cc.contourFill;
                }
            }
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ContourControl cc = (ContourControl)o;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            ContourControl contourControl2 = cc;
            synchronized (contourControl2) {
                boolean bl;
                if (this.mainContours != cc.mainContours) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (!Util.isApproximatelyEqual(this.surfaceValue, cc.surfaceValue)) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (!Util.isApproximatelyEqual(this.contourInterval, cc.contourInterval)) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (!Util.isApproximatelyEqual(this.lowLimit, cc.lowLimit)) {
                    boolean bl5 = false;
                    return bl5;
                }
                if (!Util.isApproximatelyEqual(this.hiLimit, cc.hiLimit)) {
                    boolean bl6 = false;
                    return bl6;
                }
                if (!Util.isApproximatelyEqual(this.base, cc.base)) {
                    boolean bl7 = false;
                    return bl7;
                }
                if (this.labels != cc.labels) {
                    boolean bl8 = false;
                    return bl8;
                }
                if (this.arithmeticProgression != cc.arithmeticProgression) {
                    boolean bl9 = false;
                    return bl9;
                }
                if (this.levels == null) {
                    if (cc.levels != null) {
                        boolean bl10 = false;
                        return bl10;
                    }
                } else {
                    if (cc.levels == null || this.levels.length != cc.levels.length) {
                        boolean bl11 = false;
                        return bl11;
                    }
                    int i = 0;
                    while (i < this.levels.length) {
                        if (!Util.isApproximatelyEqual(this.levels[i], cc.levels[i])) {
                            boolean bl12 = false;
                            return bl12;
                        }
                        ++i;
                    }
                }
                if (this.dash != cc.dash) {
                    bl = false;
                    return bl;
                }
                if (this.horizontalContourSlice != cc.horizontalContourSlice) {
                    bl = false;
                    return bl;
                }
                if (this.verticalContourSlice != cc.verticalContourSlice) {
                    bl = false;
                    return bl;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceLow, cc.horizontalSliceLow)) {
                    bl = false;
                    return bl;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceHi, cc.horizontalSliceHi)) {
                    bl = false;
                    return bl;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceStep, cc.horizontalSliceStep)) {
                    bl = false;
                    return bl;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceLow, cc.verticalSliceLow)) {
                    bl = false;
                    return bl;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceHi, cc.verticalSliceHi)) {
                    bl = false;
                    return bl;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceStep, cc.verticalSliceStep)) {
                    bl = false;
                    return bl;
                }
                if (this.contourFill != cc.contourFill) {
                    bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    public synchronized Object clone() {
        ContourControl cc = (ContourControl)super.clone();
        if (this.levels != null) {
            cc.levels = (float[])this.levels.clone();
        }
        return cc;
    }
}

