/*
 * Decompiled with CFR 0.152.
 */
package ucar.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.server.RemoteServer;
import ucar.util.AbstractLogger;
import ucar.util.Logger;

public class RMILogger
extends AbstractLogger
implements Logger {
    private int maxLevel_;
    private PrintStream logStream_;

    public RMILogger(int maxLevel, OutputStream logStream) {
        this.maxLevel_ = maxLevel;
        this.setLog(logStream);
    }

    public RMILogger() {
        this(5, System.err);
    }

    private void makeConsistent() {
        if (this.maxLevel_ > 5 && RemoteServer.getLog() != this.logStream_) {
            RemoteServer.setLog(this.logStream_);
        }
    }

    public synchronized void setLog(OutputStream logStream) {
        this.logStream_ = logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream);
        this.makeConsistent();
    }

    public synchronized void logUpTo(int maxLevel) {
        this.maxLevel_ = maxLevel;
        this.makeConsistent();
    }

    public synchronized void log(int level, String message) throws IOException {
        if (level > this.maxLevel_) {
            return;
        }
        PrintStream ps = RemoteServer.getLog();
        if (ps == null) {
            ps = this.logStream_;
        }
        ps.println(message);
    }
}

