/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.DimensionDictionary;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.Named;
import ucar.netcdf.ProtoVariable;

public class Variable
implements MultiArray,
Named {
    final ProtoVariable meta;
    final Accessor io;

    public Variable(ProtoVariable proto, Accessor io) {
        if (proto == null || io == null) {
            throw new NullPointerException();
        }
        this.meta = proto;
        this.io = io;
    }

    public Class getComponentType() {
        return this.meta.getComponentType();
    }

    public int getRank() {
        return this.meta.getRank();
    }

    public int[] getLengths() {
        return this.meta.getLengths();
    }

    public boolean isUnlimited() {
        return this.meta.isUnlimited();
    }

    public boolean isScalar() {
        return this.meta.isScalar();
    }

    public String getName() {
        return this.meta.getName();
    }

    public DimensionIterator getDimensionIterator() {
        return this.meta.getDimensionIterator();
    }

    public AttributeSet getAttributes() {
        return this.meta.getAttributes();
    }

    public Attribute getAttribute(String name) {
        return this.meta.getAttribute(name);
    }

    public Object get(int[] index) throws IOException {
        return this.io.get(index);
    }

    public boolean getBoolean(int[] index) throws IOException {
        return this.io.getBoolean(index);
    }

    public char getChar(int[] index) throws IOException {
        return this.io.getChar(index);
    }

    public byte getByte(int[] index) throws IOException {
        return this.io.getByte(index);
    }

    public short getShort(int[] index) throws IOException {
        return this.io.getShort(index);
    }

    public int getInt(int[] index) throws IOException {
        return this.io.getInt(index);
    }

    public long getLong(int[] index) throws IOException {
        return this.io.getLong(index);
    }

    public float getFloat(int[] index) throws IOException {
        return this.io.getFloat(index);
    }

    public double getDouble(int[] index) throws IOException {
        return this.io.getDouble(index);
    }

    public void set(int[] index, Object value) throws IOException {
        this.io.set(index, value);
    }

    public void setBoolean(int[] index, boolean value) throws IOException {
        this.io.setBoolean(index, value);
    }

    public void setChar(int[] index, char value) throws IOException {
        this.io.setChar(index, value);
    }

    public void setByte(int[] index, byte value) throws IOException {
        this.io.setByte(index, value);
    }

    public void setShort(int[] index, short value) throws IOException {
        this.io.setShort(index, value);
    }

    public void setInt(int[] index, int value) throws IOException {
        this.io.setInt(index, value);
    }

    public void setLong(int[] index, long value) throws IOException {
        this.io.setLong(index, value);
    }

    public void setFloat(int[] index, float value) throws IOException {
        this.io.setFloat(index, value);
    }

    public void setDouble(int[] index, double value) throws IOException {
        this.io.setDouble(index, value);
    }

    public MultiArray copyout(int[] origin, int[] shape) throws IOException {
        if (shape.length != this.getRank()) {
            throw new IllegalArgumentException("rank mismatch");
        }
        return this.io.copyout(origin, shape);
    }

    public void copyin(int[] origin, MultiArray data) throws IOException {
        if (data.getRank() != this.getRank()) {
            throw new IllegalArgumentException(data.getRank() + " != " + this.getRank());
        }
        if (data.getComponentType() != this.getComponentType()) {
            throw new IllegalArgumentException(data.getComponentType().getName() + " != " + this.getComponentType().getName());
        }
        this.io.copyin(origin, data);
    }

    public Object toArray() throws IOException {
        return this.io.toArray();
    }

    public Object toArray(Object dst, int[] origin, int[] shape) throws IOException {
        return this.io.toArray(dst, origin, shape);
    }

    public void toCdl(StringBuffer buf) {
        this.meta.toCdl(buf);
    }

    public String toString() {
        return this.meta.toString();
    }

    void connectDims(DimensionDictionary dimensions) {
        this.meta.connectDims(dimensions);
    }
}

