/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;

public class ColumnTable
implements DataTable {
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private int chunk;
    private int rowSize;
    private char[] types;
    private Class[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;

    public ColumnTable(Object[] arrays, int[] sizes) throws TableException {
        this.setup(arrays, sizes);
    }

    protected void setup(Object[] arrays, int[] sizes) throws TableException {
        this.checkArrayConsistency(arrays, sizes);
        this.getNumberOfRows();
        this.initializePointers();
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.arrays.length;
    }

    public Object getColumn(int col) {
        return this.arrays[col];
    }

    public void setColumn(int col, Object newColumn) throws TableException {
        this.arrays[col] = newColumn;
        this.setup(this.arrays, this.sizes);
    }

    public Object getElement(int row, int col) {
        Object x = Array.newInstance(this.bases[col], this.sizes[col]);
        System.arraycopy(this.arrays[col], this.sizes[col] * row, x, 0, this.sizes[col]);
        return x;
    }

    public void setElement(int row, int col, Object x) throws TableException {
        String classname = x.getClass().getName();
        if (!classname.equals("[" + this.types[col])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(x) != this.sizes[col]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(x, 0, this.arrays[col], this.sizes[col] * row, this.sizes[col]);
    }

    public Object getRow(int row) {
        Object[] x = new Object[this.arrays.length];
        int col = 0;
        while (col < this.arrays.length) {
            x[col] = this.getElement(row, col);
            ++col;
        }
        return x;
    }

    public void setRow(int row, Object x) throws TableException {
        if (!(x instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        int col = 0;
        while (col < this.arrays.length) {
            this.setElement(row, col, ((Object[])x)[col]);
            ++col;
        }
    }

    protected void checkArrayConsistency(Object[] arrays, int[] sizes) throws TableException {
        if (arrays.length != sizes.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int ratio = 0;
        int rowSize = 0;
        this.types = new char[arrays.length];
        this.bases = new Class[arrays.length];
        boolean nullTable = true;
        int i = 0;
        while (i < arrays.length) {
            if (Array.getLength(arrays[i]) > 0) {
                nullTable = false;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < arrays.length) {
            String classname = arrays[i2].getClass().getName();
            if (classname.charAt(0) != '[' || classname.length() != 2) {
                throw new TableException("Non-primitive array");
            }
            int thisSize = Array.getLength(arrays[i2]);
            if (thisSize != 0 || sizes[i2] != 0) {
                if (!(thisSize != 0 && sizes[i2] > 0 || nullTable)) {
                    throw new TableException("Invalid size for array: index=" + i2);
                }
                if (thisSize % sizes[i2] != 0) {
                    throw new TableException("Row size does not divide array: index=" + i2);
                }
                if (sizes[i2] > 0) {
                    int thisRatio = thisSize / sizes[i2];
                    if (ratio != 0 && thisRatio != ratio) {
                        throw new TableException("Different number of rows in different columns");
                    }
                    ratio = thisRatio;
                }
                rowSize += sizes[i2] * ArrayFuncs.getBaseLength(arrays[i2]);
                this.types[i2] = classname.charAt(1);
                this.bases[i2] = ArrayFuncs.getBaseClass(arrays[i2]);
            }
            ++i2;
        }
        this.nrow = ratio;
        this.rowSize = rowSize;
        this.arrays = arrays;
        this.sizes = sizes;
    }

    protected void getNumberOfRows() {
        int bufSize = 65536;
        this.chunk = this.rowSize == 0 ? 0 : (this.rowSize > bufSize ? 1 : (bufSize / this.rowSize >= this.nrow ? this.nrow : bufSize / this.rowSize + 1));
    }

    protected void initializePointers() {
        int nbyte = 0;
        int nshort = 0;
        int nint = 0;
        int nlong = 0;
        int nfloat = 0;
        int ndouble = 0;
        int nchar = 0;
        int nboolean = 0;
        int col = 0;
        while (col < this.arrays.length) {
            switch (this.types[col]) {
                case 'B': {
                    ++nbyte;
                    break;
                }
                case 'S': {
                    ++nshort;
                    break;
                }
                case 'I': {
                    ++nint;
                    break;
                }
                case 'L': {
                    ++nlong;
                    break;
                }
                case 'F': {
                    ++nfloat;
                    break;
                }
                case 'D': {
                    ++ndouble;
                    break;
                }
                case 'C': {
                    ++nchar;
                    break;
                }
                case 'Z': {
                    ++nboolean;
                }
            }
            ++col;
        }
        this.bytePointers = new byte[nbyte][];
        this.shortPointers = new short[nshort][];
        this.intPointers = new int[nint][];
        this.longPointers = new long[nlong][];
        this.floatPointers = new float[nfloat][];
        this.doublePointers = new double[ndouble][];
        this.charPointers = new char[nchar][];
        this.booleanPointers = new boolean[nboolean][];
        nbyte = 0;
        nshort = 0;
        nint = 0;
        nlong = 0;
        nfloat = 0;
        ndouble = 0;
        nchar = 0;
        nboolean = 0;
        int col2 = 0;
        while (col2 < this.arrays.length) {
            switch (this.types[col2]) {
                case 'B': {
                    this.bytePointers[nbyte] = (byte[])this.arrays[col2];
                    ++nbyte;
                    break;
                }
                case 'S': {
                    this.shortPointers[nshort] = (short[])this.arrays[col2];
                    ++nshort;
                    break;
                }
                case 'I': {
                    this.intPointers[nint] = (int[])this.arrays[col2];
                    ++nint;
                    break;
                }
                case 'L': {
                    this.longPointers[nlong] = (long[])this.arrays[col2];
                    ++nlong;
                    break;
                }
                case 'F': {
                    this.floatPointers[nfloat] = (float[])this.arrays[col2];
                    ++nfloat;
                    break;
                }
                case 'D': {
                    this.doublePointers[ndouble] = (double[])this.arrays[col2];
                    ++ndouble;
                    break;
                }
                case 'C': {
                    this.charPointers[nchar] = (char[])this.arrays[col2];
                    ++nchar;
                    break;
                }
                case 'Z': {
                    this.booleanPointers[nboolean] = (boolean[])this.arrays[col2];
                    ++nboolean;
                }
            }
            ++col2;
        }
    }

    public int read(InputStream is) throws IOException {
        byte[] buffer = new byte[this.chunk * this.rowSize];
        if (this.rowSize == 0) {
            return 0;
        }
        int currRow = 0;
        while (currRow < this.nrow) {
            int drow = this.chunk;
            if (currRow + drow > this.nrow) {
                drow = this.nrow - currRow;
            }
            int need = drow * this.rowSize;
            int got = 0;
            while (need > 0) {
                int len = is.read(buffer, got, need);
                if (len <= 0) {
                    throw new EOFException("EOF reached in ColumnarIO.read");
                }
                need -= len;
                got += len;
            }
            int bufOffset = 0;
            int row = currRow;
            while (row < currRow + drow) {
                int ibyte = 0;
                int ishort = 0;
                int iint = 0;
                int ilong = 0;
                int ichar = 0;
                int ifloat = 0;
                int idouble = 0;
                int iboolean = 0;
                int col = 0;
                while (col < this.arrays.length) {
                    int arrOffset = this.sizes[col] * row;
                    int size = this.sizes[col];
                    switch (this.types[col]) {
                        case 'I': {
                            int[] ia = this.intPointers[iint];
                            ++iint;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                ia[i] = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                bufOffset += 4;
                                ++i;
                            }
                            break;
                        }
                        case 'S': {
                            short[] s = this.shortPointers[ishort];
                            ++ishort;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                s[i] = (short)(buffer[bufOffset] << 8 | buffer[bufOffset + 1] & 0xFF);
                                bufOffset += 2;
                                ++i;
                            }
                            break;
                        }
                        case 'B': {
                            byte[] b = this.bytePointers[ibyte];
                            ++ibyte;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                b[i] = buffer[bufOffset];
                                ++bufOffset;
                                ++i;
                            }
                            break;
                        }
                        case 'F': {
                            int tmp;
                            float[] f = this.floatPointers[ifloat];
                            ++ifloat;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                tmp = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                f[i] = Float.intBitsToFloat(tmp);
                                bufOffset += 4;
                                ++i;
                            }
                            break;
                        }
                        case 'D': {
                            int i2;
                            int i1;
                            double[] d = this.doublePointers[idouble];
                            ++idouble;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                i1 = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                i2 = buffer[bufOffset += 4] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                bufOffset += 4;
                                d[i] = Double.longBitsToDouble((long)i1 << 32 | (long)i2 & 0xFFFFFFFFL);
                                ++i;
                            }
                            break;
                        }
                        case 'C': {
                            int tmp;
                            char[] c = this.charPointers[ichar];
                            ++ichar;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                tmp = buffer[bufOffset] << 8 | buffer[bufOffset + 1] & 0xFF;
                                c[i] = (char)tmp;
                                bufOffset += 2;
                                ++i;
                            }
                            break;
                        }
                        case 'L': {
                            int i2;
                            int i1;
                            long[] l = this.longPointers[ilong];
                            ++ilong;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                i1 = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                i2 = buffer[bufOffset += 4] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                bufOffset += 4;
                                l[i] = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
                                ++i;
                            }
                            break;
                        }
                        case 'Z': {
                            boolean[] bool = this.booleanPointers[iboolean];
                            ++iboolean;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                bool[i] = buffer[bufOffset] == 1;
                                ++bufOffset;
                                ++i;
                            }
                            break;
                        }
                    }
                    ++col;
                }
                ++row;
            }
            currRow += drow;
        }
        return this.rowSize * this.nrow;
    }

    public int write(OutputStream os) throws IOException {
        byte[] buffer = new byte[this.chunk * this.rowSize];
        if (this.rowSize == 0) {
            return 0;
        }
        int currRow = 0;
        while (currRow < this.nrow) {
            int drow = this.chunk;
            if (currRow + drow > this.nrow) {
                drow = this.nrow - currRow;
            }
            int bufOffset = 0;
            int row = currRow;
            while (row < currRow + drow) {
                int ibyte = 0;
                int ishort = 0;
                int iint = 0;
                int ilong = 0;
                int ichar = 0;
                int ifloat = 0;
                int idouble = 0;
                int iboolean = 0;
                int col = 0;
                while (col < this.arrays.length) {
                    int arrOffset = this.sizes[col] * row;
                    int size = this.sizes[col];
                    switch (this.types[col]) {
                        case 'I': {
                            int[] ia = this.intPointers[iint];
                            ++iint;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                buffer[bufOffset] = (byte)(ia[i] >>> 24);
                                buffer[bufOffset + 1] = (byte)(ia[i] >>> 16);
                                buffer[bufOffset + 2] = (byte)(ia[i] >>> 8);
                                buffer[bufOffset + 3] = (byte)ia[i];
                                bufOffset += 4;
                                ++i;
                            }
                            break;
                        }
                        case 'S': {
                            short[] s = this.shortPointers[ishort];
                            ++ishort;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                buffer[bufOffset] = (byte)(s[i] >>> 8);
                                buffer[bufOffset + 1] = (byte)s[i];
                                bufOffset += 2;
                                ++i;
                            }
                            break;
                        }
                        case 'B': {
                            byte[] b = this.bytePointers[ibyte];
                            ++ibyte;
                            System.arraycopy(b, arrOffset, buffer, bufOffset, size);
                            bufOffset += size;
                            break;
                        }
                        case 'F': {
                            float[] f = this.floatPointers[ifloat];
                            ++ifloat;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                int tmp = Float.floatToIntBits(f[i]);
                                buffer[bufOffset] = (byte)(tmp >>> 24);
                                buffer[bufOffset + 1] = (byte)(tmp >>> 16);
                                buffer[bufOffset + 2] = (byte)(tmp >>> 8);
                                buffer[bufOffset + 3] = (byte)tmp;
                                bufOffset += 4;
                                ++i;
                            }
                            break;
                        }
                        case 'D': {
                            int i2;
                            int i1;
                            double[] d = this.doublePointers[idouble];
                            ++idouble;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                long lng = Double.doubleToLongBits(d[i]);
                                i1 = (int)(lng >>> 32);
                                i2 = (int)lng;
                                buffer[bufOffset] = (byte)(i1 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i1 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i1 >>> 8);
                                buffer[bufOffset + 3] = (byte)i1;
                                buffer[bufOffset += 4] = (byte)(i2 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i2 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i2 >>> 8);
                                buffer[bufOffset + 3] = (byte)i2;
                                bufOffset += 4;
                                ++i;
                            }
                            break;
                        }
                        case 'C': {
                            char[] c = this.charPointers[ichar];
                            ++ichar;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                buffer[bufOffset] = (byte)(c[i] >>> 8);
                                buffer[bufOffset + 1] = (byte)c[i];
                                bufOffset += 2;
                                ++i;
                            }
                            break;
                        }
                        case 'L': {
                            int i2;
                            int i1;
                            long[] l = this.longPointers[ilong];
                            ++ilong;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                i1 = (int)(l[i] >>> 32);
                                i2 = (int)l[i];
                                buffer[bufOffset] = (byte)(i1 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i1 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i1 >>> 8);
                                buffer[bufOffset + 3] = (byte)i1;
                                buffer[bufOffset += 4] = (byte)(i2 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i2 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i2 >>> 8);
                                buffer[bufOffset + 3] = (byte)i2;
                                bufOffset += 4;
                                ++i;
                            }
                            break;
                        }
                        case 'Z': {
                            boolean[] bool = this.booleanPointers[iboolean];
                            ++iboolean;
                            int i = arrOffset;
                            while (i < arrOffset + size) {
                                buffer[bufOffset] = bool[i] ? (byte)1 : 0;
                                ++bufOffset;
                                ++i;
                            }
                            break;
                        }
                    }
                    ++col;
                }
                ++row;
            }
            os.write(buffer, 0, this.rowSize * drow);
            currRow += drow;
        }
        return this.rowSize * this.nrow;
    }

    public Class[] getBases() {
        return this.bases;
    }

    public char[] getTypes() {
        return this.types;
    }
}

