/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import nom.tam.util.BufferedDataOutputStream;

public class BufferedDataInputStream
extends BufferedInputStream
implements DataInput {
    private long bufferOffset = 0L;
    private int primitiveArrayCount;

    public BufferedDataInputStream(InputStream o) {
        super(o);
    }

    public BufferedDataInputStream(InputStream o, int bufLength) {
        super(o, bufLength);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        int total = 0;
        while (len > 0) {
            int xlen = super.read(buf, offset + total, len);
            if (xlen <= 0) {
                if (total == 0) {
                    throw new EOFException();
                }
                return total;
            }
            len -= xlen;
            total += xlen;
        }
        return total;
    }

    public int read() throws IOException {
        return super.read();
    }

    public long skip(long offset) throws IOException {
        long total = 0L;
        while (offset > 0L) {
            long xoff = super.skip(offset);
            if (xoff == 0L) {
                return total;
            }
            offset -= xoff;
            total += xoff;
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int b = this.read();
        return b == 1;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read() | 0xFF;
    }

    public int readInt() throws IOException {
        byte[] b = new byte[4];
        if (this.read(b, 0, 4) < 4) {
            throw new EOFException();
        }
        int i = b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return i;
    }

    public short readShort() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 2) {
            throw new EOFException();
        }
        short s = (short)(b[0] << 8 | b[1] & 0xFF);
        return s;
    }

    public int readUnsignedShort() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 2) {
            throw new EOFException();
        }
        return (b[0] & 0xFF) << 8 | b[1] & 0xFF;
    }

    public char readChar() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 2) {
            throw new EOFException();
        }
        char c = (char)(b[0] << 8 | b[1] & 0xFF);
        return c;
    }

    public long readLong() throws IOException {
        byte[] b = new byte[8];
        if (this.read(b, 0, 8) < 8) {
            throw new EOFException();
        }
        int i1 = b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        int i2 = b[4] << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | b[7] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public float readFloat() throws IOException {
        byte[] b = new byte[4];
        if (this.read(b, 0, 4) < 4) {
            throw new EOFException();
        }
        int i = b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public double readDouble() throws IOException {
        byte[] b = new byte[8];
        if (this.read(b, 0, 8) < 8) {
            throw new EOFException();
        }
        int i1 = b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        int i2 = b[4] << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | b[7] & 0xFF;
        return Double.longBitsToDouble((long)i1 << 32 | (long)i2 & 0xFFFFFFFFL);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(b, off, len) < len) {
            throw new EOFException();
        }
    }

    public int skipBytes(int toSkip) throws IOException {
        if (this.skip(toSkip) < (long)toSkip) {
            throw new EOFException();
        }
        return toSkip;
    }

    public String readUTF() throws IOException {
        DataInputStream d = new DataInputStream(this);
        return d.readUTF();
    }

    public String readLine() throws IOException {
        DataInputStream d = new DataInputStream(this);
        return d.readLine();
    }

    public int readPrimitiveArray(Object o) throws IOException {
        this.primitiveArrayCount = 0;
        return this.primitiveArrayRecurse(o);
    }

    protected int primitiveArrayRecurse(Object o) throws IOException {
        if (o == null) {
            return this.primitiveArrayCount;
        }
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + className);
        }
        if (className.charAt(1) == '[') {
            int i = 0;
            while (i < ((Object[])o).length) {
                this.primitiveArrayRecurse(((Object[])o)[i]);
                ++i;
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += this.readBooleanArray((boolean[])o);
                    break;
                }
                case 'B': {
                    int len = this.read((byte[])o, 0, ((byte[])o).length);
                    if (len < ((byte[])o).length) {
                        this.primitiveArrayCount += len;
                        this.primitiveEOFThrower();
                    }
                    this.primitiveArrayCount += len;
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += this.readCharArray((char[])o);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += this.readShortArray((short[])o);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += this.readIntArray((int[])o);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += this.readLongArray((long[])o);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += this.readFloatArray((float[])o);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += this.readDoubleArray((double[])o);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.Object;")) {
                        int i = 0;
                        while (i < ((Object[])o).length) {
                            this.primitiveArrayRecurse(((Object[])o)[i]);
                            ++i;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + className);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    protected int readBooleanArray(boolean[] b) throws IOException {
        byte[] bx = new byte[b.length];
        if (this.read(bx, 0, bx.length) < bx.length) {
            this.primitiveEOFThrower();
        }
        int i = 0;
        while (i < b.length) {
            b[i] = bx[i] == 1;
            ++i;
        }
        return bx.length;
    }

    protected int readShortArray(short[] s) throws IOException {
        if (s.length == 0) {
            return 0;
        }
        byte[] b = new byte[2 * s.length];
        if (this.read(b, 0, b.length) < b.length) {
            this.primitiveEOFThrower();
        }
        char c = (char)(b[0] << 8 | b[1]);
        int i = 0;
        while (i < s.length) {
            s[i] = (short)(b[2 * i] << 8 | b[2 * i + 1] & 0xFF);
            ++i;
        }
        return b.length;
    }

    protected int readCharArray(char[] c) throws IOException {
        byte[] b = new byte[2 * c.length];
        if (this.read(b, 0, b.length) < b.length) {
            this.primitiveEOFThrower();
        }
        int i = 0;
        while (i < c.length) {
            c[i] = (char)(b[2 * i] << 8 | b[2 * i + 1] & 0xFF);
            ++i;
        }
        return b.length;
    }

    protected int readIntArray(int[] i) throws IOException {
        byte[] b = new byte[4 * i.length];
        if (this.read(b, 0, b.length) < b.length) {
            this.primitiveEOFThrower();
        }
        int ii = 0;
        while (ii < i.length) {
            i[ii] = b[4 * ii] << 24 | (b[4 * ii + 1] & 0xFF) << 16 | (b[4 * ii + 2] & 0xFF) << 8 | b[4 * ii + 3] & 0xFF;
            ++ii;
        }
        return b.length;
    }

    protected int readLongArray(long[] l) throws IOException {
        byte[] b = new byte[8 * l.length];
        if (this.read(b, 0, b.length) < b.length) {
            this.primitiveEOFThrower();
        }
        int i = 0;
        while (i < l.length) {
            int i1 = b[8 * i] << 24 | (b[8 * i + 1] & 0xFF) << 16 | (b[8 * i + 2] & 0xFF) << 8 | b[8 * i + 3] & 0xFF;
            int i2 = b[8 * i + 4] << 24 | (b[8 * i + 5] & 0xFF) << 16 | (b[8 * i + 6] & 0xFF) << 8 | b[8 * i + 7] & 0xFF;
            l[i] = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
            ++i;
        }
        return b.length;
    }

    protected int readFloatArray(float[] f) throws IOException {
        byte[] b = new byte[4 * f.length];
        if (this.read(b, 0, b.length) < b.length) {
            this.primitiveEOFThrower();
        }
        int i = 0;
        while (i < f.length) {
            int t = b[4 * i] << 24 | (b[4 * i + 1] & 0xFF) << 16 | (b[4 * i + 2] & 0xFF) << 8 | b[4 * i + 3] & 0xFF;
            f[i] = Float.intBitsToFloat(t);
            ++i;
        }
        return b.length;
    }

    protected int readDoubleArray(double[] d) throws IOException {
        byte[] b = new byte[8 * d.length];
        if (this.read(b, 0, b.length) < b.length) {
            this.primitiveEOFThrower();
        }
        int i = 0;
        while (i < d.length) {
            int i1 = b[8 * i] << 24 | (b[8 * i + 1] & 0xFF) << 16 | (b[8 * i + 2] & 0xFF) << 8 | b[8 * i + 3] & 0xFF;
            int i2 = b[8 * i + 4] << 24 | (b[8 * i + 5] & 0xFF) << 16 | (b[8 * i + 6] & 0xFF) << 8 | b[8 * i + 7] & 0xFF;
            d[i] = Double.longBitsToDouble((long)i1 << 32 | (long)i2 & 0xFFFFFFFFL);
            ++i;
        }
        return b.length;
    }

    protected void primitiveEOFThrower() throws EOFException {
        throw new EOFException("EOF on primitive array read after " + this.primitiveArrayCount + " bytes.");
    }

    public void printStatus() {
        System.out.println("BufferedDataInputStream:");
        System.out.println("    count=" + this.count);
        System.out.println("      pos=" + this.pos);
    }

    public String toString() {
        return "BufferedDataInputStream[count=" + this.count + ",pos=" + this.pos + "]";
    }

    public static void main(String[] args) throws Exception {
        boolean booleanScalar = true;
        byte byteScalar = 18;
        short shortScalar = 4660;
        char charScalar = 'p';
        int intScalar = 305419896;
        long longScalar = 81985529205931230L;
        float floatScalar = 1.1f;
        double doubleScalar = 1.2;
        String stringScalar = "This is a string";
        boolean[] booleanArray = new boolean[50];
        byte[][] byteArray = new byte[50][50];
        short[] shortArray = new short[50];
        char[][] charArray = new char[50][50];
        int[][][] intArray = new int[50][50][50];
        long[] longArray = new long[50];
        float[] floatArray = new float[50];
        double[][] doubleArray = new double[50][50];
        int i = 0;
        while (i < 50) {
            int sign = 1;
            if (i % 2 > 0) {
                sign = -1;
            }
            booleanArray[i] = i % 2 == 1;
            shortArray[i] = (short)(sign * i | 0x1234);
            longArray[i] = (long)sign * ((long)i | 0x1234567890ABCDEL);
            floatArray[i] = (float)i + (float)sign * 2.33f;
            int j = 0;
            while (j < 50) {
                byteArray[i][j] = (byte)(i - j);
                charArray[i][j] = (char)(i + j);
                doubleArray[i][j] = (double)(sign * i * j) * 3.97;
                int k = 0;
                while (k < 50) {
                    intArray[i][j][k] = sign * (i * j + i * k + j * k + 19088743);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        BufferedDataOutputStream o = new BufferedDataOutputStream(new FileOutputStream("BufferedData.test"));
        o.writeBoolean(booleanScalar);
        o.writePrimitiveArray(booleanArray);
        o.writeByte(byteScalar);
        o.writePrimitiveArray(byteArray);
        int i2 = 0;
        while (i2 < 50) {
            o.write(byteArray[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < 50) {
            o.write(byteArray[i3], 0, 25);
            o.write(byteArray[i3], 25, 25);
            ++i3;
        }
        o.writeShort(shortScalar);
        o.writePrimitiveArray(shortArray);
        o.writeChar(charScalar);
        o.writePrimitiveArray(charArray);
        o.writeInt(intScalar);
        o.writePrimitiveArray(intArray);
        o.writeLong(longScalar);
        o.writePrimitiveArray(longArray);
        o.writeFloat(floatScalar);
        o.writePrimitiveArray(floatArray);
        o.writeDouble(doubleScalar);
        o.writePrimitiveArray(doubleArray);
        o.flush();
        o.close();
        o = null;
        BufferedDataInputStream in = new BufferedDataInputStream(new FileInputStream("BufferedData.test"));
        System.out.println("Functionality tests (Note String I/O not checked)");
        System.out.println("");
        BufferedDataInputStream.passes(booleanScalar == in.readBoolean(), "boolean scalar");
        boolean[] ba = new boolean[50];
        in.readPrimitiveArray(ba);
        BufferedDataInputStream.passes(ba[0] == booleanArray[0], "boolean array (start)");
        BufferedDataInputStream.passes(ba[49] == booleanArray[49], "boolean array (end)");
        BufferedDataInputStream.passes(ba[22] == booleanArray[22], "boolean array (middle)");
        BufferedDataInputStream.passes(byteScalar == in.readByte(), "byte scalar");
        byte[][] binp1 = new byte[50][50];
        byte[][] binp2 = new byte[50][50];
        byte[][] binp3 = new byte[50][50];
        int i4 = 0;
        while (i4 < 50) {
            in.read(binp3[i4], 0, 25);
            in.read(binp3[i4], 25, 25);
            ++i4;
        }
        int i5 = 0;
        while (i5 < 50) {
            in.readFully(binp2[i5]);
            ++i5;
        }
        in.readPrimitiveArray(binp1);
        BufferedDataInputStream.passes(binp1[0][0] == byteArray[0][0], "byte array(start-method1)");
        BufferedDataInputStream.passes(binp1[49][49] == byteArray[49][49], "byte array(end-method1)");
        BufferedDataInputStream.passes(binp1[22][22] == byteArray[22][22], "byte array(middle-method1");
        BufferedDataInputStream.passes(binp2[0][0] == byteArray[0][0], "byte array(start-method2)");
        BufferedDataInputStream.passes(binp2[49][49] == byteArray[49][49], "byte array(end-method2)");
        BufferedDataInputStream.passes(binp2[22][22] == byteArray[22][22], "byte array(middle-method2");
        BufferedDataInputStream.passes(binp3[0][0] == byteArray[0][0], "byte array(start-method3)");
        BufferedDataInputStream.passes(binp3[49][49] == byteArray[49][49], "byte array(end-method3)");
        BufferedDataInputStream.passes(binp3[22][22] == byteArray[22][22], "byte array(middle-method3");
        BufferedDataInputStream.passes(shortScalar == in.readShort(), "short scalar");
        short[] sa = new short[50];
        in.readPrimitiveArray(sa);
        BufferedDataInputStream.passes(sa[0] == shortArray[0], "short array (start)");
        BufferedDataInputStream.passes(sa[49] == shortArray[49], "short array (end)");
        BufferedDataInputStream.passes(sa[22] == shortArray[22], "short array (middle)");
        BufferedDataInputStream.passes(charScalar == in.readChar(), "char scalar");
        char[][] ca = new char[50][50];
        in.readPrimitiveArray(ca);
        BufferedDataInputStream.passes(ca[0][0] == charArray[0][0], "char array (start)");
        BufferedDataInputStream.passes(ca[49][49] == charArray[49][49], "char array (end)");
        BufferedDataInputStream.passes(ca[22][22] == charArray[22][22], "char array (middle)");
        BufferedDataInputStream.passes(intScalar == in.readInt(), "int scalar");
        int[][][] ia = new int[50][50][50];
        in.readPrimitiveArray(ia);
        BufferedDataInputStream.passes(ia[0][0][0] == intArray[0][0][0], "int array (start)");
        BufferedDataInputStream.passes(ia[49][49][49] == intArray[49][49][49], "int array (end)");
        BufferedDataInputStream.passes(ia[22][22][22] == intArray[22][22][22], "int array (middle)");
        BufferedDataInputStream.passes(longScalar == in.readLong(), "long scalar");
        long[] la = new long[50];
        in.readPrimitiveArray(la);
        BufferedDataInputStream.passes(la[0] == longArray[0], "long array (start)");
        BufferedDataInputStream.passes(la[49] == longArray[49], "long array (end)");
        BufferedDataInputStream.passes(la[22] == longArray[22], "long array (middle)");
        BufferedDataInputStream.passes(floatScalar == in.readFloat(), "float scalar");
        float[] fa = new float[50];
        in.readPrimitiveArray(fa);
        BufferedDataInputStream.passes(fa[0] == floatArray[0], "float array (start)");
        BufferedDataInputStream.passes(fa[49] == floatArray[49], "float array (end)");
        BufferedDataInputStream.passes(fa[22] == floatArray[22], "float array (middle)");
        BufferedDataInputStream.passes(doubleScalar == in.readDouble(), "double scalar");
        double[][] da = new double[50][50];
        in.readPrimitiveArray(da);
        BufferedDataInputStream.passes(da[0][0] == doubleArray[0][0], "double array (start)");
        BufferedDataInputStream.passes(da[49][49] == doubleArray[49][49], "double array (end)");
        BufferedDataInputStream.passes(da[22][22] == doubleArray[22][22], "double array (middle)");
        in = null;
        System.out.println("");
        System.out.println("Timing test:  Write and read an 800x800 int array");
        System.out.println("");
        System.out.println("Initializing array");
        int[][] data = new int[800][800];
        int[][] indata = new int[800][800];
        int i6 = 0;
        while (i6 < data.length) {
            int j = 0;
            while (j < data[0].length) {
                data[i6][j] = i6 * j * (i6 - j);
                ++j;
            }
            ++i6;
        }
        System.out.println("");
        System.out.println("Using DataXputStream(BufferedXputStream) at " + new Date());
        DataOutputStream ds = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("test_std.data")));
        int i7 = 0;
        while (i7 < 800) {
            int j = 0;
            while (j < 800) {
                ds.writeInt(data[i7][j]);
                ++j;
            }
            ++i7;
        }
        ds.flush();
        ds.close();
        ds = null;
        System.out.println("                          Finished write at:" + new Date());
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream("test_std.data")));
        int i8 = 0;
        while (i8 < 800) {
            int j = 0;
            while (j < 800) {
                indata[i8][j] = is.readInt();
                ++j;
            }
            ++i8;
        }
        is = null;
        System.out.println("                          Finished read at: " + new Date());
        System.out.println("");
        System.out.println("Using BufferedDataXputStream at             " + new Date());
        BufferedDataOutputStream ob = new BufferedDataOutputStream(new FileOutputStream("test_bd.data"));
        ob.writePrimitiveArray(data);
        ob.flush();
        ob.close();
        ob = null;
        System.out.println("                          Finished write at:" + new Date());
        BufferedDataInputStream ib = new BufferedDataInputStream(new FileInputStream("test_bd.data"));
        ib.readPrimitiveArray(indata);
        ib = null;
        System.out.println("                          Finished read at: " + new Date());
    }

    private static void passes(boolean status, String msg) {
        System.out.print(msg + ":");
        if (msg.length() < 30) {
            System.out.print("                              ".substring(0, 30 - msg.length()));
        }
        if (status) {
            System.out.println(" passes");
        } else {
            System.out.println(" fails");
        }
    }
}

