/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.HeaderCardException;

public class HeaderCard {
    String key;
    String value;
    String comment;
    boolean isString;
    private static final int MAX_KEYWORD_LENGTH = 8;
    private static final int MAX_VALUE_LENGTH = 70;
    private String space40 = "                                        ";

    public HeaderCard(String key, String value, String comment) throws HeaderCardException {
        if (key == null && value != null) {
            throw new HeaderCardException("Null keyword with non-null value");
        }
        if (key != null && key.length() > 8) {
            throw new HeaderCardException("Keyword too long");
        }
        if (value != null) {
            if ((value = value.trim()).length() > 70) {
                throw new HeaderCardException("Value too long");
            }
            if (value.charAt(0) == '\'') {
                if (value.charAt(value.length() - 1) != '\'') {
                    throw new HeaderCardException("Missing end quote in string value");
                }
                value = value.substring(1, value.length() - 1).trim();
                this.isString = true;
            }
        }
        this.key = key;
        this.value = value;
        this.comment = comment;
    }

    public HeaderCard(String card) {
        int slashLoc;
        this.key = null;
        this.value = null;
        this.comment = null;
        this.isString = false;
        if (card.length() < 9) {
            this.key = card;
            return;
        }
        this.key = card.substring(0, 8).trim();
        if (this.key.length() == 0) {
            this.key = "";
            this.comment = card.substring(8);
            return;
        }
        if (!card.substring(8, 10).equals("= ")) {
            this.comment = card.substring(8);
            return;
        }
        String valcom = card.substring(10).trim();
        if (valcom.length() == 0) {
            this.value = "";
            return;
        }
        int vend = -1;
        boolean quote = false;
        if (valcom.charAt(0) == '\'') {
            int offset = 1;
            while (offset < valcom.length()) {
                vend = valcom.indexOf("'", offset);
                if (vend == valcom.length() - 1) break;
                if (vend == -1) {
                    this.key = null;
                    this.comment = card;
                    return;
                }
                if (valcom.charAt(vend + 1) != '\'') break;
                offset = vend + 2;
            }
            this.value = valcom.substring(1, vend).trim();
            this.isString = true;
        }
        if ((slashLoc = valcom.indexOf(47)) != -1) {
            this.comment = valcom.substring(slashLoc + 1).trim();
            valcom = valcom.substring(0, slashLoc).trim();
        }
        if (!this.isString) {
            this.value = valcom;
        }
    }

    public boolean isStringValue() {
        return this.isString;
    }

    public boolean isKeyValuePair() {
        return this.key != null && this.value != null;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        if (this.key != null) {
            buf.append(this.key);
        }
        while (buf.length() < 8) {
            buf.append(' ');
        }
        if (this.value != null) {
            buf.append("= ");
            if (this.isString) {
                buf.append('\'');
                buf.append(this.value);
                while (buf.length() < 19) {
                    buf.append(' ');
                }
                buf.append('\'');
            } else {
                int offset = buf.length();
                buf.append(this.value);
                while (buf.length() < 30) {
                    buf.insert(offset, ' ');
                }
            }
            if (this.comment != null) {
                buf.append(" / ");
            }
        } else if (this.comment != null && this.comment.startsWith("= ")) {
            buf.append("  ");
        }
        if (this.comment != null) {
            buf.append(this.comment);
        }
        if (buf.length() > 80) {
            buf.setLength(80);
        } else {
            if (buf.length() < 40) {
                buf.append(this.space40);
            }
            if (buf.length() < 80) {
                buf.append(this.space40.substring(0, 80 - buf.length()));
            }
        }
        return buf.toString();
    }
}

