/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;

public class StackConverter {
    ImagePlus imp;
    int type;
    int nSlices;
    int width;
    int height;

    public StackConverter(ImagePlus imp) {
        this.imp = imp;
        this.type = imp.getType();
        this.nSlices = imp.getStackSize();
        if (this.nSlices < 2) {
            throw new IllegalArgumentException("Stack required");
        }
        this.width = imp.getWidth();
        this.height = imp.getHeight();
    }

    public void convertToGray8() {
        ImageStack stack1 = this.imp.getStack();
        int currentSlice = this.imp.getCurrentSlice();
        if (this.type == 4 || this.type == 3) {
            this.convertRGBToGray8();
            this.imp.setSlice(currentSlice);
            return;
        }
        ImageStack stack2 = new ImageStack(this.width, this.height);
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        int i = 1;
        while (i <= this.nSlices) {
            String label = stack1.getSliceLabel(1);
            ip = stack1.getProcessor(1);
            stack1.deleteSlice(1);
            System.gc();
            ip.setMinAndMax(min, max);
            boolean scale = ImageConverter.getDoScaling();
            stack2.addSlice(label, ip.convertToByte(scale));
            if (i % inc == 0) {
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            ++i;
        }
        this.imp.setStack(null, stack2);
        this.imp.setSlice(currentSlice);
        this.imp.getCalibration().disableDensityCalibration();
        IJ.showProgress(1.0);
    }

    void convertRGBToGray8() {
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        int i = 1;
        while (i <= this.nSlices) {
            String label = stack1.getSliceLabel(1);
            ImageProcessor ip = stack1.getProcessor(1);
            stack1.deleteSlice(1);
            System.gc();
            if (ip instanceof ByteProcessor) {
                ip = new ColorProcessor(ip.createImage());
            }
            boolean scale = ImageConverter.getDoScaling();
            stack2.addSlice(label, ip.convertToByte(scale));
            if (i % inc == 0) {
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            ++i;
        }
        this.imp.setStack(null, stack2);
        IJ.showProgress(1.0);
    }

    public void convertToGray32() {
        int type = this.imp.getType();
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        Calibration cal = this.imp.getCalibration();
        int i = 1;
        while (i <= this.nSlices) {
            String label = stack1.getSliceLabel(1);
            ImageProcessor ip1 = stack1.getProcessor(1);
            ip1.setCalibrationTable(cal.getCTable());
            ImageProcessor ip2 = ip1.convertToFloat();
            stack1.deleteSlice(1);
            System.gc();
            stack2.addSlice(label, ip2);
            if (i % inc == 0) {
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            ++i;
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
        cal.disableDensityCalibration();
    }

    public void convertToRGB() {
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        Calibration cal = this.imp.getCalibration();
        int i = 1;
        while (i <= this.nSlices) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip1 = stack1.getProcessor(i);
            ImageProcessor ip2 = ip1.convertToRGB();
            stack2.addSlice(label, ip2);
            if (i % inc == 0) {
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            ++i;
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
        cal.disableDensityCalibration();
    }
}

