/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.PlotWindow;
import ij.io.OpenDialog;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Fitter
extends PlugInFrame
implements PlugIn,
ItemListener,
ActionListener {
    Choice fit;
    Button doIt;
    Button open;
    Button apply;
    Checkbox settings;
    String fitTypeStr = CurveFitter.fitList[0];
    TextArea textArea;
    double[] dx = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dy = new double[]{0.0, 0.9, 4.5, 8.0, 18.0, 24.0};
    double[] x;
    double[] y;
    static CurveFitter cf;
    static int fitType;
    static /* synthetic */ Class class$ij$plugin$frame$Fitter;

    public Fitter() {
        super("Curve Fitter");
        Panel panel = new Panel();
        this.fit = new Choice();
        int i = 0;
        while (i < CurveFitter.fitList.length) {
            this.fit.addItem(CurveFitter.fitList[i]);
            ++i;
        }
        this.fit.addItemListener(this);
        panel.add(this.fit);
        this.doIt = new Button(" Fit ");
        this.doIt.addActionListener(this);
        panel.add(this.doIt);
        this.open = new Button("Open");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.apply = new Button("Apply");
        this.apply.addActionListener(this);
        panel.add(this.apply);
        this.settings = new Checkbox("Show settings", false);
        panel.add(this.settings);
        this.add("North", panel);
        String text = "";
        int i2 = 0;
        while (i2 < this.dx.length) {
            text = text + IJ.d2s(this.dx[i2], 2) + "  " + IJ.d2s(this.dy[i2], 2) + "\n";
            ++i2;
        }
        this.textArea = new TextArea("", 15, 30, 1);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.append(text);
        this.add("Center", this.textArea);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        IJ.register(class$ij$plugin$frame$Fitter == null ? (class$ij$plugin$frame$Fitter = Fitter.class$("ij.plugin.frame.Fitter")) : class$ij$plugin$frame$Fitter);
    }

    public void doFit(int fitType) {
        Fitter.fitType = fitType;
        if (!this.getData()) {
            return;
        }
        double[] a = Tools.getMinMax(this.x);
        double xmin = a[0];
        double xmax = a[1];
        a = Tools.getMinMax(this.y);
        double ymin = a[0];
        double ymax = a[1];
        cf = new CurveFitter(this.x, this.y);
        cf.doFit(fitType, this.settings.getState());
        IJ.write(cf.getResultString());
        float[] px = new float[100];
        float[] py = new float[100];
        double inc = (xmax - xmin) / 99.0;
        double tmp = xmin;
        int i = 0;
        while (i < 100) {
            px[i] = (float)tmp;
            tmp += inc;
            ++i;
        }
        int i2 = 0;
        while (i2 < 100) {
            py[i2] = (float)CurveFitter.f(fitType, cf.getParams(), px[i2]);
            ++i2;
        }
        a = Tools.getMinMax(py);
        ymin = Math.min(ymin, a[0]);
        ymax = Math.max(ymax, a[1]);
        PlotWindow pw = new PlotWindow(CurveFitter.fList[fitType], "X", "Y", px, py);
        pw.setLimits(xmin, xmax, ymin, ymax);
        pw.addPoints(this.x, this.y, 0);
        pw.draw();
    }

    double sqr(double x) {
        return x * x;
    }

    boolean getData() {
        this.textArea.selectAll();
        String text = this.textArea.getText();
        this.textArea.select(0, 0);
        StringTokenizer st = new StringTokenizer(text);
        int nTokens = st.countTokens();
        if (nTokens < 4 || nTokens % 2 != 0) {
            return false;
        }
        int n = nTokens / 2;
        this.x = new double[n];
        this.y = new double[n];
        int i = 0;
        while (i < n) {
            this.x[i] = this.getNum(st);
            this.y[i] = this.getNum(st);
            ++i;
        }
        return true;
    }

    void applyFunction() {
        if (cf == null) {
            IJ.error("No function available");
            return;
        }
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            IJ.noImage();
            return;
        }
        if (img.getTitle().startsWith("y=")) {
            IJ.error("First select the image to be transformed");
            return;
        }
        double[] p = cf.getParams();
        int width = img.getWidth();
        int height = img.getHeight();
        int size = width * height;
        float[] data = new float[size];
        ImageProcessor ip = img.getProcessor();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                float value = ip.getPixelValue(x, y);
                data[y * width + x] = (float)CurveFitter.f(fitType, p, value);
                ++x;
            }
            ++y;
        }
        FloatProcessor ip2 = new FloatProcessor(width, height, data, ip.getColorModel());
        new ImagePlus(img.getTitle() + "-transformed", ip2).show();
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void open() {
        OpenDialog od = new OpenDialog("Open Text File...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        this.textArea.selectAll();
        this.textArea.setText("");
        try {
            String s;
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            while ((s = r.readLine()) != null && s.length() <= 50) {
                this.textArea.append(s + "\n");
            }
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.fitTypeStr = this.fit.getSelectedItem();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.doIt) {
            this.doFit(this.fit.getSelectedIndex());
        } else if (e.getSource() == this.apply) {
            this.applyFunction();
        } else {
            this.open();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

