/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 3;
    }

    public void run(ImageProcessor ip) {
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int background = ip.getPixel(0, 0);
        this.imp.killRoi();
        boolean okay = IJ.showMessageWithCancel("XY_Coordinates", "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \nwidth: " + width + "\n" + "height: " + height + "\n" + "background value: " + background + "\n");
        if (!okay) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save Coordinates as Text...", this.imp.getTitle(), ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.write("" + e);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int count = 0;
        byte[] pixels = (byte[])ip.getPixels();
        String ls = System.getProperty("line.separator");
        int y = height - 1;
        while (y >= 0) {
            int x = 0;
            while (x < width) {
                int v = pixels[y * width + x] & 0xFF;
                if (v != background) {
                    pw.print(x + " " + (height - 1 - y) + " " + v + ls);
                    ++count;
                }
                ++x;
            }
            if (y % 10 == 0) {
                IJ.showProgress((double)(height - y) / (double)height);
            }
            --y;
        }
        IJ.showProgress(1.0);
        pw.close();
        IJ.write(this.imp.getTitle() + ": " + count + " pixels (" + IJ.d2s((double)count * 100.0 / (double)(width * height)) + "%)\n");
    }
}

