/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Scaler
implements PlugInFilter {
    private ImagePlus imp;
    private static double xscale = 0.5;
    private static double yscale = 0.5;
    private static boolean newWindow = true;
    private static boolean interpolate = true;
    static /* synthetic */ Class class$ij$plugin$filter$Scaler;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Scaler == null ? (class$ij$plugin$filter$Scaler = Scaler.class$("ij.plugin.filter.Scaler")) : class$ij$plugin$filter$Scaler);
        return 31;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Scale", IJ.getInstance());
        gd.addNumericField("X Scale (0.05-25):", xscale, 2);
        gd.addNumericField("Y Scale (0.05-25):", yscale, 2);
        gd.addCheckbox("Create New Window", newWindow);
        gd.addCheckbox("Interpolate", interpolate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        xscale = gd.getNextNumber();
        yscale = gd.getNextNumber();
        if (gd.invalidNumber()) {
            IJ.error("Width or height are invalid.");
            return;
        }
        if (xscale > 25.0) {
            xscale = 25.0;
        }
        if (xscale < 0.05) {
            xscale = 0.05;
        }
        if (yscale > 25.0) {
            yscale = 25.0;
        }
        if (yscale < 0.05) {
            yscale = 0.05;
        }
        newWindow = gd.getNextBoolean();
        interpolate = gd.getNextBoolean();
        ip.setInterpolate(interpolate);
        this.imp.startTiming();
        try {
            if (newWindow) {
                Rectangle r = ip.getRoi();
                int newWidth = (int)(xscale * (double)r.width);
                int newHeight = (int)(yscale * (double)r.height);
                ImagePlus imp2 = this.imp.createImagePlus();
                imp2.setProcessor("Untitled", ip.resize(newWidth, newHeight));
                Calibration cal = imp2.getCalibration();
                if (cal.scaled()) {
                    cal.pixelWidth *= 1.0 / xscale;
                    cal.pixelHeight *= 1.0 / yscale;
                    this.imp.setCalibration(cal);
                }
                imp2.show();
                this.imp.trimProcessor();
                imp2.trimProcessor();
            } else {
                if (this.imp.getStackSize() > 1) {
                    Undo.reset();
                }
                StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
                sp.scale(xscale, yscale);
                this.imp.killRoi();
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Scale");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

