/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.FileOutputStream;

public class RoiWriter
implements PlugInFilter {
    static final int HEADER_SIZE = 64;
    static final int VERSION = 217;
    final int polygon = 0;
    final int rect = 1;
    final int oval = 2;
    final int line = 3;
    final int freeLine = 4;
    final int segLine = 5;
    final int noRoi = 6;
    final int freehand = 7;
    final int traced = 8;
    ImagePlus imp;
    byte[] data;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1183;
    }

    public void run(ImageProcessor ip) {
        try {
            this.saveRoi(this.imp);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("ROI Writer", msg);
        }
    }

    public void saveRoi(ImagePlus imp) throws Exception {
        String name;
        int type;
        Roi roi = imp.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        int roiType = roi.getType();
        if (roiType >= 5) {
            throw new IllegalArgumentException("Area selection required");
        }
        if (roiType == 2) {
            type = 0;
            name = "Polygon.roi";
        } else if (roiType == 3) {
            type = 7;
            name = "Freehand.roi";
        } else if (roiType == 4) {
            type = 8;
            name = "TracedRoi.roi";
        } else if (roiType == 1) {
            type = 2;
            name = "Oval.roi";
        } else {
            type = 1;
            name = "Rectangle.roi";
        }
        SaveDialog sd = new SaveDialog("Save ROI...", name, ".roi");
        name = sd.getFileName();
        if (name == null) {
            return;
        }
        String dir = sd.getDirectory();
        FileOutputStream f = new FileOutputStream(dir + name);
        int n = 0;
        int[] x = null;
        int[] y = null;
        if (roi instanceof PolygonRoi) {
            PolygonRoi p = (PolygonRoi)roi;
            n = p.getNCoordinates();
            x = p.getXCoordinates();
            y = p.getYCoordinates();
        }
        this.data = new byte[64 + n * 4];
        Rectangle r = roi.getBoundingRect();
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 217);
        this.data[6] = (byte)type;
        this.putShort(8, r.y);
        this.putShort(10, r.x);
        this.putShort(12, r.y + r.height);
        this.putShort(14, r.x + r.width);
        this.putShort(16, n);
        if (n > 0) {
            int base1 = 64;
            int base2 = base1 + 2 * n;
            int i = 0;
            while (i < n) {
                this.putShort(base1 + i * 2, x[i]);
                this.putShort(base2 + i * 2, y[i]);
                ++i;
            }
        }
        f.write(this.data);
        f.close();
    }

    void putShort(int base, int v) {
        this.data[base] = (byte)(v >>> 8 & 0xFF);
        this.data[base + 1] = (byte)(v & 0xFF);
    }
}

