/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.gui.ProfilePlot;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Profiler
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("set")) {
            this.doOptions();
            return 4096;
        }
        this.imp = imp;
        return 1439;
    }

    public void run(ImageProcessor ip) {
        boolean averageHorizontally = IJ.altKeyDown();
        new ProfilePlot(this.imp, averageHorizontally).createWindow();
    }

    public void doOptions() {
        boolean fixedScale;
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        boolean wasFixedScale = fixedScale = ymin != 0.0 || ymax != 0.0;
        GenericDialog gd = new GenericDialog("Profile Plot Options", IJ.getInstance());
        gd.addNumericField("Y Min:", ymin, 2);
        gd.addNumericField("Y Max:", ymax, 2);
        gd.addCheckbox("Fixed Y-axis Scale", fixedScale);
        gd.addCheckbox("Do Not Save X-Values", !PlotWindow.saveXValues);
        gd.addCheckbox("Auto-close", PlotWindow.autoClose);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ymin = gd.getNextNumber();
        ymax = gd.getNextNumber();
        fixedScale = gd.getNextBoolean();
        PlotWindow.saveXValues = !gd.getNextBoolean();
        PlotWindow.autoClose = gd.getNextBoolean();
        if (!(fixedScale || wasFixedScale || ymin == 0.0 && ymax == 0.0)) {
            fixedScale = true;
        }
        if (!fixedScale) {
            ymin = 0.0;
            ymax = 0.0;
        }
        ProfilePlot.setMinAndMax(ymin, ymax);
    }
}

